/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.dom.rewrite;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;

public abstract class LineInformation {
    public static LineInformation create(final IDocument doc) {
        return new LineInformation(){

            public int getLineOfOffset(int offset) {
                try {
                    return doc.getLineOfOffset(offset);
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }

            public int getLineOffset(int line) {
                try {
                    return doc.getLineOffset(line);
                }
                catch (BadLocationException e) {
                    return -1;
                }
            }
        };
    }

    public static LineInformation create(final JavaScriptUnit astRoot) {
        return new LineInformation(){

            public int getLineOfOffset(int offset) {
                return astRoot.getLineNumber(offset) - 1;
            }

            public int getLineOffset(int line) {
                return astRoot.getPosition(line + 1, 0);
            }
        };
    }

    public abstract int getLineOfOffset(int var1);

    public abstract int getLineOffset(int var1);
}

