/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.hierarchy;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.Openable;
import org.eclipse.wst.jsdt.internal.core.SearchableEnvironment;
import org.eclipse.wst.jsdt.internal.core.hierarchy.HierarchyBuilder;
import org.eclipse.wst.jsdt.internal.core.hierarchy.RegionBasedTypeHierarchy;
import org.eclipse.wst.jsdt.internal.core.hierarchy.TypeHierarchy;

public class RegionBasedHierarchyBuilder
extends HierarchyBuilder {
    public RegionBasedHierarchyBuilder(TypeHierarchy hierarchy) throws JavaScriptModelException {
        super(hierarchy);
    }

    public void build(boolean computeSubtypes) {
        JavaModelManager manager = JavaModelManager.getJavaModelManager();
        try {
            manager.cacheZipFiles();
            if (this.hierarchy.focusType == null || computeSubtypes) {
                SubProgressMonitor typeInRegionMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 30);
                HashMap allOpenablesInRegion = this.determineOpenablesInRegion((IProgressMonitor)typeInRegionMonitor);
                this.hierarchy.initialize(allOpenablesInRegion.size());
                SubProgressMonitor buildMonitor = this.hierarchy.progressMonitor == null ? null : new SubProgressMonitor(this.hierarchy.progressMonitor, 70);
                this.createTypeHierarchyBasedOnRegion(allOpenablesInRegion, (IProgressMonitor)buildMonitor);
                ((RegionBasedTypeHierarchy)this.hierarchy).pruneDeadBranches();
            } else {
                this.hierarchy.initialize(1);
                this.buildSupertypes();
            }
        }
        finally {
            manager.flushZipFiles();
        }
    }

    private void createTypeHierarchyBasedOnRegion(HashMap allOpenablesInRegion, IProgressMonitor monitor) {
        try {
            int size = allOpenablesInRegion.size();
            if (monitor != null) {
                monitor.beginTask("", size * 2);
            }
            this.infoToHandle = new HashMap(size);
            for (Map.Entry entry : allOpenablesInRegion.entrySet()) {
                JavaProject project = (JavaProject)entry.getKey();
                ArrayList allOpenables = (ArrayList)entry.getValue();
                Openable[] openables = new Openable[allOpenables.size()];
                allOpenables.toArray(openables);
                try {
                    SearchableEnvironment searchableEnvironment = project.newSearchableNameEnvironment(this.hierarchy.workingCopies);
                    this.nameLookup = searchableEnvironment.nameLookup;
                    this.hierarchyResolver.resolve(openables, null, monitor);
                }
                catch (JavaScriptModelException javaScriptModelException) {
                    // empty catch block
                }
            }
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private HashMap determineOpenablesInRegion(IProgressMonitor monitor) {
        try {
            HashMap allOpenables = new HashMap();
            IJavaScriptElement[] roots = ((RegionBasedTypeHierarchy)this.hierarchy).region.getElements();
            int length = roots.length;
            if (monitor != null) {
                monitor.beginTask("", length);
            }
            int i = 0;
            while (i < length) {
                IJavaScriptElement root = roots[i];
                IJavaScriptProject javaProject = root.getJavaScriptProject();
                ArrayList<IJavaScriptElement> openables = (ArrayList<IJavaScriptElement>)allOpenables.get(javaProject);
                if (openables == null) {
                    openables = new ArrayList<IJavaScriptElement>();
                    allOpenables.put(javaProject, openables);
                }
                switch (root.getElementType()) {
                    case 2: {
                        this.injectAllOpenablesForJavaProject((IJavaScriptProject)root, openables);
                        break;
                    }
                    case 3: {
                        this.injectAllOpenablesForPackageFragmentRoot((IPackageFragmentRoot)root, openables);
                        break;
                    }
                    case 4: {
                        this.injectAllOpenablesForPackageFragment((IPackageFragment)root, openables);
                        break;
                    }
                    case 5: 
                    case 6: {
                        openables.add(root);
                        break;
                    }
                    case 7: {
                        IType type = (IType)root;
                        if (type.isBinary()) {
                            openables.add(type.getClassFile());
                            break;
                        }
                        openables.add(type.getJavaScriptUnit());
                        break;
                    }
                }
                this.worked(monitor, 1);
                ++i;
            }
            HashMap hashMap = allOpenables;
            return hashMap;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    private void injectAllOpenablesForJavaProject(IJavaScriptProject project, ArrayList openables) {
        try {
            IPackageFragmentRoot[] devPathRoots = ((JavaProject)project).getPackageFragmentRoots();
            if (devPathRoots == null) {
                return;
            }
            int j = 0;
            while (j < devPathRoots.length) {
                IPackageFragmentRoot root = devPathRoots[j];
                this.injectAllOpenablesForPackageFragmentRoot(root, openables);
                ++j;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
    }

    private void injectAllOpenablesForPackageFragment(IPackageFragment packFrag, ArrayList openables) {
        try {
            IPackageFragmentRoot root = (IPackageFragmentRoot)packFrag.getParent();
            int kind = root.getKind();
            if (kind != 0) {
                boolean isSourcePackageFragment;
                boolean bl = isSourcePackageFragment = kind == 1;
                if (isSourcePackageFragment) {
                    IJavaScriptUnit[] cus = packFrag.getJavaScriptUnits();
                    int i = 0;
                    int length = cus.length;
                    while (i < length) {
                        openables.add(cus[i]);
                        ++i;
                    }
                } else {
                    IClassFile[] classFiles = packFrag.getClassFiles();
                    int i = 0;
                    int length = classFiles.length;
                    while (i < length) {
                        openables.add(classFiles[i]);
                        ++i;
                    }
                }
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
    }

    private void injectAllOpenablesForPackageFragmentRoot(IPackageFragmentRoot root, ArrayList openables) {
        try {
            IJavaScriptElement[] packFrags = root.getChildren();
            int k = 0;
            while (k < packFrags.length) {
                IPackageFragment packFrag = (IPackageFragment)packFrags[k];
                this.injectAllOpenablesForPackageFragment(packFrag, openables);
                ++k;
            }
        }
        catch (JavaScriptModelException e) {
            return;
        }
    }
}

