/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import java.io.File;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.wst.jsdt.internal.core.ClasspathEntry;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.JavaModel;
import org.eclipse.wst.jsdt.internal.core.JavaModelManager;
import org.eclipse.wst.jsdt.internal.core.JavaProject;
import org.eclipse.wst.jsdt.internal.core.PackageFragment;
import org.eclipse.wst.jsdt.internal.core.search.AbstractSearchScope;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaSearchScope
extends AbstractSearchScope {
    private ArrayList elements;
    private ArrayList projectPaths = new ArrayList();
    private int[] projectIndexes;
    private String[] containerPaths;
    private String[] relativePaths;
    private boolean[] isPkgPath;
    protected AccessRuleSet[] pathRestrictions;
    private int pathsCount;
    private int threshold;
    private IPath[] enclosingProjectsAndJars;
    private Hashtable exclusionPathList = new Hashtable();
    public static final AccessRuleSet NOT_ENCLOSED = new AccessRuleSet(null, null);

    public JavaSearchScope() {
        this(5);
    }

    private JavaSearchScope(int size) {
        this.initialize(size);
    }

    private void addEnclosingProjectOrJar(IPath path) {
        int length = this.enclosingProjectsAndJars.length;
        int i = 0;
        while (i < length) {
            if (this.enclosingProjectsAndJars[i].equals((Object)path)) {
                return;
            }
            ++i;
        }
        this.enclosingProjectsAndJars = new IPath[length + 1];
        System.arraycopy(this.enclosingProjectsAndJars, 0, this.enclosingProjectsAndJars, 0, length);
        this.enclosingProjectsAndJars[length] = path;
    }

    public void add(JavaProject project, int includeMask, HashSet visitedProject) throws JavaScriptModelException {
        this.add(project, null, includeMask, visitedProject, null);
    }

    void add(JavaProject javaProject, IPath pathToAdd, int includeMask, HashSet visitedProjects, IIncludePathEntry referringEntry) throws JavaScriptModelException {
        IProject project = javaProject.getProject();
        if (!project.isAccessible() || !visitedProjects.add(project)) {
            return;
        }
        IPath projectPath = project.getFullPath();
        String projectPathString = projectPath.toString();
        this.addEnclosingProjectOrJar(projectPath);
        IIncludePathEntry[] entries = javaProject.getResolvedClasspath();
        IJavaScriptModel model = javaProject.getJavaScriptModel();
        JavaModelManager.PerProjectInfo perProjectInfo = javaProject.getPerProjectInfo();
        int i = 0;
        int length = entries.length;
        while (i < length) {
            block16: {
                ClasspathEntry cpEntry;
                AccessRuleSet access;
                IIncludePathEntry entry;
                block15: {
                    entry = entries[i];
                    access = null;
                    cpEntry = (ClasspathEntry)entry;
                    if (referringEntry == null) break block15;
                    if (!entry.isExported() && entry.getEntryKind() != 3) break block16;
                    cpEntry = cpEntry.combineWith((ClasspathEntry)referringEntry);
                }
                access = cpEntry.getAccessRuleSet();
                block0 : switch (entry.getEntryKind()) {
                    case 1: {
                        IPath path;
                        IIncludePathEntry rawEntry = null;
                        Map rootPathToRawEntries = perProjectInfo.rootPathToRawEntries;
                        if (rootPathToRawEntries != null) {
                            rawEntry = (IIncludePathEntry)rootPathToRawEntries.get(entry.getPath());
                        }
                        if (rawEntry == null) break;
                        switch (rawEntry.getEntryKind()) {
                            case 1: 
                            case 4: {
                                if ((includeMask & 2) == 0) break;
                                path = entry.getPath();
                                if (pathToAdd != null && !pathToAdd.equals((Object)path)) break block0;
                                String pathToString = path.getDevice() == null ? path.toString() : path.toOSString();
                                this.add(projectPath.toString(), "", pathToString, false, access);
                                this.addEnclosingProjectOrJar(path);
                                break;
                            }
                            case 5: {
                                IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer(rawEntry.getPath(), javaProject);
                                if (container == null || (container.getKind() != 1 || (includeMask & 2) == 0) && (includeMask & 4) == 0) break block0;
                                IPath path2 = entry.getPath();
                                if (pathToAdd != null && !pathToAdd.equals((Object)path2)) break block0;
                                String pathToString = path2.getDevice() == null ? path2.toString() : path2.toOSString();
                                this.add(projectPath.toString(), "", pathToString, false, access);
                                this.addEnclosingProjectOrJar(path2);
                            }
                        }
                        break;
                    }
                    case 2: {
                        if ((includeMask & 8) == 0) break;
                        IPath path = entry.getPath();
                        if (pathToAdd != null && !pathToAdd.equals((Object)path)) break;
                        this.add((JavaProject)model.getJavaScriptProject(entry.getPath().lastSegment()), null, includeMask, visitedProjects, cpEntry);
                        break;
                    }
                    case 3: {
                        if ((includeMask & 1) == 0) break;
                        IPath path = entry.getPath();
                        if (pathToAdd != null && !pathToAdd.equals((Object)path)) break;
                        this.add(projectPath.toString(), Util.relativePath(path, 1), projectPathString, false, access);
                    }
                }
            }
            ++i;
        }
    }

    public void add(IJavaScriptElement element) throws JavaScriptModelException {
        this.add(element, true);
    }

    public void add(IJavaScriptElement element, boolean excludeSubfolders) throws JavaScriptModelException {
        IPath containerPath = null;
        String containerPathToString = null;
        int includeMask = 7;
        switch (element.getElementType()) {
            case 1: {
                break;
            }
            case 2: {
                this.add((JavaProject)element, null, includeMask, new HashSet(2), null);
                break;
            }
            case 3: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element;
                IPath rootPath = root.getPath();
                IIncludePathEntry entry = root.getResolvedIncludepathEntry();
                if (entry == null) break;
                IPath[] exclusionsPaths = entry.getExclusionPatterns();
                if (exclusionsPaths != null && exclusionsPaths.length > 0) {
                    this.addExclusions(rootPath, exclusionsPaths);
                }
                containerPath = root.getKind() == 1 ? root.getParent().getPath() : rootPath;
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                IResource rootResource = root.getResource();
                String projectPath = root.getJavaScriptProject().getPath().toString();
                if (rootResource != null && rootResource.isAccessible()) {
                    String relativePath = Util.relativePath(rootResource.getFullPath(), containerPath.segmentCount());
                    this.add(projectPath, relativePath, containerPathToString, false, null);
                    break;
                }
                this.add(projectPath, "", containerPathToString, false, null);
                break;
            }
            case 4: {
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getParent();
                String projectPath = root.getJavaScriptProject().getPath().toString();
                if (root.isArchive()) {
                    String relativePath = Util.concatWith(((PackageFragment)element).names, '/');
                    containerPath = root.getPath();
                    containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                    this.add(projectPath, relativePath, containerPathToString, excludeSubfolders, null);
                    break;
                }
                IResource resource = element.getResource();
                if (resource == null) break;
                containerPath = resource.isAccessible() ? (root.getKind() == 1 ? root.getParent().getPath() : root.getPath()) : resource.getParent().getFullPath();
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                String relativePath = Util.relativePath(resource.getFullPath(), containerPath.segmentCount());
                this.add(projectPath, relativePath, containerPathToString, excludeSubfolders, null);
                break;
            }
            default: {
                String relativePath;
                if (element instanceof IMember) {
                    if (this.elements == null) {
                        this.elements = new ArrayList();
                    }
                    this.elements.add(element);
                }
                IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
                String projectPath = root.getJavaScriptProject().getPath().toString();
                if (root.getKind() == 1) {
                    containerPath = root.getParent().getPath();
                    relativePath = Util.relativePath(this.getPath(element, false), 1);
                } else {
                    containerPath = root.getPath();
                    relativePath = this.getPath(element, true).toString();
                }
                containerPathToString = containerPath.getDevice() == null ? containerPath.toString() : containerPath.toOSString();
                this.add(projectPath, relativePath, containerPathToString, false, null);
            }
        }
        if (containerPath != null) {
            this.addEnclosingProjectOrJar(containerPath);
        }
    }

    private void addExclusions(IPath containerPath, IPath[] exclusionsPaths) {
        this.exclusionPathList.put(containerPath.toString(), exclusionsPaths);
    }

    public boolean shouldExclude(String container, String resourceName) {
        boolean shouldExclude = false;
        if (container == null || resourceName == null || this.exclusionPathList.size() == 0) {
            return false;
        }
        IPath[] exclusions = (IPath[])this.exclusionPathList.get(container);
        if (exclusions == null) {
            return false;
        }
        Path fullPath = new Path(String.valueOf(container) + "/" + resourceName);
        int i = 0;
        while (!shouldExclude && i < exclusions.length) {
            shouldExclude = Util.isExcluded((IPath)fullPath, null, (char[][])new char[][]{exclusions[i].toString().toCharArray()});
            ++i;
        }
        return shouldExclude;
    }

    private void add(String projectPath, String relativePath, String containerPath, boolean isPackage, AccessRuleSet access) {
        String currentContainerPath;
        String currentRelativePath;
        containerPath = this.normalize(containerPath);
        relativePath = this.normalize(relativePath);
        int length = this.containerPaths.length;
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentRelativePath = this.relativePaths[index]) != null && (currentContainerPath = this.containerPaths[index]) != null) {
            if (currentRelativePath.equals(relativePath) && currentContainerPath.equals(containerPath)) {
                return;
            }
            if (++index != length) continue;
            index = 0;
        }
        int idx = this.projectPaths.indexOf(projectPath);
        if (idx == -1) {
            this.projectPaths.add(projectPath);
            idx = this.projectPaths.indexOf(projectPath);
        }
        this.projectIndexes[index] = idx;
        this.relativePaths[index] = relativePath;
        this.containerPaths[index] = containerPath;
        this.isPkgPath[index] = isPackage;
        if (this.pathRestrictions != null) {
            this.pathRestrictions[index] = access;
        } else if (access != null) {
            this.pathRestrictions = new AccessRuleSet[this.relativePaths.length];
            this.pathRestrictions[index] = access;
        }
        if (++this.pathsCount > this.threshold) {
            this.rehash();
        }
    }

    public boolean encloses(String resourcePathString) {
        int separatorIndex = resourcePathString.indexOf("|");
        if (separatorIndex != -1) {
            String relativePath;
            String jarPath = resourcePathString.substring(0, separatorIndex);
            return this.indexOf(jarPath, relativePath = resourcePathString.substring(separatorIndex + 1)) >= 0;
        }
        return this.indexOf(resourcePathString) >= 0;
    }

    private int indexOf(String fullPath) {
        int answer = -1;
        String answerFullPath = null;
        int i = 0;
        int length = this.relativePaths.length;
        while (i < length) {
            String currentRelativePath = this.relativePaths[i];
            if (currentRelativePath != null) {
                String currentFullPath;
                String currentContainerPath = this.containerPaths[i];
                String string = currentFullPath = currentRelativePath.length() == 0 ? currentContainerPath : String.valueOf(currentContainerPath) + '/' + currentRelativePath;
                if (this.encloses(currentFullPath, fullPath, i) && (answerFullPath == null || !this.encloses(currentFullPath, answerFullPath, i))) {
                    answerFullPath = currentFullPath;
                    answer = i;
                }
            }
            ++i;
        }
        return answer;
    }

    private int indexOf(String containerPath, String relativePath) {
        String currentContainerPath;
        int length = this.containerPaths.length;
        int index = (containerPath.hashCode() & Integer.MAX_VALUE) % length;
        while ((currentContainerPath = this.containerPaths[index]) != null) {
            String currentRelativePath;
            if (currentContainerPath.equals(containerPath) && this.encloses(currentRelativePath = this.relativePaths[index], relativePath, index)) {
                return index;
            }
            if (++index != length) continue;
            index = 0;
        }
        return -1;
    }

    private boolean encloses(String enclosingPath, String path, int index) {
        int enclosingLength;
        int pathLength = (path = this.normalize(path)).length();
        if (pathLength < (enclosingLength = enclosingPath.length())) {
            return false;
        }
        if (enclosingLength == 0) {
            return true;
        }
        if (pathLength == enclosingLength) {
            Path path1 = new Path(path);
            Path path2 = new Path(enclosingPath);
            return path1.equals((Object)path2);
        }
        if (!this.isPkgPath[index]) {
            return path.startsWith(enclosingPath) && path.charAt(enclosingLength) == '/';
        }
        return path.startsWith(enclosingPath) && (enclosingPath.length() == path.lastIndexOf(47) || enclosingPath.length() == path.length());
    }

    public boolean encloses(IJavaScriptElement element) {
        if (this.elements != null) {
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                IJavaScriptElement scopeElement = (IJavaScriptElement)this.elements.get(i);
                IJavaScriptElement searchedElement = element;
                while (searchedElement != null) {
                    if (searchedElement.equals(scopeElement)) {
                        return true;
                    }
                    searchedElement = searchedElement.getParent();
                }
                ++i;
            }
            return false;
        }
        IPackageFragmentRoot root = (IPackageFragmentRoot)element.getAncestor(3);
        if (root != null && root.isArchive()) {
            IPath relativePath;
            IPath rootPath = root.getPath();
            String rootPathToString = rootPath.getDevice() == null ? rootPath.toString() : rootPath.toOSString();
            return this.indexOf(rootPathToString, (relativePath = this.getPath(element, true)).toString()) >= 0;
        }
        String fullResourcePathString = this.getPath(element, false).toString();
        return this.indexOf(fullResourcePathString) >= 0;
    }

    public IPath[] enclosingProjectsAndJars() {
        return this.enclosingProjectsAndJars;
    }

    private IPath getPath(IJavaScriptElement element, boolean relativeToRoot) {
        switch (element.getElementType()) {
            case 1: {
                return Path.EMPTY;
            }
            case 2: {
                return element.getPath();
            }
            case 3: {
                if (relativeToRoot) {
                    return Path.EMPTY;
                }
                return element.getPath();
            }
            case 4: {
                String relativePath = Util.concatWith(((PackageFragment)element).names, '/');
                return this.getPath(element.getParent(), relativeToRoot).append((IPath)new Path(relativePath));
            }
            case 5: 
            case 6: {
                return this.getPath(element.getParent(), relativeToRoot).append((IPath)new Path(element.getElementName()));
            }
        }
        return this.getPath(element.getParent(), relativeToRoot);
    }

    public AccessRuleSet getAccessRuleSet(String relativePath, String containerPath) {
        int index = this.indexOf(containerPath, relativePath);
        if (index == -1) {
            return NOT_ENCLOSED;
        }
        if (this.pathRestrictions == null) {
            return null;
        }
        return this.pathRestrictions[index];
    }

    protected void initialize(int size) {
        this.pathsCount = 0;
        this.threshold = size;
        int extraRoom = (int)((float)size * 1.75f);
        if (this.threshold == extraRoom) {
            ++extraRoom;
        }
        this.relativePaths = new String[extraRoom];
        this.containerPaths = new String[extraRoom];
        this.projectPaths = new ArrayList();
        this.projectIndexes = new int[extraRoom];
        this.isPkgPath = new boolean[extraRoom];
        this.pathRestrictions = null;
        this.enclosingProjectsAndJars = new IPath[0];
    }

    private String normalize(String path) {
        int pathLength = path.length();
        int index = pathLength - 1;
        while (index >= 0 && path.charAt(index) == '/') {
            --index;
        }
        if (index != pathLength - 1) {
            return path.substring(0, index + 1);
        }
        return path;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void processDelta(IJavaScriptElementDelta delta) {
        switch (delta.getKind()) {
            case 4: {
                IJavaScriptElementDelta[] children = delta.getAffectedChildren();
                int i = 0;
                int length = children.length;
                while (i < length) {
                    IJavaScriptElementDelta child = children[i];
                    this.processDelta(child);
                    ++i;
                }
                return;
            }
            case 2: {
                IJavaScriptElement element = delta.getElement();
                if (!this.encloses(element)) return;
                if (this.elements != null) {
                    this.elements.remove(element);
                }
                IPath path = null;
                switch (element.getElementType()) {
                    case 2: {
                        path = ((IJavaScriptProject)element).getProject().getFullPath();
                    }
                    case 3: {
                        if (path == null) {
                            path = ((IPackageFragmentRoot)element).getPath();
                        }
                        int toRemove = -1;
                        int i = 0;
                        while (i < this.pathsCount) {
                            if (this.relativePaths[i].equals(path)) {
                                toRemove = i;
                                break;
                            }
                            ++i;
                        }
                        if (toRemove == -1) return;
                        this.relativePaths[toRemove] = null;
                        this.rehash();
                    }
                }
            }
        }
    }

    public IPackageFragmentRoot packageFragmentRoot(String resourcePathString) {
        boolean isJarFile;
        int index = -1;
        int separatorIndex = resourcePathString.indexOf("|");
        boolean bl = isJarFile = separatorIndex != -1;
        if (isJarFile) {
            String jarPath = resourcePathString.substring(0, separatorIndex);
            String relativePath = resourcePathString.substring(separatorIndex + 1);
            index = this.indexOf(jarPath, relativePath);
        } else {
            index = this.indexOf(resourcePathString);
        }
        if (index >= 0) {
            String projectPath;
            int idx = this.projectIndexes[index];
            String string = projectPath = idx == -1 ? null : (String)this.projectPaths.get(idx);
            if (projectPath != null) {
                IJavaScriptProject project = JavaScriptCore.create(ResourcesPlugin.getWorkspace().getRoot().getProject(projectPath));
                if (isJarFile) {
                    return project.getPackageFragmentRoot(this.containerPaths[index]);
                }
                Object target = JavaModel.getTarget((IContainer)ResourcesPlugin.getWorkspace().getRoot(), (IPath)new Path(String.valueOf(this.containerPaths[index]) + '/' + this.relativePaths[index]), false);
                if (target instanceof IProject) {
                    return project.getPackageFragmentRoot((IResource)((IProject)target));
                }
                if (target instanceof IResource) {
                    IJavaScriptElement element = JavaScriptCore.create((IResource)target);
                    return (IPackageFragmentRoot)element.getAncestor(3);
                }
                if (target instanceof File) {
                    return project.getPackageFragmentRoot(this.containerPaths[index]);
                }
            }
        }
        return null;
    }

    private void rehash() {
        JavaSearchScope newScope = new JavaSearchScope(this.pathsCount * 2);
        newScope.projectPaths.ensureCapacity(this.projectPaths.size());
        int i = this.relativePaths.length;
        while (--i >= 0) {
            String currentPath = this.relativePaths[i];
            if (currentPath == null) continue;
            int idx = this.projectIndexes[i];
            String projectPath = idx == -1 ? null : (String)this.projectPaths.get(idx);
            newScope.add(projectPath, currentPath, this.containerPaths[i], this.isPkgPath[i], this.pathRestrictions == null ? null : this.pathRestrictions[i]);
        }
        this.relativePaths = newScope.relativePaths;
        this.containerPaths = newScope.containerPaths;
        this.projectPaths = newScope.projectPaths;
        this.projectIndexes = newScope.projectIndexes;
        this.isPkgPath = newScope.isPkgPath;
        this.pathRestrictions = newScope.pathRestrictions;
        this.threshold = newScope.threshold;
    }

    public String toString() {
        StringBuffer result = new StringBuffer("JavaSearchScope on ");
        if (this.elements != null) {
            result.append("[");
            int i = 0;
            int length = this.elements.size();
            while (i < length) {
                JavaElement element = (JavaElement)this.elements.get(i);
                result.append("\n\t");
                result.append(element.toStringWithAncestors());
                ++i;
            }
            result.append("\n]");
        } else if (this.pathsCount == 0) {
            result.append("[empty scope]");
        } else {
            result.append("[");
            int i = 0;
            while (i < this.relativePaths.length) {
                String path = this.relativePaths[i];
                if (path != null) {
                    result.append("\n\t");
                    result.append(this.containerPaths[i]);
                    if (path.length() > 0) {
                        result.append('/');
                        result.append(path);
                    }
                }
                ++i;
            }
            result.append("\n]");
        }
        return result.toString();
    }
}

