/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search;

import org.eclipse.core.runtime.Path;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.IJavaScriptSearchScope;
import org.eclipse.wst.jsdt.core.search.ModuleMatchRequestor;
import org.eclipse.wst.jsdt.internal.core.LibraryFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.PackageFragmentRoot;
import org.eclipse.wst.jsdt.internal.core.search.IModuleRequestor;
import org.eclipse.wst.jsdt.internal.core.search.JavaSearchScope;
import org.eclipse.wst.jsdt.internal.core.util.HashtableOfArrayToObject;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class ModuleMatchRequestorWrapper
implements IModuleRequestor {
    ModuleMatchRequestor requestor;
    private IJavaScriptSearchScope scope;
    private String lastPkgFragmentRootPath;
    private IPackageFragmentRoot lastPkgFragmentRoot;
    private HashtableOfArrayToObject packageHandles;

    public ModuleMatchRequestorWrapper(ModuleMatchRequestor requestor, IJavaScriptSearchScope scope) {
        this.requestor = requestor;
        this.scope = scope;
    }

    public void acceptType(char[] qualification, char[] simpleName, String path) {
        try {
            int separatorIndex;
            IType type = null;
            if (qualification != null && qualification.length > 0 && CharOperation.indexOf('.', simpleName) == -1) {
                simpleName = CharOperation.concat(qualification, simpleName, '.');
            }
            IType iType = type = (separatorIndex = path.indexOf("|")) == -1 ? this.createTypeFromPath(path, new String(simpleName)) : this.createTypeFromJar(path, separatorIndex);
            if (type != null && !type.isAnonymous()) {
                this.requestor.acceptElementMatch(type);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
    }

    public void acceptFunction(char[] signature, char[] declaringQualification, char[] declaringSimpleName, String path) {
        try {
            IFunction method;
            int separatorIndex;
            IType type = null;
            if (declaringQualification != null && declaringQualification.length > 0 && CharOperation.indexOf('.', declaringSimpleName) == -1) {
                declaringSimpleName = CharOperation.concat(declaringQualification, declaringSimpleName, '.');
            }
            IType iType = type = (separatorIndex = path.indexOf("|")) == -1 ? this.createTypeFromPath(path, new String(declaringSimpleName)) : this.createTypeFromJar(path, separatorIndex);
            if (type != null && (method = type.getFunction(CharOperation.charToString(signature), new String[0])).exists()) {
                this.requestor.acceptElementMatch(method);
                return;
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
    }

    public void acceptField(char[] signature, char[] declaringQualification, char[] declaringSimpleName, String path) {
        try {
            IField field;
            int separatorIndex;
            IType type = null;
            if (declaringQualification != null && declaringQualification.length > 0 && CharOperation.indexOf('.', declaringSimpleName) == -1) {
                declaringSimpleName = CharOperation.concat(declaringQualification, declaringSimpleName, '.');
            }
            IType iType = type = (separatorIndex = path.indexOf("|")) == -1 ? this.createTypeFromPath(path, new String(declaringSimpleName)) : this.createTypeFromJar(path, separatorIndex);
            if (type != null && (field = type.getField(CharOperation.charToString(signature))).exists()) {
                this.requestor.acceptElementMatch(field);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
    }

    public void acceptType(IType type) {
        this.requestor.acceptElementMatch(type);
    }

    public void acceptFunction(IFunction function) {
        this.requestor.acceptElementMatch(function);
    }

    public void acceptField(IField field) {
        this.requestor.acceptElementMatch(field);
    }

    private IType createTypeFromJar(String resourcePath, int separatorIndex) throws JavaScriptModelException {
        Object[] pkgName;
        String classFilePath;
        String[] simpleNames;
        int length;
        if (this.lastPkgFragmentRootPath == null || this.lastPkgFragmentRootPath.length() > resourcePath.length() || !resourcePath.startsWith(this.lastPkgFragmentRootPath)) {
            String jarPath = resourcePath.substring(0, separatorIndex);
            IPackageFragmentRoot root = ((JavaSearchScope)this.scope).packageFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRootPath = jarPath;
            this.lastPkgFragmentRoot = root;
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        if ((length = (simpleNames = new Path(classFilePath = resourcePath.substring(separatorIndex + 1)).segments()).length - 1) > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        return pkgFragment.getClassFile(simpleNames[length]).getType();
    }

    private IType createTypeFromPath(String resourcePath, String typeName) throws JavaScriptModelException {
        String simpleName;
        Object[] pkgName;
        boolean isLibrary;
        int rootPathLength = -1;
        boolean samePath = false;
        if (resourcePath != null && this.lastPkgFragmentRoot != null) {
            Path path1 = new Path(resourcePath);
            Path path2 = new Path(this.lastPkgFragmentRootPath);
            samePath = path1.equals((Object)path2);
        }
        if (!(samePath || this.lastPkgFragmentRootPath != null && resourcePath.startsWith(this.lastPkgFragmentRootPath) && (rootPathLength = this.lastPkgFragmentRootPath.length()) > 0 && rootPathLength < resourcePath.length() && resourcePath.charAt(rootPathLength) == '/')) {
            IPackageFragmentRoot root = ((JavaSearchScope)this.scope).packageFragmentRoot(resourcePath);
            if (root == null) {
                return null;
            }
            this.lastPkgFragmentRoot = root;
            this.lastPkgFragmentRootPath = this.lastPkgFragmentRoot.getPath().toString();
            this.packageHandles = new HashtableOfArrayToObject(5);
        }
        boolean bl = isLibrary = this.lastPkgFragmentRoot instanceof LibraryFragmentRoot && !((LibraryFragmentRoot)this.lastPkgFragmentRoot).isDirectory();
        if (isLibrary) {
            Object[] pkgName2 = new String[]{this.lastPkgFragmentRootPath};
            IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName2);
            if (pkgFragment == null) {
                pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String)pkgName2[0]);
                this.packageHandles.put(pkgName2, pkgFragment);
            }
            IClassFile classFile = pkgFragment.getClassFile((String)pkgName2[0]);
            return classFile.getType(typeName);
        }
        String[] simpleNames = new Path(resourcePath = resourcePath.substring(this.lastPkgFragmentRootPath.length() + 1)).segments();
        int length = simpleNames.length - 1;
        if (length > 0) {
            pkgName = new String[length];
            System.arraycopy(simpleNames, 0, pkgName, 0, length);
        } else {
            pkgName = CharOperation.NO_STRINGS;
        }
        IPackageFragment pkgFragment = (IPackageFragment)this.packageHandles.get(pkgName);
        if (pkgFragment == null) {
            pkgFragment = ((PackageFragmentRoot)this.lastPkgFragmentRoot).getPackageFragment((String[])pkgName);
            this.packageHandles.put(pkgName, pkgFragment);
        }
        if (Util.isJavaLikeFileName(simpleName = simpleNames[length]) && pkgFragment.getKind() != 2) {
            IJavaScriptUnit unit = pkgFragment.getJavaScriptUnit(simpleName);
            IType type = unit.getType(typeName);
            return type;
        }
        IClassFile classFile = pkgFragment.getClassFile(simpleName);
        return classFile.getType(typeName);
    }
}

