/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryField;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.wst.jsdt.internal.compiler.env.IBinaryType;
import org.eclipse.wst.jsdt.internal.compiler.lookup.BinaryTypeBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.wst.jsdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.wst.jsdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.wst.jsdt.internal.core.BinaryType;
import org.eclipse.wst.jsdt.internal.core.ClassFile;
import org.eclipse.wst.jsdt.internal.core.JavaElement;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryField;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryMethod;
import org.eclipse.wst.jsdt.internal.core.ResolvedBinaryType;
import org.eclipse.wst.jsdt.internal.core.search.indexing.IIndexConstants;
import org.eclipse.wst.jsdt.internal.core.search.matching.ConstructorPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.FieldPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.MatchLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.MethodPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.OrPattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.PatternLocator;
import org.eclipse.wst.jsdt.internal.core.search.matching.SuperTypeReferencePattern;
import org.eclipse.wst.jsdt.internal.core.search.matching.TypeDeclarationPattern;
import org.eclipse.wst.jsdt.internal.core.util.QualificationHelpers;

public class ClassFileMatchLocator
implements IIndexConstants {
    public static char[] convertClassFileFormat(char[] name) {
        return CharOperation.replaceOnCopy(name, '/', '.');
    }

    private boolean checkDeclaringType(IBinaryType enclosingBinaryType, char[] simpleName, char[] qualification, boolean isCaseSensitive, boolean isCamelCase) {
        if (simpleName == null && qualification == null) {
            return true;
        }
        if (enclosingBinaryType == null) {
            return true;
        }
        char[] declaringTypeName = ClassFileMatchLocator.convertClassFileFormat(enclosingBinaryType.getName());
        return this.checkTypeName(simpleName, qualification, declaringTypeName, isCaseSensitive, isCamelCase);
    }

    private boolean checkParameters(char[] methodDescriptor, char[][] parameterSimpleNames, char[][] parameterQualifications, boolean isCaseSensitive, boolean isCamelCase) {
        int parameterCount = parameterSimpleNames.length;
        char[][] arguments = Signature.getParameterTypes(methodDescriptor);
        if (parameterCount != arguments.length) {
            return false;
        }
        int i = 0;
        while (i < parameterCount) {
            if (!this.checkTypeName(parameterSimpleNames[i], parameterQualifications[i], Signature.toCharArray(arguments[i]), isCaseSensitive, isCamelCase)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean checkTypeName(char[] simpleName, char[] qualification, char[] fullyQualifiedTypeName, boolean isCaseSensitive, boolean isCamelCase) {
        char[] wildcardPattern = PatternLocator.qualifiedPattern(simpleName, qualification);
        if (wildcardPattern == null) {
            return true;
        }
        return CharOperation.match(wildcardPattern, fullyQualifiedTypeName, isCaseSensitive);
    }

    private boolean checkTypeName(char[] typeName1, char[] typeName2, boolean isCaseSensitive, boolean isCamelCase) {
        char[][] typeNameSeperated = QualificationHelpers.seperateFullyQualifedName(typeName1);
        char[] wildcardPattern = PatternLocator.qualifiedPattern(typeNameSeperated[1], typeNameSeperated[0]);
        if (wildcardPattern == null) {
            return true;
        }
        return CharOperation.match(wildcardPattern, typeName2, isCaseSensitive);
    }

    public void locateMatches(MatchLocator locator, ClassFile classFile, IBinaryType info) throws CoreException {
        IBinaryField[] fields;
        IBinaryMethod[] methods;
        SearchPattern pattern = locator.pattern;
        BinaryType binaryType = (BinaryType)classFile.getType();
        if (this.matchBinary(pattern, info, null)) {
            binaryType = new ResolvedBinaryType((JavaElement)binaryType.getParent(), binaryType.getElementName(), binaryType.getKey());
            locator.reportBinaryMemberDeclaration(null, binaryType, null, info, 0);
        }
        int accuracy = 0;
        if (pattern.mustResolve) {
            try {
                BinaryTypeBinding binding = locator.cacheBinaryType(binaryType, info);
                if (binding != null) {
                    if (!locator.typeInHierarchy(binding)) {
                        return;
                    }
                    MethodBinding[] methods2 = binding.methods();
                    int i = 0;
                    int l = methods2.length;
                    while (i < l) {
                        MethodBinding method = methods2[i];
                        if (locator.patternLocator.resolveLevel(method) == 3) {
                            char[] methodSignature = method.signature();
                            IFunction methodHandle = binaryType.getFunction(new String(method.isConstructor() ? binding.compoundName[binding.compoundName.length - 1] : method.selector), CharOperation.toStrings(Signature.getParameterTypes(ClassFileMatchLocator.convertClassFileFormat(methodSignature))));
                            locator.reportBinaryMemberDeclaration(null, methodHandle, method, info, 0);
                        }
                        ++i;
                    }
                    FieldBinding[] fields2 = binding.fields();
                    int i2 = 0;
                    int l2 = fields2.length;
                    while (i2 < l2) {
                        FieldBinding field = fields2[i2];
                        if (locator.patternLocator.resolveLevel(field) == 3) {
                            IField fieldHandle = binaryType.getField(new String(field.name));
                            locator.reportBinaryMemberDeclaration(null, fieldHandle, field, info, 0);
                        }
                        ++i2;
                    }
                    return;
                }
            }
            catch (AbortCompilation binding) {
                // empty catch block
            }
            accuracy = 1;
        }
        if ((methods = info.getMethods()) != null) {
            int i = 0;
            int l = methods.length;
            while (i < l) {
                IBinaryMethod method = methods[i];
                if (this.matchBinary(pattern, method, info)) {
                    char[] name;
                    if (method.isConstructor()) {
                        name = info.getName();
                        int lastSlash = CharOperation.lastIndexOf('/', name);
                        if (lastSlash != -1) {
                            name = CharOperation.subarray(name, lastSlash + 1, name.length);
                        }
                    } else {
                        name = method.getSelector();
                    }
                    String selector = new String(name);
                    String[] parameterTypes = CharOperation.toStrings(Signature.getParameterTypes(ClassFileMatchLocator.convertClassFileFormat(method.getMethodDescriptor())));
                    IFunction methodHandle = binaryType.getFunction(selector, parameterTypes);
                    methodHandle = new ResolvedBinaryMethod(binaryType, selector, parameterTypes, methodHandle.getKey());
                    locator.reportBinaryMemberDeclaration(null, methodHandle, null, info, accuracy);
                }
                ++i;
            }
        }
        if ((fields = info.getFields()) != null) {
            int i = 0;
            int l = fields.length;
            while (i < l) {
                IBinaryField field = fields[i];
                if (this.matchBinary(pattern, field, info)) {
                    String fieldName = new String(field.getName());
                    IField fieldHandle = binaryType.getField(fieldName);
                    fieldHandle = new ResolvedBinaryField(binaryType, fieldName, fieldHandle.getKey());
                    locator.reportBinaryMemberDeclaration(null, fieldHandle, null, info, accuracy);
                }
                ++i;
            }
        }
    }

    boolean matchBinary(SearchPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        switch (pattern.kind) {
            case 32: {
                return this.matchConstructor((ConstructorPattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 64: {
                return this.matchField((FieldPattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 128: {
                return this.matchMethod((MethodPattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 16: {
                return this.matchSuperTypeReference((SuperTypeReferencePattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 8: {
                return this.matchTypeDeclaration((TypeDeclarationPattern)pattern, binaryInfo, enclosingBinaryType);
            }
            case 256: {
                SearchPattern[] patterns = ((OrPattern)pattern).patterns;
                int i = 0;
                int length = patterns.length;
                while (i < length) {
                    if (this.matchBinary(patterns[i], binaryInfo, enclosingBinaryType)) {
                        return true;
                    }
                    ++i;
                }
                break;
            }
        }
        return false;
    }

    boolean matchConstructor(ConstructorPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        char[] methodDescriptor;
        if (!pattern.findDeclarations) {
            return false;
        }
        if (!(binaryInfo instanceof IBinaryMethod)) {
            return false;
        }
        IBinaryMethod method = (IBinaryMethod)binaryInfo;
        if (!method.isConstructor()) {
            return false;
        }
        if (!this.checkDeclaringType(enclosingBinaryType, pattern.declaringSimpleName, pattern.declaringQualification, pattern.isCaseSensitive(), pattern.isCamelCase())) {
            return false;
        }
        return pattern.parameterSimpleNames == null || this.checkParameters(methodDescriptor = ClassFileMatchLocator.convertClassFileFormat(method.getMethodDescriptor()), pattern.parameterSimpleNames, pattern.parameterQualifications, pattern.isCaseSensitive(), pattern.isCamelCase());
    }

    boolean matchField(FieldPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        if (!pattern.findDeclarations) {
            return false;
        }
        if (!(binaryInfo instanceof IBinaryField)) {
            return false;
        }
        IBinaryField field = (IBinaryField)binaryInfo;
        if (!pattern.matchesName(pattern.name, field.getName())) {
            return false;
        }
        if (!this.checkDeclaringType(enclosingBinaryType, pattern.getDeclaringSimpleName(), pattern.getDeclaringQualification(), pattern.isCaseSensitive(), pattern.isCamelCase())) {
            return false;
        }
        char[] fieldTypeSignature = Signature.toCharArray(ClassFileMatchLocator.convertClassFileFormat(field.getTypeName()));
        return this.checkTypeName(pattern.typeSimpleName, pattern.typeQualification, fieldTypeSignature, pattern.isCaseSensitive(), pattern.isCamelCase());
    }

    boolean matchMethod(MethodPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        boolean checkParameters;
        if (!pattern.findDeclarations) {
            return false;
        }
        if (!(binaryInfo instanceof IBinaryMethod)) {
            return false;
        }
        IBinaryMethod method = (IBinaryMethod)binaryInfo;
        if (!pattern.matchesName(pattern.selector, method.getSelector())) {
            return false;
        }
        if (!this.checkDeclaringType(enclosingBinaryType, pattern.getDeclaringSimpleName(), pattern.getDeclaringQualification(), pattern.isCaseSensitive(), pattern.isCamelCase())) {
            return false;
        }
        boolean checkReturnType = pattern.getDeclaringSimpleName() == null && (pattern.returnSimpleName != null || pattern.returnQualification != null);
        boolean bl = checkParameters = pattern.parameterSimpleNames != null;
        if (checkReturnType || checkParameters) {
            char[] returnTypeSignature;
            char[] methodDescriptor = ClassFileMatchLocator.convertClassFileFormat(method.getMethodDescriptor());
            if (checkReturnType && !this.checkTypeName(pattern.returnSimpleName, pattern.returnQualification, returnTypeSignature = Signature.toCharArray(Signature.getReturnType(methodDescriptor)), pattern.isCaseSensitive(), pattern.isCamelCase())) {
                return false;
            }
            if (checkParameters && !this.checkParameters(methodDescriptor, pattern.parameterSimpleNames, pattern.parameterQualifications, pattern.isCaseSensitive(), pattern.isCamelCase())) {
                return false;
            }
        }
        return true;
    }

    boolean matchSuperTypeReference(SuperTypeReferencePattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        char[] superclassName;
        if (!(binaryInfo instanceof IBinaryType)) {
            return false;
        }
        IBinaryType type = (IBinaryType)binaryInfo;
        char[] vmName = type.getSuperclassName();
        return vmName != null && this.checkTypeName(pattern.typeName, superclassName = ClassFileMatchLocator.convertClassFileFormat(vmName), pattern.isCaseSensitive(), pattern.isCamelCase());
    }

    boolean matchTypeDeclaration(TypeDeclarationPattern pattern, Object binaryInfo, IBinaryType enclosingBinaryType) {
        if (!(binaryInfo instanceof IBinaryType)) {
            return false;
        }
        IBinaryType type = (IBinaryType)binaryInfo;
        char[] fullyQualifiedTypeName = ClassFileMatchLocator.convertClassFileFormat(type.getName());
        if (pattern.enclosingTypeNames == null) {
            char[] pkg;
            char[] simpleName = pattern.getMatchMode() == 1 ? CharOperation.concat(pattern.simpleName, IIndexConstants.ONE_STAR) : pattern.simpleName;
            if (!this.checkTypeName(simpleName, pkg = pattern.qualification, fullyQualifiedTypeName, pattern.isCaseSensitive(), pattern.isCamelCase())) {
                return false;
            }
        } else {
            char[] patternString;
            char[] enclosingTypeName = CharOperation.concatWith(pattern.enclosingTypeNames, '.');
            char[] cArray = patternString = pattern.qualification == null ? enclosingTypeName : CharOperation.concat(pattern.qualification, enclosingTypeName, '.');
            if (!this.checkTypeName(pattern.simpleName, patternString, fullyQualifiedTypeName, pattern.isCaseSensitive(), pattern.isCamelCase())) {
                return false;
            }
        }
        return true;
    }
}

