/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.core.search.matching;

import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.compiler.CharOperation;
import org.eclipse.wst.jsdt.internal.core.search.matching.JavaSearchPattern;

public abstract class VariablePattern
extends JavaSearchPattern {
    protected boolean findDeclarations;
    protected boolean findReferences;
    protected boolean readAccess;
    protected boolean writeAccess;
    public char[] name;
    ISourceReference sourceVariable;

    public VariablePattern(int patternKind, boolean findDeclarations, boolean readAccess, boolean writeAccess, char[] name, int matchRule, ISourceReference sourceRef) {
        super(patternKind, matchRule);
        this.findDeclarations = findDeclarations;
        this.readAccess = readAccess;
        this.writeAccess = writeAccess;
        this.findReferences = readAccess || writeAccess;
        this.name = this.isCaseSensitive() || this.isCamelCase() ? name : CharOperation.toLowerCase(name);
        this.sourceVariable = sourceRef;
    }

    public IJavaScriptElement getJavaElement() {
        return (IJavaScriptElement)((Object)this.sourceVariable);
    }

    protected int getVariableStart() {
        try {
            return this.sourceVariable.getSourceRange().getOffset();
        }
        catch (JavaScriptModelException e) {
            return -1;
        }
    }

    protected int getVariableLength() {
        try {
            return this.sourceVariable.getSourceRange().getLength();
        }
        catch (JavaScriptModelException e) {
            return -1;
        }
    }

    protected boolean mustResolve() {
        return this.findReferences;
    }
}

