/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.wst.common.ui.internal.dialogs.SelectSingleFileDialog;
import org.eclipse.wst.xml.core.internal.catalog.Catalog;
import org.eclipse.wst.xml.core.internal.catalog.CatalogSet;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.ui.internal.XMLUIPlugin;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;

public class AdvancedOptionsDialog
extends Dialog {
    protected ICatalog workingUserCatalog;

    public AdvancedOptionsDialog(Shell parentShell, ICatalog workingUserCatalog) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.workingUserCatalog = workingUserCatalog;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(dialogArea, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        label.setText(XMLCatalogMessages.UI_LABEL_DIALOG_DESCRIPTION);
        Composite buttonComposite = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 3;
        buttonComposite.setLayout((Layout)gridLayout);
        buttonComposite.setLayoutData((Object)new GridData(768));
        Composite placeHolder = new Composite(buttonComposite, 0);
        placeHolder.setLayoutData((Object)new GridData(768));
        Composite buttonGroup = new Composite(buttonComposite, 0);
        gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.makeColumnsEqualWidth = true;
        buttonGroup.setLayout((Layout)gridLayout);
        buttonGroup.setLayoutData((Object)this.createGridData());
        Button importButton = new Button(buttonGroup, 0x1000008);
        importButton.setText("  " + XMLCatalogMessages.UI_BUTTON_IMPORT + "  ");
        Button exportButton = new Button(buttonGroup, 0x1000008);
        exportButton.setText("  " + XMLCatalogMessages.UI_BUTTON_EXPORT + "  ");
        placeHolder = new Composite(buttonComposite, 0);
        placeHolder.setLayoutData((Object)new GridData(768));
        SelectionAdapter importButtonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedOptionsDialog.this.invokeImportDialog();
            }
        };
        importButton.addSelectionListener((SelectionListener)importButtonSelectionListener);
        SelectionAdapter exportButtonSelectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AdvancedOptionsDialog.this.invokeExportDialog();
            }
        };
        exportButton.addSelectionListener((SelectionListener)exportButtonSelectionListener);
        return dialogArea;
    }

    protected GridData createGridData() {
        GridData gd = new GridData(2);
        gd.horizontalAlignment = 64;
        gd.verticalAlignment = 4;
        return gd;
    }

    protected void invokeImportDialog() {
        SelectSingleFileDialog dialog = new SelectSingleFileDialog(this.getShell(), null, true);
        String[] extensions = new String[]{".xmlcatalog", ".xml"};
        dialog.addFilterExtensions(extensions);
        dialog.create();
        dialog.getShell().setText(XMLCatalogMessages.UI_LABEL_IMPORT_DIALOG_TITLE);
        dialog.setTitle(XMLCatalogMessages.UI_LABEL_IMPORT_DIALOG_HEADING);
        dialog.setMessage(XMLCatalogMessages.UI_LABEL_IMPORT_DIALOG_MESSAGE);
        dialog.setBlockOnOpen(true);
        int rc = dialog.open();
        if (rc == 0) {
            IFile file = dialog.getFile();
            if (file != null) {
                String fileName = file.getLocation().toFile().toURI().toString();
                try {
                    CatalogSet tempResourceSet = new CatalogSet();
                    Catalog newCatalog = tempResourceSet.lookupOrCreateCatalog("temp", fileName);
                    this.workingUserCatalog.addEntriesFromCatalog((ICatalog)newCatalog);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.close();
        }
    }

    protected void invokeExportDialog() {
        IPath path;
        IPath originalFilePath = null;
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        if (projects.length > 0) {
            originalFilePath = projects[0].getFullPath().append(".xmlcatalog");
        }
        SaveAsDialog dialog = new SaveAsDialog(this.getShell());
        if (originalFilePath != null) {
            IFile originalFile = ResourcesPlugin.getWorkspace().getRoot().getFile(originalFilePath);
            dialog.setOriginalFile(originalFile);
        }
        dialog.create();
        dialog.getShell().setText(XMLCatalogMessages.UI_LABEL_EXPORT_DIALOG_TITLE);
        dialog.setTitle(XMLCatalogMessages.UI_LABEL_EXPORT_DIALOG_HEADING);
        dialog.setMessage(XMLCatalogMessages.UI_LABEL_EXPORT_DIALOG_MESSAGE);
        dialog.setBlockOnOpen(true);
        int rc = dialog.open();
        if (rc == 0 && (path = dialog.getResult()) != null) {
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile(path);
            String fileName = file.getLocation().toFile().toURI().toString();
            try {
                this.createFileIfRequired(file);
                this.workingUserCatalog.setLocation(fileName);
                this.workingUserCatalog.save();
            }
            catch (Exception ex) {
                try {
                    String title = XMLCatalogMessages.UI_LABEL_CATALOG_SAVE_ERROR;
                    String briefMessage = XMLCatalogMessages.UI_LABEL_CATALOG_COULD_NOT_BE_SAVED;
                    String reason = file.isReadOnly() ? NLS.bind((String)XMLCatalogMessages.UI_LABEL_FILE_IS_READ_ONLY, (Object)fileName) : NLS.bind((String)XMLCatalogMessages.ERROR_SAVING_FILE, (Object)fileName);
                    String details = NLS.bind((String)XMLCatalogMessages.ERROR_SAVING_FILE, (Object)fileName);
                    ErrorDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)title, (String)briefMessage, (IStatus)AdvancedOptionsDialog.createStatus(reason, details));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.close();
        }
    }

    private static IStatus createStatus(String reason, String msg) {
        String pluginId = XMLUIPlugin.getDefault().getBundle().getSymbolicName();
        MultiStatus multiStatus = new MultiStatus(pluginId, 0, reason, null);
        Status status = new Status(4, pluginId, 0, msg, null);
        multiStatus.add((IStatus)status);
        return multiStatus;
    }

    protected void createFileIfRequired(IFile file) {
        try {
            if (file != null && !file.exists()) {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(new byte[0]);
                file.create((InputStream)inputStream, true, null);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

