/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.catalog;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.part.PageBook;
import org.eclipse.wst.common.ui.internal.dialogs.SelectSingleFileDialog;
import org.eclipse.wst.common.uriresolver.internal.URI;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogElement;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalogEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IDelegateCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.INextCatalog;
import org.eclipse.wst.xml.core.internal.catalog.provisional.IRewriteEntry;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ISuffixEntry;
import org.eclipse.wst.xml.ui.internal.catalog.CatalogFileTypeRegistryReader;
import org.eclipse.wst.xml.ui.internal.catalog.ImageFactory;
import org.eclipse.wst.xml.ui.internal.catalog.URIUtils;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogFileType;
import org.eclipse.wst.xml.ui.internal.catalog.XMLCatalogMessages;
import org.eclipse.wst.xml.ui.internal.catalog.XMLQuickScan;

public class EditCatalogEntryDialog
extends Dialog {
    protected static Image borwseImage = ImageFactory.INSTANCE.getImage("icons/obj16/file_expand.gif");
    protected static Image catalogEntryToolBarImage = ImageFactory.INSTANCE.getImage("icons/etool50/catalogEntry.gif");
    protected static Image nextCatalogToolBarImage = ImageFactory.INSTANCE.getImage("icons/etool50/nextCatalog.gif");
    protected static Image delegateCatalogToolBarImage = ImageFactory.INSTANCE.getImage("icons/etool50/delegateCatalog.gif");
    protected static Image rewriteToolBarImage = ImageFactory.INSTANCE.getImage("icons/etool50/rewrite.gif");
    protected static Image prefixToolBarImage = ImageFactory.INSTANCE.getImage("icons/etool50/prefix.gif");
    protected static Image suffixToolBarImage = ImageFactory.INSTANCE.getImage("icons/etool50/sufix.gif");
    protected ICatalog catalog;
    protected ICatalogElement fCatalogElement;
    protected String errorMessage;
    protected String warningMessage;
    protected Button okButton;
    protected PageBook pageContainer;
    protected CatalogElementPage selectedPage;
    protected ToolBar toolBar;
    protected Composite elementTypeComposite;
    protected Color color;
    protected boolean dataSaved;

    public static String[] createStringArray(List list) {
        String[] stringArray = new String[list.size()];
        int i = 0;
        while (i < stringArray.length) {
            stringArray[i] = (String)list.get(i);
            ++i;
        }
        return stringArray;
    }

    public static String removeLeadingSlash(String uri) {
        if (uri != null) {
            while (uri.startsWith("/") || uri.startsWith("\\")) {
                uri = uri.substring(1);
            }
        }
        return uri;
    }

    public EditCatalogEntryDialog(Shell parentShell, ICatalog aCatalog) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.catalog = aCatalog;
    }

    public EditCatalogEntryDialog(Shell parentShell, ICatalogElement catalogElement, ICatalog aCatalog) {
        this(parentShell, aCatalog);
        this.fCatalogElement = catalogElement;
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.selectedPage.saveData();
            if (!this.dataSaved) {
                return;
            }
        }
        super.buttonPressed(buttonId);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.okButton.setEnabled(false);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.updateOKButtonState();
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogAreaComposite = (Composite)super.createDialogArea(parent);
        this.color = new Color((Device)dialogAreaComposite.getDisplay(), 200, 0, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        dialogAreaComposite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        gd.widthHint = 550;
        dialogAreaComposite.setLayoutData((Object)gd);
        this.createMainComponent(dialogAreaComposite);
        return this.dialogArea;
    }

    public boolean close() {
        if (this.color != null) {
            this.color.dispose();
        }
        return super.close();
    }

    protected Composite createMainComponent(Composite composite) {
        if (this.fCatalogElement != null) {
            Composite composite1 = new Composite(composite, 0);
            GridData data = new GridData(1808);
            composite1.setLayoutData((Object)data);
            GridLayout layout = new GridLayout();
            composite1.setLayout((Layout)layout);
            this.pageContainer = new PageBook(composite1, 0);
            this.pageContainer.setLayoutData((Object)new GridData(1808));
            if (this.fCatalogElement.getType() == 1) {
                CatalogEntryPage entryPage = new CatalogEntryPage();
                ((CatalogElementPage)entryPage).createControl((Composite)this.pageContainer);
                this.showPage(entryPage);
            } else if (this.fCatalogElement.getType() == 10) {
                NextCatalogPage nextCatalogPage = new NextCatalogPage();
                ((CatalogElementPage)nextCatalogPage).createControl((Composite)this.pageContainer);
                this.showPage(nextCatalogPage);
            } else if (this.fCatalogElement.getType() == 30) {
                DelegateCatalogPage delegateCatalogPage = new DelegateCatalogPage();
                delegateCatalogPage.createControl((Composite)this.pageContainer);
                this.showPage(delegateCatalogPage);
            } else if (this.fCatalogElement.getType() == 40) {
                SuffixEntryPage suffixEntryPage = new SuffixEntryPage();
                suffixEntryPage.createControl((Composite)this.pageContainer);
                this.showPage(suffixEntryPage);
            } else if (this.fCatalogElement.getType() == 20) {
                RewriteEntryPage rewriteEntryPage = new RewriteEntryPage();
                rewriteEntryPage.createControl((Composite)this.pageContainer);
                this.showPage(rewriteEntryPage);
            }
            return composite1;
        }
        return this.createMainComponentWithToolbar(composite);
    }

    protected Composite createMainComponentWithToolbar(Composite composite) {
        FormLayout formLayout = new FormLayout();
        formLayout.marginHeight = 5;
        formLayout.marginWidth = 5;
        composite.setLayout((Layout)formLayout);
        Label label = new Label(composite, 0);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        label.setLayoutData((Object)data);
        this.toolBar = new ToolBar(composite, 0x800A00);
        data = new FormData();
        data.top = new FormAttachment((Control)label, 0);
        data.left = new FormAttachment(0, 0);
        data.bottom = new FormAttachment(100, 0);
        this.toolBar.setLayoutData((Object)data);
        Composite composite1 = new Composite(composite, 2048);
        data = new FormData();
        data.top = new FormAttachment((Control)label, 0);
        data.left = new FormAttachment((Control)this.toolBar, 0, -1);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment(100, 0);
        composite1.setLayoutData((Object)data);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite1.setLayout((Layout)layout);
        this.pageContainer = new PageBook(composite1, 0);
        this.pageContainer.setLayoutData((Object)new GridData(1808));
        this.createCatalogEntryButton();
        this.createRewriteButton();
        this.createSuffixCatalogButton();
        this.createNextCatalogButton();
        this.createDelegateCatalogButton();
        if (this.toolBar.getItemCount() > 0) {
            ToolItem item = this.toolBar.getItem(0);
            this.showPage((CatalogElementPage)item.getData());
        }
        return composite1;
    }

    protected void createCatalogEntryButton() {
        CatalogEntryPage page = new CatalogEntryPage();
        ((CatalogElementPage)page).createControl((Composite)this.pageContainer);
        ToolItem toolItem = new ToolItem(this.toolBar, 32);
        toolItem.setImage(catalogEntryToolBarImage);
        toolItem.setText(XMLCatalogMessages.EditCatalogEntryDialog_catalogEntryLabel);
        toolItem.setData((Object)page);
        toolItem.addSelectionListener((SelectionListener)new ToolBarItemSelectionChangeListener());
        toolItem.setSelection(true);
    }

    protected void createNextCatalogButton() {
        NextCatalogPage page = new NextCatalogPage();
        ((CatalogElementPage)page).createControl((Composite)this.pageContainer);
        ToolItem toolItem = new ToolItem(this.toolBar, 32);
        toolItem.setImage(nextCatalogToolBarImage);
        toolItem.setText(XMLCatalogMessages.EditCatalogEntryDialog_nextCatalogLabel);
        toolItem.setData((Object)page);
        toolItem.addSelectionListener((SelectionListener)new ToolBarItemSelectionChangeListener());
    }

    protected void createRewriteButton() {
        RewriteEntryPage page = new RewriteEntryPage();
        ((CatalogElementPage)page).createControl((Composite)this.pageContainer);
        ToolItem toolItem = new ToolItem(this.toolBar, 32);
        toolItem.setImage(rewriteToolBarImage);
        toolItem.setText(XMLCatalogMessages.EditCatalogEntryDialog_rewriteEntryLabel);
        toolItem.setData((Object)page);
        toolItem.addSelectionListener((SelectionListener)new ToolBarItemSelectionChangeListener());
    }

    protected void createDelegateCatalogButton() {
        DelegateCatalogPage page = new DelegateCatalogPage();
        ((CatalogElementPage)page).createControl((Composite)this.pageContainer);
        ToolItem toolItem = new ToolItem(this.toolBar, 32);
        toolItem.setImage(delegateCatalogToolBarImage);
        toolItem.setText(XMLCatalogMessages.EditCatalogEntryDialog_delegateCatalogLabel);
        toolItem.setData((Object)page);
        toolItem.addSelectionListener((SelectionListener)new ToolBarItemSelectionChangeListener());
    }

    protected void createSuffixCatalogButton() {
        SuffixEntryPage page = new SuffixEntryPage();
        ((CatalogElementPage)page).createControl((Composite)this.pageContainer);
        ToolItem toolItem = new ToolItem(this.toolBar, 32);
        toolItem.setImage(suffixToolBarImage);
        toolItem.setText(XMLCatalogMessages.EditCatalogEntryDialog_suffixEntryLabel);
        toolItem.setData((Object)page);
        toolItem.addSelectionListener((SelectionListener)new ToolBarItemSelectionChangeListener());
    }

    protected ICatalogElement getCatalogElement() {
        return this.fCatalogElement;
    }

    protected String getDisplayValue(String string) {
        return string != null ? string : "";
    }

    protected XMLCatalogFileType getMatchingFileType(String description) {
        XMLCatalogFileType fileType = null;
        Iterator i = CatalogFileTypeRegistryReader.getXMLCatalogFileTypes().iterator();
        while (i.hasNext()) {
            XMLCatalogFileType theFileType = (XMLCatalogFileType)i.next();
            if (theFileType.description == null || !theFileType.description.equals(description)) continue;
            fileType = theFileType;
        }
        return fileType;
    }

    protected boolean showPage(CatalogElementPage page) {
        if (this.pageContainer.isDisposed()) {
            return false;
        }
        this.selectedPage = page;
        this.pageContainer.setVisible(true);
        this.pageContainer.showPage(this.selectedPage.getControl());
        this.fCatalogElement = this.selectedPage.getData();
        this.selectedPage.refresh();
        return true;
    }

    protected void updateErrorMessageLabel(Label errorMessageLabel) {
        if (this.errorMessage != null) {
            errorMessageLabel.setText(this.errorMessage);
        } else if (this.warningMessage != null) {
            errorMessageLabel.setText(this.warningMessage);
        } else {
            errorMessageLabel.setText("");
        }
    }

    protected void updateOKButtonState() {
        if (this.okButton != null) {
            this.okButton.setEnabled(this.errorMessage == null);
        }
    }

    protected Button createBrowseButton(Composite composite) {
        Button browseButton = new Button(composite, 8);
        browseButton.setImage(borwseImage);
        Rectangle r = borwseImage.getBounds();
        GridData gd = new GridData();
        int IMAGE_WIDTH_MARGIN = 6;
        int IMAGE_HEIGHT_MARGIN = 6;
        gd.heightHint = r.height + IMAGE_HEIGHT_MARGIN;
        gd.widthHint = r.width + IMAGE_WIDTH_MARGIN;
        browseButton.setLayoutData((Object)gd);
        return browseButton;
    }

    protected Button createWorkspaceBrowseButton(Composite composite) {
        Button browseWorkspaceButton = new Button(composite, 8);
        browseWorkspaceButton.setText(XMLCatalogMessages.UI_BUTTON_MENU_BROWSE_WORKSPACE);
        return browseWorkspaceButton;
    }

    protected Button createFileSystemBrowseButton(Composite composite) {
        Button browseFileSystemButton = new Button(composite, 8);
        browseFileSystemButton.setText(XMLCatalogMessages.UI_BUTTON_MENU_BROWSE_WORKSPACE);
        return browseFileSystemButton;
    }

    String invokeWorkspaceFileSelectionDialog() {
        FilterableSelectSingleFileDialog dialog = new FilterableSelectSingleFileDialog(this.getShell());
        dialog.createAndOpen();
        IFile file = dialog.getFile();
        String uri = null;
        if (file != null) {
            uri = file.getFullPath().toString();
            while (uri.startsWith("/") || uri.startsWith("\\")) {
                uri = uri.substring(1);
            }
        }
        return uri;
    }

    String invokeFileSelectionDialog() {
        FileDialog dialog = new FileDialog(this.getShell(), 4);
        return dialog.open();
    }

    protected abstract class AbstractDelegatePage
    extends CatalogElementPage {
        protected Button browseWorkspaceButton;
        protected Button browseFileSystemButton;
        protected Text catalogLocationField;
        protected Label errorMessageLabel;

        protected AbstractDelegatePage() {
        }

        protected void computeErrorMessage() {
            EditCatalogEntryDialog.this.errorMessage = null;
            String fileName = this.catalogLocationField.getText();
            if (fileName.trim().length() > 0) {
                String uri;
                if (fileName.indexOf("..") != -1 || fileName.indexOf("./") != -1 || fileName.indexOf("/.") != -1 || fileName.indexOf(".\\") != -1 || fileName.indexOf("\\.") != -1) {
                    EditCatalogEntryDialog.this.errorMessage = XMLCatalogMessages.UI_WARNING_URI_MUST_NOT_HAVE_DOTS;
                }
                if (!URIHelper.hasProtocol((String)(uri = fileName))) {
                    String string = uri = URIHelper.isAbsolute((String)uri) ? URIHelper.prependFileProtocol((String)uri) : URIHelper.prependPlatformResourceProtocol((String)uri);
                }
                if (EditCatalogEntryDialog.this.errorMessage == null && !URIHelper.isReadableURI((String)uri, (boolean)false)) {
                    EditCatalogEntryDialog.this.errorMessage = String.valueOf(XMLCatalogMessages.UI_WARNING_URI_NOT_FOUND_COLON) + fileName;
                }
            } else {
                EditCatalogEntryDialog.this.errorMessage = "";
            }
        }

        public abstract Control createControl(Composite var1);

        protected Control createNextCatalogPanel(Composite parent, String catalogUriLabel) {
            ModifyListener modifyListener = new ModifyListener(this){
                final /* synthetic */ AbstractDelegatePage this$1;
                {
                    this.this$1 = abstractDelegatePage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateWidgets(e.widget);
                }
            };
            Composite composite = new Composite(parent, 0);
            GridData gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            Composite group = new Composite(composite, 0);
            gd = new GridData(768);
            group.setLayoutData((Object)gd);
            layout = new GridLayout();
            group.setLayout((Layout)layout);
            this.createSpecificFields(group);
            Label resourceLocationLabel = new Label(group, 0);
            resourceLocationLabel.setText(catalogUriLabel);
            this.catalogLocationField = new Text(group, 2052);
            this.catalogLocationField.setLayoutData((Object)new GridData(768));
            this.catalogLocationField.setText(URIUtils.convertURIToLocation(EditCatalogEntryDialog.this.getDisplayValue(this.getCatalogLocation())));
            this.catalogLocationField.addModifyListener(modifyListener);
            Composite browseButtonsComposite = new Composite(group, 0x800000);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 3;
            browseButtonsComposite.setLayoutData((Object)gd);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginBottom = 5;
            browseButtonsComposite.setLayout((Layout)layout);
            this.browseWorkspaceButton = new Button(browseButtonsComposite, 8);
            this.browseWorkspaceButton.setText(XMLCatalogMessages.UI_BUTTON_MENU_BROWSE_WORKSPACE);
            this.browseWorkspaceButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ AbstractDelegatePage this$1;
                {
                    this.this$1 = abstractDelegatePage;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String value = AbstractDelegatePage.access$0(this.this$1).invokeWorkspaceFileSelectionDialog();
                    if (value != null) {
                        this.this$1.catalogLocationField.setText(value);
                    }
                }
            });
            this.browseFileSystemButton = new Button(browseButtonsComposite, 8);
            this.browseFileSystemButton.setText(XMLCatalogMessages.UI_BUTTON_MENU_BROWSE_FILE_SYSTEM);
            this.browseFileSystemButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ AbstractDelegatePage this$1;
                {
                    this.this$1 = abstractDelegatePage;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String value = AbstractDelegatePage.access$0(this.this$1).invokeFileSelectionDialog();
                    if (value != null) {
                        this.this$1.catalogLocationField.setText(value);
                    }
                }
            });
            this.errorMessageLabel = new Label(group, 0);
            this.errorMessageLabel.setForeground(EditCatalogEntryDialog.this.color);
            this.errorMessageLabel.setLayoutData((Object)new GridData(768));
            this.updateWidgets(null);
            return composite;
        }

        protected void createSpecificFields(Composite group) {
        }

        protected abstract String getCatalogLocation();

        protected void updateWidgets(Widget widget) {
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        static /* synthetic */ EditCatalogEntryDialog access$0(AbstractDelegatePage abstractDelegatePage) {
            return abstractDelegatePage.EditCatalogEntryDialog.this;
        }
    }

    protected abstract class CatalogElementPage {
        Control fControl;

        public abstract void refresh();

        public abstract Control createControl(Composite var1);

        public Control getControl() {
            return this.fControl;
        }

        public abstract ICatalogElement getData();

        public abstract void saveData();
    }

    protected class CatalogEntryPage
    extends CatalogElementPage {
        protected Button browseWorkspaceButton;
        protected Button browseFileSystemButton;
        protected ICatalogEntry catalogEntry;
        protected Button checkboxButton;
        protected Label errorMessageLabel;
        protected Text keyField;
        protected Combo keyTypeCombo;
        protected Text resourceLocationField;
        protected Combo resourceTypeCombo;
        protected Text webAddressField;
        protected String key;
        protected int type;

        protected CatalogEntryPage() {
        }

        public void refresh() {
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        protected void computeErrorMessage() {
            String uri;
            EditCatalogEntryDialog.this.errorMessage = null;
            EditCatalogEntryDialog.this.warningMessage = null;
            String fileName = this.resourceLocationField.getText();
            if (fileName.trim().length() > 0) {
                if (fileName.indexOf("..") != -1 || fileName.indexOf("./") != -1 || fileName.indexOf("/.") != -1 || fileName.indexOf(".\\") != -1 || fileName.indexOf("\\.") != -1) {
                    EditCatalogEntryDialog.this.errorMessage = XMLCatalogMessages.UI_WARNING_URI_MUST_NOT_HAVE_DOTS;
                }
                if (!URIHelper.hasProtocol((String)(uri = fileName))) {
                    URIHelper.isAbsolute((String)uri);
                    String string = uri = URIHelper.isAbsolute((String)uri) ? URIHelper.prependFileProtocol((String)uri) : URIHelper.prependPlatformResourceProtocol((String)uri);
                }
                if (EditCatalogEntryDialog.this.errorMessage == null && !URIHelper.isReadableURI((String)uri, (boolean)false)) {
                    EditCatalogEntryDialog.this.errorMessage = String.valueOf(XMLCatalogMessages.UI_WARNING_URI_NOT_FOUND_COLON) + fileName;
                }
            } else {
                EditCatalogEntryDialog.this.errorMessage = "";
            }
            if (this.keyField.getText().length() > 0 && this.getKeyType() == 3 && (uri = URI.createURI((String)this.keyField.getText())).scheme() == null) {
                EditCatalogEntryDialog.this.warningMessage = XMLCatalogMessages.UI_WARNING_SHOULD_BE_FULLY_QUALIFIED_URI;
            }
            if (EditCatalogEntryDialog.this.errorMessage == null && this.checkboxButton.getSelection() && this.webAddressField.getText().trim().length() == 0) {
                EditCatalogEntryDialog.this.errorMessage = "";
            }
            if (EditCatalogEntryDialog.this.errorMessage == null && this.keyField.getText().trim().length() == 0) {
                EditCatalogEntryDialog.this.errorMessage = "";
            }
        }

        protected Control createCatalogEntryPanel(Composite parent) {
            ModifyListener modifyListener = new ModifyListener(this){
                final /* synthetic */ CatalogEntryPage this$1;
                {
                    this.this$1 = catalogEntryPage;
                }

                public void modifyText(ModifyEvent e) {
                    String namespaceURI;
                    String uri;
                    if (e.widget == this.this$1.resourceLocationField && this.this$1.keyField.getText().length() == 0 && (uri = this.this$1.resourceLocationField.getText()).endsWith("xsd") && !URIHelper.hasProtocol((String)uri) && (namespaceURI = XMLQuickScan.getTargetNamespaceURIForSchema(uri = URIHelper.isAbsolute((String)uri) ? URIHelper.prependFileProtocol((String)uri) : URIHelper.prependPlatformResourceProtocol((String)uri))) != null) {
                        this.this$1.keyField.setText(namespaceURI);
                    }
                    this.this$1.updateWidgets(e.widget);
                }
            };
            Composite composite = new Composite(parent, 0);
            GridData gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            Composite group = new Composite(composite, 0);
            gd = new GridData(768);
            group.setLayoutData((Object)gd);
            layout = new GridLayout(2, false);
            group.setLayout((Layout)layout);
            Label resourceLocationLabel = new Label(group, 0);
            resourceLocationLabel.setText(XMLCatalogMessages.UI_LABEL_LOCATION_COLON);
            this.resourceLocationField = new Text(group, 2052);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.resourceLocationField.setLayoutData((Object)gd);
            this.resourceLocationField.setText(EditCatalogEntryDialog.this.getDisplayValue(URIUtils.convertURIToLocation(this.getEntry().getURI())));
            this.resourceLocationField.addModifyListener(modifyListener);
            Composite browseButtonsComposite = new Composite(group, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 3;
            browseButtonsComposite.setLayoutData((Object)gd);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginBottom = 5;
            browseButtonsComposite.setLayout((Layout)layout);
            this.browseWorkspaceButton = new Button(browseButtonsComposite, 8);
            this.browseWorkspaceButton.setText(XMLCatalogMessages.UI_BUTTON_MENU_BROWSE_WORKSPACE);
            this.browseWorkspaceButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ CatalogEntryPage this$1;
                {
                    this.this$1 = catalogEntryPage;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String value = CatalogEntryPage.access$0(this.this$1).invokeWorkspaceFileSelectionDialog();
                    if (value != null) {
                        this.this$1.resourceLocationField.setText(value);
                    }
                }
            });
            this.browseFileSystemButton = new Button(browseButtonsComposite, 8);
            this.browseFileSystemButton.setText(XMLCatalogMessages.UI_BUTTON_MENU_BROWSE_FILE_SYSTEM);
            this.browseFileSystemButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ CatalogEntryPage this$1;
                {
                    this.this$1 = catalogEntryPage;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String value = CatalogEntryPage.access$0(this.this$1).invokeFileSelectionDialog();
                    if (value != null) {
                        this.this$1.resourceLocationField.setText(value);
                    }
                }
            });
            Label keyTypeLabel = new Label(group, 0);
            keyTypeLabel.setText(XMLCatalogMessages.UI_KEY_TYPE_COLON);
            this.keyTypeCombo = new Combo(group, 8);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.keyTypeCombo.setLayoutData((Object)gd);
            this.updateKeyTypeCombo(this.getEntry().getEntryType());
            this.keyTypeCombo.addModifyListener(modifyListener);
            Label keyValueLabel = new Label(group, 0);
            keyValueLabel.setText(XMLCatalogMessages.UI_LABEL_KEY_COLON);
            this.keyField = new Text(group, 2052);
            this.keyField.setLayoutData((Object)gd);
            this.keyField.setText(EditCatalogEntryDialog.this.getDisplayValue(this.getEntry().getKey()));
            this.keyField.addModifyListener(modifyListener);
            Composite group2 = new Composite(composite, 0);
            gd = new GridData(768);
            group2.setLayoutData((Object)gd);
            layout = new GridLayout();
            group2.setLayout((Layout)layout);
            this.checkboxButton = new Button(group2, 32);
            this.checkboxButton.setText(XMLCatalogMessages.UI_LABEL_SPECIFY_ALTERNATIVE_WEB_URL);
            this.checkboxButton.setLayoutData((Object)new GridData());
            this.checkboxButton.setSelection(this.getEntry().getAttributeValue("webURL") != null);
            SelectionListener buttonListener = new SelectionListener(this){
                final /* synthetic */ CatalogEntryPage this$1;
                {
                    this.this$1 = catalogEntryPage;
                }

                public void widgetDefaultSelected(SelectionEvent event) {
                }

                public void widgetSelected(SelectionEvent event) {
                    if (event.widget == this.this$1.checkboxButton) {
                        this.this$1.updateWidgets((Widget)this.this$1.checkboxButton);
                    }
                }
            };
            this.checkboxButton.addSelectionListener(buttonListener);
            ModifyListener webAddressFieldListener = new ModifyListener(this){
                final /* synthetic */ CatalogEntryPage this$1;
                {
                    this.this$1 = catalogEntryPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.computeErrorMessage();
                    CatalogEntryPage.access$0(this.this$1).updateErrorMessageLabel(this.this$1.errorMessageLabel);
                    CatalogEntryPage.access$0(this.this$1).updateOKButtonState();
                }
            };
            this.webAddressField = new Text(group2, 2052);
            this.webAddressField.setLayoutData((Object)gd);
            this.webAddressField.setText(EditCatalogEntryDialog.this.getDisplayValue(this.getEntry().getAttributeValue("webURL")));
            this.webAddressField.setEnabled(false);
            this.webAddressField.addModifyListener(webAddressFieldListener);
            this.errorMessageLabel = new Label(group2, 0);
            this.errorMessageLabel.setForeground(EditCatalogEntryDialog.this.color);
            this.errorMessageLabel.setLayoutData((Object)new GridData(768));
            this.updateWidgets(null);
            this.key = this.getEntry().getKey();
            this.type = this.getEntry().getEntryType();
            return composite;
        }

        public Control createControl(Composite parent) {
            this.fControl = this.createCatalogEntryPanel(parent);
            return this.fControl;
        }

        public ICatalogElement getData() {
            return this.getEntry();
        }

        protected ICatalogEntry getEntry() {
            if (this.catalogEntry == null) {
                if (EditCatalogEntryDialog.this.fCatalogElement != null && EditCatalogEntryDialog.this.fCatalogElement.getType() == 1) {
                    this.catalogEntry = (ICatalogEntry)EditCatalogEntryDialog.this.fCatalogElement;
                } else if (EditCatalogEntryDialog.this.catalog != null) {
                    this.catalogEntry = (ICatalogEntry)EditCatalogEntryDialog.this.catalog.createCatalogElement(1);
                }
            }
            return this.catalogEntry;
        }

        protected int getKeyType() {
            switch (this.keyTypeCombo.getSelectionIndex()) {
                case 0: {
                    if ("schema".equals(this.keyTypeCombo.getData("keyType"))) {
                        return 4;
                    }
                    return 2;
                }
                case 1: {
                    return 3;
                }
                case 2: {
                    return 4;
                }
            }
            return 2;
        }

        public void saveData() {
            if (this.validateData()) {
                this.getEntry().setURI(URIUtils.convertLocationToURI(this.resourceLocationField.getText()));
                this.getEntry().setKey(this.keyField.getText());
                this.getEntry().setEntryType(this.getKeyType());
                this.getEntry().setAttributeValue("webURL", this.checkboxButton.getSelection() ? this.webAddressField.getText() : null);
                EditCatalogEntryDialog.this.dataSaved = true;
            } else {
                EditCatalogEntryDialog.this.errorMessage = XMLCatalogMessages.UI_WARNING_DUPLICATE_ENTRY;
                this.errorMessageLabel.setText(EditCatalogEntryDialog.this.errorMessage);
                EditCatalogEntryDialog.this.updateOKButtonState();
                EditCatalogEntryDialog.this.dataSaved = false;
            }
        }

        protected boolean validateData() {
            String result = null;
            if (this.key == null || !this.key.equals(this.keyField.getText()) || this.type != this.getKeyType()) {
                try {
                    switch (this.getKeyType()) {
                        case 2: {
                            result = EditCatalogEntryDialog.this.catalog.resolvePublic(this.keyField.getText(), null);
                            break;
                        }
                        case 3: {
                            result = EditCatalogEntryDialog.this.catalog.resolveSystem(this.keyField.getText());
                            break;
                        }
                        case 4: {
                            result = EditCatalogEntryDialog.this.catalog.resolveURI(this.keyField.getText());
                        }
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return result == null;
        }

        protected void updateKeyTypeCombo(int type) {
            this.keyTypeCombo.removeAll();
            Iterator i = CatalogFileTypeRegistryReader.getXMLCatalogFileTypes().iterator();
            while (i.hasNext()) {
                XMLCatalogFileType theFileType = (XMLCatalogFileType)i.next();
                if (theFileType.extensions == null) continue;
                Iterator j = theFileType.extensions.iterator();
                while (j.hasNext()) {
                    String extension = (String)j.next();
                    if (!this.resourceLocationField.getText().endsWith(extension)) continue;
                    if ("org.eclipse.wst.xml.core.ui.catalogFileType.xsd".equals(theFileType.id)) {
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_PUBLIC);
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_SYSTEM);
                        this.keyTypeCombo.setData("keyType", (Object)"schema");
                        continue;
                    }
                    if ("org.eclipse.wst.xml.core.ui.catalogFileType.dtd".equals(theFileType.id)) {
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_PUBLIC);
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM);
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
                        continue;
                    }
                    this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
                }
            }
            if (this.keyTypeCombo.getItemCount() == 0) {
                this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_PUBLIC);
                this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM);
                this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
            }
            switch (type) {
                case 2: {
                    this.keyTypeCombo.select(0);
                    break;
                }
                case 3: {
                    this.keyTypeCombo.select(1);
                    break;
                }
                case 4: {
                    if ("schema".equals(this.keyTypeCombo.getData("keyType"))) {
                        this.keyTypeCombo.select(0);
                        break;
                    }
                    this.keyTypeCombo.select(2);
                    break;
                }
                default: {
                    if (this.keyTypeCombo.getItemCount() <= 0) break;
                    this.keyTypeCombo.select(0);
                }
            }
        }

        protected void updateWebAddressWidgets(int keyType) {
            boolean isPublicKeyType = keyType == 2;
            this.checkboxButton.setEnabled(isPublicKeyType);
            this.webAddressField.setEnabled(isPublicKeyType && this.checkboxButton.getSelection());
        }

        protected void updateWidgets(Widget widget) {
            if (widget != this.keyTypeCombo) {
                this.updateKeyTypeCombo(this.getKeyType());
            }
            this.updateWebAddressWidgets(this.getKeyType());
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        static /* synthetic */ EditCatalogEntryDialog access$0(CatalogEntryPage catalogEntryPage) {
            return catalogEntryPage.EditCatalogEntryDialog.this;
        }
    }

    protected class DelegateCatalogPage
    extends AbstractDelegatePage {
        protected IDelegateCatalog delegateCatalog;
        private Text prefixField;
        private Combo keyTypeCombo;

        protected DelegateCatalogPage() {
        }

        public void refresh() {
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        protected void computeErrorMessage() {
            EditCatalogEntryDialog.this.errorMessage = null;
            String prefix = this.prefixField.getText();
            if (prefix.length() <= 0) {
                EditCatalogEntryDialog.this.errorMessage = "";
            }
        }

        public ICatalogElement getData() {
            return this.getDelegateCatalog();
        }

        protected void createSpecificFields(Composite group) {
            Composite prefixComposite = new Composite(group, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginBottom = 5;
            prefixComposite.setLayout((Layout)layout);
            Label keyTypeLabel = new Label(prefixComposite, 0);
            keyTypeLabel.setText(XMLCatalogMessages.UI_MATCH_KEY_TYPE_COLON);
            this.keyTypeCombo = new Combo(prefixComposite, 8);
            GridData gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.keyTypeCombo.setLayoutData((Object)gd);
            this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_PUBLIC);
            this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM);
            this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
            switch (this.getDelegateCatalog().getEntryType()) {
                case 31: {
                    this.keyTypeCombo.select(0);
                    break;
                }
                case 32: {
                    this.keyTypeCombo.select(1);
                    break;
                }
                default: {
                    this.keyTypeCombo.select(2);
                }
            }
            Label prefixLabel = new Label(prefixComposite, 0);
            prefixLabel.setText(XMLCatalogMessages.UI_LABEL_START_STRING_COLON);
            this.prefixField = new Text(prefixComposite, 2052);
            this.prefixField.setLayoutData((Object)new GridData(4, 0, true, false));
            this.prefixField.setText(EditCatalogEntryDialog.this.getDisplayValue(this.getDelegateCatalog().getStartString()));
            ModifyListener modifyListener = new ModifyListener(this){
                final /* synthetic */ DelegateCatalogPage this$1;
                {
                    this.this$1 = delegateCatalogPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateWidgets(e.widget);
                }
            };
            this.prefixField.addModifyListener(modifyListener);
            prefixComposite.setLayoutData((Object)new GridData(4, 0, true, false));
        }

        protected IDelegateCatalog getDelegateCatalog() {
            if (this.delegateCatalog == null) {
                if (EditCatalogEntryDialog.this.fCatalogElement != null && EditCatalogEntryDialog.this.fCatalogElement.getType() == 30) {
                    this.delegateCatalog = (IDelegateCatalog)EditCatalogEntryDialog.this.fCatalogElement;
                } else if (EditCatalogEntryDialog.this.catalog != null) {
                    this.delegateCatalog = (IDelegateCatalog)EditCatalogEntryDialog.this.catalog.createCatalogElement(33);
                }
            }
            return this.delegateCatalog;
        }

        public void saveData() {
            if (this.validateData()) {
                this.getDelegateCatalog().setCatalogLocation(URIUtils.convertLocationToURI(this.catalogLocationField.getText()));
                this.getDelegateCatalog().setStartString(this.prefixField.getText());
                this.getDelegateCatalog().setEntryType(this.getDelegateType());
                EditCatalogEntryDialog.this.dataSaved = true;
            } else {
                EditCatalogEntryDialog.this.errorMessage = XMLCatalogMessages.UI_WARNING_DUPLICATE_DELEGATE;
                this.errorMessageLabel.setText(EditCatalogEntryDialog.this.errorMessage);
                EditCatalogEntryDialog.this.updateOKButtonState();
                EditCatalogEntryDialog.this.dataSaved = false;
            }
        }

        private int getDelegateType() {
            switch (this.keyTypeCombo.getSelectionIndex()) {
                case 0: {
                    return 31;
                }
                case 1: {
                    return 32;
                }
            }
            return 33;
        }

        protected boolean validateData() {
            IDelegateCatalog entry = this.getDelegateCatalog();
            String prefix = this.prefixField.getText();
            if (entry.getEntryType() != this.getDelegateType() || !prefix.equals(entry.getStartString())) {
                IDelegateCatalog[] entries = EditCatalogEntryDialog.this.catalog.getDelegateCatalogs();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getStartString().equals(this.prefixField) && entries[i].getEntryType() == this.getDelegateType()) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        protected String getCatalogLocation() {
            return this.getDelegateCatalog().getCatalogLocation();
        }

        public Control createControl(Composite parent) {
            this.fControl = this.createNextCatalogPanel(parent, XMLCatalogMessages.UI_LABEL_DELEGATE_CATALOG_URI_COLON);
            return this.fControl;
        }
    }

    protected class FilterableSelectSingleFileDialog
    extends SelectSingleFileDialog
    implements SelectionListener {
        protected Combo filterControl;

        public FilterableSelectSingleFileDialog(Shell parentShell) {
            super(parentShell, null, true);
            this.setFilters(null);
        }

        public void createAndOpen() {
            this.create();
            this.setBlockOnOpen(true);
            this.getShell().setText(XMLCatalogMessages.UI_LABEL_FILE_SELECTION);
            this.setTitle(XMLCatalogMessages.UI_LABEL_SELECT_FILE);
            this.setMessage(XMLCatalogMessages.UI_LABEL_CHOOSE_FILE_TO_ADD_TO_CATALOG);
            this.open();
        }

        public void createFilterControl(Composite composite) {
            Label label = new Label(composite, 0);
            label.setText(XMLCatalogMessages.UI_LABEL_SELECT_FILE_FILTER_CONTROL);
            this.filterControl = new Combo(composite, 8);
            GridData gd = new GridData(768);
            this.filterControl.setLayoutData((Object)gd);
            this.filterControl.setText(XMLCatalogMessages.UI_TEXT_SELECT_FILE_FILTER_CONTROL);
            this.filterControl.add(XMLCatalogMessages.UI_TEXT_SELECT_FILE_FILTER_CONTROL);
            Iterator i = CatalogFileTypeRegistryReader.getXMLCatalogFileTypes().iterator();
            while (i.hasNext()) {
                XMLCatalogFileType fileType = (XMLCatalogFileType)i.next();
                if (fileType.description == null) continue;
                this.filterControl.add(fileType.description);
            }
            this.filterControl.select(0);
            this.filterControl.addSelectionListener((SelectionListener)this);
        }

        protected void setFilters(XMLCatalogFileType fileType) {
            if (fileType == null) {
                ArrayList list = new ArrayList();
                Iterator i = CatalogFileTypeRegistryReader.getXMLCatalogFileTypes().iterator();
                while (i.hasNext()) {
                    XMLCatalogFileType theFileType = (XMLCatalogFileType)i.next();
                    if (theFileType.extensions == null) continue;
                    list.addAll(theFileType.extensions);
                }
                this.selectSingleFileView.setFilterExtensions(EditCatalogEntryDialog.createStringArray(list));
            } else if (fileType.extensions != null) {
                this.selectSingleFileView.setFilterExtensions(EditCatalogEntryDialog.createStringArray(fileType.extensions));
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            String text = this.filterControl.getText();
            XMLCatalogFileType fileType = EditCatalogEntryDialog.this.getMatchingFileType(text);
            this.setFilters(fileType);
        }
    }

    protected class NextCatalogPage
    extends AbstractDelegatePage {
        protected INextCatalog nextCatalog;

        protected NextCatalogPage() {
        }

        public ICatalogElement getData() {
            return this.getNextCatalog();
        }

        public void refresh() {
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        protected INextCatalog getNextCatalog() {
            if (this.nextCatalog == null) {
                if (EditCatalogEntryDialog.this.fCatalogElement != null && EditCatalogEntryDialog.this.fCatalogElement.getType() == 10) {
                    this.nextCatalog = (INextCatalog)EditCatalogEntryDialog.this.fCatalogElement;
                } else if (EditCatalogEntryDialog.this.catalog != null) {
                    this.nextCatalog = (INextCatalog)EditCatalogEntryDialog.this.catalog.createCatalogElement(10);
                }
            }
            return this.nextCatalog;
        }

        public void saveData() {
            this.getNextCatalog().setCatalogLocation(URIUtils.convertLocationToURI(this.catalogLocationField.getText()));
            EditCatalogEntryDialog.this.dataSaved = true;
        }

        protected String getCatalogLocation() {
            return this.getNextCatalog().getCatalogLocation();
        }

        public Control createControl(Composite parent) {
            this.fControl = this.createNextCatalogPanel(parent, XMLCatalogMessages.UI_LABEL_CATALOG_URI_COLON);
            return this.fControl;
        }
    }

    protected class RadioItemSelectionChangeListener
    implements SelectionListener {
        protected RadioItemSelectionChangeListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Button button;
            Object selection = e.getSource();
            if (selection instanceof Button && (button = (Button)selection).getSelection()) {
                EditCatalogEntryDialog.this.showPage((CatalogElementPage)button.getData());
            }
        }
    }

    protected class RewriteEntryPage
    extends CatalogElementPage {
        protected IRewriteEntry rewriteEntry;
        private Text startStringField;
        private Text prefixField;
        private Combo keyTypeCombo;
        protected Label errorMessageLabel;

        protected RewriteEntryPage() {
        }

        public void refresh() {
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        public ICatalogElement getData() {
            return this.getRewriteEntry();
        }

        protected void computeErrorMessage() {
            EditCatalogEntryDialog.this.errorMessage = null;
            String start = this.startStringField.getText();
            String prefix = this.prefixField.getText();
            if (start.trim().length() <= 0 || prefix.trim().length() <= 0) {
                EditCatalogEntryDialog.this.errorMessage = "";
            }
        }

        protected IRewriteEntry getRewriteEntry() {
            if (this.rewriteEntry == null) {
                if (EditCatalogEntryDialog.this.fCatalogElement != null && EditCatalogEntryDialog.this.fCatalogElement.getType() == 20) {
                    this.rewriteEntry = (IRewriteEntry)EditCatalogEntryDialog.this.fCatalogElement;
                } else if (EditCatalogEntryDialog.this.catalog != null) {
                    this.rewriteEntry = (IRewriteEntry)EditCatalogEntryDialog.this.catalog.createCatalogElement(21);
                }
            }
            return this.rewriteEntry;
        }

        protected void updateWidgets(Widget widget) {
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        public void saveData() {
            if (this.validateData()) {
                this.getRewriteEntry().setRewritePrefix(this.prefixField.getText());
                this.getRewriteEntry().setStartString(this.startStringField.getText());
                this.getRewriteEntry().setEntryType(this.getEntryType());
                EditCatalogEntryDialog.this.dataSaved = true;
            } else {
                EditCatalogEntryDialog.this.errorMessage = XMLCatalogMessages.UI_WARNING_DUPLICATE_REWRITE;
                this.errorMessageLabel.setText(EditCatalogEntryDialog.this.errorMessage);
                EditCatalogEntryDialog.this.updateOKButtonState();
                EditCatalogEntryDialog.this.dataSaved = false;
            }
        }

        private int getEntryType() {
            switch (this.keyTypeCombo.getSelectionIndex()) {
                case 0: {
                    return 21;
                }
            }
            return 22;
        }

        protected boolean validateData() {
            IRewriteEntry entry = this.getRewriteEntry();
            String startString = this.startStringField.getText();
            if (entry.getEntryType() != this.getEntryType() || !entry.getStartString().equals(startString)) {
                IRewriteEntry[] entries = EditCatalogEntryDialog.this.catalog.getRewriteEntries();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getStartString().equals(startString) && entries[i].getEntryType() == this.getEntryType()) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        public Control createControl(Composite parent) {
            this.fControl = this.createRewriteEntryPanel(parent);
            return this.fControl;
        }

        public Control createRewriteEntryPanel(Composite parent) {
            ModifyListener modifyListener = new ModifyListener(this){
                final /* synthetic */ RewriteEntryPage this$1;
                {
                    this.this$1 = rewriteEntryPage;
                }

                public void modifyText(ModifyEvent e) {
                    this.this$1.updateWidgets(e.widget);
                }
            };
            Composite composite = new Composite(parent, 0);
            GridData gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            Composite group = new Composite(composite, 0);
            gd = new GridData(768);
            group.setLayoutData((Object)gd);
            layout = new GridLayout();
            group.setLayout((Layout)layout);
            Composite prefixComposite = new Composite(group, 0);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginBottom = 5;
            prefixComposite.setLayout((Layout)layout);
            Label keyTypeLabel = new Label(prefixComposite, 0);
            keyTypeLabel.setText(XMLCatalogMessages.UI_MATCH_KEY_TYPE_COLON);
            this.keyTypeCombo = new Combo(prefixComposite, 8);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.keyTypeCombo.setLayoutData((Object)gd);
            this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM);
            this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
            switch (this.getRewriteEntry().getEntryType()) {
                case 32: {
                    this.keyTypeCombo.select(0);
                    break;
                }
                default: {
                    this.keyTypeCombo.select(1);
                }
            }
            Label startStringLabel = new Label(prefixComposite, 0);
            startStringLabel.setText(XMLCatalogMessages.UI_LABEL_START_STRING_COLON);
            this.startStringField = new Text(prefixComposite, 2052);
            this.startStringField.setLayoutData((Object)new GridData(4, 0, true, false));
            this.startStringField.setText(EditCatalogEntryDialog.this.getDisplayValue(this.getRewriteEntry().getStartString()));
            this.startStringField.addModifyListener(modifyListener);
            Label prefixLabel = new Label(prefixComposite, 0);
            prefixLabel.setText(XMLCatalogMessages.UI_LABEL_REWRITE_PREFIX_COLON);
            this.prefixField = new Text(prefixComposite, 2052);
            this.prefixField.setLayoutData((Object)new GridData(4, 0, true, false));
            this.prefixField.setText(EditCatalogEntryDialog.this.getDisplayValue(this.getRewriteEntry().getRewritePrefix()));
            this.prefixField.addModifyListener(modifyListener);
            prefixComposite.setLayoutData((Object)new GridData(4, 0, true, false));
            this.errorMessageLabel = new Label(group, 0);
            this.errorMessageLabel.setForeground(EditCatalogEntryDialog.this.color);
            this.errorMessageLabel.setLayoutData((Object)new GridData(768));
            this.updateWidgets(null);
            return composite;
        }
    }

    protected class SuffixEntryPage
    extends CatalogElementPage {
        protected Button browseWorkspaceButton;
        protected Button browseFileSystemButton;
        protected ISuffixEntry catalogEntry;
        protected Label errorMessageLabel;
        protected Text suffixField;
        protected Combo keyTypeCombo;
        protected Text resourceLocationField;
        protected Combo resourceTypeCombo;
        protected String key;
        protected int type;

        protected SuffixEntryPage() {
        }

        public void refresh() {
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        protected void computeErrorMessage() {
            EditCatalogEntryDialog.this.errorMessage = null;
            EditCatalogEntryDialog.this.warningMessage = null;
            String fileName = this.resourceLocationField.getText();
            if (fileName.trim().length() > 0) {
                String uri;
                if (fileName.indexOf("..") != -1 || fileName.indexOf("./") != -1 || fileName.indexOf("/.") != -1 || fileName.indexOf(".\\") != -1 || fileName.indexOf("\\.") != -1) {
                    EditCatalogEntryDialog.this.errorMessage = XMLCatalogMessages.UI_WARNING_URI_MUST_NOT_HAVE_DOTS;
                }
                if (!URIHelper.hasProtocol((String)(uri = fileName))) {
                    URIHelper.isAbsolute((String)uri);
                    String string = uri = URIHelper.isAbsolute((String)uri) ? URIHelper.prependFileProtocol((String)uri) : URIHelper.prependPlatformResourceProtocol((String)uri);
                }
                if (EditCatalogEntryDialog.this.errorMessage == null && !URIHelper.isReadableURI((String)uri, (boolean)false)) {
                    EditCatalogEntryDialog.this.errorMessage = String.valueOf(XMLCatalogMessages.UI_WARNING_URI_NOT_FOUND_COLON) + fileName;
                }
            } else {
                EditCatalogEntryDialog.this.errorMessage = "";
            }
            if (EditCatalogEntryDialog.this.errorMessage == null && this.suffixField.getText().trim().length() == 0) {
                EditCatalogEntryDialog.this.errorMessage = "";
            }
        }

        protected Control createSuffixEntryPanel(Composite parent) {
            ModifyListener modifyListener = new ModifyListener(this){
                final /* synthetic */ SuffixEntryPage this$1;
                {
                    this.this$1 = suffixEntryPage;
                }

                public void modifyText(ModifyEvent e) {
                    String namespaceURI;
                    String uri;
                    if (e.widget == this.this$1.resourceLocationField && this.this$1.suffixField.getText().length() == 0 && (uri = this.this$1.resourceLocationField.getText()).endsWith("xsd") && !URIHelper.hasProtocol((String)uri) && (namespaceURI = XMLQuickScan.getTargetNamespaceURIForSchema(uri = URIHelper.isAbsolute((String)uri) ? URIHelper.prependFileProtocol((String)uri) : URIHelper.prependPlatformResourceProtocol((String)uri))) != null) {
                        this.this$1.suffixField.setText(namespaceURI);
                    }
                    this.this$1.updateWidgets(e.widget);
                }
            };
            Composite composite = new Composite(parent, 0);
            GridData gd = new GridData(1808);
            composite.setLayoutData((Object)gd);
            GridLayout layout = new GridLayout();
            composite.setLayout((Layout)layout);
            Composite group = new Composite(composite, 0);
            gd = new GridData(768);
            group.setLayoutData((Object)gd);
            layout = new GridLayout(2, false);
            group.setLayout((Layout)layout);
            Label resourceLocationLabel = new Label(group, 0);
            resourceLocationLabel.setText(XMLCatalogMessages.UI_LABEL_LOCATION_COLON);
            this.resourceLocationField = new Text(group, 2052);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.resourceLocationField.setLayoutData((Object)gd);
            this.resourceLocationField.setText(EditCatalogEntryDialog.this.getDisplayValue(URIUtils.convertURIToLocation(this.getEntry().getURI())));
            this.resourceLocationField.addModifyListener(modifyListener);
            Composite browseButtonsComposite = new Composite(group, 0);
            gd = new GridData(768);
            gd.horizontalSpan = 2;
            gd.horizontalAlignment = 3;
            browseButtonsComposite.setLayoutData((Object)gd);
            layout = new GridLayout();
            layout.numColumns = 2;
            layout.marginWidth = 0;
            layout.marginHeight = 0;
            layout.marginBottom = 5;
            browseButtonsComposite.setLayout((Layout)layout);
            this.browseWorkspaceButton = new Button(browseButtonsComposite, 8);
            this.browseWorkspaceButton.setText(XMLCatalogMessages.UI_BUTTON_MENU_BROWSE_WORKSPACE);
            this.browseWorkspaceButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SuffixEntryPage this$1;
                {
                    this.this$1 = suffixEntryPage;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String value = SuffixEntryPage.access$0(this.this$1).invokeWorkspaceFileSelectionDialog();
                    if (value != null) {
                        this.this$1.resourceLocationField.setText(value);
                    }
                }
            });
            this.browseFileSystemButton = new Button(browseButtonsComposite, 8);
            this.browseFileSystemButton.setText(XMLCatalogMessages.UI_BUTTON_MENU_BROWSE_FILE_SYSTEM);
            this.browseFileSystemButton.addSelectionListener(new SelectionListener(this){
                final /* synthetic */ SuffixEntryPage this$1;
                {
                    this.this$1 = suffixEntryPage;
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    String value = SuffixEntryPage.access$0(this.this$1).invokeFileSelectionDialog();
                    if (value != null) {
                        this.this$1.resourceLocationField.setText(value);
                    }
                }
            });
            Label keyTypeLabel = new Label(group, 0);
            keyTypeLabel.setText(XMLCatalogMessages.UI_KEY_TYPE_COLON);
            this.keyTypeCombo = new Combo(group, 8);
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.keyTypeCombo.setLayoutData((Object)gd);
            this.updateKeyTypeCombo(this.getEntry().getEntryType());
            this.keyTypeCombo.addModifyListener(modifyListener);
            Label suffixValueLabel = new Label(group, 0);
            suffixValueLabel.setText(XMLCatalogMessages.UI_LABEL_SUFFIX_COLON);
            this.suffixField = new Text(group, 2052);
            this.suffixField.setLayoutData((Object)gd);
            this.suffixField.setText(EditCatalogEntryDialog.this.getDisplayValue(this.getEntry().getSuffix()));
            this.suffixField.addModifyListener(modifyListener);
            this.errorMessageLabel = new Label(composite, 0);
            this.errorMessageLabel.setForeground(EditCatalogEntryDialog.this.color);
            this.errorMessageLabel.setLayoutData((Object)new GridData(768));
            this.updateWidgets(null);
            this.key = this.getEntry().getSuffix();
            this.type = this.getEntry().getEntryType();
            return composite;
        }

        public Control createControl(Composite parent) {
            this.fControl = this.createSuffixEntryPanel(parent);
            return this.fControl;
        }

        public ICatalogElement getData() {
            return this.getEntry();
        }

        protected ISuffixEntry getEntry() {
            if (this.catalogEntry == null) {
                if (EditCatalogEntryDialog.this.fCatalogElement != null && EditCatalogEntryDialog.this.fCatalogElement.getType() == 40) {
                    this.catalogEntry = (ISuffixEntry)EditCatalogEntryDialog.this.fCatalogElement;
                } else if (EditCatalogEntryDialog.this.catalog != null) {
                    this.catalogEntry = (ISuffixEntry)EditCatalogEntryDialog.this.catalog.createCatalogElement(40);
                }
            }
            return this.catalogEntry;
        }

        protected int getKeyType() {
            switch (this.keyTypeCombo.getSelectionIndex()) {
                case 0: {
                    return 42;
                }
                case 1: {
                    return 41;
                }
            }
            return 42;
        }

        public void saveData() {
            if (this.validateData()) {
                this.getEntry().setURI(URIUtils.convertLocationToURI(this.resourceLocationField.getText()));
                this.getEntry().setSuffix(this.suffixField.getText());
                this.getEntry().setEntryType(this.getKeyType());
                EditCatalogEntryDialog.this.dataSaved = true;
            } else {
                EditCatalogEntryDialog.this.errorMessage = XMLCatalogMessages.UI_WARNING_DUPLICATE_SUFFIX;
                this.errorMessageLabel.setText(EditCatalogEntryDialog.this.errorMessage);
                EditCatalogEntryDialog.this.updateOKButtonState();
                EditCatalogEntryDialog.this.dataSaved = false;
            }
        }

        protected boolean validateData() {
            ISuffixEntry entry = this.getEntry();
            String uri = URIUtils.convertLocationToURI(this.resourceLocationField.getText());
            if (entry.getEntryType() != this.getKeyType() || !entry.getSuffix().equals(this.suffixField.getText()) || !entry.getURI().equals(uri)) {
                ISuffixEntry[] entries = EditCatalogEntryDialog.this.catalog.getSuffixEntries();
                int i = 0;
                while (i < entries.length) {
                    if (entries[i].getSuffix().equals(this.suffixField.getText()) && entries[i].getEntryType() == this.getKeyType()) {
                        return false;
                    }
                    ++i;
                }
            }
            return true;
        }

        protected void updateKeyTypeCombo(int type) {
            this.keyTypeCombo.removeAll();
            Iterator i = CatalogFileTypeRegistryReader.getXMLCatalogFileTypes().iterator();
            while (i.hasNext()) {
                XMLCatalogFileType theFileType = (XMLCatalogFileType)i.next();
                if (theFileType.extensions == null) continue;
                Iterator j = theFileType.extensions.iterator();
                while (j.hasNext()) {
                    String extension = (String)j.next();
                    if (!this.resourceLocationField.getText().endsWith(extension)) continue;
                    if ("org.eclipse.wst.xml.core.ui.catalogFileType.xsd".equals(theFileType.id)) {
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_PUBLIC);
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_XSD_SYSTEM);
                        continue;
                    }
                    if ("org.eclipse.wst.xml.core.ui.catalogFileType.dtd".equals(theFileType.id)) {
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
                        this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM);
                        continue;
                    }
                    this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
                }
            }
            if (this.keyTypeCombo.getItemCount() == 0) {
                this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_URI);
                this.keyTypeCombo.add(XMLCatalogMessages.UI_KEY_TYPE_DESCRIPTION_DTD_SYSTEM);
            }
            switch (type) {
                case 42: {
                    this.keyTypeCombo.select(0);
                    break;
                }
                case 41: {
                    this.keyTypeCombo.select(1);
                    break;
                }
                default: {
                    if (this.keyTypeCombo.getItemCount() <= 0) break;
                    this.keyTypeCombo.select(0);
                }
            }
        }

        protected void updateWidgets(Widget widget) {
            if (widget != this.keyTypeCombo) {
                this.updateKeyTypeCombo(this.getKeyType());
            }
            this.computeErrorMessage();
            EditCatalogEntryDialog.this.updateErrorMessageLabel(this.errorMessageLabel);
            EditCatalogEntryDialog.this.updateOKButtonState();
        }

        static /* synthetic */ EditCatalogEntryDialog access$0(SuffixEntryPage suffixEntryPage) {
            return suffixEntryPage.EditCatalogEntryDialog.this;
        }
    }

    protected class ToolBarItemSelectionChangeListener
    implements SelectionListener {
        protected ToolBarItemSelectionChangeListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void widgetSelected(SelectionEvent e) {
            Object selection = e.getSource();
            if (selection instanceof ToolItem) {
                ToolItem toolItem = (ToolItem)selection;
                ToolBar toolbar = toolItem.getParent();
                if (toolbar != null) {
                    ToolItem[] items = toolbar.getItems();
                    int i = 0;
                    while (i < items.length) {
                        items[i].setSelection(items[i] == toolItem);
                        ++i;
                    }
                }
                EditCatalogEntryDialog.this.showPage((CatalogElementPage)toolItem.getData());
            }
        }
    }
}

