/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.contentassist;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.ui.internal.IReleasable;
import org.eclipse.wst.sse.ui.internal.StructuredTextViewer;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.ui.internal.contentassist.XMLContentAssistProcessor;

public class NoRegionContentAssistProcessor
implements IContentAssistProcessor,
IReleasable {
    private static final boolean DEBUG = false;
    protected char[] completionProposalAutoActivationCharacters = null;
    protected char[] contextInformationAutoActivationCharacters = null;
    private final ICompletionProposal[] EMPTY_PROPOSAL_SET = new ICompletionProposal[0];
    protected String fErrorMessage = null;
    private HashMap fNameToProcessorMap = null;
    private HashMap fPartitionToProcessorMap = null;

    protected void addPartitionProcessor(String key, IContentAssistProcessor processor) {
        this.addProcessor(this.getPartitionToProcessorMap(), key, processor);
    }

    protected void addNameProcessor(String key, IContentAssistProcessor processor) {
        this.addProcessor(this.getNameToProcessorMap(), key, processor);
    }

    protected IContentAssistProcessor getPartitionProcessor(String key) {
        return (IContentAssistProcessor)this.getPartitionToProcessorMap().get(key);
    }

    private void addProcessor(HashMap map, String key, IContentAssistProcessor processor) {
        Object o = map.remove(key);
        if (o != null && o instanceof IReleasable) {
            ((IReleasable)o).release();
        }
        map.put(key, processor);
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int documentOffset) {
        IContentAssistProcessor p = null;
        ICompletionProposal[] results = this.EMPTY_PROPOSAL_SET;
        p = this.guessContentAssistProcessor(viewer, documentOffset);
        if (p != null) {
            results = p.computeCompletionProposals(viewer, documentOffset);
        }
        return results != null ? results : this.EMPTY_PROPOSAL_SET;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int documentOffset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return this.completionProposalAutoActivationCharacters;
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return this.contextInformationAutoActivationCharacters;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    private HashMap getNameToProcessorMap() {
        if (this.fNameToProcessorMap == null) {
            this.fNameToProcessorMap = new HashMap();
            this.initNameToProcessorMap();
        }
        return this.fNameToProcessorMap;
    }

    private HashMap getPartitionToProcessorMap() {
        if (this.fPartitionToProcessorMap == null) {
            this.fPartitionToProcessorMap = new HashMap();
            this.initPartitionToProcessorMap();
        }
        return this.fPartitionToProcessorMap;
    }

    protected String getPartitionType(StructuredTextViewer viewer, int documentPosition) {
        IDocument document = viewer.getDocument();
        String partitionType = null;
        ITypedRegion partition = null;
        try {
            partition = document.getPartition(documentPosition);
            partitionType = partition.getType();
        }
        catch (BadLocationException e) {
            partitionType = null;
        }
        return partitionType;
    }

    protected IContentAssistProcessor guessContentAssistProcessor(ITextViewer viewer, int documentOffset) {
        IStructuredDocumentRegion sdPrev;
        String currentRegionType;
        IContentAssistProcessor p = null;
        IStructuredDocumentRegion sdRegion = ContentAssistUtils.getStructuredDocumentRegion((ITextViewer)viewer, (int)documentOffset);
        if (sdRegion == null || (currentRegionType = sdRegion.getType()) != "UNDEFINED" || (sdPrev = sdRegion.getPrevious()) != null) {
            // empty if block
        }
        if (p == null && viewer.getDocument().getLength() > 0) {
            String prevPartitionType = this.getPartitionType((StructuredTextViewer)viewer, documentOffset - 1);
            p = (IContentAssistProcessor)this.getPartitionToProcessorMap().get(prevPartitionType);
        }
        return p;
    }

    protected void initNameToProcessorMap() {
    }

    protected void initPartitionToProcessorMap() {
        XMLContentAssistProcessor xmlProcessor = new XMLContentAssistProcessor();
        this.addProcessor(this.getPartitionToProcessorMap(), "org.eclipse.wst.xml.XML_DEFAULT", xmlProcessor);
    }

    public void release() {
        this.releasePartitionToProcessorMap();
        this.releaseNameToProcessorMap();
    }

    protected void releaseMap(HashMap map) {
        if (map != null && !map.isEmpty()) {
            Iterator it = map.keySet().iterator();
            Object key = null;
            while (it.hasNext()) {
                key = it.next();
                if (!(map.get(key) instanceof IReleasable)) continue;
                ((IReleasable)map.get(key)).release();
            }
            map.clear();
            map = null;
        }
    }

    protected void releaseNameToProcessorMap() {
        this.releaseMap(this.fNameToProcessorMap);
    }

    protected void releasePartitionToProcessorMap() {
        this.releaseMap(this.fPartitionToProcessorMap);
    }
}

