/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.correction;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.sse.core.internal.provisional.text.IStructuredDocumentRegion;
import org.eclipse.wst.sse.core.internal.provisional.text.ITextRegion;
import org.eclipse.wst.sse.ui.internal.contentassist.ContentAssistUtils;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.Logger;
import org.eclipse.wst.xml.ui.internal.XMLUIMessages;
import org.eclipse.wst.xml.ui.internal.editor.XMLEditorPluginImageHelper;

public class RenameInFileQuickAssistProposal
implements ICompletionProposal,
ICompletionProposalExtension2 {
    protected IRegion fSelectedRegion;

    public void apply(IDocument document) {
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        IDocument document = viewer.getDocument();
        Point originalRange = viewer.getSelectedRange();
        LinkedPositionGroup group = new LinkedPositionGroup();
        try {
            ITextRegion region;
            IDOMNode node = (IDOMNode)ContentAssistUtils.getNodeAt((ITextViewer)viewer, (int)offset);
            IStructuredDocumentRegion startStructuredDocumentRegion = node.getStartStructuredDocumentRegion();
            ITextRegion iTextRegion = region = startStructuredDocumentRegion == null ? null : startStructuredDocumentRegion.getRegionAtCharacterOffset(offset);
            if (region != null) {
                group.addPosition(new LinkedPosition(document, startStructuredDocumentRegion.getStartOffset() + region.getStart(), region.getTextLength(), 0));
                if (region.getType() == "XML_TAG_NAME" && node.getEndStructuredDocumentRegion() != null && (region = node.getEndStructuredDocumentRegion().getRegions().get(1)) != null) {
                    group.addPosition(new LinkedPosition(document, node.getEndStructuredDocumentRegion().getStartOffset() + region.getStart(), region.getTextLength(), 1));
                }
            } else {
                IStructuredDocumentRegion endStructuredDocumentRegion = node.getEndStructuredDocumentRegion();
                ITextRegion iTextRegion2 = region = endStructuredDocumentRegion == null ? null : endStructuredDocumentRegion.getRegionAtCharacterOffset(offset);
                if (region != null) {
                    if (region.getType() == "XML_TAG_NAME" && node.getStartStructuredDocumentRegion() != null) {
                        ITextRegion startTagNameRegion = node.getStartStructuredDocumentRegion().getRegions().get(1);
                        if (region != null) {
                            group.addPosition(new LinkedPosition(document, node.getStartStructuredDocumentRegion().getStartOffset() + startTagNameRegion.getStart(), startTagNameRegion.getTextLength(), 0));
                            group.addPosition(new LinkedPosition(document, endStructuredDocumentRegion.getStartOffset() + region.getStart(), region.getTextLength(), 1));
                        }
                    } else {
                        group.addPosition(new LinkedPosition(document, endStructuredDocumentRegion.getStartOffset() + region.getStart(), region.getTextLength(), 0));
                    }
                }
            }
            if (viewer instanceof ITextViewerExtension) {
                ((ITextViewerExtension)viewer).setRedraw(true);
            }
            LinkedModeModel linkedModeModel = new LinkedModeModel();
            linkedModeModel.addGroup(group);
            linkedModeModel.forceInstall();
            EditorLinkedModeUI ui = new EditorLinkedModeUI(linkedModeModel, viewer);
            ui.setExitPosition(viewer, offset, 0, -1);
            ui.enter();
            viewer.setSelectedRange(originalRange.x, originalRange.y);
            this.fSelectedRegion = ui.getSelectedRegion();
        }
        catch (BadLocationException e) {
            Logger.log(1, e.getMessage());
        }
    }

    public String getAdditionalProposalInfo() {
        return XMLUIMessages.RenameInFileQuickAssistProposal_0;
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public String getDisplayString() {
        return XMLUIMessages.RenameInFileQuickAssistProposal_1;
    }

    public Image getImage() {
        return XMLEditorPluginImageHelper.getInstance().getImage("icons/full/tobj16/localvariable_obj.png");
    }

    public Point getSelection(IDocument document) {
        return null;
    }

    public void selected(ITextViewer viewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer viewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }
}

