/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.ui.internal.tabletree;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.DefaultPositionUpdater;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPositionUpdater;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.NavigationLocation;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.xml.core.internal.provisional.document.IDOMNode;
import org.eclipse.wst.xml.ui.internal.tabletree.IDesignViewer;

class DesignPageNavigationLocation
extends NavigationLocation {
    private static final String TAG_X = "x";
    private static final String TAG_Y = "y";
    private static final String TAG_INFO = "info";
    private static final String INFO_DELETED = "deleted";
    private static final String INFO_NOT_DELETED = "not_deleted";
    private static final String CATEGORY;
    private static final IPositionUpdater fgPositionUpdater;
    private Position fPosition;
    private IDocument fDocument;
    private Position fSavedPosition;
    private IDesignViewer fViewer;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        StringBuffer stringBuffer = new StringBuffer("__navigation_");
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.texteditor.TextSelectionNavigationLocation");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        CATEGORY = stringBuffer.append(clazz.hashCode()).toString();
        fgPositionUpdater = new DefaultPositionUpdater(CATEGORY);
    }

    DesignPageNavigationLocation(IEditorPart part, IDesignViewer viewer, boolean initialize) {
        super(part);
        this.fViewer = viewer;
        if (initialize) {
            ISelection selection = this.fViewer.getSelectionProvider().getSelection();
            ITextEditor textPart = this.getTextEditorPart();
            if (textPart != null) {
                IDocument document = this.getDocument(textPart);
                if (selection instanceof IStructuredSelection && !selection.isEmpty()) {
                    IDOMNode node;
                    Position position;
                    Object first = ((IStructuredSelection)selection).getFirstElement();
                    if (first instanceof IDOMNode && this.installOnDocument(document, position = new Position((node = (IDOMNode)first).getStartOffset(), node.getLength()))) {
                        this.fDocument = document;
                        this.fPosition = position;
                        if (!part.isDirty()) {
                            this.fSavedPosition = new Position(this.fPosition.offset, this.fPosition.length);
                        }
                    }
                } else {
                    Position position = new Position(0, 0);
                    if (this.installOnDocument(document, position)) {
                        this.fDocument = document;
                        this.fPosition = position;
                        if (!part.isDirty()) {
                            this.fSavedPosition = new Position(this.fPosition.offset, this.fPosition.length);
                        }
                    }
                }
            }
        }
    }

    protected ITextEditor getTextEditorPart() {
        IEditorPart part = super.getEditorPart();
        if (part != null) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ui.texteditor.ITextEditor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (ITextEditor)part.getAdapter((Class)clazz);
        }
        return null;
    }

    private IDocument getDocument(ITextEditor part) {
        IDocumentProvider provider = part.getDocumentProvider();
        return provider.getDocument((Object)part.getEditorInput());
    }

    private boolean installOnDocument(IDocument document, Position position) {
        if (document != null && position != null) {
            if (!document.containsPositionCategory(CATEGORY)) {
                document.addPositionCategory(CATEGORY);
                document.addPositionUpdater(fgPositionUpdater);
            }
            try {
                document.addPosition(CATEGORY, position);
                return true;
            }
            catch (BadLocationException badLocationException) {
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
        return false;
    }

    private boolean uninstallFromDocument(IDocument document, Position position) {
        if (document != null && position != null) {
            try {
                document.removePosition(CATEGORY, position);
                Position[] category = document.getPositions(CATEGORY);
                if (category == null || category.length == 0) {
                    document.removePositionCategory(CATEGORY);
                    document.removePositionUpdater(fgPositionUpdater);
                }
                return true;
            }
            catch (BadPositionCategoryException badPositionCategoryException) {
                // empty catch block
            }
        }
        return false;
    }

    public String toString() {
        return "Selection<" + this.fPosition + ">";
    }

    private boolean equalsLocationOf() {
        Object first;
        if (this.fPosition == null) {
            return true;
        }
        if (this.fPosition.isDeleted) {
            return false;
        }
        ISelection selection = this.fViewer.getSelectionProvider().getSelection();
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)first;
            return this.fPosition.offset == node.getStartOffset() && this.fPosition.length == node.getLength();
        }
        return false;
    }

    public void dispose() {
        this.uninstallFromDocument(this.fDocument, this.fPosition);
        this.fDocument = null;
        this.fPosition = null;
        this.fSavedPosition = null;
        super.dispose();
    }

    public void releaseState() {
        this.uninstallFromDocument(this.fDocument, this.fPosition);
        this.fDocument = null;
        this.fPosition = null;
        this.fSavedPosition = null;
        super.releaseState();
    }

    public boolean mergeInto(INavigationLocation location) {
        if (location == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != location.getClass()) {
            return false;
        }
        if (this.fPosition == null || this.fPosition.isDeleted) {
            return true;
        }
        DesignPageNavigationLocation s = (DesignPageNavigationLocation)location;
        if (s.fPosition == null || s.fPosition.isDeleted) {
            this.uninstallFromDocument(this.fDocument, this.fPosition);
            s.fDocument = this.fDocument;
            s.fPosition = this.fPosition;
            s.fSavedPosition = this.fSavedPosition;
            return true;
        }
        if (s.fDocument == this.fDocument && (s.fPosition.overlapsWith(this.fPosition.offset, this.fPosition.length) || this.fPosition.offset + this.fPosition.length == s.fPosition.offset || s.fPosition.offset + s.fPosition.length == this.fPosition.offset)) {
            s.fPosition.offset = this.fPosition.offset;
            s.fPosition.length = this.fPosition.length;
            return true;
        }
        return false;
    }

    public void restoreLocation() {
        if (this.fPosition == null || this.fPosition.isDeleted) {
            return;
        }
        if (this.fViewer instanceof Viewer) {
            ((Viewer)this.fViewer).setSelection(this.getSelection(), true);
        }
    }

    /*
     * Exception decompiling
     */
    private ISelection getSelection() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 101->104)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void restoreState(IMemento memento) {
        ITextEditor part = this.getTextEditorPart();
        if (part != null) {
            this.fDocument = this.getDocument(part);
            Integer offset = memento.getInteger(TAG_X);
            Integer length = memento.getInteger(TAG_Y);
            String deleted = memento.getString(TAG_INFO);
            if (offset != null && length != null) {
                Position p = new Position(offset.intValue(), length.intValue());
                if (deleted != null) {
                    boolean bl = p.isDeleted = INFO_DELETED.equals(deleted);
                }
                if (this.installOnDocument(this.fDocument, p)) {
                    this.fPosition = p;
                    if (!part.isDirty()) {
                        this.fSavedPosition = new Position(this.fPosition.offset, this.fPosition.length);
                    }
                }
            }
        }
    }

    public void saveState(IMemento memento) {
        if (this.fSavedPosition != null) {
            memento.putInteger(TAG_X, this.fSavedPosition.offset);
            memento.putInteger(TAG_Y, this.fSavedPosition.length);
            memento.putString(TAG_INFO, this.fSavedPosition.isDeleted ? INFO_DELETED : INFO_NOT_DELETED);
        }
    }

    public void partSaved(IEditorPart part) {
        this.fSavedPosition = this.fPosition == null || this.fPosition.isDeleted() ? null : new Position(this.fPosition.offset, this.fPosition.length);
    }

    public void update() {
        Object first;
        IEditorPart part = this.getEditorPart();
        if (part == null || this.equalsLocationOf()) {
            return;
        }
        ISelection selection = this.fViewer.getSelectionProvider().getSelection();
        if (selection == null || selection.isEmpty()) {
            return;
        }
        if (selection instanceof IStructuredSelection && (first = ((IStructuredSelection)selection).getFirstElement()) instanceof IDOMNode) {
            IDOMNode node = (IDOMNode)first;
            this.fPosition.offset = node.getStartOffset();
            this.fPosition.length = node.getLength();
            this.fPosition.isDeleted = false;
            if (!part.isDirty()) {
                this.fSavedPosition = new Position(this.fPosition.offset, this.fPosition.length);
            }
        }
    }
}

