/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.egit.core.RepositoryCache;
import org.eclipse.egit.core.RepositoryUtil;
import org.eclipse.egit.core.project.RepositoryMapping;
import org.eclipse.egit.ui.internal.ConfigurationChecker;
import org.eclipse.egit.ui.internal.KnownHosts;
import org.eclipse.egit.ui.internal.RepositoryCacheRule;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.credentials.EGitCredentialsProvider;
import org.eclipse.egit.ui.internal.trace.GitTraceLocation;
import org.eclipse.egit.ui.internal.variables.GitTemplateVariableResolver;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.templates.ContextTypeRegistry;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateVariableResolver;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jgit.events.IndexChangedEvent;
import org.eclipse.jgit.events.IndexChangedListener;
import org.eclipse.jgit.events.ListenerHandle;
import org.eclipse.jgit.events.RepositoryEvent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.CredentialsProvider;
import org.eclipse.osgi.service.debug.DebugOptions;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWindowListener;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.ui.statushandlers.StatusManager;
import org.eclipse.ui.themes.ITheme;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin
implements DebugOptionsListener {
    private static Activator plugin;
    private static List<IPropertyChangeListener> propertyChangeListeners;
    public static final String DECORATORS_CHANGED = "org.eclipse.egit.ui.DECORATORS_CHANGED";
    private ResourceManager resourceManager;
    private RepositoryChangeScanner rcs;
    private ResourceRefreshJob refreshJob;
    private ListenerHandle refreshHandle;
    private DebugOptions debugOptions;
    private volatile boolean uiIsActive;
    private IWindowListener focusListener;

    static {
        propertyChangeListeners = new ArrayList<IPropertyChangeListener>(5);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getPluginId() {
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    private static IStatus toStatus(int severity, String message, Throwable throwable) {
        Throwable exc = throwable;
        while (exc instanceof InvocationTargetException) {
            Throwable cause;
            String msg = exc.getLocalizedMessage();
            if (msg != null && !msg.isEmpty() || (cause = exc.getCause()) == null) break;
            exc = cause;
        }
        if (exc != null && (message == null || message.isEmpty())) {
            message = exc.getLocalizedMessage();
        }
        return new Status(severity, Activator.getPluginId(), message, exc);
    }

    public static void handleError(String message, Throwable throwable, boolean show) {
        Activator.handleIssue(4, message, throwable, show);
    }

    public static void handleIssue(int severity, String message, Throwable throwable, boolean show) {
        IStatus status = Activator.toStatus(severity, message, throwable);
        int style = 1;
        if (show) {
            style |= 2;
        }
        StatusManager.getManager().handle(status, style);
    }

    public static void showError(String message, Throwable throwable) {
        IStatus status = Activator.toStatus(4, message, throwable);
        StatusManager.getManager().handle(status, 2);
    }

    public static void showErrorStatus(String message, IStatus status) {
        StatusManager.getManager().handle(status, 2);
    }

    public static void logError(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static void error(String message, Throwable e) {
        Activator.handleError(message, e, false);
    }

    public static IStatus createErrorStatus(String message, Throwable throwable) {
        return Activator.toStatus(4, message, throwable);
    }

    public static IStatus createErrorStatus(String message) {
        return Activator.toStatus(4, message, null);
    }

    public static ITheme getTheme() {
        return plugin.getWorkbench().getThemeManager().getCurrentTheme();
    }

    public static Font getFont(String id) {
        return Activator.getTheme().getFontRegistry().get(id);
    }

    public static Font getBoldFont(String id) {
        return Activator.getTheme().getFontRegistry().getBold(id);
    }

    public Activator() {
        Activator.setActivator(this);
    }

    private static void setActivator(Activator a) {
        plugin = a;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Hashtable<String, String> props = new Hashtable<String, String>(4);
        ((Dictionary)props).put("listener.symbolic.name", context.getBundle().getSymbolicName());
        context.registerService(DebugOptionsListener.class.getName(), (Object)this, props);
        this.setupRepoChangeScanner();
        this.setupRepoIndexRefresh();
        this.setupFocusHandling();
        this.setupCredentialsProvider();
        ConfigurationChecker.checkConfiguration();
        this.registerTemplateVariableResolvers();
    }

    private void setupCredentialsProvider() {
        CredentialsProvider.setDefault((CredentialsProvider)new EGitCredentialsProvider());
    }

    private void registerTemplateVariableResolvers() {
        if (Activator.hasJavaPlugin()) {
            ContextTypeRegistry codeTemplateContextRegistry = JavaPlugin.getDefault().getCodeTemplateContextRegistry();
            Iterator ctIter = codeTemplateContextRegistry.contextTypes();
            while (ctIter.hasNext()) {
                TemplateContextType contextType = (TemplateContextType)ctIter.next();
                contextType.addResolver((TemplateVariableResolver)new GitTemplateVariableResolver("git_config", UIText.GitTemplateVariableResolver_GitConfigDescription));
            }
        }
    }

    static boolean isActive() {
        return Activator.getDefault().uiIsActive;
    }

    private void setupFocusHandling() {
        this.focusListener = new IWindowListener(){

            private void updateUiState() {
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        boolean wasActive = Activator.this.uiIsActive;
                        Activator.this.uiIsActive = Display.getCurrent().getActiveShell() != null;
                        if (Activator.this.uiIsActive != wasActive && GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                            this.traceUiIsActive();
                        }
                    }

                    private void traceUiIsActive() {
                        StringBuilder message = new StringBuilder("workbench is ");
                        message.append(Activator.this.uiIsActive ? "active" : "inactive");
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), message.toString());
                    }
                });
            }

            public void windowOpened(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowDeactivated(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowClosed(IWorkbenchWindow window) {
                this.updateUiState();
            }

            public void windowActivated(IWorkbenchWindow window) {
                this.updateUiState();
                Activator.this.rcs.schedule(500L);
                Activator.this.refreshJob.triggerRefresh();
            }
        };
        Job job = new Job(UIText.Activator_setupFocusListener){

            protected IStatus run(IProgressMonitor monitor) {
                if (PlatformUI.isWorkbenchRunning()) {
                    PlatformUI.getWorkbench().addWindowListener(Activator.this.focusListener);
                } else {
                    this.schedule(1000L);
                }
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    public void optionsChanged(DebugOptions options) {
        this.debugOptions = options;
        GitTraceLocation.initializeFromOptions(options, this.isDebugging());
    }

    public DebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    private void setupRepoIndexRefresh() {
        this.refreshJob = new ResourceRefreshJob();
        this.refreshHandle = Repository.getGlobalListenerList().addIndexChangedListener((IndexChangedListener)this.refreshJob);
    }

    public static synchronized void addPropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.add(listener);
    }

    public static synchronized void removePropertyChangeListener(IPropertyChangeListener listener) {
        propertyChangeListeners.remove(listener);
    }

    public static synchronized void broadcastPropertyChange(PropertyChangeEvent event) {
        for (IPropertyChangeListener listener : propertyChangeListeners) {
            listener.propertyChange(event);
        }
    }

    private void setupRepoChangeScanner() {
        this.rcs = new RepositoryChangeScanner();
        this.getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.rcs);
    }

    public void stop(BundleContext context) throws Exception {
        if (this.refreshHandle != null) {
            this.refreshHandle.remove();
            this.refreshHandle = null;
        }
        if (this.focusListener != null) {
            if (PlatformUI.isWorkbenchRunning()) {
                PlatformUI.getWorkbench().removeWindowListener(this.focusListener);
            }
            this.focusListener = null;
        }
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Trying to cancel " + this.rcs.getName() + " job");
        }
        this.getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this.rcs);
        this.rcs.setReschedule(false);
        this.rcs.cancel();
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Trying to cancel " + this.refreshJob.getName() + " job");
        }
        this.refreshJob.cancel();
        this.rcs.join();
        this.refreshJob.join();
        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Jobs terminated");
        }
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
            this.resourceManager = null;
        }
        super.stop(context);
        plugin = null;
    }

    protected void saveDialogSettings() {
        KnownHosts.store();
        super.saveDialogSettings();
    }

    public RepositoryUtil getRepositoryUtil() {
        return org.eclipse.egit.core.Activator.getDefault().getRepositoryUtil();
    }

    public synchronized ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            Display display = PlatformUI.getWorkbench().getDisplay();
            if (display == null) {
                throw new IllegalStateException();
            }
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources((Display)display));
        }
        return this.resourceManager;
    }

    public static final boolean hasJavaPlugin() {
        try {
            return Class.forName("org.eclipse.jdt.internal.ui.JavaPlugin") != null;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return false;
        }
    }

    private static class RepositoryChangeScanner
    extends Job
    implements IPropertyChangeListener {
        private volatile boolean doReschedule;
        private int interval;
        private final RepositoryCache repositoryCache;

        RepositoryChangeScanner() {
            super(UIText.Activator_repoScanJobName);
            this.setRule(new RepositoryCacheRule());
            this.setSystem(true);
            this.setUser(false);
            this.repositoryCache = org.eclipse.egit.core.Activator.getDefault().getRepositoryCache();
            this.updateRefreshInterval();
        }

        public boolean shouldSchedule() {
            return this.doReschedule;
        }

        public boolean shouldRun() {
            return this.doReschedule;
        }

        void setReschedule(boolean reschedule) {
            this.doReschedule = reschedule;
        }

        protected IStatus run(IProgressMonitor monitor) {
            if (Activator.getDefault().getPreferenceStore().getBoolean("refesh_only_when_active") && !Activator.isActive()) {
                monitor.done();
                return Status.OK_STATUS;
            }
            Repository[] repos = this.repositoryCache.getAllRepositories();
            if (repos.length == 0) {
                return Status.OK_STATUS;
            }
            monitor.beginTask(UIText.Activator_scanningRepositories, repos.length);
            try {
                try {
                    Repository[] repositoryArray = repos;
                    int n = repos.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Repository repo = repositoryArray[n2];
                        if (monitor.isCanceled()) {
                            break;
                        }
                        if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                            GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Scanning " + repo + " for changes");
                        }
                        repo.scanForRepoChanges();
                        monitor.worked(1);
                        ++n2;
                    }
                }
                catch (IOException e) {
                    if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                        GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Stopped rescheduling " + this.getName() + "job");
                    }
                    IStatus iStatus = Activator.createErrorStatus(UIText.Activator_scanError, e);
                    monitor.done();
                    return iStatus;
                }
            }
            finally {
                monitor.done();
            }
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Rescheduling " + this.getName() + " job");
            }
            this.schedule(this.interval);
            return Status.OK_STATUS;
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (!"refesh_index_interval".equals(event.getProperty())) {
                return;
            }
            this.updateRefreshInterval();
        }

        private void updateRefreshInterval() {
            this.interval = RepositoryChangeScanner.getRefreshIndexInterval();
            this.setReschedule(this.interval > 0);
            this.cancel();
            this.schedule(this.interval);
        }

        private static int getRefreshIndexInterval() {
            return 1000 * Activator.getDefault().getPreferenceStore().getInt("refesh_index_interval");
        }
    }

    static class ResourceRefreshJob
    extends Job
    implements IndexChangedListener {
        private Set<Repository> repositoriesChanged = new LinkedHashSet<Repository>();

        ResourceRefreshJob() {
            super(UIText.Activator_refreshJobName);
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public IStatus run(IProgressMonitor monitor) {
            LinkedHashSet<Repository> repos;
            Set<Repository> set = this.repositoriesChanged;
            synchronized (set) {
                if (this.repositoriesChanged.isEmpty()) {
                    return Status.OK_STATUS;
                }
                repos = new LinkedHashSet<Repository>(this.repositoriesChanged);
                this.repositoriesChanged.clear();
            }
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IProject[] projects = workspace.getRoot().getProjects();
            final LinkedHashSet<IProject> toRefresh = new LinkedHashSet<IProject>();
            IProject[] iProjectArray = projects;
            int n = projects.length;
            int n2 = 0;
            while (n2 < n) {
                RepositoryMapping mapping;
                IProject p = iProjectArray[n2];
                if (p.isAccessible() && (mapping = RepositoryMapping.getMapping((IProject)p)) != null && repos.contains(mapping.getRepository())) {
                    toRefresh.add(p);
                }
                ++n2;
            }
            if (toRefresh.isEmpty()) {
                return Status.OK_STATUS;
            }
            try {
                workspace.run(new IWorkspaceRunnable(){

                    public void run(IProgressMonitor m) throws CoreException {
                        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)m, (String)UIText.Activator_refreshingProjects, (int)toRefresh.size());
                        for (IProject p : toRefresh) {
                            if (subMonitor.isCanceled()) {
                                return;
                            }
                            ISchedulingRule rule = p.getWorkspace().getRuleFactory().refreshRule((IResource)p);
                            try {
                                try {
                                    ResourceRefreshJob.getJobManager().beginRule(rule, (IProgressMonitor)subMonitor);
                                    if (p.isAccessible()) {
                                        p.refreshLocal(2, (IProgressMonitor)subMonitor.newChild(1));
                                    }
                                }
                                catch (CoreException e) {
                                    Activator.handleError(UIText.Activator_refreshFailed, e, false);
                                    ResourceRefreshJob.getJobManager().endRule(rule);
                                    continue;
                                }
                            }
                            catch (Throwable throwable) {
                                ResourceRefreshJob.getJobManager().endRule(rule);
                                throw throwable;
                            }
                            ResourceRefreshJob.getJobManager().endRule(rule);
                        }
                    }
                }, workspace.getRuleFactory().refreshRule((IResource)workspace.getRoot()), 1, monitor);
            }
            catch (CoreException e) {
                Activator.handleError(UIText.Activator_refreshFailed, e, false);
                return new Status(4, Activator.getPluginId(), e.getMessage());
            }
            if (!monitor.isCanceled()) {
                Set<Repository> set2 = this.repositoriesChanged;
                synchronized (set2) {
                    if (!this.repositoriesChanged.isEmpty()) {
                        this.schedule(100L);
                    }
                }
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public void onIndexChanged(IndexChangedEvent e) {
            if (Activator.getDefault().getPreferenceStore().getBoolean("refesh_on_index_change")) {
                this.mayTriggerRefresh((RepositoryEvent)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void mayTriggerRefresh(RepositoryEvent e) {
            Set<Repository> set = this.repositoriesChanged;
            synchronized (set) {
                this.repositoriesChanged.add(e.getRepository());
            }
            if (!Activator.getDefault().getPreferenceStore().getBoolean("refesh_only_when_active") || Activator.isActive()) {
                this.triggerRefresh();
            }
        }

        void triggerRefresh() {
            if (GitTraceLocation.REPOSITORYCHANGESCANNER.isActive()) {
                GitTraceLocation.getTrace().trace(GitTraceLocation.REPOSITORYCHANGESCANNER.getLocation(), "Triggered refresh");
            }
            this.schedule();
        }
    }
}

