/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.dialogs;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.Queue;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IProgressMonitorWithBlocking;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ProgressMonitorWrapper;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class NonBlockingWizardDialog
extends WizardDialog {
    private Queue<BackgroundJob> jobs = new LinkedList<BackgroundJob>();

    public NonBlockingWizardDialog(Shell parentShell, IWizard newWizard) {
        super(parentShell, newWizard);
    }

    protected Control createContents(Composite parent) {
        parent.addDisposeListener(e -> this.cancelJobs());
        this.addPageChangedListener(e -> this.cancelJobs());
        return super.createContents(parent);
    }

    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (!fork) {
            super.run(fork, cancelable, runnable);
        }
        this.run(runnable, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(IRunnableWithProgress runnable, Runnable onCancel) {
        Assert.isNotNull((Object)runnable);
        Queue<BackgroundJob> queue = this.jobs;
        synchronized (queue) {
            BackgroundJob newJob = new BackgroundJob(runnable, onCancel, this.getCurrentPage());
            this.jobs.add(newJob);
            if (this.jobs.size() == 1) {
                newJob.schedule();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobs() {
        Job currentJob;
        Queue<BackgroundJob> queue = this.jobs;
        synchronized (queue) {
            currentJob = this.jobs.peek();
            this.jobs.clear();
        }
        if (currentJob != null) {
            currentJob.cancel();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showPage(IWizardPage page) {
        Queue<BackgroundJob> queue = this.jobs;
        synchronized (queue) {
            super.showPage(page);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWizardPage getCurrentPage() {
        Queue<BackgroundJob> queue = this.jobs;
        synchronized (queue) {
            return super.getCurrentPage();
        }
    }

    protected final ProgressMonitorPart createProgressMonitorPart(Composite composite, GridLayout pmlayout) {
        return new BackgroundProgressMonitorPart(composite, (Layout)pmlayout);
    }

    private void restoreFocus(Control focusControl) {
        Shell shell;
        if (focusControl != null && !focusControl.isDisposed() && (shell = this.getShell()) != null && !shell.isDisposed() && focusControl.getShell() == shell) {
            focusControl.setFocus();
        }
    }

    private class BackgroundJob
    extends Job {
        private IRunnableWithProgress runnable;
        private Runnable onCancel;
        private IWizardPage page;

        public BackgroundJob(IRunnableWithProgress runnable, Runnable onCancel, IWizardPage page) {
            super(MessageFormat.format(UIText.NonBlockingWizardDialog_BackgroundJobName, page.getName()));
            this.runnable = runnable;
            this.onCancel = onCancel;
            this.page = page;
            this.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

                public void done(IJobChangeEvent event) {
                    if (!PlatformUI.isWorkbenchRunning()) {
                        return;
                    }
                    Display display = PlatformUI.getWorkbench().getDisplay();
                    if (display == null || display.isDisposed()) {
                        return;
                    }
                    display.syncExec(() -> {
                        boolean hideProgress = false;
                        Queue queue = NonBlockingWizardDialog.this.jobs;
                        synchronized (queue) {
                            ProgressMonitorPart part;
                            IProgressMonitor uiMonitor;
                            Job currentJob = (Job)NonBlockingWizardDialog.this.jobs.peek();
                            if (currentJob == BackgroundJob.this) {
                                NonBlockingWizardDialog.this.jobs.poll();
                                Job nextJob = (Job)NonBlockingWizardDialog.this.jobs.peek();
                                if (nextJob != null) {
                                    nextJob.schedule();
                                } else {
                                    hideProgress = true;
                                }
                            } else if (currentJob == null) {
                                hideProgress = true;
                            }
                            if (hideProgress && (uiMonitor = NonBlockingWizardDialog.this.getProgressMonitor()) instanceof ProgressMonitorPart && !(part = (ProgressMonitorPart)uiMonitor).isDisposed()) {
                                part.setVisible(false);
                                part.removeFromCancelComponent(null);
                            }
                        }
                    });
                }
            });
            this.setUser(false);
            this.setSystem(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean shouldRun() {
            Queue queue = NonBlockingWizardDialog.this.jobs;
            synchronized (queue) {
                return this.page == NonBlockingWizardDialog.this.getCurrentPage() && NonBlockingWizardDialog.this.jobs.peek() == this;
            }
        }

        protected void canceling() {
            try {
                if (this.onCancel != null) {
                    this.onCancel.run();
                }
            }
            finally {
                super.canceling();
            }
        }

        protected IStatus run(IProgressMonitor monitor) {
            IProgressMonitor combinedMonitor;
            if (!this.shouldRun()) {
                return Status.CANCEL_STATUS;
            }
            IProgressMonitor uiMonitor = NonBlockingWizardDialog.this.getProgressMonitor();
            if (uiMonitor instanceof ProgressMonitorPart) {
                ProgressMonitorPart part = (ProgressMonitorPart)uiMonitor;
                IProgressMonitor[] newMonitor = new IProgressMonitor[1];
                Display display = PlatformUI.getWorkbench().getDisplay();
                if (display == null || display.isDisposed()) {
                    return Status.CANCEL_STATUS;
                }
                display.syncExec(() -> {
                    if (((ProgressMonitorPart)uiMonitor).isDisposed()) {
                        return;
                    }
                    try {
                        Control focusControl = display.getFocusControl();
                        part.setVisible(true);
                        part.attachToCancelComponent(null);
                        NonBlockingWizardDialog.this.restoreFocus(focusControl);
                        if (part instanceof BackgroundProgressMonitorPart) {
                            ((BackgroundProgressMonitorPart)part).setJob(this);
                        }
                        iProgressMonitorArray[0] = new ForwardingProgressMonitor(uiMonitor, monitor, part.getDisplay());
                    }
                    catch (SWTException sWTException) {
                        return;
                    }
                });
                combinedMonitor = newMonitor[0];
                if (combinedMonitor == null) {
                    return Status.CANCEL_STATUS;
                }
            } else {
                combinedMonitor = monitor;
            }
            try {
                IStatus iStatus;
                try {
                    this.runnable.run(combinedMonitor);
                }
                catch (InvocationTargetException e) {
                    iStatus = Activator.createErrorStatus(e.getLocalizedMessage(), e);
                    monitor.done();
                    if (combinedMonitor != monitor) {
                        combinedMonitor.done();
                    }
                    return iStatus;
                }
                catch (InterruptedException interruptedException) {
                    iStatus = Status.CANCEL_STATUS;
                    monitor.done();
                    if (combinedMonitor != monitor) {
                        combinedMonitor.done();
                    }
                    return iStatus;
                }
            }
            finally {
                monitor.done();
                if (combinedMonitor != monitor) {
                    combinedMonitor.done();
                }
            }
            return Status.OK_STATUS;
        }
    }

    private class BackgroundProgressMonitorPart
    extends ProgressMonitorPart {
        private Job job;

        public BackgroundProgressMonitorPart(Composite parent, Layout layout) {
            super(parent, layout, true);
        }

        public void setJob(Job job) {
            this.job = job;
        }

        public void beginTask(String name, int totalWork) {
            Display display = this.getDisplay();
            Control focusControl = display.isDisposed() ? null : display.getFocusControl();
            super.beginTask(name, totalWork);
            NonBlockingWizardDialog.this.restoreFocus(focusControl);
        }

        public void setCanceled(boolean cancel) {
            super.setCanceled(cancel);
            if (cancel && this.job != null) {
                this.job.cancel();
            }
        }

        public void done() {
            this.job = null;
            super.done();
        }
    }

    private static class ForwardingProgressMonitor
    extends ProgressMonitorWrapper {
        private Display display;
        private Collector collector;
        private IProgressMonitor jobMonitor;
        private String currentTask = "";

        public ForwardingProgressMonitor(IProgressMonitor monitor, IProgressMonitor jobMonitor, Display display) {
            super(monitor);
            Assert.isNotNull((Object)display);
            this.display = display;
            this.jobMonitor = jobMonitor;
        }

        public boolean isCanceled() {
            return this.jobMonitor.isCanceled() || super.isCanceled();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void beginTask(String name, int totalWork) {
            ForwardingProgressMonitor forwardingProgressMonitor = this;
            synchronized (forwardingProgressMonitor) {
                this.collector = null;
            }
            this.display.asyncExec(() -> {
                this.currentTask = name;
                this.getWrappedProgressMonitor().beginTask(name, totalWork);
            });
        }

        private synchronized void clearCollector(Collector collectorToClear) {
            if (this.collector == collectorToClear) {
                this.collector = null;
            }
        }

        private void createCollector(String taskName, String subTask, double work) {
            this.collector = new Collector(taskName, subTask, work, this.getWrappedProgressMonitor());
            this.display.asyncExec((Runnable)this.collector);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void done() {
            ForwardingProgressMonitor forwardingProgressMonitor = this;
            synchronized (forwardingProgressMonitor) {
                this.collector = null;
            }
            if (!this.display.isDisposed()) {
                this.display.asyncExec(() -> {
                    try {
                        this.getWrappedProgressMonitor().done();
                    }
                    catch (SWTException sWTException) {}
                });
            }
        }

        public synchronized void internalWorked(double work) {
            if (this.collector == null) {
                this.createCollector(null, null, work);
            } else {
                this.collector.worked(work);
            }
        }

        public synchronized void setTaskName(String name) {
            this.currentTask = name;
            if (this.collector == null) {
                this.createCollector(name, null, 0.0);
            } else {
                this.collector.setTaskName(name);
            }
        }

        public synchronized void subTask(String name) {
            if (this.collector == null) {
                this.createCollector(null, name, 0.0);
            } else {
                this.collector.subTask(name);
            }
        }

        public void worked(int work) {
            this.internalWorked(work);
        }

        public void clearBlocked() {
            IProgressMonitor wrapped = this.getWrappedProgressMonitor();
            if (!(wrapped instanceof IProgressMonitorWithBlocking)) {
                return;
            }
            this.display.asyncExec(() -> {
                ((IProgressMonitorWithBlocking)wrapped).clearBlocked();
                Dialog.getBlockedHandler().clearBlocked();
            });
        }

        public void setBlocked(IStatus reason) {
            IProgressMonitor wrapped = this.getWrappedProgressMonitor();
            if (!(wrapped instanceof IProgressMonitorWithBlocking)) {
                return;
            }
            this.display.asyncExec(() -> {
                ((IProgressMonitorWithBlocking)wrapped).setBlocked(reason);
                Dialog.getBlockedHandler().showBlocked(wrapped, reason, this.currentTask);
            });
        }

        private class Collector
        implements Runnable {
            private String taskName;
            private String subTask;
            private double worked;
            private IProgressMonitor monitor;

            public Collector(String taskName, String subTask, double work, IProgressMonitor monitor) {
                this.taskName = taskName;
                this.subTask = subTask;
                this.worked = work;
                this.monitor = monitor;
            }

            public void setTaskName(String name) {
                this.taskName = name;
            }

            public void worked(double workedIncrement) {
                this.worked += workedIncrement;
            }

            public void subTask(String subTaskName) {
                this.subTask = subTaskName;
            }

            @Override
            public void run() {
                ForwardingProgressMonitor.this.clearCollector(this);
                if (this.taskName != null) {
                    this.monitor.setTaskName(this.taskName);
                }
                if (this.subTask != null) {
                    this.monitor.subTask(this.subTask);
                }
                if (this.worked > 0.0) {
                    this.monitor.internalWorked(this.worked);
                }
            }
        }
    }
}

