/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.egit.ui.internal.fetch;

import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.egit.ui.Activator;
import org.eclipse.egit.ui.internal.UIText;
import org.eclipse.egit.ui.internal.dialogs.AbstractConfigureRemoteDialog;
import org.eclipse.egit.ui.internal.fetch.FetchOperationUI;
import org.eclipse.egit.ui.internal.fetch.FetchResultDialog;
import org.eclipse.egit.ui.internal.fetch.SimpleFetchRefSpecWizard;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jgit.lib.Config;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.FetchResult;
import org.eclipse.jgit.transport.RefSpec;
import org.eclipse.jgit.transport.RemoteConfig;
import org.eclipse.jgit.transport.URIish;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;

public class SimpleConfigureFetchDialog
extends AbstractConfigureRemoteDialog {
    public static Dialog getDialog(Shell shell, Repository repository) {
        RemoteConfig configToUse = SimpleConfigureFetchDialog.getConfiguredRemote(repository);
        return new SimpleConfigureFetchDialog(shell, repository, configToUse, true);
    }

    public static Dialog getDialog(Shell shell, Repository repository, String remoteName) {
        RemoteConfig configToUse;
        try {
            configToUse = new RemoteConfig((Config)repository.getConfig(), remoteName);
        }
        catch (URISyntaxException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        return new SimpleConfigureFetchDialog(shell, repository, configToUse, false);
    }

    public static RemoteConfig getConfiguredRemote(Repository repository) {
        ArrayList allRemotes;
        String branch;
        try {
            branch = repository.getBranch();
        }
        catch (IOException e) {
            Activator.handleError(e.getMessage(), e, true);
            return null;
        }
        if (branch == null) {
            return null;
        }
        String remoteName = ObjectId.isId((String)branch) ? "origin" : repository.getConfig().getString("branch", branch, "remote");
        try {
            allRemotes = RemoteConfig.getAllRemoteConfigs((Config)repository.getConfig());
        }
        catch (URISyntaxException uRISyntaxException) {
            allRemotes = new ArrayList();
        }
        RemoteConfig defaultConfig = null;
        RemoteConfig configuredConfig = null;
        for (RemoteConfig config : allRemotes) {
            if (config.getName().equals("origin")) {
                defaultConfig = config;
            }
            if (remoteName == null || !config.getName().equals(remoteName)) continue;
            configuredConfig = config;
        }
        RemoteConfig configToUse = configuredConfig != null ? configuredConfig : defaultConfig;
        return configToUse;
    }

    private SimpleConfigureFetchDialog(Shell shell, Repository repository, RemoteConfig config, boolean showBranchInfo) {
        super(shell, repository, config, showBranchInfo, false);
        if (config.getFetchRefSpecs().isEmpty() && !repository.getConfig().getSubsections("remote").contains(config.getName())) {
            StringBuilder defaultRefSpec = new StringBuilder();
            defaultRefSpec.append('+');
            defaultRefSpec.append("refs/heads/");
            defaultRefSpec.append('*').append(':');
            defaultRefSpec.append("refs/remotes/");
            defaultRefSpec.append(config.getName());
            defaultRefSpec.append("/*");
            config.addFetchRefSpec(new RefSpec(defaultRefSpec.toString()));
        }
    }

    @Override
    protected RefSpec getNewRefSpec() {
        SimpleFetchRefSpecWizard wiz = new SimpleFetchRefSpecWizard(this.getRepository(), this.getConfig());
        WizardDialog dlg = new WizardDialog(this.getShell(), (IWizard)wiz);
        return dlg.open() == 0 ? wiz.getSpec() : null;
    }

    @Override
    protected void createOkButton(Composite parent) {
        this.createButton(parent, 0, UIText.SimpleConfigureFetchDialog_SaveAndFetchButton, true);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(UIText.SimpleConfigureFetchDialog_WindowTitle);
    }

    public void create() {
        super.create();
        this.setTitle(NLS.bind((String)UIText.SimpleConfigureFetchDialog_DialogTitle, (Object)this.getConfig().getName()));
        this.setMessage(UIText.SimpleConfigureFetchDialog_DialogMessage);
        this.updateControls();
    }

    @Override
    protected void updateControls() {
        this.setErrorMessage(null);
        boolean anyUri = false;
        if (!this.getConfig().getURIs().isEmpty()) {
            this.commonUriText.setText(((URIish)this.getConfig().getURIs().get(0)).toPrivateString());
            anyUri = true;
        } else {
            this.commonUriText.setText("");
        }
        this.specViewer.setInput((Object)this.getConfig().getFetchRefSpecs());
        this.specViewer.getTable().setEnabled(true);
        this.addRefSpecAction.setEnabled(anyUri);
        this.addRefSpecAdvancedAction.setEnabled(anyUri);
        if (this.getConfig().getURIs().isEmpty()) {
            this.setErrorMessage(UIText.AbstractConfigureRemoteDialog_MissingUriMessage);
        } else if (this.getConfig().getFetchRefSpecs().isEmpty()) {
            this.setErrorMessage(UIText.SimpleConfigureFetchDialog_MissingMappingMessage);
        }
        boolean anySpec = !this.getConfig().getFetchRefSpecs().isEmpty();
        this.getButton(0).setEnabled(anyUri && anySpec);
        this.getButton(97).setEnabled(anyUri && anySpec);
    }

    @Override
    protected void dryRun(IProgressMonitor monitor) {
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        final FetchOperationUI op = new FetchOperationUI(this.getRepository(), this.getConfig(), timeout, true);
        try {
            final FetchResult result = op.execute(monitor);
            this.getShell().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    FetchResultDialog dlg = new FetchResultDialog(SimpleConfigureFetchDialog.this.getShell(), SimpleConfigureFetchDialog.this.getRepository(), result, op.getSourceString());
                    dlg.showConfigureButton(false);
                    dlg.open();
                }
            });
        }
        catch (CoreException e) {
            Activator.handleError(e.getMessage(), e, true);
        }
    }

    @Override
    protected void performOperation() {
        int timeout = Activator.getDefault().getPreferenceStore().getInt("remote_connection_timeout");
        FetchOperationUI op = new FetchOperationUI(this.getRepository(), this.getConfig(), timeout, false);
        op.start();
    }
}

