/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide.application;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobFunction;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.Policy;

class IDEIdleHelper {
    private static final int DEFAULT_GC_INTERVAL = 60000;
    private static final int DEFAULT_GC_MAX = 8000;
    private static final int GC_DELAY_MULTIPLIER = 60;
    private static final int IDLE_INTERVAL = 5000;
    private static final String PROP_GC = "ide.gc";
    private static final String PROP_GC_INTERVAL = "ide.gc.interval";
    private static final String PROP_GC_MAX = "ide.gc.max";
    protected IWorkbenchConfigurer configurer;
    private Listener idleListener;
    private long lastGC = System.currentTimeMillis();
    private int maxGC = 8000;
    private int minGCInterval = 60000;
    private int nextGCInterval = 60000;
    private Job gcJob;
    private Runnable handler;

    IDEIdleHelper(IWorkbenchConfigurer aConfigurer) {
        this.configurer = aConfigurer;
        if (PlatformUI.getTestableObject().getTestHarness() != null) {
            return;
        }
        String enabled = System.getProperty(PROP_GC);
        if (enabled == null || enabled.equalsIgnoreCase(Boolean.FALSE.toString())) {
            return;
        }
        Integer prop = Integer.getInteger(PROP_GC_INTERVAL);
        if (prop != null && prop >= 0) {
            this.minGCInterval = this.nextGCInterval = prop.intValue();
        }
        if ((prop = Integer.getInteger(PROP_GC_MAX)) != null) {
            this.maxGC = prop;
        }
        this.createGarbageCollectionJob();
        final Display display = this.configurer.getWorkbench().getDisplay();
        this.handler = new Runnable(){

            @Override
            public void run() {
                if (!display.isDisposed() && !IDEIdleHelper.this.configurer.getWorkbench().isClosing()) {
                    int nextInterval;
                    long start = System.currentTimeMillis();
                    if (!Job.getJobManager().isIdle()) {
                        nextInterval = 5000;
                    } else if (start - IDEIdleHelper.this.lastGC < (long)IDEIdleHelper.this.nextGCInterval) {
                        nextInterval = IDEIdleHelper.this.nextGCInterval - (int)(start - IDEIdleHelper.this.lastGC);
                    } else {
                        IDEIdleHelper.this.gcJob.schedule();
                        nextInterval = IDEIdleHelper.this.minGCInterval;
                    }
                    display.timerExec(nextInterval, (Runnable)this);
                }
            }
        };
        this.idleListener = new Listener(){

            public void handleEvent(Event event) {
                display.timerExec(5000, IDEIdleHelper.this.handler);
            }
        };
        display.addFilter(2, this.idleListener);
        display.addFilter(4, this.idleListener);
    }

    private void createGarbageCollectionJob() {
        this.gcJob = Job.create((String)IDEWorkbenchMessages.IDEIdleHelper_backgroundGC, (IJobFunction)new IJobFunction(){

            public IStatus run(IProgressMonitor monitor) {
                Display display = IDEIdleHelper.this.configurer.getWorkbench().getDisplay();
                if (display != null && !display.isDisposed()) {
                    long start = System.currentTimeMillis();
                    System.gc();
                    System.runFinalization();
                    IDEIdleHelper.this.lastGC = start;
                    int duration = (int)(System.currentTimeMillis() - start);
                    if (Policy.DEBUG_GC) {
                        System.out.println("Explicit GC took: " + duration);
                    }
                    if (duration > IDEIdleHelper.this.maxGC) {
                        if (Policy.DEBUG_GC) {
                            System.out.println("Further explicit GCs disabled due to long GC");
                        }
                        IDEIdleHelper.this.shutdown();
                    } else {
                        IDEIdleHelper.this.nextGCInterval = Math.max(IDEIdleHelper.this.minGCInterval, 60 * duration);
                        if (Policy.DEBUG_GC) {
                            System.out.println("Next GC to run in: " + IDEIdleHelper.this.nextGCInterval);
                        }
                    }
                }
                return Status.OK_STATUS;
            }
        });
        this.gcJob.setSystem(true);
    }

    void shutdown() {
        if (this.idleListener == null) {
            return;
        }
        final Display display = this.configurer.getWorkbench().getDisplay();
        if (display != null && !display.isDisposed()) {
            try {
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        display.timerExec(-1, IDEIdleHelper.this.handler);
                        display.removeFilter(2, IDEIdleHelper.this.idleListener);
                        display.removeFilter(4, IDEIdleHelper.this.idleListener);
                    }
                });
            }
            catch (SWTException sWTException) {
                // empty catch block
            }
        }
    }
}

