/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.nls;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IOpenable;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.StringLiteral;
import org.eclipse.wst.jsdt.core.dom.TypeLiteral;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSElement;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;

public class NLSHintHelper {
    private NLSHintHelper() {
    }

    public static AccessorClassReference getAccessorClassReference(JavaScriptUnit astRoot, NLSElement nlsElement) {
        Region region = nlsElement.getPosition();
        return NLSHintHelper.getAccessorClassReference(astRoot, (IRegion)region);
    }

    public static AccessorClassReference getAccessorClassReference(JavaScriptUnit astRoot, IRegion region) {
        String resourceBundleName;
        ASTNode nlsStringLiteral = NodeFinder.perform((ASTNode)astRoot, region.getOffset(), region.getLength());
        if (nlsStringLiteral == null) {
            return null;
        }
        ASTNode parent = nlsStringLiteral.getParent();
        ITypeBinding accessorBinding = null;
        if (parent instanceof FunctionInvocation) {
            FunctionInvocation methodInvocation = (FunctionInvocation)parent;
            List args = methodInvocation.arguments();
            if (args.indexOf(nlsStringLiteral) != 0) {
                return null;
            }
            Expression firstArgument = (Expression)args.get(0);
            ITypeBinding argumentBinding = firstArgument.resolveTypeBinding();
            if (argumentBinding == null || !argumentBinding.getQualifiedName().equals("java.lang.String")) {
                return null;
            }
            ITypeBinding typeBinding = methodInvocation.resolveTypeBinding();
            if (typeBinding == null || !typeBinding.getQualifiedName().equals("java.lang.String")) {
                return null;
            }
            IFunctionBinding methodBinding = methodInvocation.resolveMethodBinding();
            if (methodBinding == null || !Modifier.isStatic((int)methodBinding.getModifiers())) {
                return null;
            }
            accessorBinding = methodBinding.getDeclaringClass();
        } else if (parent instanceof QualifiedName) {
            QualifiedName name = (QualifiedName)parent;
            IBinding binding = name.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return null;
            }
            IVariableBinding variableBinding = (IVariableBinding)binding;
            if (!Modifier.isStatic((int)variableBinding.getModifiers())) {
                return null;
            }
            accessorBinding = variableBinding.getDeclaringClass();
        } else if (parent instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment decl = (VariableDeclarationFragment)parent;
            if (decl.getInitializer() != null) {
                return null;
            }
            IVariableBinding binding = decl.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return null;
            }
            IVariableBinding variableBinding = binding;
            if (!Modifier.isStatic((int)variableBinding.getModifiers())) {
                return null;
            }
            if (!Modifier.isPublic((int)variableBinding.getModifiers())) {
                return null;
            }
            accessorBinding = variableBinding.getDeclaringClass();
        }
        if (accessorBinding == null) {
            return null;
        }
        try {
            resourceBundleName = NLSHintHelper.getResourceBundleName(accessorBinding);
        }
        catch (JavaScriptModelException e) {
            return null;
        }
        if (resourceBundleName != null) {
            return new AccessorClassReference(accessorBinding, resourceBundleName, new Region(parent.getStartPosition(), parent.getLength()));
        }
        return null;
    }

    public static IPackageFragment getPackageOfAccessorClass(IJavaScriptProject javaProject, ITypeBinding accessorBinding) throws JavaScriptModelException {
        IJavaScriptUnit unit;
        if (accessorBinding != null && (unit = Bindings.findCompilationUnit(accessorBinding, javaProject)) != null) {
            return (IPackageFragment)unit.getParent();
        }
        return null;
    }

    public static String getResourceBundleName(ITypeBinding accessorClassBinding) throws JavaScriptModelException {
        IJavaScriptElement je = accessorClassBinding.getJavaElement();
        if (je == null) {
            return null;
        }
        IOpenable openable = je.getOpenable();
        IJavaScriptUnit container = null;
        if (openable instanceof IJavaScriptUnit) {
            container = (IJavaScriptUnit)openable;
        } else if (openable instanceof IClassFile) {
            container = (IClassFile)openable;
        } else {
            Assert.isLegal((boolean)false);
        }
        JavaScriptUnit astRoot = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)container, ASTProvider.WAIT_YES, null);
        return NLSHintHelper.getResourceBundleName(astRoot);
    }

    public static String getResourceBundleName(IJavaScriptUnit unit) throws JavaScriptModelException {
        return NLSHintHelper.getResourceBundleName(JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)unit, ASTProvider.WAIT_YES, null));
    }

    public static String getResourceBundleName(IClassFile classFile) throws JavaScriptModelException {
        return NLSHintHelper.getResourceBundleName(JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)classFile, ASTProvider.WAIT_YES, null));
    }

    public static String getResourceBundleName(JavaScriptUnit astRoot) throws JavaScriptModelException {
        String result;
        Object fieldName;
        if (astRoot == null) {
            return null;
        }
        final HashMap resultCollector = new HashMap(5);
        final Object RESULT_KEY = new Object();
        final Object FIELD_KEY = new Object();
        astRoot.accept(new ASTVisitor(){

            public boolean visit(FunctionInvocation node) {
                IBinding fieldNameBinding;
                IFunctionBinding method = node.resolveMethodBinding();
                if (method == null) {
                    return true;
                }
                String name = method.getDeclaringClass().getQualifiedName();
                if (!("java.util.ResourceBundle".equals(name) && "getBundle".equals(method.getName()) && node.arguments().size() > 0 || "org.eclipse.osgi.util.NLS".equals(name) && "initializeMessages".equals(method.getName()) && node.arguments().size() == 2)) {
                    return true;
                }
                Expression argument = (Expression)node.arguments().get(0);
                String bundleName = this.getBundleName(argument);
                if (bundleName != null) {
                    resultCollector.put(RESULT_KEY, bundleName);
                }
                if (argument instanceof Name && (fieldNameBinding = ((Name)argument).resolveBinding()) != null) {
                    resultCollector.put(FIELD_KEY, fieldNameBinding);
                }
                return false;
            }

            public boolean visit(VariableDeclarationFragment node) {
                Expression initializer = node.getInitializer();
                String bundleName = this.getBundleName(initializer);
                if (bundleName != null) {
                    IBinding fieldNameBinding = node.getName().resolveBinding();
                    if (fieldNameBinding != null) {
                        resultCollector.put(fieldNameBinding, bundleName);
                    }
                    return false;
                }
                return true;
            }

            public boolean visit(Assignment node) {
                IBinding fieldNameBinding;
                String bundleName;
                if (node.getLeftHandSide() instanceof Name && (bundleName = this.getBundleName(node.getRightHandSide())) != null && (fieldNameBinding = ((Name)node.getLeftHandSide()).resolveBinding()) != null) {
                    resultCollector.put(fieldNameBinding, bundleName);
                    return false;
                }
                return true;
            }

            private String getBundleName(Expression initializer) {
                SimpleType simple;
                ITypeBinding typeBinding;
                FunctionInvocation methInvocation;
                Expression exp;
                if (initializer instanceof StringLiteral) {
                    return ((StringLiteral)initializer).getLiteralValue();
                }
                if (initializer instanceof FunctionInvocation && (exp = (methInvocation = (FunctionInvocation)initializer).getExpression()) != null && exp instanceof TypeLiteral && (typeBinding = (simple = (SimpleType)((TypeLiteral)exp).getType()).resolveBinding()) != null) {
                    return typeBinding.getQualifiedName();
                }
                return null;
            }
        });
        for (Object o : resultCollector.keySet()) {
            IBinding binding;
            if (!(o instanceof IBinding) || !(fieldName = (binding = (IBinding)o).getName()).equals("BUNDLE_NAME") && !fieldName.equals("RESOURCE_BUNDLE") && !fieldName.equals("bundleName") || (result = (String)resultCollector.get(binding)) == null) continue;
            return result;
        }
        result = (String)resultCollector.get(RESULT_KEY);
        if (result != null) {
            return result;
        }
        fieldName = resultCollector.get(FIELD_KEY);
        if (fieldName != null) {
            return (String)resultCollector.get(fieldName);
        }
        return null;
    }

    public static IPackageFragment getResourceBundlePackage(IJavaScriptProject javaProject, String packageName, String resourceName) throws JavaScriptModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getAllPackageFragmentRoots();
        int i = 0;
        while (i < allRoots.length) {
            IPackageFragment packageFragment;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() == 1 && (packageFragment = root.getPackageFragment(packageName)).exists()) {
                Object[] resources = packageFragment.isDefaultPackage() ? root.getNonJavaScriptResources() : packageFragment.getNonJavaScriptResources();
                int j = 0;
                while (j < resources.length) {
                    IFile file;
                    Object object = resources[j];
                    if (object instanceof IFile && (file = (IFile)object).getName().equals(resourceName)) {
                        return packageFragment;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return null;
    }

    public static IStorage getResourceBundle(IJavaScriptUnit compilationUnit) throws JavaScriptModelException {
        IJavaScriptProject project = compilationUnit.getJavaScriptProject();
        if (project == null) {
            return null;
        }
        String name = NLSHintHelper.getResourceBundleName(compilationUnit);
        if (name == null) {
            return null;
        }
        String packName = Signature.getQualifier((String)name);
        String resourceName = String.valueOf(Signature.getSimpleName((String)name)) + ".properties";
        return NLSHintHelper.getResourceBundle(project, packName, resourceName);
    }

    public static IStorage getResourceBundle(IJavaScriptProject javaProject, String packageName, String resourceName) throws JavaScriptModelException {
        IPackageFragmentRoot[] allRoots = javaProject.getAllPackageFragmentRoots();
        int i = 0;
        while (i < allRoots.length) {
            IStorage storage;
            IPackageFragmentRoot root = allRoots[i];
            if (root.getKind() == 1 && (storage = NLSHintHelper.getResourceBundle(root, packageName, resourceName)) != null) {
                return storage;
            }
            ++i;
        }
        return null;
    }

    public static IStorage getResourceBundle(IPackageFragmentRoot root, String packageName, String resourceName) throws JavaScriptModelException {
        IPackageFragment packageFragment = root.getPackageFragment(packageName);
        if (packageFragment.exists()) {
            Object[] resources = packageFragment.isDefaultPackage() ? root.getNonJavaScriptResources() : packageFragment.getNonJavaScriptResources();
            int j = 0;
            while (j < resources.length) {
                IStorage storage;
                Object object = resources[j];
                if (JavaModelUtil.isOpenableStorage(object) && (storage = (IStorage)object).getName().equals(resourceName)) {
                    return storage;
                }
                ++j;
            }
        }
        return null;
    }

    public static IStorage getResourceBundle(IJavaScriptProject javaProject, AccessorClassReference accessorClassReference) throws JavaScriptModelException {
        String resourceBundle = accessorClassReference.getResourceBundleName();
        if (resourceBundle == null) {
            return null;
        }
        String resourceName = String.valueOf(Signature.getSimpleName((String)resourceBundle)) + ".properties";
        String packName = Signature.getQualifier((String)resourceBundle);
        ITypeBinding accessorClass = accessorClassReference.getBinding();
        if (accessorClass.isFromSource()) {
            return NLSHintHelper.getResourceBundle(javaProject, packName, resourceName);
        }
        if (accessorClass.getJavaElement() != null) {
            return NLSHintHelper.getResourceBundle((IPackageFragmentRoot)accessorClass.getJavaElement().getAncestor(3), packName, resourceName);
        }
        return null;
    }

    public static Properties getProperties(IJavaScriptProject javaProject, AccessorClassReference accessorClassReference) {
        try {
            IStorage storage = NLSHintHelper.getResourceBundle(javaProject, accessorClassReference);
            return NLSHintHelper.getProperties(storage);
        }
        catch (JavaScriptModelException ex) {
            return null;
        }
    }

    public static Properties getProperties(IStorage storage) {
        if (storage == null) {
            return null;
        }
        Properties props = new Properties();
        InputStream is = null;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        try {
            try {
                ITextFileBuffer buffer;
                if (manager != null && (buffer = manager.getTextFileBuffer(storage.getFullPath(), LocationKind.NORMALIZE)) != null) {
                    IDocument document = buffer.getDocument();
                    is = new ByteArrayInputStream(document.get().getBytes());
                }
                if (is == null) {
                    is = storage.getContents();
                }
                props.load(is);
            }
            catch (IOException e) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e2) {
                        JavaScriptPlugin.log(e2);
                    }
                }
                return null;
            }
            catch (CoreException e) {
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (IOException e3) {
                        JavaScriptPlugin.log(e3);
                    }
                }
                return null;
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    JavaScriptPlugin.log(e);
                }
            }
        }
        return props;
    }
}

