/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.IRefactoringStatusEntryComparator;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.RefactoringStatusEntry;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTParser;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.AbstractTypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.AnonymousClassDeclaration;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.Block;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.ConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.ExpressionStatement;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.ImportDeclaration;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.Modifier;
import org.eclipse.wst.jsdt.core.dom.Name;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.QualifiedType;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SimpleType;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.Statement;
import org.eclipse.wst.jsdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.wst.jsdt.core.dom.SuperConstructorInvocation;
import org.eclipse.wst.jsdt.core.dom.ThisExpression;
import org.eclipse.wst.jsdt.core.dom.Type;
import org.eclipse.wst.jsdt.core.dom.TypeDeclaration;
import org.eclipse.wst.jsdt.core.dom.TypeDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchPattern;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.wst.jsdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodeFactory;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.Bindings;
import org.eclipse.wst.jsdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.Checks;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JDTRefactoringDescriptorComment;
import org.eclipse.wst.jsdt.internal.corext.refactoring.JavaRefactoringArguments;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringScopeFactory;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringSearchEngine2;
import org.eclipse.wst.jsdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.wst.jsdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.changes.DynamicValidationRefactoringChange;
import org.eclipse.wst.jsdt.internal.corext.refactoring.code.ScriptableRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ASTNodeSearchUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ConstructorReferenceFinder;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.ImportRewriteUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.MemberVisibilityAdjustor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavadocUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.JdtFlags;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.preferences.JavaPreferencesSettings;
import org.eclipse.wst.jsdt.internal.ui.viewsupport.BindingLabelProvider;
import org.eclipse.wst.jsdt.ui.CodeGeneration;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabels;

public final class MoveInnerToTopRefactoring
extends ScriptableRefactoring {
    private static final String ATTRIBUTE_FIELD = "field";
    private static final String ATTRIBUTE_MANDATORY = "mandatory";
    private static final String ATTRIBUTE_POSSIBLE = "possible";
    private static final String ATTRIBUTE_FINAL = "final";
    private static final String ATTRIBUTE_FIELD_NAME = "fieldName";
    private static final String ATTRIBUTE_PARAMETER_NAME = "parameterName";
    private TextChangeManager fChangeManager;
    private CodeGenerationSettings fCodeGenerationSettings;
    private boolean fCreateInstanceField;
    private String fEnclosingInstanceFieldName;
    private boolean fIsInstanceFieldCreationMandatory;
    private boolean fIsInstanceFieldCreationPossible;
    private boolean fMarkInstanceFieldAsFinal;
    private String fNameForEnclosingInstanceConstructorParameter;
    private String fNewSourceOfInputType;
    private CompilationUnitRewrite fSourceRewrite;
    private Collection fStaticImports;
    private IType fType;
    private String fQualifiedTypeName;
    private Collection fTypeImports;

    private static boolean containsNonStatic(FieldAccess[] accesses) {
        int i = 0;
        while (i < accesses.length) {
            if (!MoveInnerToTopRefactoring.isStatic(accesses[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean containsNonStatic(FunctionInvocation[] invocations) {
        int i = 0;
        while (i < invocations.length) {
            if (!MoveInnerToTopRefactoring.isStatic(invocations[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean containsNonStatic(SimpleName[] fieldNames) {
        int i = 0;
        while (i < fieldNames.length) {
            if (!MoveInnerToTopRefactoring.isStaticFieldName(fieldNames[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean containsStatusEntry(RefactoringStatus status, RefactoringStatusEntry other) {
        return status.getEntries(new IRefactoringStatusEntryComparator(){

            public final int compare(RefactoringStatusEntry entry1, RefactoringStatusEntry entry2) {
                return entry1.getMessage().compareTo(entry2.getMessage());
            }
        }, other).length > 0;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(IType enclosing, AbstractTypeDeclaration[] declarations) {
        String typeName = enclosing.getElementName();
        int i = 0;
        while (i < declarations.length) {
            AbstractTypeDeclaration declaration = declarations[i];
            if (declaration.getName().getIdentifier().equals(typeName)) {
                return declaration;
            }
            ++i;
        }
        return null;
    }

    private static AbstractTypeDeclaration findTypeDeclaration(IType type, JavaScriptUnit unit) {
        List types = MoveInnerToTopRefactoring.getDeclaringTypes(type);
        types.add(type);
        AbstractTypeDeclaration[] declarations = unit.types().toArray(new AbstractTypeDeclaration[unit.types().size()]);
        AbstractTypeDeclaration declaration = null;
        for (IType enclosing : types) {
            declaration = MoveInnerToTopRefactoring.findTypeDeclaration(enclosing, declarations);
            Assert.isNotNull((Object)declaration);
            declarations = MoveInnerToTopRefactoring.getAbstractTypeDeclarations(declaration);
        }
        Assert.isNotNull(declaration);
        return declaration;
    }

    public static AbstractTypeDeclaration[] getAbstractTypeDeclarations(AbstractTypeDeclaration declaration) {
        int typeCount = 0;
        ListIterator iterator = declaration.bodyDeclarations().listIterator();
        while (iterator.hasNext()) {
            if (!(iterator.next() instanceof AbstractTypeDeclaration)) continue;
            ++typeCount;
        }
        AbstractTypeDeclaration[] declarations = new AbstractTypeDeclaration[typeCount];
        int next = 0;
        ListIterator iterator2 = declaration.bodyDeclarations().listIterator();
        while (iterator2.hasNext()) {
            Object object = iterator2.next();
            if (!(object instanceof AbstractTypeDeclaration)) continue;
            declarations[next++] = (AbstractTypeDeclaration)object;
        }
        return declarations;
    }

    private static ITypeBinding getDeclaringTypeBinding(FieldAccess fieldAccess) {
        IVariableBinding varBinding = fieldAccess.resolveFieldBinding();
        if (varBinding == null) {
            return null;
        }
        return varBinding.getDeclaringClass();
    }

    private static ITypeBinding getDeclaringTypeBinding(FunctionInvocation methodInvocation) {
        IFunctionBinding binding = methodInvocation.resolveMethodBinding();
        if (binding == null) {
            return null;
        }
        return binding.getDeclaringClass();
    }

    private static List getDeclaringTypes(IType type) {
        IType declaringType = type.getDeclaringType();
        if (declaringType == null) {
            return new ArrayList(0);
        }
        List result = MoveInnerToTopRefactoring.getDeclaringTypes(declaringType);
        result.add(declaringType);
        return result;
    }

    private static String[] getFieldNames(IType type) {
        try {
            IField[] fields = type.getFields();
            ArrayList<String> result = new ArrayList<String>(fields.length);
            int i = 0;
            while (i < fields.length) {
                result.add(fields[i].getElementName());
                ++i;
            }
            return result.toArray(new String[result.size()]);
        }
        catch (JavaScriptModelException e) {
            return null;
        }
    }

    private static Set getMergedSet(Set s1, Set s2) {
        HashSet result = new HashSet();
        result.addAll(s1);
        result.addAll(s2);
        return result;
    }

    private static String[] getParameterNamesOfAllConstructors(IType type) throws JavaScriptModelException {
        IFunction[] constructors = JavaElementUtil.getAllConstructors(type);
        HashSet<String> result = new HashSet<String>();
        int i = 0;
        while (i < constructors.length) {
            result.addAll(Arrays.asList(constructors[i].getParameterNames()));
            ++i;
        }
        return result.toArray(new String[result.size()]);
    }

    private static ASTNode[] getReferenceNodesIn(JavaScriptUnit cuNode, Map references, IJavaScriptUnit cu) {
        SearchMatch[] results = (SearchMatch[])references.get(cu);
        if (results == null) {
            return new ASTNode[0];
        }
        return ASTNodeSearchUtil.getAstNodes(results, cuNode);
    }

    private static boolean isCorrespondingTypeBinding(ITypeBinding binding, IType type) {
        if (binding == null) {
            return false;
        }
        return Bindings.getFullyQualifiedName(binding).equals(JavaElementUtil.createSignature((IMember)type));
    }

    private static boolean isStatic(FieldAccess access) {
        IVariableBinding fieldBinding = access.resolveFieldBinding();
        if (fieldBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(fieldBinding);
    }

    private static boolean isStatic(FunctionInvocation invocation) {
        IFunctionBinding methodBinding = invocation.resolveMethodBinding();
        if (methodBinding == null) {
            return false;
        }
        return JdtFlags.isStatic(methodBinding);
    }

    private static boolean isStaticFieldName(SimpleName name) {
        IBinding binding = name.resolveBinding();
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding variableBinding = (IVariableBinding)binding;
        if (!variableBinding.isField()) {
            return false;
        }
        return JdtFlags.isStatic(variableBinding);
    }

    public MoveInnerToTopRefactoring(IType type, CodeGenerationSettings settings) throws JavaScriptModelException {
        this.fType = type;
        this.fCodeGenerationSettings = settings;
        this.fMarkInstanceFieldAsFinal = true;
        if (this.fType != null) {
            this.initialize();
        }
    }

    private void initialize() throws JavaScriptModelException {
        this.fQualifiedTypeName = JavaModelUtil.concatenateName(this.fType.getPackageFragment().getElementName(), this.fType.getElementName());
        this.fEnclosingInstanceFieldName = this.getInitialNameForEnclosingInstanceField();
        this.fSourceRewrite = new CompilationUnitRewrite(this.fType.getJavaScriptUnit());
        this.fIsInstanceFieldCreationPossible = !JdtFlags.isStatic((IMember)this.fType);
        this.fCreateInstanceField = this.fIsInstanceFieldCreationMandatory = this.fIsInstanceFieldCreationPossible && this.isInstanceFieldCreationMandatory();
    }

    private void addEnclosingInstanceDeclaration(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        AST ast = declaration.getAST();
        VariableDeclarationFragment fragment = ast.newVariableDeclarationFragment();
        fragment.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
        FieldDeclaration newField = ast.newFieldDeclaration(fragment);
        newField.modifiers().addAll(ASTNodeFactory.newModifiers(ast, this.getEnclosingInstanceAccessModifiers()));
        newField.setType(this.createEnclosingType(ast));
        String comment = CodeGeneration.getFieldComment(this.fType.getJavaScriptUnit(), declaration.getName().getIdentifier(), this.fEnclosingInstanceFieldName, StubUtility.getLineDelimiterUsed(this.fType.getJavaScriptProject()));
        if (comment != null && comment.length() > 0) {
            JSdoc doc = (JSdoc)rewrite.createStringPlaceholder(comment, 29);
            newField.setJavadoc(doc);
        }
        rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)newField, null);
    }

    private void addImportsToTargetUnit(IJavaScriptUnit targetUnit, IProgressMonitor monitor) throws CoreException, JavaScriptModelException {
        monitor.beginTask("", 2);
        try {
            ImportRewrite rewrite = StubUtility.createImportRewrite(targetUnit, true);
            if (this.fTypeImports != null) {
                ITypeBinding type2 = null;
                for (ITypeBinding type2 : this.fTypeImports) {
                    rewrite.addImport(type2);
                }
            }
            if (this.fStaticImports != null) {
                IBinding binding2 = null;
                for (IBinding binding2 : this.fStaticImports) {
                    rewrite.addStaticImport(binding2);
                }
            }
            this.fTypeImports = null;
            this.fStaticImports = null;
            TextEdit edits = rewrite.rewriteImports((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            JavaModelUtil.applyEdit(targetUnit, edits, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
    }

    private void addInheritedTypeQualifications(AbstractTypeDeclaration declaration, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)targetRewrite);
        JavaScriptUnit unit = (JavaScriptUnit)declaration.getRoot();
        ITypeBinding binding = declaration.resolveBinding();
        if (binding != null) {
            Type type = null;
            if (declaration instanceof TypeDeclaration && (type = ((TypeDeclaration)declaration).getSuperclassType()) != null && unit.findDeclaringNode((IBinding)binding) != null) {
                this.addTypeQualification(type, targetRewrite, group);
            }
        }
    }

    private void addParameterToConstructor(ASTRewrite rewrite, FunctionDeclaration declaration) throws JavaScriptModelException {
        Assert.isNotNull((Object)rewrite);
        Assert.isNotNull((Object)declaration);
        AST ast = declaration.getAST();
        String name = this.getNameForEnclosingInstanceConstructorParameter();
        SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
        variable.setType(this.createEnclosingType(ast));
        variable.setName(ast.newSimpleName(name));
        rewrite.getListRewrite((ASTNode)declaration, FunctionDeclaration.PARAMETERS_PROPERTY).insertFirst((ASTNode)variable, null);
        JavadocUtil.addParamJavadoc(name, declaration, rewrite, this.fType.getJavaScriptProject(), null);
    }

    private void addSimpleTypeQualification(CompilationUnitRewrite targetRewrite, ITypeBinding declaring, SimpleType simpleType, TextEditGroup group) {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaring);
        Assert.isNotNull((Object)simpleType);
        AST ast = targetRewrite.getRoot().getAST();
        if (!(simpleType.getName() instanceof QualifiedName)) {
            targetRewrite.getASTRewrite().replace((ASTNode)simpleType, (ASTNode)ast.newQualifiedType(targetRewrite.getImportRewrite().addImport(declaring, ast), ast.newSimpleName(simpleType.getName().getFullyQualifiedName())), group);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleType);
        }
    }

    private void addTypeQualification(Type type, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        ITypeBinding declaring;
        Assert.isNotNull((Object)type);
        Assert.isNotNull((Object)targetRewrite);
        ITypeBinding binding = type.resolveBinding();
        if (binding != null && (declaring = binding.getDeclaringClass()) != null && type instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)type;
            this.addSimpleTypeQualification(targetRewrite, declaring, simpleType, group);
        }
    }

    private RefactoringStatus checkConstructorParameterNames() {
        RefactoringStatus result = new RefactoringStatus();
        JavaScriptUnit cuNode = new RefactoringASTParser(3).parse((ITypeRoot)this.fType.getJavaScriptUnit(), false);
        FunctionDeclaration[] nodes = this.getConstructorDeclarationNodes(MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, cuNode));
        int i = 0;
        while (i < nodes.length) {
            FunctionDeclaration constructor = nodes[i];
            for (SingleVariableDeclaration param : constructor.parameters()) {
                if (!this.fEnclosingInstanceFieldName.equals(param.getName().getIdentifier())) continue;
                String msg = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_name_used, new String[]{param.getName().getIdentifier(), this.fType.getElementName()});
                result.addError(msg, JavaStatusContext.create((ITypeRoot)this.fType.getJavaScriptUnit(), (ASTNode)param));
            }
            ++i;
        }
        return result;
    }

    public RefactoringStatus checkEnclosingInstanceName(String name) {
        if (!this.fCreateInstanceField) {
            return new RefactoringStatus();
        }
        RefactoringStatus result = Checks.checkFieldName(name);
        if (!Checks.startsWithLowerCase(name)) {
            result.addWarning(RefactoringCoreMessages.MoveInnerToTopRefactoring_names_start_lowercase);
        }
        if (this.fType.getField(name).exists()) {
            Object[] keys = new String[]{name, this.fType.getElementName()};
            String msg = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_already_declared, keys);
            result.addError(msg, JavaStatusContext.create((IMember)this.fType.getField(name)));
        }
        return result;
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException {
        pm.beginTask("", 2);
        try {
            RefactoringStatus result = new RefactoringStatus();
            if (JdtFlags.isStatic((IMember)this.fType)) {
                result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            }
            if (this.fType.getPackageFragment().getJavaScriptUnit(JavaModelUtil.getRenamedCUName(this.fType.getJavaScriptUnit(), this.fType.getElementName())).exists()) {
                String message = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_compilation_Unit_exists, new String[]{JavaModelUtil.getRenamedCUName(this.fType.getJavaScriptUnit(), this.fType.getElementName()), this.fType.getPackageFragment().getElementName()});
                result.addFatalError(message);
            }
            result.merge(this.checkEnclosingInstanceName(this.fEnclosingInstanceFieldName));
            result.merge(Checks.checkCompilationUnitName(JavaModelUtil.getRenamedCUName(this.fType.getJavaScriptUnit(), this.fType.getElementName())));
            result.merge(this.checkConstructorParameterNames());
            result.merge(this.checkTypeNameInPackage());
            this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 1), result);
            result.merge(Checks.validateModifiesFiles(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits()), this.getValidationContext()));
            RefactoringStatus refactoringStatus = result;
            return refactoringStatus;
        }
        finally {
            pm.done();
        }
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor monitor) throws CoreException {
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    private RefactoringStatus checkTypeNameInPackage() throws JavaScriptModelException {
        IType type = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.fType.getElementName());
        if (type == null || !type.exists()) {
            return null;
        }
        String message = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_type_exists, new String[]{this.fType.getElementName(), this.fType.getPackageFragment().getElementName()});
        return RefactoringStatus.createErrorStatus((String)message);
    }

    private Expression createAccessExpressionToEnclosingInstanceFieldText(ASTNode node, IBinding binding, AbstractTypeDeclaration declaration) {
        if (Modifier.isStatic((int)binding.getModifiers())) {
            return node.getAST().newName(JavaModelUtil.getTypeQualifiedName(this.fType.getDeclaringType()));
        }
        if (this.isInAnonymousTypeInsideInputType(node, declaration) || this.isInLocalTypeInsideInputType(node, declaration) || this.isInNonStaticMemberTypeInsideInputType(node, declaration)) {
            return this.createQualifiedReadAccessExpressionForEnclosingInstance(node.getAST());
        }
        return this.createReadAccessExpressionForEnclosingInstance(node.getAST());
    }

    public Change createChange(IProgressMonitor monitor) throws CoreException {
        boolean enclosing;
        monitor.beginTask(RefactoringCoreMessages.MoveInnerToTopRefactoring_creating_change, 1);
        HashMap<String, String> arguments = new HashMap<String, String>();
        String project = null;
        IJavaScriptProject javaProject = this.fType.getJavaScriptProject();
        if (javaProject != null) {
            project = javaProject.getElementName();
        }
        String description = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_descriptor_description_short, this.fType.getElementName());
        String header = Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_descriptor_description, new String[]{JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fType, 2235681801344L), JavaScriptElementLabels.getElementLabel(this.fType.getParent(), 2235681801344L)});
        JDTRefactoringDescriptorComment comment = new JDTRefactoringDescriptorComment(project, this, header);
        comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_original_pattern, JavaScriptElementLabels.getElementLabel((IJavaScriptElement)this.fType, 2235681801344L)));
        boolean bl = enclosing = this.fEnclosingInstanceFieldName != null && !"".equals(this.fEnclosingInstanceFieldName);
        if (enclosing) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_field_pattern, this.fEnclosingInstanceFieldName));
        }
        if (this.fNameForEnclosingInstanceConstructorParameter != null && !"".equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            comment.addSetting(Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_parameter_pattern, this.fNameForEnclosingInstanceConstructorParameter));
        }
        if (enclosing && this.fMarkInstanceFieldAsFinal) {
            comment.addSetting(RefactoringCoreMessages.MoveInnerToTopRefactoring_declare_final);
        }
        JDTRefactoringDescriptor descriptor = new JDTRefactoringDescriptor("org.eclipse.wst.jsdt.ui.move.inner", project, description, comment.asString(), arguments, 786438);
        arguments.put("input", descriptor.elementToHandle((IJavaScriptElement)this.fType));
        if (enclosing) {
            arguments.put(ATTRIBUTE_FIELD_NAME, this.fEnclosingInstanceFieldName);
        }
        if (this.fNameForEnclosingInstanceConstructorParameter != null && !"".equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            arguments.put(ATTRIBUTE_PARAMETER_NAME, this.fNameForEnclosingInstanceConstructorParameter);
        }
        arguments.put(ATTRIBUTE_FIELD, Boolean.valueOf(this.fCreateInstanceField).toString());
        arguments.put(ATTRIBUTE_FINAL, Boolean.valueOf(this.fMarkInstanceFieldAsFinal).toString());
        arguments.put(ATTRIBUTE_POSSIBLE, Boolean.valueOf(this.fIsInstanceFieldCreationPossible).toString());
        arguments.put(ATTRIBUTE_MANDATORY, Boolean.valueOf(this.fIsInstanceFieldCreationMandatory).toString());
        DynamicValidationRefactoringChange result = new DynamicValidationRefactoringChange(descriptor, RefactoringCoreMessages.MoveInnerToTopRefactoring_move_to_Top);
        result.addAll((Change[])this.fChangeManager.getAllChanges());
        result.add(this.createCompilationUnitForMovedType((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        return result;
    }

    private TextChangeManager createChangeManager(IProgressMonitor monitor, RefactoringStatus status) throws CoreException {
        Assert.isNotNull((Object)monitor);
        Assert.isNotNull((Object)status);
        TextChangeManager manager = new TextChangeManager();
        try {
            monitor.beginTask(RefactoringCoreMessages.MoveInnerToTopRefactoring_creating_preview, 4);
            HashMap<IJavaScriptUnit, CompilationUnitRewrite> rewrites = new HashMap<IJavaScriptUnit, CompilationUnitRewrite>(2);
            this.fSourceRewrite.clearASTAndImportRewrites();
            rewrites.put(this.fSourceRewrite.getCu(), this.fSourceRewrite);
            MemberVisibilityAdjustor adjustor = new MemberVisibilityAdjustor((IJavaScriptElement)this.fType.getPackageFragment(), (IMember)this.fType);
            adjustor.setRewrites(rewrites);
            adjustor.setVisibilitySeverity(2);
            adjustor.setFailureSeverity(2);
            adjustor.setStatus(status);
            adjustor.adjustVisibility((IProgressMonitor)new SubProgressMonitor(monitor, 1));
            LinkedHashMap parameters = new LinkedHashMap();
            ITypeBinding[] bindings = new ITypeBinding[parameters.values().size()];
            parameters.values().toArray(bindings);
            Map typeReferences = this.createTypeReferencesMapping((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            Map constructorReferences = null;
            constructorReferences = JdtFlags.isStatic((IMember)this.fType) ? new HashMap(0) : this.createConstructorReferencesMapping((IProgressMonitor)new SubProgressMonitor(monitor, 1), status);
            if (this.fCreateInstanceField) {
                IType type = this.fType;
                Modifier.ModifierKeyword keyword = null;
                while ((type = type.getDeclaringType()) != null) {
                    if (adjustor.getAdjustments().containsKey(type) || !Modifier.isPrivate((int)type.getFlags())) continue;
                    adjustor.getAdjustments().put(type, new MemberVisibilityAdjustor.OutgoingMemberVisibilityAdjustment((IMember)type, keyword, RefactoringStatus.createWarningStatus((String)Messages.format(RefactoringCoreMessages.MemberVisibilityAdjustor_change_visibility_type_warning, new String[]{MemberVisibilityAdjustor.getLabel((IJavaScriptElement)type), MemberVisibilityAdjustor.getLabel(keyword)}), (RefactoringStatusContext)JavaStatusContext.create((ITypeRoot)type.getJavaScriptUnit(), type.getSourceRange()))));
                }
            }
            monitor.worked(1);
            for (IJavaScriptUnit unit : MoveInnerToTopRefactoring.getMergedSet(typeReferences.keySet(), constructorReferences.keySet())) {
                CompilationUnitRewrite targetRewrite = this.getCompilationUnitRewrite(unit);
                this.createCompilationUnitRewrite(bindings, targetRewrite, typeReferences, constructorReferences, adjustor.getAdjustments().containsKey(this.fType), this.fType.getJavaScriptUnit(), unit, false, status, monitor);
                if (unit.equals(this.fType.getJavaScriptUnit())) {
                    try {
                        adjustor.setStatus(new RefactoringStatus());
                        adjustor.rewriteVisibility(targetRewrite.getCu(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    }
                    finally {
                        adjustor.setStatus(status);
                    }
                    this.fNewSourceOfInputType = this.createNewSource(targetRewrite, unit);
                    targetRewrite.clearASTAndImportRewrites();
                    this.createCompilationUnitRewrite(bindings, targetRewrite, typeReferences, constructorReferences, adjustor.getAdjustments().containsKey(this.fType), this.fType.getJavaScriptUnit(), unit, true, status, monitor);
                }
                adjustor.rewriteVisibility(targetRewrite.getCu(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                manager.manage(unit, (TextChange)targetRewrite.createChange());
            }
        }
        finally {
            monitor.done();
        }
        return manager;
    }

    private Change createCompilationUnitForMovedType(IProgressMonitor pm) throws CoreException {
        IJavaScriptUnit newCuWC = null;
        try {
            newCuWC = this.fType.getPackageFragment().getJavaScriptUnit(JavaModelUtil.getRenamedCUName(this.fType.getJavaScriptUnit(), this.fType.getElementName())).getWorkingCopy(null);
            String source = this.createSourceForNewCu(newCuWC, pm);
            CreateCompilationUnitChange createCompilationUnitChange = new CreateCompilationUnitChange(this.fType.getPackageFragment().getJavaScriptUnit(JavaModelUtil.getRenamedCUName(this.fType.getJavaScriptUnit(), this.fType.getElementName())), source, null);
            return createCompilationUnitChange;
        }
        finally {
            if (newCuWC != null) {
                newCuWC.discardWorkingCopy();
            }
        }
    }

    private void createCompilationUnitRewrite(ITypeBinding[] parameters, CompilationUnitRewrite targetRewrite, Map typeReferences, Map constructorReferences, boolean visibilityWasAdjusted, IJavaScriptUnit sourceUnit, IJavaScriptUnit targetUnit, boolean remove, RefactoringStatus status, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)parameters);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)typeReferences);
        Assert.isNotNull((Object)constructorReferences);
        Assert.isNotNull((Object)sourceUnit);
        Assert.isNotNull((Object)targetUnit);
        JavaScriptUnit root = targetRewrite.getRoot();
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (targetUnit.equals(sourceUnit)) {
            AbstractTypeDeclaration declaration = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, root);
            TextEditGroup qualifierGroup = this.fSourceRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_qualifier);
            ITypeBinding binding = declaration.resolveBinding();
            if (!remove) {
                if (!JdtFlags.isStatic((IMember)this.fType) && this.fCreateInstanceField) {
                    if (JavaElementUtil.getAllConstructors(this.fType).length == 0) {
                        this.createConstructor(declaration, rewrite);
                    } else {
                        this.modifyConstructors(declaration, rewrite);
                    }
                    this.addInheritedTypeQualifications(declaration, targetRewrite, qualifierGroup);
                    this.addEnclosingInstanceDeclaration(declaration, rewrite);
                }
                this.fTypeImports = new HashSet();
                this.fStaticImports = new HashSet();
                ImportRewriteUtil.collectImports(this.fType.getJavaScriptProject(), (ASTNode)declaration, this.fTypeImports, this.fStaticImports, false);
                if (binding != null) {
                    this.fTypeImports.remove(binding);
                }
            }
            this.modifyAccessToEnclosingInstance(targetRewrite, declaration, status, monitor);
            if (binding != null) {
                this.modifyInterfaceMemberModifiers(binding);
                ITypeBinding declaring = binding.getDeclaringClass();
                if (declaring != null) {
                    declaration.accept((ASTVisitor)new TypeReferenceQualifier(binding, null));
                }
            }
            TextEditGroup groupMove = targetRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_label);
            if (remove) {
                rewrite.remove((ASTNode)declaration, groupMove);
                targetRewrite.getImportRemover().registerRemovedNode((ASTNode)declaration);
            } else {
                int newFlags = JdtFlags.clearFlag(8, declaration.getModifiers());
                if (!visibilityWasAdjusted && (Modifier.isPrivate((int)declaration.getModifiers()) || Modifier.isProtected((int)declaration.getModifiers()))) {
                    newFlags = JdtFlags.clearFlag(6, newFlags);
                    RefactoringStatusEntry entry = new RefactoringStatusEntry(2, Messages.format(RefactoringCoreMessages.MoveInnerToTopRefactoring_change_visibility_type_warning, new String[]{BindingLabelProvider.getBindingLabel((IBinding)binding, 2235681801344L)}), JavaStatusContext.create((ITypeRoot)this.fSourceRewrite.getCu()));
                    if (!MoveInnerToTopRefactoring.containsStatusEntry(status, entry)) {
                        status.addEntry(entry);
                    }
                }
                ModifierRewrite.create(rewrite, (ASTNode)declaration).setModifiers(newFlags, groupMove);
            }
        }
        ASTNode[] references = MoveInnerToTopRefactoring.getReferenceNodesIn(root, typeReferences, targetUnit);
        int index = 0;
        while (index < references.length) {
            this.updateTypeReference(parameters, references[index], targetRewrite, targetUnit);
            ++index;
        }
        references = MoveInnerToTopRefactoring.getReferenceNodesIn(root, constructorReferences, targetUnit);
        index = 0;
        while (index < references.length) {
            this.updateConstructorReference(parameters, references[index], targetRewrite, targetUnit);
            ++index;
        }
    }

    private void createConstructor(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)rewrite);
        AST ast = declaration.getAST();
        FunctionDeclaration constructor = ast.newFunctionDeclaration();
        constructor.setConstructor(true);
        constructor.setName(ast.newSimpleName(declaration.getName().getIdentifier()));
        String comment = CodeGeneration.getMethodComment(this.fType.getJavaScriptUnit(), this.fType.getElementName(), this.fType.getElementName(), this.getNewConstructorParameterNames(), new String[0], null, null, StubUtility.getLineDelimiterUsed(this.fType.getJavaScriptProject()));
        if (comment != null && comment.length() > 0) {
            JSdoc doc = (JSdoc)rewrite.createStringPlaceholder(comment, 29);
            constructor.setJavadoc(doc);
        }
        if (this.fCreateInstanceField) {
            SingleVariableDeclaration variable = ast.newSingleVariableDeclaration();
            String name = this.getNameForEnclosingInstanceConstructorParameter();
            variable.setName(ast.newSimpleName(name));
            variable.setType(this.createEnclosingType(ast));
            constructor.parameters().add(variable);
            Block body = ast.newBlock();
            Assignment assignment = ast.newAssignment();
            if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
                assignment.setLeftHandSide((Expression)access);
            } else {
                assignment.setLeftHandSide((Expression)ast.newSimpleName(this.fEnclosingInstanceFieldName));
            }
            assignment.setRightHandSide((Expression)ast.newSimpleName(name));
            ExpressionStatement statement = ast.newExpressionStatement((Expression)assignment);
            body.statements().add(statement);
            constructor.setBody(body);
        } else {
            constructor.setBody(ast.newBlock());
        }
        rewrite.getListRewrite((ASTNode)declaration, declaration.getBodyDeclarationsProperty()).insertFirst((ASTNode)constructor, null);
    }

    private Map createConstructorReferencesMapping(IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        SearchResultGroup[] groups = ConstructorReferenceFinder.getConstructorReferences(this.fType, pm, status);
        HashMap<IJavaScriptUnit, SearchMatch[]> result = new HashMap<IJavaScriptUnit, SearchMatch[]>();
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            IJavaScriptUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.put(cu, group.getSearchResults());
            }
            ++i;
        }
        return result;
    }

    private Expression createEnclosingInstanceCreationString(ASTNode node, IJavaScriptUnit cu) throws JavaScriptModelException {
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        Assert.isNotNull((Object)cu);
        Expression expression = null;
        expression = node instanceof ClassInstanceCreation ? ((ClassInstanceCreation)node).getExpression() : ((SuperConstructorInvocation)node).getExpression();
        AST ast = node.getAST();
        if (expression != null) {
            return expression;
        }
        if (JdtFlags.isStatic((IMember)this.fType)) {
            return null;
        }
        if (this.isInsideSubclassOfDeclaringType(node)) {
            return ast.newThisExpression();
        }
        if (node.getStartPosition() >= this.fType.getSourceRange().getOffset() && ASTNodes.getExclusiveEnd(node) <= this.fType.getSourceRange().getOffset() + this.fType.getSourceRange().getLength()) {
            if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
                FieldAccess access = ast.newFieldAccess();
                access.setExpression((Expression)ast.newThisExpression());
                access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
                return access;
            }
            return ast.newSimpleName(this.fEnclosingInstanceFieldName);
        }
        if (this.isInsideTypeNestedInDeclaringType(node)) {
            ThisExpression qualified = ast.newThisExpression();
            qualified.setQualifier((Name)ast.newSimpleName(this.fType.getDeclaringType().getElementName()));
            return qualified;
        }
        return null;
    }

    private Type createEnclosingType(AST ast) throws JavaScriptModelException {
        Assert.isNotNull((Object)ast);
        Type type = ASTNodeFactory.newType(ast, JavaModelUtil.getTypeQualifiedName(this.fType.getDeclaringType()));
        return type;
    }

    private String createNewSource(CompilationUnitRewrite targetRewrite, IJavaScriptUnit unit) throws CoreException, JavaScriptModelException {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        CompilationUnitChange change = targetRewrite.createChange();
        if (change == null) {
            change = new CompilationUnitChange("", unit);
        }
        String source = change.getPreviewContent((IProgressMonitor)new NullProgressMonitor());
        ASTParser parser = ASTParser.newParser((int)3);
        parser.setProject(this.fType.getJavaScriptProject());
        parser.setResolveBindings(false);
        parser.setSource(source.toCharArray());
        AbstractTypeDeclaration declaration = MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, (JavaScriptUnit)parser.createAST(null));
        return source.substring(declaration.getStartPosition(), ASTNodes.getExclusiveEnd((ASTNode)declaration));
    }

    private Expression createQualifiedReadAccessExpressionForEnclosingInstance(AST ast) {
        ThisExpression expression = ast.newThisExpression();
        expression.setQualifier(ast.newName(new String[]{this.fType.getElementName()}));
        FieldAccess access = ast.newFieldAccess();
        access.setExpression((Expression)expression);
        access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
        return access;
    }

    private Expression createReadAccessExpressionForEnclosingInstance(AST ast) {
        if (this.fCodeGenerationSettings.useKeywordThis || this.fEnclosingInstanceFieldName.equals(this.fNameForEnclosingInstanceConstructorParameter)) {
            FieldAccess access = ast.newFieldAccess();
            access.setExpression((Expression)ast.newThisExpression());
            access.setName(ast.newSimpleName(this.fEnclosingInstanceFieldName));
            return access;
        }
        return ast.newSimpleName(this.fEnclosingInstanceFieldName);
    }

    private String createSourceForNewCu(IJavaScriptUnit unit, IProgressMonitor monitor) throws CoreException {
        Assert.isNotNull((Object)unit);
        Assert.isNotNull((Object)monitor);
        try {
            monitor.beginTask("", 2);
            String separator = StubUtility.getLineDelimiterUsed(this.fType.getJavaScriptProject());
            String block = this.getAlignedSourceBlock(unit, this.fNewSourceOfInputType);
            String content = CodeGeneration.getCompilationUnitContent(unit, null, block, separator);
            if (content == null || block.startsWith("/*") || block.startsWith("//")) {
                StringBuffer buffer = new StringBuffer();
                if (!this.fType.getPackageFragment().isDefaultPackage()) {
                    buffer.append("package ").append(this.fType.getPackageFragment().getElementName()).append(';');
                }
                buffer.append(separator).append(separator);
                buffer.append(block);
                content = buffer.toString();
            }
            unit.getBuffer().setContents(content);
            this.addImportsToTargetUnit(unit, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        }
        finally {
            monitor.done();
        }
        return unit.getSource();
    }

    private Map createTypeReferencesMapping(IProgressMonitor pm, RefactoringStatus status) throws JavaScriptModelException {
        RefactoringSearchEngine2 engine = new RefactoringSearchEngine2(SearchPattern.createPattern((IJavaScriptElement)this.fType, (int)3, (int)24));
        engine.setFiltering(true, true);
        engine.setScope(RefactoringScopeFactory.create((IJavaScriptElement)this.fType));
        engine.setStatus(status);
        engine.searchPattern((IProgressMonitor)new SubProgressMonitor(pm, 1));
        SearchResultGroup[] groups = (SearchResultGroup[])engine.getResults();
        HashMap<IJavaScriptUnit, SearchMatch[]> result = new HashMap<IJavaScriptUnit, SearchMatch[]>();
        int i = 0;
        while (i < groups.length) {
            SearchResultGroup group = groups[i];
            IJavaScriptUnit cu = group.getCompilationUnit();
            if (cu != null) {
                result.put(cu, group.getSearchResults());
            }
            ++i;
        }
        return result;
    }

    private String getAlignedSourceBlock(IJavaScriptUnit unit, String block) {
        Assert.isNotNull((Object)block);
        String[] lines = Strings.convertIntoLines(block);
        Strings.trimIndentation(lines, unit.getJavaScriptProject(), false);
        return Strings.concatenate(lines, StubUtility.getLineDelimiterUsed(this.fType.getJavaScriptProject()));
    }

    private CompilationUnitRewrite getCompilationUnitRewrite(IJavaScriptUnit unit) {
        Assert.isNotNull((Object)unit);
        if (unit.equals(this.fType.getJavaScriptUnit())) {
            return this.fSourceRewrite;
        }
        return new CompilationUnitRewrite(unit);
    }

    private FunctionDeclaration[] getConstructorDeclarationNodes(AbstractTypeDeclaration declaration) {
        if (declaration instanceof TypeDeclaration) {
            FunctionDeclaration[] declarations = ((TypeDeclaration)declaration).getMethods();
            ArrayList<FunctionDeclaration> result = new ArrayList<FunctionDeclaration>(2);
            int index = 0;
            while (index < declarations.length) {
                if (declarations[index].isConstructor()) {
                    result.add(declarations[index]);
                }
                ++index;
            }
            return result.toArray(new FunctionDeclaration[result.size()]);
        }
        return new FunctionDeclaration[0];
    }

    public boolean getCreateInstanceField() {
        return this.fCreateInstanceField;
    }

    private int getEnclosingInstanceAccessModifiers() {
        if (this.fMarkInstanceFieldAsFinal) {
            return 18;
        }
        return 2;
    }

    public String getEnclosingInstanceName() {
        return this.fEnclosingInstanceFieldName;
    }

    private String getInitialNameForEnclosingInstanceField() {
        IType enclosingType = this.fType.getDeclaringType();
        if (enclosingType == null) {
            return "";
        }
        String[] suggestedNames = StubUtility.getFieldNameSuggestions(this.fType.getDeclaringType(), this.getEnclosingInstanceAccessModifiers(), MoveInnerToTopRefactoring.getFieldNames(this.fType));
        if (suggestedNames.length > 0) {
            return suggestedNames[0];
        }
        String name = enclosingType.getElementName();
        if (name.equals("")) {
            return "";
        }
        return String.valueOf(Character.toLowerCase(name.charAt(0))) + name.substring(1);
    }

    public IType getInputType() {
        return this.fType;
    }

    public String getName() {
        return RefactoringCoreMessages.MoveInnerToTopRefactoring_name;
    }

    private String getNameForEnclosingInstanceConstructorParameter() throws JavaScriptModelException {
        if (this.fNameForEnclosingInstanceConstructorParameter != null) {
            return this.fNameForEnclosingInstanceConstructorParameter;
        }
        String[] suggestedNames = StubUtility.getArgumentNameSuggestions(this.fType.getDeclaringType(), MoveInnerToTopRefactoring.getParameterNamesOfAllConstructors(this.fType));
        this.fNameForEnclosingInstanceConstructorParameter = suggestedNames.length > 0 ? suggestedNames[0] : this.fEnclosingInstanceFieldName;
        return this.fNameForEnclosingInstanceConstructorParameter;
    }

    private String[] getNewConstructorParameterNames() throws JavaScriptModelException {
        if (!this.fCreateInstanceField) {
            return new String[0];
        }
        return new String[]{this.getNameForEnclosingInstanceConstructorParameter()};
    }

    private ASTNode getNewQualifiedNameNode(ITypeBinding[] parameters, Name name) {
        AST ast = name.getAST();
        boolean raw = false;
        ITypeBinding binding = name.resolveTypeBinding();
        return ast.newName(this.fQualifiedTypeName);
    }

    private ASTNode getNewUnqualifiedTypeNode(ITypeBinding[] parameters, Name name) {
        AST ast = name.getAST();
        boolean raw = false;
        ITypeBinding binding = name.resolveTypeBinding();
        return ast.newSimpleType((Name)ast.newSimpleName(this.fType.getElementName()));
    }

    private boolean insertExpressionAsParameter(ClassInstanceCreation cic, ASTRewrite rewrite, IJavaScriptUnit cu, TextEditGroup group) throws JavaScriptModelException {
        Expression expression = this.createEnclosingInstanceCreationString((ASTNode)cic, cu);
        if (expression == null) {
            return false;
        }
        rewrite.getListRewrite((ASTNode)cic, ClassInstanceCreation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)expression, group);
        return true;
    }

    private boolean insertExpressionAsParameter(SuperConstructorInvocation sci, ASTRewrite rewrite, IJavaScriptUnit cu, TextEditGroup group) throws JavaScriptModelException {
        Expression expression = this.createEnclosingInstanceCreationString((ASTNode)sci, cu);
        if (expression == null) {
            return false;
        }
        rewrite.getListRewrite((ASTNode)sci, SuperConstructorInvocation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)expression, group);
        return true;
    }

    public boolean isCreatingInstanceFieldMandatory() {
        return this.fIsInstanceFieldCreationMandatory;
    }

    public boolean isCreatingInstanceFieldPossible() {
        return this.fIsInstanceFieldCreationPossible;
    }

    private boolean isInAnonymousTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)ASTNodes.getParent(node, AnonymousClassDeclaration.class);
        return anonymous != null && ASTNodes.isParent((ASTNode)anonymous, (ASTNode)declaration);
    }

    private boolean isInLocalTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        TypeDeclarationStatement statement = (TypeDeclarationStatement)ASTNodes.getParent(node, TypeDeclarationStatement.class);
        return statement != null && ASTNodes.isParent((ASTNode)statement, (ASTNode)declaration);
    }

    private boolean isInNonStaticMemberTypeInsideInputType(ASTNode node, AbstractTypeDeclaration declaration) {
        AbstractTypeDeclaration nested = (AbstractTypeDeclaration)ASTNodes.getParent(node, AbstractTypeDeclaration.class);
        return nested != null && !declaration.equals((Object)nested) && !Modifier.isStatic((int)nested.getFlags()) && ASTNodes.isParent((ASTNode)nested, (ASTNode)declaration);
    }

    private boolean isInsideSubclassOfDeclaringType(ASTNode node) {
        boolean isAnonymous;
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(node, AbstractTypeDeclaration.class);
        Assert.isNotNull((Object)declaration);
        AnonymousClassDeclaration anonymous = (AnonymousClassDeclaration)ASTNodes.getParent(node, AnonymousClassDeclaration.class);
        boolean bl = isAnonymous = anonymous != null && ASTNodes.isParent((ASTNode)anonymous, (ASTNode)declaration);
        if (isAnonymous) {
            return anonymous != null && this.isSubclassBindingOfEnclosingType(anonymous.resolveBinding());
        }
        return this.isSubclassBindingOfEnclosingType(declaration.resolveBinding());
    }

    private boolean isInsideTypeNestedInDeclaringType(ASTNode node) {
        Assert.isTrue((node instanceof ClassInstanceCreation || node instanceof SuperConstructorInvocation ? 1 : 0) != 0);
        AbstractTypeDeclaration declaration = (AbstractTypeDeclaration)ASTNodes.getParent(node, AbstractTypeDeclaration.class);
        Assert.isNotNull((Object)declaration);
        ITypeBinding enclosing = declaration.resolveBinding();
        while (enclosing != null) {
            if (MoveInnerToTopRefactoring.isCorrespondingTypeBinding(enclosing, this.fType.getDeclaringType())) {
                return true;
            }
            enclosing = enclosing.getDeclaringClass();
        }
        return false;
    }

    private boolean isInstanceFieldCreationMandatory() throws JavaScriptModelException {
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(this.fType.getDeclaringType().newSupertypeHierarchy((IProgressMonitor)new NullProgressMonitor()));
        MoveInnerToTopRefactoring.findTypeDeclaration(this.fType, this.fSourceRewrite.getRoot()).accept((ASTVisitor)collector);
        return MoveInnerToTopRefactoring.containsNonStatic(collector.getFieldAccesses()) || MoveInnerToTopRefactoring.containsNonStatic(collector.getMethodInvocations()) || MoveInnerToTopRefactoring.containsNonStatic(collector.getSimpleFieldNames());
    }

    public boolean isInstanceFieldMarkedFinal() {
        return this.fMarkInstanceFieldAsFinal;
    }

    private boolean isSubclassBindingOfEnclosingType(ITypeBinding binding) {
        while (binding != null) {
            if (MoveInnerToTopRefactoring.isCorrespondingTypeBinding(binding, this.fType.getDeclaringType())) {
                return true;
            }
            binding = binding.getSuperclass();
        }
        return false;
    }

    private void modifyAccessToEnclosingInstance(CompilationUnitRewrite targetRewrite, AbstractTypeDeclaration declaration, RefactoringStatus status, IProgressMonitor monitor) throws JavaScriptModelException {
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)declaration);
        Assert.isNotNull((Object)monitor);
        HashSet handledMethods = new HashSet();
        HashSet handledFields = new HashSet();
        MemberAccessNodeCollector collector = new MemberAccessNodeCollector(this.fType.getDeclaringType().newSupertypeHierarchy((IProgressMonitor)new SubProgressMonitor(monitor, 1)));
        declaration.accept((ASTVisitor)collector);
        this.modifyAccessToMethodsFromEnclosingInstance(targetRewrite, handledMethods, collector.getMethodInvocations(), declaration, status);
        this.modifyAccessToFieldsFromEnclosingInstance(targetRewrite, handledFields, collector.getFieldAccesses(), declaration, status);
        this.modifyAccessToFieldsFromEnclosingInstance(targetRewrite, handledFields, collector.getSimpleFieldNames(), declaration, status);
    }

    private void modifyAccessToFieldsFromEnclosingInstance(CompilationUnitRewrite targetRewrite, Set handledFields, FieldAccess[] fieldAccesses, AbstractTypeDeclaration declaration, RefactoringStatus status) {
        FieldAccess access = null;
        int index = 0;
        while (index < fieldAccesses.length) {
            IVariableBinding binding;
            access = fieldAccesses[index];
            Assert.isNotNull((Object)access.getExpression());
            if (access.getExpression() instanceof ThisExpression && ((ThisExpression)access.getExpression()).getQualifier() != null && (binding = access.resolveFieldBinding()) != null) {
                targetRewrite.getASTRewrite().replace((ASTNode)access.getExpression(), (ASTNode)this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)access, (IBinding)binding, declaration), null);
                targetRewrite.getImportRemover().registerRemovedNode((ASTNode)access.getExpression());
            }
            ++index;
        }
    }

    private void modifyAccessToFieldsFromEnclosingInstance(CompilationUnitRewrite targetRewrite, Set handledFields, SimpleName[] simpleNames, AbstractTypeDeclaration declaration, RefactoringStatus status) {
        IBinding binding = null;
        SimpleName simpleName = null;
        IVariableBinding variable = null;
        int index = 0;
        while (index < simpleNames.length) {
            simpleName = simpleNames[index];
            binding = simpleName.resolveBinding();
            if (binding != null && binding instanceof IVariableBinding && !(simpleName.getParent() instanceof FieldAccess)) {
                variable = (IVariableBinding)binding;
                FieldAccess access = simpleName.getAST().newFieldAccess();
                access.setExpression(this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)simpleName, (IBinding)variable, declaration));
                access.setName(simpleName.getAST().newSimpleName(simpleName.getIdentifier()));
                targetRewrite.getASTRewrite().replace((ASTNode)simpleName, (ASTNode)access, null);
                targetRewrite.getImportRemover().registerRemovedNode((ASTNode)simpleName);
            }
            ++index;
        }
    }

    private void modifyAccessToMethodsFromEnclosingInstance(CompilationUnitRewrite targetRewrite, Set handledMethods, FunctionInvocation[] methodInvocations, AbstractTypeDeclaration declaration, RefactoringStatus status) {
        IFunctionBinding binding = null;
        FunctionInvocation invocation = null;
        int index = 0;
        while (index < methodInvocations.length) {
            invocation = methodInvocations[index];
            binding = invocation.resolveMethodBinding();
            if (binding != null) {
                Expression target = invocation.getExpression();
                if (target == null) {
                    Expression expression = this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)invocation, (IBinding)binding, declaration);
                    targetRewrite.getASTRewrite().set((ASTNode)invocation, (StructuralPropertyDescriptor)FunctionInvocation.EXPRESSION_PROPERTY, (Object)expression, null);
                } else if (invocation.getExpression() instanceof ThisExpression && ((ThisExpression)invocation.getExpression()).getQualifier() != null) {
                    targetRewrite.getASTRewrite().replace((ASTNode)target, (ASTNode)this.createAccessExpressionToEnclosingInstanceFieldText((ASTNode)invocation, (IBinding)binding, declaration), null);
                    targetRewrite.getImportRemover().registerRemovedNode((ASTNode)target);
                }
            }
            ++index;
        }
    }

    private void modifyConstructors(AbstractTypeDeclaration declaration, ASTRewrite rewrite) throws CoreException {
        FunctionDeclaration[] declarations = this.getConstructorDeclarationNodes(declaration);
        int index = 0;
        while (index < declarations.length) {
            Assert.isTrue((boolean)declarations[index].isConstructor());
            this.addParameterToConstructor(rewrite, declarations[index]);
            this.setEnclosingInstanceFieldInConstructor(rewrite, declarations[index]);
            ++index;
        }
    }

    private void modifyInterfaceMemberModifiers(ITypeBinding binding) {
        ASTNode node;
        Assert.isNotNull((Object)binding);
        ITypeBinding declaring = binding.getDeclaringClass();
        while (declaring != null) {
            declaring = declaring.getDeclaringClass();
        }
        if (declaring != null && (node = ASTNodes.findDeclaration((IBinding)binding, (ASTNode)this.fSourceRewrite.getRoot())) instanceof AbstractTypeDeclaration) {
            ModifierRewrite.create(this.fSourceRewrite.getASTRewrite(), node).setVisibility(1, null);
        }
    }

    public void setCreateInstanceField(boolean create) {
        Assert.isTrue((boolean)this.fIsInstanceFieldCreationPossible);
        Assert.isTrue((!this.fIsInstanceFieldCreationMandatory ? 1 : 0) != 0);
        this.fCreateInstanceField = create;
    }

    private void setEnclosingInstanceFieldInConstructor(ASTRewrite rewrite, FunctionDeclaration decl) throws JavaScriptModelException {
        AST ast = decl.getAST();
        Block body = decl.getBody();
        List statements = body.statements();
        if (statements.isEmpty()) {
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(ast));
            assignment.setRightHandSide((Expression)ast.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter()));
            rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertFirst((ASTNode)ast.newExpressionStatement((Expression)assignment), null);
        } else {
            Statement first = (Statement)statements.get(0);
            if (first instanceof ConstructorInvocation) {
                rewrite.getListRewrite((ASTNode)first, ConstructorInvocation.ARGUMENTS_PROPERTY).insertFirst((ASTNode)ast.newSimpleName(this.fEnclosingInstanceFieldName), null);
            } else {
                int index = 0;
                if (first instanceof SuperConstructorInvocation) {
                    ++index;
                }
                Assignment assignment = ast.newAssignment();
                assignment.setLeftHandSide(this.createReadAccessExpressionForEnclosingInstance(ast));
                assignment.setRightHandSide((Expression)ast.newSimpleName(this.getNameForEnclosingInstanceConstructorParameter()));
                rewrite.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY).insertAt((ASTNode)ast.newExpressionStatement((Expression)assignment), index, null);
            }
        }
    }

    public void setEnclosingInstanceName(String name) {
        Assert.isNotNull((Object)name);
        this.fEnclosingInstanceFieldName = name;
    }

    public void setMarkInstanceFieldAsFinal(boolean mark) {
        this.fMarkInstanceFieldAsFinal = mark;
    }

    private void updateConstructorReference(ClassInstanceCreation creation, CompilationUnitRewrite targetRewrite, IJavaScriptUnit unit, TextEditGroup group) throws JavaScriptModelException {
        Expression expression;
        Assert.isNotNull((Object)creation);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(creation, rewrite, unit, group);
        }
        if ((expression = creation.getExpression()) != null) {
            rewrite.remove((ASTNode)expression, null);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }
    }

    private void updateConstructorReference(ITypeBinding[] parameters, ASTNode reference, CompilationUnitRewrite targetRewrite, IJavaScriptUnit cu) throws CoreException {
        TextEditGroup group = targetRewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_update_constructor_reference);
        if (reference instanceof SuperConstructorInvocation) {
            this.updateConstructorReference((SuperConstructorInvocation)reference, targetRewrite, cu, group);
        } else if (reference instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)reference, targetRewrite, cu, group);
        } else if (reference.getParent() instanceof ClassInstanceCreation) {
            this.updateConstructorReference((ClassInstanceCreation)reference.getParent(), targetRewrite, cu, group);
        }
    }

    private void updateConstructorReference(SuperConstructorInvocation invocation, CompilationUnitRewrite targetRewrite, IJavaScriptUnit unit, TextEditGroup group) throws CoreException {
        Expression expression;
        Assert.isNotNull((Object)invocation);
        Assert.isNotNull((Object)targetRewrite);
        Assert.isNotNull((Object)unit);
        ASTRewrite rewrite = targetRewrite.getASTRewrite();
        if (this.fCreateInstanceField) {
            this.insertExpressionAsParameter(invocation, rewrite, unit, group);
        }
        if ((expression = invocation.getExpression()) != null) {
            rewrite.remove((ASTNode)expression, null);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)expression);
        }
    }

    private boolean updateNameReference(ITypeBinding[] parameters, Name name, CompilationUnitRewrite targetRewrite, TextEditGroup group) {
        if (ASTNodes.asString((ASTNode)name).equals(this.fType.getFullyQualifiedName('.'))) {
            targetRewrite.getASTRewrite().replace((ASTNode)name, this.getNewQualifiedNameNode(parameters, name), group);
            targetRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
            return true;
        }
        targetRewrite.getASTRewrite().replace((ASTNode)name, this.getNewUnqualifiedTypeNode(parameters, name), group);
        targetRewrite.getImportRemover().registerRemovedNode((ASTNode)name);
        return true;
    }

    private boolean updateReference(ITypeBinding[] parameters, ASTNode node, CompilationUnitRewrite rewrite, TextEditGroup group) {
        if (node instanceof QualifiedName) {
            return this.updateNameReference(parameters, (Name)((QualifiedName)node), rewrite, group);
        }
        if (node instanceof SimpleType) {
            return this.updateNameReference(parameters, ((SimpleType)node).getName(), rewrite, group);
        }
        return false;
    }

    private void updateReferenceInImport(ImportDeclaration enclosingImport, ASTNode node, CompilationUnitRewrite rewrite) throws CoreException {
        IBinding binding = enclosingImport.resolveBinding();
        if (binding instanceof ITypeBinding) {
            ITypeBinding type = (ITypeBinding)binding;
            ImportRewrite rewriter = rewrite.getImportRewrite();
            if (enclosingImport.isStatic()) {
                String typeName;
                String oldImport = ASTNodes.asString(node);
                StringBuffer buffer = new StringBuffer(oldImport);
                int index = buffer.indexOf(typeName = this.fType.getDeclaringType().getElementName());
                if (index >= 0) {
                    buffer.delete(index, index + typeName.length() + 1);
                    String newImport = buffer.toString();
                    if (enclosingImport.isOnDemand()) {
                        rewriter.removeStaticImport(String.valueOf(oldImport) + ".*");
                        rewriter.addStaticImport(newImport, "*", false);
                    } else {
                        rewriter.removeStaticImport(oldImport);
                        int offset = newImport.lastIndexOf(46);
                        if (offset >= 0 && offset < newImport.length() - 1) {
                            rewriter.addStaticImport(newImport.substring(0, offset), newImport.substring(offset + 1), false);
                        }
                    }
                }
            } else {
                rewriter.removeImport(type.getQualifiedName());
            }
        }
    }

    private void updateTypeReference(ITypeBinding[] parameters, ASTNode node, CompilationUnitRewrite rewrite, IJavaScriptUnit cu) throws CoreException {
        ImportDeclaration enclosingImport = (ImportDeclaration)ASTNodes.getParent(node, ImportDeclaration.class);
        if (enclosingImport != null) {
            this.updateReferenceInImport(enclosingImport, node, rewrite);
        } else {
            TextEditGroup group = rewrite.createGroupDescription(RefactoringCoreMessages.MoveInnerToTopRefactoring_update_type_reference);
            this.updateReference(parameters, node, rewrite, group);
            if (!this.fType.getPackageFragment().equals(cu.getParent())) {
                String name = String.valueOf(this.fType.getPackageFragment().getElementName()) + '.' + this.fType.getElementName();
                rewrite.getImportRemover().registerAddedImport(name);
                rewrite.getImportRewrite().addImport(name);
            }
        }
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        String mandatory;
        if (arguments instanceof JavaRefactoringArguments) {
            String createField;
            String parameterName;
            JavaRefactoringArguments extended = (JavaRefactoringArguments)arguments;
            String handle = extended.getAttribute("input");
            if (handle != null) {
                IJavaScriptElement element = JDTRefactoringDescriptor.handleToElement(extended.getProject(), handle, false);
                if (element == null || !element.exists() || element.getElementType() != 7) {
                    return this.createInputFatalStatus(element, "org.eclipse.wst.jsdt.ui.move.inner");
                }
                this.fType = (IType)element;
                this.fCodeGenerationSettings = JavaPreferencesSettings.getCodeGenerationSettings(this.fType.getJavaScriptProject());
                try {
                    this.initialize();
                }
                catch (JavaScriptModelException exception) {
                    JavaScriptPlugin.log(exception);
                }
            } else {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, "input"));
            }
            String fieldName = extended.getAttribute(ATTRIBUTE_FIELD_NAME);
            if (fieldName != null && !"".equals(fieldName)) {
                this.fEnclosingInstanceFieldName = fieldName;
            }
            if ((parameterName = extended.getAttribute(ATTRIBUTE_PARAMETER_NAME)) != null && !"".equals(parameterName)) {
                this.fNameForEnclosingInstanceConstructorParameter = parameterName;
            }
            if ((createField = extended.getAttribute(ATTRIBUTE_FIELD)) == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FIELD));
            }
            this.fCreateInstanceField = Boolean.valueOf(createField);
            String markFinal = extended.getAttribute(ATTRIBUTE_FINAL);
            if (markFinal == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_FINAL));
            }
            this.fMarkInstanceFieldAsFinal = Boolean.valueOf(markFinal);
            String possible = extended.getAttribute(ATTRIBUTE_POSSIBLE);
            if (possible == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_POSSIBLE));
            }
            this.fIsInstanceFieldCreationPossible = Boolean.valueOf(possible);
            mandatory = extended.getAttribute(ATTRIBUTE_MANDATORY);
            if (mandatory == null) {
                return RefactoringStatus.createFatalErrorStatus((String)Messages.format(RefactoringCoreMessages.InitializableRefactoring_argument_not_exist, ATTRIBUTE_MANDATORY));
            }
        } else {
            return RefactoringStatus.createFatalErrorStatus((String)RefactoringCoreMessages.InitializableRefactoring_inacceptable_arguments);
        }
        this.fIsInstanceFieldCreationMandatory = Boolean.valueOf(mandatory);
        return new RefactoringStatus();
    }

    private static class MemberAccessNodeCollector
    extends ASTVisitor {
        private final List fFieldAccesses = new ArrayList(0);
        private final ITypeHierarchy fHierarchy;
        private final List fMethodAccesses = new ArrayList(0);
        private final List fSimpleNames = new ArrayList(0);

        MemberAccessNodeCollector(ITypeHierarchy hierarchy) {
            Assert.isNotNull((Object)hierarchy);
            this.fHierarchy = hierarchy;
        }

        FieldAccess[] getFieldAccesses() {
            return this.fFieldAccesses.toArray(new FieldAccess[this.fFieldAccesses.size()]);
        }

        FunctionInvocation[] getMethodInvocations() {
            return this.fMethodAccesses.toArray(new FunctionInvocation[this.fMethodAccesses.size()]);
        }

        SimpleName[] getSimpleFieldNames() {
            return this.fSimpleNames.toArray(new SimpleName[this.fSimpleNames.size()]);
        }

        public boolean visit(FieldAccess node) {
            IType type;
            ITypeBinding declaring = MoveInnerToTopRefactoring.getDeclaringTypeBinding(node);
            if (declaring != null && (type = (IType)declaring.getJavaElement()) != null && this.fHierarchy.contains(type)) {
                this.fFieldAccesses.add(node);
            }
            return super.visit(node);
        }

        public boolean visit(FunctionInvocation node) {
            IType type;
            ITypeBinding declaring = MoveInnerToTopRefactoring.getDeclaringTypeBinding(node);
            if (declaring != null && (type = (IType)declaring.getJavaElement()) != null && this.fHierarchy.contains(type)) {
                this.fMethodAccesses.add(node);
            }
            return super.visit(node);
        }

        public boolean visit(SimpleName node) {
            if (node.getParent() instanceof QualifiedName) {
                return super.visit(node);
            }
            IBinding binding = node.resolveBinding();
            if (binding instanceof IVariableBinding) {
                IType type;
                IVariableBinding variable = (IVariableBinding)binding;
                ITypeBinding declaring = variable.getDeclaringClass();
                if (variable.isField() && declaring != null && (type = (IType)declaring.getJavaElement()) != null && this.fHierarchy.contains(type)) {
                    this.fSimpleNames.add(node);
                    return false;
                }
            }
            return super.visit(node);
        }

        public boolean visit(ThisExpression node) {
            IType type;
            ITypeBinding binding;
            Name qualifier = node.getQualifier();
            if (qualifier != null && (binding = qualifier.resolveTypeBinding()) != null && (type = (IType)binding.getJavaElement()) != null && this.fHierarchy.contains(type)) {
                this.fSimpleNames.add(qualifier);
                return false;
            }
            return super.visit(node);
        }
    }

    private class TypeReferenceQualifier
    extends ASTVisitor {
        private final TextEditGroup fGroup;
        private final ITypeBinding fTypeBinding;

        public TypeReferenceQualifier(ITypeBinding type, TextEditGroup group) {
            Assert.isNotNull((Object)type);
            Assert.isNotNull((Object)type.getDeclaringClass());
            this.fTypeBinding = type;
            this.fGroup = group;
        }

        public boolean visit(ClassInstanceCreation node) {
            Assert.isNotNull((Object)node);
            if (MoveInnerToTopRefactoring.this.fCreateInstanceField) {
                AST ast = node.getAST();
                Type type = node.getType();
                ITypeBinding binding = type.resolveBinding();
                if (binding != null && binding.getDeclaringClass() != null && !Bindings.equals((IBinding)binding, (IBinding)this.fTypeBinding) && MoveInnerToTopRefactoring.this.fSourceRewrite.getRoot().findDeclaringNode((IBinding)binding) != null) {
                    if (!Modifier.isStatic((int)binding.getModifiers())) {
                        SimpleName expression = null;
                        if (((MoveInnerToTopRefactoring)MoveInnerToTopRefactoring.this).fCodeGenerationSettings.useKeywordThis || MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName.equals(MoveInnerToTopRefactoring.this.fNameForEnclosingInstanceConstructorParameter)) {
                            FieldAccess access = ast.newFieldAccess();
                            access.setExpression((Expression)ast.newThisExpression());
                            access.setName(ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName));
                            expression = access;
                        } else {
                            expression = ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName);
                        }
                        if (node.getExpression() != null) {
                            MoveInnerToTopRefactoring.this.fSourceRewrite.getImportRemover().registerRemovedNode((ASTNode)node.getExpression());
                        }
                        MoveInnerToTopRefactoring.this.fSourceRewrite.getASTRewrite().set((ASTNode)node, (StructuralPropertyDescriptor)ClassInstanceCreation.EXPRESSION_PROPERTY, (Object)expression, this.fGroup);
                    } else {
                        MoveInnerToTopRefactoring.this.addTypeQualification(type, MoveInnerToTopRefactoring.this.fSourceRewrite, this.fGroup);
                    }
                }
            }
            return true;
        }

        public boolean visit(QualifiedType node) {
            Assert.isNotNull((Object)node);
            return false;
        }

        public boolean visit(SimpleType node) {
            ITypeBinding declaring;
            ITypeBinding binding;
            Assert.isNotNull((Object)node);
            if (!(node.getParent() instanceof ClassInstanceCreation) && (binding = node.resolveBinding()) != null && (declaring = binding.getDeclaringClass()) != null && !Bindings.equals((IBinding)declaring, (IBinding)this.fTypeBinding.getDeclaringClass()) && !Bindings.equals((IBinding)binding, (IBinding)this.fTypeBinding) && MoveInnerToTopRefactoring.this.fSourceRewrite.getRoot().findDeclaringNode((IBinding)binding) != null && Modifier.isStatic((int)binding.getModifiers())) {
                MoveInnerToTopRefactoring.this.addTypeQualification((Type)node, MoveInnerToTopRefactoring.this.fSourceRewrite, this.fGroup);
            }
            return super.visit(node);
        }

        public boolean visit(ThisExpression node) {
            Assert.isNotNull((Object)node);
            Name name = node.getQualifier();
            if (name != null && name.isSimpleName()) {
                AST ast = node.getAST();
                SimpleName expression = null;
                if (((MoveInnerToTopRefactoring)MoveInnerToTopRefactoring.this).fCodeGenerationSettings.useKeywordThis || MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName.equals(MoveInnerToTopRefactoring.this.fNameForEnclosingInstanceConstructorParameter)) {
                    FieldAccess access = ast.newFieldAccess();
                    access.setExpression((Expression)ast.newThisExpression());
                    access.setName(ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName));
                    expression = access;
                } else {
                    expression = ast.newSimpleName(MoveInnerToTopRefactoring.this.fEnclosingInstanceFieldName);
                }
                MoveInnerToTopRefactoring.this.fSourceRewrite.getASTRewrite().replace((ASTNode)node, (ASTNode)expression, null);
            }
            return super.visit(node);
        }
    }
}

