/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.callhierarchy;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.CallHierarchyMessages;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchScopeActionGroup;
import org.eclipse.wst.jsdt.internal.ui.callhierarchy.SearchUtil;
import org.eclipse.wst.jsdt.internal.ui.search.JavaSearchScopeFactory;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;

class SelectWorkingSetAction
extends Action {
    private final SearchScopeActionGroup fGroup;

    public SelectWorkingSetAction(SearchScopeActionGroup group) {
        super(CallHierarchyMessages.SearchScopeActionGroup_workingset_select_text);
        this.fGroup = group;
        this.setToolTipText(CallHierarchyMessages.SearchScopeActionGroup_workingset_select_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.call_hierarchy_search_scope_action_context");
    }

    public void run() {
        try {
            IWorkingSet[] workingSets = JavaSearchScopeFactory.getInstance().queryWorkingSets();
            if (workingSets != null) {
                this.fGroup.setActiveWorkingSets(workingSets);
                SearchUtil.updateLRUWorkingSets(workingSets);
            } else {
                this.fGroup.setActiveWorkingSets(null);
            }
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), JavaScriptPlugin.getActiveWorkbenchShell(), CallHierarchyMessages.SelectWorkingSetAction_error_title, CallHierarchyMessages.SelectWorkingSetAction_error_message);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

