/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.commands;

import org.eclipse.core.commands.AbstractParameterValueConverter;
import org.eclipse.core.commands.ParameterValueConversionException;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptModel;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.Signature;
import org.eclipse.wst.jsdt.internal.core.util.Util;

public class JavaElementReferenceConverter
extends AbstractParameterValueConverter {
    private static final char PROJECT_END_CHAR = '/';
    private static final char TYPE_END_CHAR = '#';
    private static final char PARAM_START_CHAR = '(';
    private static final char PARAM_END_CHAR = ')';

    public Object convertToObject(String parameterValue) throws ParameterValueConversionException {
        this.assertWellFormed(parameterValue != null);
        int projectEndPosition = parameterValue.indexOf(47);
        this.assertWellFormed(projectEndPosition != -1);
        String projectName = parameterValue.substring(0, projectEndPosition);
        String javaElementRef = parameterValue.substring(projectEndPosition + 1);
        IJavaScriptModel javaModel = JavaScriptCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot());
        this.assertExists((IJavaScriptElement)javaModel);
        IJavaScriptProject javaProject = javaModel.getJavaScriptProject(projectName);
        this.assertExists((IJavaScriptElement)javaProject);
        int typeEndPosition = javaElementRef.indexOf(35);
        String typeName = typeEndPosition == -1 ? javaElementRef : javaElementRef.substring(0, typeEndPosition);
        if (Util.isJavaLikeFileName((String)typeName)) {
            ITypeRoot typeRoot = null;
            try {
                typeRoot = javaProject.findTypeRoot(typeName);
            }
            catch (JavaScriptModelException javaScriptModelException) {
                // empty catch block
            }
            this.assertExists((IJavaScriptElement)typeRoot);
            if (typeEndPosition == -1) {
                return typeRoot;
            }
            String memberRef = javaElementRef.substring(typeEndPosition + 1);
            int paramStartPosition = memberRef.indexOf(40);
            if (paramStartPosition == -1) {
                IField field = typeRoot.getField(memberRef);
                this.assertExists((IJavaScriptElement)field);
                return field;
            }
            String methodName = memberRef.substring(0, paramStartPosition);
            String signature = memberRef.substring(paramStartPosition);
            String[] parameterTypes = null;
            try {
                parameterTypes = Signature.getParameterTypes((String)signature);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.assertWellFormed(parameterTypes != null);
            IFunction method = typeRoot.getFunction(methodName, parameterTypes);
            this.assertExists((IJavaScriptElement)method);
            return method;
        }
        IType type = null;
        try {
            type = javaProject.findType(typeName);
        }
        catch (JavaScriptModelException memberRef) {
            // empty catch block
        }
        this.assertExists((IJavaScriptElement)type);
        if (typeEndPosition == -1) {
            return type;
        }
        String memberRef = javaElementRef.substring(typeEndPosition + 1);
        int paramStartPosition = memberRef.indexOf(40);
        if (paramStartPosition == -1) {
            IField field = type.getField(memberRef);
            this.assertExists((IJavaScriptElement)field);
            return field;
        }
        String methodName = memberRef.substring(0, paramStartPosition);
        String signature = memberRef.substring(paramStartPosition);
        String[] parameterTypes = null;
        try {
            parameterTypes = Signature.getParameterTypes((String)signature);
        }
        catch (IllegalArgumentException method) {
            // empty catch block
        }
        this.assertWellFormed(parameterTypes != null);
        IFunction method = type.getFunction(methodName, parameterTypes);
        this.assertExists((IJavaScriptElement)method);
        return method;
    }

    private void assertWellFormed(boolean assertion) throws ParameterValueConversionException {
        if (!assertion) {
            throw new ParameterValueConversionException("Malformed parameterValue");
        }
    }

    private void assertExists(IJavaScriptElement javaElement) throws ParameterValueConversionException {
        if (javaElement == null || !javaElement.exists()) {
            throw new ParameterValueConversionException("parameterValue must reference an existing IJavaScriptElement");
        }
    }

    public String convertToString(Object parameterValue) throws ParameterValueConversionException {
        StringBuffer buffer;
        if (!(parameterValue instanceof IJavaScriptElement)) {
            throw new ParameterValueConversionException("parameterValue must be an IJavaScriptElement");
        }
        IJavaScriptElement javaElement = (IJavaScriptElement)parameterValue;
        IJavaScriptProject javaProject = javaElement.getJavaScriptProject();
        if (javaProject == null) {
            throw new ParameterValueConversionException("Could not get IJavaScriptProject for element");
        }
        if (javaElement instanceof IType) {
            IType type = (IType)javaElement;
            buffer = this.composeTypeReference(type);
        } else if (javaElement instanceof IFunction) {
            IFunction method = (IFunction)javaElement;
            buffer = this.composeTypeReference(method.getDeclaringType());
            buffer.append('#');
            buffer.append(method.getElementName());
            String[] parameterTypes = method.getParameterTypes();
            buffer.append('(');
            int i = 0;
            while (i < parameterTypes.length) {
                buffer.append(parameterTypes[i]);
                ++i;
            }
            buffer.append(')');
        } else if (javaElement instanceof IField) {
            IField field = (IField)javaElement;
            buffer = this.composeTypeReference(field.getDeclaringType());
            buffer.append('#');
            buffer.append(field.getElementName());
        } else {
            throw new ParameterValueConversionException("Unsupported IJavaScriptElement type");
        }
        return buffer.toString();
    }

    private StringBuffer composeTypeReference(IType type) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(type.getJavaScriptProject().getElementName());
        buffer.append('/');
        buffer.append(type.getFullyQualifiedName());
        return buffer;
    }
}

