/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor;

import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.texteditor.IEditorStatusLine;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.AccessorClassReference;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.NLSHintHelper;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditorMessages;

public class NLSKeyHyperlink
implements IHyperlink {
    private IRegion fRegion;
    private AccessorClassReference fAccessorClassReference;
    private IEditorPart fEditor;
    private final String fKeyName;

    public NLSKeyHyperlink(IRegion region, String keyName, AccessorClassReference ref, IEditorPart editor) {
        Assert.isNotNull((Object)region);
        Assert.isNotNull((Object)keyName);
        Assert.isNotNull((Object)ref);
        Assert.isNotNull((Object)editor);
        this.fRegion = region;
        this.fKeyName = keyName;
        this.fAccessorClassReference = ref;
        this.fEditor = editor;
    }

    public IRegion getHyperlinkRegion() {
        return this.fRegion;
    }

    public void open() {
        IStorage propertiesFile = null;
        try {
            ITypeBinding typeBinding = this.fAccessorClassReference.getBinding();
            propertiesFile = NLSHintHelper.getResourceBundle(typeBinding.getJavaElement().getJavaScriptProject(), this.fAccessorClassReference);
        }
        catch (JavaScriptModelException typeBinding) {
            // empty catch block
        }
        if (propertiesFile == null) {
            this.showErrorInStatusLine(this.fEditor, JavaEditorMessages.Editor_OpenPropertiesFile_error_fileNotFound_dialogMessage);
            return;
        }
        try {
            IEditorPart editor = EditorUtility.openInEditor(propertiesFile, true);
        }
        catch (PartInitException e) {
            this.handleOpenPropertiesFileFailed(propertiesFile);
            return;
        }
        catch (JavaScriptModelException e) {
            this.handleOpenPropertiesFileFailed(propertiesFile);
            return;
        }
    }

    private void showErrorInStatusLine(IEditorPart editor, final String message) {
        Display display = this.fEditor.getSite().getShell().getDisplay();
        display.beep();
        final IEditorStatusLine statusLine = (IEditorStatusLine)editor.getAdapter(IEditorStatusLine.class);
        if (statusLine != null) {
            display.asyncExec(new Runnable(){

                public void run() {
                    statusLine.setMessage(true, message, null);
                }
            });
        }
    }

    private void handleOpenPropertiesFileFailed(IStorage propertiesFile) {
        this.showErrorInStatusLine(this.fEditor, Messages.format(JavaEditorMessages.Editor_OpenPropertiesFile_error_openEditor_dialogMessage, propertiesFile.getFullPath().toOSString()));
    }

    public String getTypeLabel() {
        return null;
    }

    public String getHyperlinkText() {
        return null;
    }
}

