/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IUpdate;
import org.eclipse.wst.jsdt.core.IInitializer;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceRange;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.internal.corext.SourceRange;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.selectionactions.SelectionActionMessages;

public class GoToNextPreviousMemberAction
extends Action
implements IUpdate {
    public static final String NEXT_MEMBER = "GoToNextMember";
    public static final String PREVIOUS_MEMBER = "GoToPreviousMember";
    private JavaEditor fEditor;
    private boolean fIsGotoNext;

    public static GoToNextPreviousMemberAction newGoToNextMemberAction(JavaEditor editor) {
        String text = SelectionActionMessages.GotoNextMember_label;
        return new GoToNextPreviousMemberAction(editor, text, true);
    }

    public static GoToNextPreviousMemberAction newGoToPreviousMemberAction(JavaEditor editor) {
        String text = SelectionActionMessages.GotoPreviousMember_label;
        return new GoToNextPreviousMemberAction(editor, text, false);
    }

    private GoToNextPreviousMemberAction(JavaEditor editor, String text, boolean isGotoNext) {
        super(text);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fIsGotoNext = isGotoNext;
        this.update();
        if (isGotoNext) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_next_member_action");
        } else {
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.wst.jsdt.ui.goto_previous_member_action");
        }
    }

    public GoToNextPreviousMemberAction(boolean isSelectNext) {
        super("");
        this.fIsGotoNext = isSelectNext;
    }

    public void update() {
        boolean enabled = false;
        ISourceReference ref = this.getSourceReference();
        if (ref != null) {
            try {
                ISourceRange range = ref.getSourceRange();
                enabled = range != null && range.getLength() > 0;
            }
            catch (JavaScriptModelException javaScriptModelException) {
                // empty catch block
            }
        }
        this.setEnabled(enabled);
    }

    public final void run() {
        ITextSelection selection = this.getTextSelection();
        ISourceRange newRange = this.getNewSelectionRange(GoToNextPreviousMemberAction.createSourceRange(selection), null);
        if (selection.getOffset() == newRange.getOffset() && selection.getLength() == newRange.getLength()) {
            return;
        }
        this.fEditor.selectAndReveal(newRange.getOffset(), newRange.getLength());
    }

    private IType[] getTypes() throws JavaScriptModelException {
        IEditorInput input = this.fEditor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return new IType[]{((IClassFileEditorInput)input).getClassFile().getType()};
        }
        return JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input).getAllTypes();
    }

    private ISourceReference getSourceReference() {
        IEditorInput input = this.fEditor.getEditorInput();
        if (input instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)input).getClassFile();
        }
        return JavaScriptPlugin.getDefault().getWorkingCopyManager().getWorkingCopy(input);
    }

    private ITextSelection getTextSelection() {
        return (ITextSelection)this.fEditor.getSelectionProvider().getSelection();
    }

    public ISourceRange getNewSelectionRange(ISourceRange oldSourceRange, IType[] types) {
        try {
            Object[] offsetArray;
            if (types == null) {
                types = this.getTypes();
            }
            if ((offsetArray = GoToNextPreviousMemberAction.createOffsetArray(types)).length == 0) {
                return oldSourceRange;
            }
            Arrays.sort(offsetArray);
            Integer oldOffset = oldSourceRange.getOffset();
            int index = Arrays.binarySearch(offsetArray, oldOffset);
            if (this.fIsGotoNext) {
                return GoToNextPreviousMemberAction.createNewSourceRange(GoToNextPreviousMemberAction.getNextOffset(index, (Integer[])offsetArray, oldOffset));
            }
            return GoToNextPreviousMemberAction.createNewSourceRange(GoToNextPreviousMemberAction.getPreviousOffset(index, (Integer[])offsetArray, oldOffset));
        }
        catch (JavaScriptModelException e) {
            JavaScriptPlugin.log(e);
            return oldSourceRange;
        }
    }

    private static Integer getPreviousOffset(int index, Integer[] offsetArray, Integer oldOffset) {
        if (index == -1) {
            return oldOffset;
        }
        if (index == 0) {
            return offsetArray[0];
        }
        if (index > 0) {
            return offsetArray[index - 1];
        }
        Assert.isTrue((index < -1 ? 1 : 0) != 0);
        int absIndex = Math.abs(index);
        return offsetArray[absIndex - 2];
    }

    private static Integer getNextOffset(int index, Integer[] offsetArray, Integer oldOffset) {
        if (index == -1) {
            return offsetArray[0];
        }
        if (index == 0) {
            if (offsetArray.length != 1) {
                return offsetArray[1];
            }
            return offsetArray[0];
        }
        if (index > 0) {
            if (index == offsetArray.length - 1) {
                return oldOffset;
            }
            return offsetArray[index + 1];
        }
        Assert.isTrue((index < -1 ? 1 : 0) != 0);
        int absIndex = Math.abs(index);
        if (absIndex > offsetArray.length) {
            return oldOffset;
        }
        return offsetArray[absIndex - 1];
    }

    private static ISourceRange createNewSourceRange(Integer offset) {
        return new SourceRange(offset, 0);
    }

    private static Integer[] createOffsetArray(IType[] types) throws JavaScriptModelException {
        ArrayList result = new ArrayList();
        int i = 0;
        while (i < types.length) {
            IType iType = types[i];
            GoToNextPreviousMemberAction.addOffset(result, iType.getNameRange().getOffset());
            GoToNextPreviousMemberAction.addOffset(result, iType.getSourceRange().getOffset() + iType.getSourceRange().getLength());
            GoToNextPreviousMemberAction.addMemberOffsetList(result, (IMember[])iType.getFunctions());
            GoToNextPreviousMemberAction.addMemberOffsetList(result, (IMember[])iType.getFields());
            GoToNextPreviousMemberAction.addMemberOffsetList(result, (IMember[])iType.getInitializers());
            ++i;
        }
        return result.toArray(new Integer[result.size()]);
    }

    private static void addMemberOffsetList(List result, IMember[] members) throws JavaScriptModelException {
        int i = 0;
        while (i < members.length) {
            GoToNextPreviousMemberAction.addOffset(result, GoToNextPreviousMemberAction.getOffset(members[i]));
            ++i;
        }
    }

    private static int getOffset(IMember iMember) throws JavaScriptModelException {
        if (iMember.getElementType() == 10) {
            return GoToNextPreviousMemberAction.firstOpeningBraceOffset((IInitializer)iMember);
        }
        if (iMember.getNameRange() != null && iMember.getNameRange().getOffset() >= 0) {
            return iMember.getNameRange().getOffset();
        }
        return iMember.getSourceRange().getOffset();
    }

    private static int firstOpeningBraceOffset(IInitializer iInitializer) throws JavaScriptModelException {
        try {
            IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
            scanner.setSource(iInitializer.getSource().toCharArray());
            int token = scanner.getNextToken();
            while (token != 158 && token != 110) {
                token = scanner.getNextToken();
            }
            if (token == 110) {
                return iInitializer.getSourceRange().getOffset() + scanner.getCurrentTokenStartPosition() + scanner.getRawTokenSource().length;
            }
            return iInitializer.getSourceRange().getOffset();
        }
        catch (InvalidInputException e) {
            return iInitializer.getSourceRange().getOffset();
        }
    }

    private static ISourceRange createSourceRange(ITextSelection ts) {
        return new SourceRange(ts.getOffset(), ts.getLength());
    }

    private static void addOffset(List result, int offset) {
        if (offset >= 0) {
            result.add(offset);
        }
    }
}

