/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogPage;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.PropertyPage;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJsGlobalScopeContainer;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JsGlobalScopeContainerInitializer;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusUtil;
import org.eclipse.wst.jsdt.internal.ui.preferences.PreferencesMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.IStatusChangeListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.SourceAttachmentBlock;

public class SourceAttachmentPropertyPage
extends PropertyPage
implements IStatusChangeListener {
    private SourceAttachmentBlock fSourceAttachmentBlock;
    private IPackageFragmentRoot fRoot;
    private IPath fContainerPath;
    private IIncludePathEntry fEntry;
    public static final String PROP_ID = "org.eclipse.wst.jsdt.ui.propertyPages.SourceAttachmentPage";

    public void createControl(Composite parent) {
        super.createControl(parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.source_attachment_property_page_context");
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        Control result = this.createPageContent(composite);
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private Control createPageContent(Composite composite) {
        try {
            this.fContainerPath = null;
            this.fEntry = null;
            this.fRoot = this.getJARPackageFragmentRoot();
            if (this.fRoot == null || this.fRoot.getKind() != 2) {
                return this.createMessageContent(composite, PreferencesMessages.SourceAttachmentPropertyPage_noarchive_message);
            }
            IPath containerPath = null;
            IJavaScriptProject jproject = this.fRoot.getJavaScriptProject();
            IIncludePathEntry entry = this.fRoot.getRawIncludepathEntry();
            if (entry == null) {
                entry = JavaScriptCore.newLibraryEntry((IPath)this.fRoot.getPath(), null, null);
            } else if (entry.getEntryKind() == 5) {
                containerPath = entry.getPath();
                JsGlobalScopeContainerInitializer initializer = JavaScriptCore.getJsGlobalScopeContainerInitializer((String)containerPath.segment(0));
                IJsGlobalScopeContainer container = JavaScriptCore.getJsGlobalScopeContainer((IPath)containerPath, (IJavaScriptProject)jproject);
                if (initializer == null || container == null) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_invalid_container, containerPath.toString()));
                }
                String containerName = container.getDescription();
                IStatus status = initializer.getSourceAttachmentStatus(containerPath, jproject);
                if (status.getCode() == 1) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_not_supported, containerName));
                }
                if (status.getCode() == 2) {
                    return this.createMessageContent(composite, Messages.format(PreferencesMessages.SourceAttachmentPropertyPage_read_only, containerName));
                }
                entry = JavaModelUtil.findEntryInContainer(container, this.fRoot.getPath());
                Assert.isNotNull((Object)entry);
            }
            this.fContainerPath = containerPath;
            this.fEntry = entry;
            this.fSourceAttachmentBlock = new SourceAttachmentBlock(this, entry);
            return this.fSourceAttachmentBlock.createControl(composite);
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
            return this.createMessageContent(composite, PreferencesMessages.SourceAttachmentPropertyPage_noarchive_message);
        }
    }

    private Control createMessageContent(Composite composite, String message) {
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        inner.setLayout((Layout)layout);
        GridData gd = new GridData(256);
        gd.widthHint = this.convertWidthInCharsToPixels(80);
        Label label = new Label(inner, 16448);
        label.setText(message);
        label.setLayoutData((Object)gd);
        return inner;
    }

    public boolean performOk() {
        if (this.fSourceAttachmentBlock != null) {
            IIncludePathEntry entry;
            block5: {
                entry = this.fSourceAttachmentBlock.getNewEntry();
                if (!entry.equals(this.fEntry)) break block5;
                return true;
            }
            try {
                IRunnableWithProgress runnable = SourceAttachmentBlock.getRunnable(this.getShell(), entry, this.fRoot.getJavaScriptProject(), this.fContainerPath);
                PlatformUI.getWorkbench().getProgressService().run(true, true, runnable);
            }
            catch (InvocationTargetException e) {
                String title = PreferencesMessages.SourceAttachmentPropertyPage_error_title;
                String message = PreferencesMessages.SourceAttachmentPropertyPage_error_message;
                ExceptionHandler.handle(e, this.getShell(), title, message);
                return false;
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        return true;
    }

    protected void performDefaults() {
        if (this.fSourceAttachmentBlock != null) {
            this.fSourceAttachmentBlock.setDefaults();
        }
        super.performDefaults();
    }

    private IPackageFragmentRoot getJARPackageFragmentRoot() throws CoreException {
        IProject proj;
        IAdaptable adaptable = this.getElement();
        IJavaScriptElement elem = (IJavaScriptElement)adaptable.getAdapter(IJavaScriptElement.class);
        if (elem instanceof IPackageFragmentRoot) {
            return (IPackageFragmentRoot)elem;
        }
        IResource resource = (IResource)adaptable.getAdapter(IResource.class);
        if (resource instanceof IFile && (proj = resource.getProject()).hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
            IJavaScriptProject jproject = JavaScriptCore.create((IProject)proj);
            return jproject.getPackageFragmentRoot(resource);
        }
        return null;
    }

    public void statusChanged(IStatus status) {
        this.setValid(!status.matches(4));
        StatusUtil.applyToStatusLine((DialogPage)this, status);
    }
}

