/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ModifyDialogTabPage;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.wst.jsdt.internal.ui.wizards.dialogfields.StringDialogField;

public abstract class ModifyDialog
extends StatusDialog
implements ModifyDialogTabPage.IModificationListener {
    private static final String DS_KEY_PREFERRED_WIDTH = "modify_dialog.preferred_width";
    private static final String DS_KEY_PREFERRED_HEIGHT = "modify_dialog.preferred_height";
    private static final String DS_KEY_PREFERRED_X = "modify_dialog.preferred_x";
    private static final String DS_KEY_PREFERRED_Y = "modify_dialog.preferred_y";
    private static final String DS_KEY_LAST_FOCUS = "modify_dialog.last_focus";
    private static final int APPLAY_BUTTON_ID = 1024;
    private static final int SAVE_BUTTON_ID = 1025;
    private final String fKeyPreferredWidth;
    private final String fKeyPreferredHight;
    private final String fKeyPreferredX;
    private final String fKeyPreferredY;
    private final String fKeyLastFocus;
    private final String fLastSaveLoadPathKey;
    private final ProfileStore fProfileStore;
    private final boolean fNewProfile;
    private ProfileManager.Profile fProfile;
    private final Map fWorkingValues;
    private final List fTabPages;
    private final IDialogSettings fDialogSettings;
    private TabFolder fTabFolder;
    private final ProfileManager fProfileManager;
    private Button fApplyButton;
    private Button fSaveButton;
    private StringDialogField fProfileNameField;

    public ModifyDialog(Shell parentShell, ProfileManager.Profile profile, ProfileManager profileManager, ProfileStore profileStore, boolean newProfile, String dialogPreferencesKey, String lastSavePathKey) {
        super(parentShell);
        this.fProfileStore = profileStore;
        this.fLastSaveLoadPathKey = lastSavePathKey;
        this.fKeyPreferredWidth = "org.eclipse.wst.jsdt.ui" + dialogPreferencesKey + DS_KEY_PREFERRED_WIDTH;
        this.fKeyPreferredHight = "org.eclipse.wst.jsdt.ui" + dialogPreferencesKey + DS_KEY_PREFERRED_HEIGHT;
        this.fKeyPreferredX = "org.eclipse.wst.jsdt.ui" + dialogPreferencesKey + DS_KEY_PREFERRED_X;
        this.fKeyPreferredY = "org.eclipse.wst.jsdt.ui" + dialogPreferencesKey + DS_KEY_PREFERRED_Y;
        this.fKeyLastFocus = "org.eclipse.wst.jsdt.ui" + dialogPreferencesKey + DS_KEY_LAST_FOCUS;
        this.fProfileManager = profileManager;
        this.fNewProfile = newProfile;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x400);
        this.fProfile = profile;
        this.setTitle(Messages.format(FormatterMessages.ModifyDialog_dialog_title, profile.getName()));
        this.fWorkingValues = new HashMap(this.fProfile.getSettings());
        this.setStatusLineAboveButtons(false);
        this.fTabPages = new ArrayList();
        this.fDialogSettings = JavaScriptPlugin.getDefault().getDialogSettings();
    }

    protected abstract void addPages(Map var1);

    public void create() {
        super.create();
        int lastFocusNr = 0;
        try {
            lastFocusNr = this.fDialogSettings.getInt(this.fKeyLastFocus);
            if (lastFocusNr < 0) {
                lastFocusNr = 0;
            }
            if (lastFocusNr > this.fTabPages.size() - 1) {
                lastFocusNr = this.fTabPages.size() - 1;
            }
        }
        catch (NumberFormatException x) {
            lastFocusNr = 0;
        }
        if (!this.fNewProfile) {
            this.fTabFolder.setSelection(lastFocusNr);
            ((ModifyDialogTabPage)this.fTabFolder.getSelection()[0].getData()).setInitialFocus();
        }
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite nameComposite = new Composite(composite, 0);
        nameComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        nameComposite.setLayout((Layout)new GridLayout(3, false));
        this.fProfileNameField = new StringDialogField();
        this.fProfileNameField.setLabelText(FormatterMessages.ModifyDialog_ProfileName_Label);
        this.fProfileNameField.setText(this.fProfile.getName());
        this.fProfileNameField.getLabelControl(nameComposite).setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.fProfileNameField.getTextControl(nameComposite).setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.fProfileNameField.setDialogFieldListener(new IDialogFieldListener(){

            public void dialogFieldChanged(DialogField field) {
                ModifyDialog.this.doValidate();
            }
        });
        this.fSaveButton = this.createButton(nameComposite, 1025, FormatterMessages.ModifyDialog_Export_Button, false);
        this.fTabFolder = new TabFolder(composite, 0);
        this.fTabFolder.setFont(composite.getFont());
        this.fTabFolder.setLayoutData((Object)new GridData(4, 4, true, true));
        this.addPages(this.fWorkingValues);
        ModifyDialog.applyDialogFont((Control)composite);
        this.fTabFolder.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                TabItem tabItem = (TabItem)e.item;
                ModifyDialogTabPage page = (ModifyDialogTabPage)tabItem.getData();
                ModifyDialog.this.fDialogSettings.put(ModifyDialog.this.fKeyLastFocus, ModifyDialog.this.fTabPages.indexOf(page));
                page.makeVisible();
            }
        });
        this.doValidate();
        return composite;
    }

    public void updateStatus(IStatus status) {
        if (status == null) {
            this.doValidate();
        } else {
            super.updateStatus(status);
        }
    }

    protected Point getInitialSize() {
        Point initialSize = super.getInitialSize();
        try {
            int lastHeight;
            int lastWidth = this.fDialogSettings.getInt(this.fKeyPreferredWidth);
            if (initialSize.x > lastWidth) {
                lastWidth = initialSize.x;
            }
            if (initialSize.y > (lastHeight = this.fDialogSettings.getInt(this.fKeyPreferredHight))) {
                lastHeight = initialSize.x;
            }
            return new Point(lastWidth, lastHeight);
        }
        catch (NumberFormatException numberFormatException) {
            return initialSize;
        }
    }

    protected Point getInitialLocation(Point initialSize) {
        try {
            return new Point(this.fDialogSettings.getInt(this.fKeyPreferredX), this.fDialogSettings.getInt(this.fKeyPreferredY));
        }
        catch (NumberFormatException ex) {
            return super.getInitialLocation(initialSize);
        }
    }

    public boolean close() {
        Rectangle shell = this.getShell().getBounds();
        this.fDialogSettings.put(this.fKeyPreferredWidth, shell.width);
        this.fDialogSettings.put(this.fKeyPreferredHight, shell.height);
        this.fDialogSettings.put(this.fKeyPreferredX, shell.x);
        this.fDialogSettings.put(this.fKeyPreferredY, shell.y);
        return super.close();
    }

    protected void okPressed() {
        this.applyPressed();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1024) {
            this.applyPressed();
            this.setTitle(Messages.format(FormatterMessages.ModifyDialog_dialog_title, this.fProfile.getName()));
        } else if (buttonId == 1025) {
            this.saveButtonPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    private void applyPressed() {
        if (!this.fProfile.getName().equals(this.fProfileNameField.getText())) {
            this.fProfile = this.fProfile.rename(this.fProfileNameField.getText(), this.fProfileManager);
        }
        this.fProfile.setSettings(new HashMap(this.fWorkingValues));
        this.fProfileManager.setSelected(this.fProfile);
        this.doValidate();
    }

    private void saveButtonPressed() {
        String path;
        ProfileManager.CustomProfile selected = new ProfileManager.CustomProfile(this.fProfileNameField.getText(), new HashMap(this.fWorkingValues), this.fProfile.getVersion(), this.fProfileManager.getProfileVersioner().getProfileKind());
        FileDialog dialog = new FileDialog(this.getShell(), 8192);
        dialog.setText(FormatterMessages.CodingStyleConfigurationBlock_save_profile_dialog_title);
        dialog.setFilterExtensions(new String[]{"*.xml"});
        String lastPath = JavaScriptPlugin.getDefault().getDialogSettings().get(String.valueOf(this.fLastSaveLoadPathKey) + ".savepath");
        if (lastPath != null) {
            dialog.setFilterPath(lastPath);
        }
        if ((path = dialog.open()) == null) {
            return;
        }
        JavaScriptPlugin.getDefault().getDialogSettings().put(String.valueOf(this.fLastSaveLoadPathKey) + ".savepath", dialog.getFilterPath());
        File file = new File(path);
        if (file.exists() && !MessageDialog.openQuestion((Shell)this.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_message, path))) {
            return;
        }
        String encoding = "UTF-8";
        IContentType type = Platform.getContentTypeManager().getContentType("org.eclipse.core.runtime.xml");
        if (type != null) {
            encoding = type.getDefaultCharset();
        }
        ArrayList<ProfileManager.CustomProfile> profiles = new ArrayList<ProfileManager.CustomProfile>();
        profiles.add(selected);
        try {
            this.fProfileStore.writeProfilesToFile(profiles, file, encoding);
        }
        catch (CoreException e) {
            String title = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_title;
            String message = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_message;
            ExceptionHandler.handle(e, this.getShell(), title, message);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fApplyButton = this.createButton(parent, 1024, FormatterMessages.ModifyDialog_apply_button, false);
        this.fApplyButton.setEnabled(false);
        GridLayout layout = (GridLayout)parent.getLayout();
        ++layout.numColumns;
        layout.makeColumnsEqualWidth = false;
        Label label = new Label(parent, 0);
        GridData data = new GridData();
        data.widthHint = layout.horizontalSpacing;
        label.setLayoutData((Object)data);
        super.createButtonsForButtonBar(parent);
    }

    protected final void addTabPage(String title, ModifyDialogTabPage tabPage) {
        TabItem tabItem = new TabItem(this.fTabFolder, 0);
        ModifyDialog.applyDialogFont((Control)tabItem.getControl());
        tabItem.setText(title);
        tabItem.setData((Object)tabPage);
        tabItem.setControl((Control)tabPage.createContents((Composite)this.fTabFolder));
        this.fTabPages.add(tabPage);
    }

    public void valuesModified() {
        this.doValidate();
    }

    protected void updateButtonsEnableState(IStatus status) {
        super.updateButtonsEnableState(status);
        if (this.fApplyButton != null && !this.fApplyButton.isDisposed()) {
            this.fApplyButton.setEnabled(this.hasChanges() && !status.matches(4));
        }
        if (this.fSaveButton != null && !this.fSaveButton.isDisposed()) {
            this.fSaveButton.setEnabled(!this.validateProfileName().matches(4));
        }
    }

    private void doValidate() {
        IStatus status = this.validateProfileName();
        if (status.matches(4)) {
            this.updateStatus(status);
            return;
        }
        String name = this.fProfileNameField.getText().trim();
        if (!name.equals(this.fProfile.getName()) && this.fProfileManager.containsName(name)) {
            this.updateStatus((IStatus)new Status(4, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_Duplicate_Status));
            return;
        }
        if (this.fProfile.isBuiltInProfile() || this.fProfile.isSharedProfile()) {
            this.updateStatus((IStatus)new Status(1, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_NewCreated_Status));
            return;
        }
        this.updateStatus(StatusInfo.OK_STATUS);
    }

    private IStatus validateProfileName() {
        String name = this.fProfileNameField.getText().trim();
        if (this.fProfile.isBuiltInProfile() && this.fProfile.getName().equals(name)) {
            return new Status(4, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_BuiltIn_Status);
        }
        if (this.fProfile.isSharedProfile() && this.fProfile.getName().equals(name)) {
            return new Status(4, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_Shared_Status);
        }
        if (name.length() == 0) {
            return new Status(4, "org.eclipse.wst.jsdt.ui", FormatterMessages.ModifyDialog_EmptyName_Status);
        }
        return StatusInfo.OK_STATUS;
    }

    private boolean hasChanges() {
        if (!this.fProfileNameField.getText().trim().equals(this.fProfile.getName())) {
            return true;
        }
        for (Map.Entry curr : this.fProfile.getSettings().entrySet()) {
            if (this.fWorkingValues.get(curr.getKey()).equals(curr.getValue())) continue;
            return true;
        }
        return false;
    }
}

