/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.preferences.formatter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.JavaUIException;
import org.eclipse.wst.jsdt.internal.ui.JavaUIStatus;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.IProfileVersioner;
import org.eclipse.wst.jsdt.internal.ui.preferences.formatter.ProfileManager;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ProfileStore {
    public static final String ENCODING = "UTF-8";
    protected static final String VERSION_KEY_SUFFIX = ".version";
    private static final String XML_NODE_ROOT = "profiles";
    private static final String XML_NODE_PROFILE = "profile";
    private static final String XML_NODE_SETTING = "setting";
    private static final String XML_ATTRIBUTE_VERSION = "version";
    private static final String XML_ATTRIBUTE_ID = "id";
    private static final String XML_ATTRIBUTE_NAME = "name";
    private static final String XML_ATTRIBUTE_PROFILE_KIND = "kind";
    private static final String XML_ATTRIBUTE_VALUE = "value";
    private final IProfileVersioner fProfileVersioner;
    private final String fProfilesKey;
    private final String fProfilesVersionKey;

    public ProfileStore(String profilesKey, IProfileVersioner profileVersioner) {
        this.fProfilesKey = profilesKey;
        this.fProfileVersioner = profileVersioner;
        this.fProfilesVersionKey = String.valueOf(profilesKey) + VERSION_KEY_SUFFIX;
    }

    public List readProfiles(IScopeContext scope) throws CoreException {
        return this.readProfilesFromString(scope.getNode("org.eclipse.wst.jsdt.ui").get(this.fProfilesKey, null));
    }

    public void writeProfiles(Collection profiles, IScopeContext instanceScope) throws CoreException {
        ByteArrayOutputStream stream = new ByteArrayOutputStream(2000);
        try {
            String val;
            ProfileStore.writeProfilesToStream(profiles, stream, ENCODING, this.fProfileVersioner);
            try {
                val = stream.toString(ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                val = stream.toString();
            }
            IEclipsePreferences uiPreferences = instanceScope.getNode("org.eclipse.wst.jsdt.ui");
            uiPreferences.put(this.fProfilesKey, val);
            uiPreferences.putInt(this.fProfilesVersionKey, this.fProfileVersioner.getCurrentVersion());
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    public List readProfilesFromString(String profiles) throws CoreException {
        if (profiles != null && profiles.length() > 0) {
            byte[] bytes;
            try {
                bytes = profiles.getBytes(ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                bytes = profiles.getBytes();
            }
            ByteArrayInputStream is = new ByteArrayInputStream(bytes);
            try {
                List res = ProfileStore.readProfilesFromStream(new InputSource(is));
                if (res != null) {
                    int i = 0;
                    while (i < res.size()) {
                        this.fProfileVersioner.update((ProfileManager.CustomProfile)res.get(i));
                        ++i;
                    }
                }
                List list = res;
                return list;
            }
            finally {
                try {
                    ((InputStream)is).close();
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }

    public List readProfilesFromFile(File file) throws CoreException {
        List list;
        FileInputStream reader = new FileInputStream(file);
        try {
            list = ProfileStore.readProfilesFromStream(new InputSource(reader));
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                throw throwable;
            }
            catch (IOException e) {
                throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
            }
        }
        try {
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return list;
    }

    public static List readProfilesFromStream(InputSource inputSource) throws CoreException {
        ProfileDefaultHandler handler = new ProfileDefaultHandler();
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser parser = factory.newSAXParser();
            parser.parse(inputSource, (DefaultHandler)handler);
        }
        catch (SAXException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_reading_xml_message);
        }
        return handler.getProfiles();
    }

    public void writeProfilesToFile(Collection profiles, File file, String encoding) throws CoreException {
        try {
            FileOutputStream stream = new FileOutputStream(file);
            try {
                ProfileStore.writeProfilesToStream(profiles, stream, encoding, this.fProfileVersioner);
            }
            finally {
                try {
                    ((OutputStream)stream).close();
                }
                catch (IOException iOException) {}
            }
        }
        catch (IOException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    public static void writeProfilesToStream(Collection profiles, OutputStream stream, String encoding, IProfileVersioner profileVersioner) throws CoreException {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.newDocument();
            Element rootElement = document.createElement(XML_NODE_ROOT);
            rootElement.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(profileVersioner.getCurrentVersion()));
            document.appendChild(rootElement);
            for (ProfileManager.Profile profile : profiles) {
                if (!profile.isProfileToSave()) continue;
                Element profileElement = ProfileStore.createProfileElement(profile, document, profileVersioner);
                rootElement.appendChild(profileElement);
            }
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            transformer.setOutputProperty("method", "xml");
            transformer.setOutputProperty("encoding", encoding);
            transformer.setOutputProperty("indent", "yes");
            transformer.transform(new DOMSource(document), new StreamResult(stream));
        }
        catch (TransformerException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
        catch (ParserConfigurationException e) {
            throw ProfileStore.createException(e, FormatterMessages.CodingStyleConfigurationBlock_error_serializing_xml_message);
        }
    }

    private static Element createProfileElement(ProfileManager.Profile profile, Document document, IProfileVersioner profileVersioner) {
        Element element = document.createElement(XML_NODE_PROFILE);
        element.setAttribute(XML_ATTRIBUTE_NAME, profile.getName());
        element.setAttribute(XML_ATTRIBUTE_VERSION, Integer.toString(profile.getVersion()));
        element.setAttribute(XML_ATTRIBUTE_PROFILE_KIND, profileVersioner.getProfileKind());
        for (String key : profile.getSettings().keySet()) {
            String value = (String)profile.getSettings().get(key);
            if (value != null) {
                Element setting = document.createElement(XML_NODE_SETTING);
                setting.setAttribute(XML_ATTRIBUTE_ID, key);
                setting.setAttribute(XML_ATTRIBUTE_VALUE, value);
                element.appendChild(setting);
                continue;
            }
            JavaScriptPlugin.logErrorMessage("ProfileStore: Profile does not contain value for key " + key);
        }
        return element;
    }

    private static JavaUIException createException(Throwable t, String message) {
        return new JavaUIException(JavaUIStatus.createError(4, message, t));
    }

    private static final class ProfileDefaultHandler
    extends DefaultHandler {
        private List fProfiles;
        private int fVersion;
        private String fName;
        private Map fSettings;
        private String fKind;

        private ProfileDefaultHandler() {
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            if (qName.equals(ProfileStore.XML_NODE_SETTING)) {
                String key = attributes.getValue(ProfileStore.XML_ATTRIBUTE_ID);
                String value = attributes.getValue(ProfileStore.XML_ATTRIBUTE_VALUE);
                this.fSettings.put(key, value);
            } else if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fName = attributes.getValue(ProfileStore.XML_ATTRIBUTE_NAME);
                this.fKind = attributes.getValue(ProfileStore.XML_ATTRIBUTE_PROFILE_KIND);
                if (this.fKind == null) {
                    this.fKind = "CodeFormatterProfile";
                }
                this.fSettings = new HashMap(200);
            } else if (qName.equals(ProfileStore.XML_NODE_ROOT)) {
                this.fProfiles = new ArrayList();
                try {
                    this.fVersion = Integer.parseInt(attributes.getValue(ProfileStore.XML_ATTRIBUTE_VERSION));
                }
                catch (NumberFormatException ex) {
                    throw new SAXException(ex);
                }
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.equals(ProfileStore.XML_NODE_PROFILE)) {
                this.fProfiles.add(new ProfileManager.CustomProfile(this.fName, this.fSettings, this.fVersion, this.fKind));
                this.fName = null;
                this.fSettings = null;
                this.fKind = null;
            }
        }

        public List getProfiles() {
            return this.fProfiles;
        }
    }
}

