/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.ltk.ui.refactoring.UserInputWizardPage;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IMember;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PullUpRefactoring;
import org.eclipse.wst.jsdt.internal.corext.refactoring.structure.PullUpRefactoringProcessor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.corext.util.Strings;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.JavaSourceViewer;
import org.eclipse.wst.jsdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.wst.jsdt.internal.ui.util.ExceptionHandler;
import org.eclipse.wst.jsdt.internal.ui.util.SWTUtil;
import org.eclipse.wst.jsdt.ui.JavaScriptElementComparator;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;
import org.eclipse.wst.jsdt.ui.text.JavaScriptSourceViewerConfiguration;

public class PullUpMethodPage
extends UserInputWizardPage {
    private static final String PAGE_NAME = "PullUpMethodPage";
    private boolean fChangedSettings = true;
    private Label fSelectionLabel;
    private SourceViewer fSourceViewer;
    private ContainerCheckedTreeViewer fTreeViewer;
    private Label fTypeHierarchyLabel;

    private static Map createTypeToMemberArrayMapping(IMember[] members) {
        Map typeToMemberSet = PullUpMethodPage.createTypeToMemberSetMapping(members);
        HashMap<IType, IMember[]> typeToMemberArray = new HashMap<IType, IMember[]>();
        for (IType type : typeToMemberSet.keySet()) {
            Set memberSet = (Set)typeToMemberSet.get(type);
            IMember[] memberArray = memberSet.toArray(new IMember[memberSet.size()]);
            typeToMemberArray.put(type, memberArray);
        }
        return typeToMemberArray;
    }

    private static Map createTypeToMemberSetMapping(IMember[] members) {
        HashMap typeToMemberSet = new HashMap();
        int i = 0;
        while (i < members.length) {
            IMember member = members[i];
            IType type = member.getDeclaringType();
            if (!typeToMemberSet.containsKey(type)) {
                typeToMemberSet.put(type, new HashSet());
            }
            ((Set)typeToMemberSet.get(type)).add(member);
            ++i;
        }
        return typeToMemberSet;
    }

    public PullUpMethodPage() {
        super(PAGE_NAME);
        this.setMessage(RefactoringMessages.PullUpInputPage_select_methods);
    }

    private void checkAllParents(IType parent) {
        ITypeHierarchy th = this.getTreeInput();
        IType root = this.getTreeInput().getType();
        IType type = parent;
        while (!root.equals(type)) {
            this.fTreeViewer.setChecked((Object)type, true);
            type = th.getSuperclass(type);
        }
        this.fTreeViewer.setChecked((Object)root, true);
    }

    public void checkPulledUp() {
        this.uncheckAll();
        PullUpRefactoringProcessor processor = this.getPullUpRefactoring().getPullUpProcessor();
        this.fTreeViewer.setCheckedElements((Object[])processor.getMembersToMove());
        IType parent = processor.getDeclaringType();
        this.fTreeViewer.setChecked((Object)parent, true);
        this.checkAllParents(parent);
    }

    private void createButtonComposite(Composite superComposite) {
        Composite buttonComposite = new Composite(superComposite, 0);
        buttonComposite.setLayoutData((Object)new GridData(4, 1, true, false));
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        buttonComposite.setLayout((Layout)layout);
        this.fSelectionLabel = new Label(buttonComposite, 16704);
        GridData data = new GridData(1, 1, true, false);
        data.widthHint = this.convertWidthInCharsToPixels(32);
        this.fSelectionLabel.setLayoutData((Object)data);
        Button button = new Button(buttonComposite, 8);
        button.setText(RefactoringMessages.PullUpInputPage2_Select);
        button.setLayoutData((Object)new GridData());
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PullUpMethodPage.this.checkPulledUp();
                PullUpMethodPage.this.updateSelectionLabel();
            }
        });
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        this.createTreeAndSourceViewer(composite);
        this.createButtonComposite(composite);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getControl(), "org.eclipse.wst.jsdt.ui.pull_up_wizard_page_context");
    }

    private void createHierarchyTreeComposite(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        this.createTypeHierarchyLabel(composite);
        this.createTreeViewer(composite);
    }

    private void createSourceViewer(Composite c) {
        IPreferenceStore store = JavaScriptPlugin.getDefault().getCombinedPreferenceStore();
        this.fSourceViewer = new JavaSourceViewer(c, null, null, false, 68354, store);
        this.fSourceViewer.configure((SourceViewerConfiguration)new JavaScriptSourceViewerConfiguration(JavaScriptPlugin.getDefault().getJavaTextTools().getColorManager(), store, null, null));
        this.fSourceViewer.setEditable(false);
        this.fSourceViewer.getControl().setLayoutData((Object)new GridData(1808));
        this.fSourceViewer.getControl().setFont(JFaceResources.getFont((String)"org.eclipse.wst.jsdt.ui.editors.textfont"));
    }

    private void createSourceViewerComposite(Composite parent) {
        Composite c = new Composite(parent, 0);
        c.setLayoutData((Object)new GridData(1808));
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        c.setLayout((Layout)layout);
        this.createSourceViewerLabel(c);
        this.createSourceViewer(c);
    }

    private void createSourceViewerLabel(Composite c) {
        Label label = new Label(c, 64);
        GridData gd = new GridData(768);
        label.setText(RefactoringMessages.PullUpInputPage2_Source);
        label.setLayoutData((Object)gd);
    }

    private void createTreeAndSourceViewer(Composite superComposite) {
        SashForm composite = new SashForm(superComposite, 256);
        this.initializeDialogUnits((Control)superComposite);
        GridData gd = new GridData(1808);
        gd.heightHint = this.convertHeightInCharsToPixels(20);
        gd.widthHint = this.convertWidthInCharsToPixels(10);
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 1;
        layout.verticalSpacing = 1;
        composite.setLayout((Layout)layout);
        this.createHierarchyTreeComposite((Composite)composite);
        this.createSourceViewerComposite((Composite)composite);
        composite.setWeights(new int[]{50, 50});
    }

    private void createTreeViewer(Composite composite) {
        Tree tree = new Tree(composite, 2850);
        tree.setLayoutData((Object)new GridData(1808));
        this.fTreeViewer = new ContainerCheckedTreeViewer(tree);
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)new JavaScriptElementLabelProvider(274));
        this.fTreeViewer.setUseHashlookup(true);
        this.fTreeViewer.setComparator((ViewerComparator)new JavaScriptElementComparator());
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                PullUpMethodPage.this.treeViewerSelectionChanged(event);
            }
        });
        this.fTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                PullUpMethodPage.this.updateSelectionLabel();
            }
        });
    }

    private void createTypeHierarchyLabel(Composite composite) {
        this.fTypeHierarchyLabel = new Label(composite, 64);
        GridData gd = new GridData(768);
        this.fTypeHierarchyLabel.setLayoutData((Object)gd);
    }

    public void fireSettingsChanged() {
        this.fChangedSettings = true;
    }

    private IFunction[] getCheckedMethods() {
        Object[] checked = this.fTreeViewer.getCheckedElements();
        ArrayList<Object> members = new ArrayList<Object>(checked.length);
        int i = 0;
        while (i < checked.length) {
            if (checked[i] instanceof IFunction) {
                members.add(checked[i]);
            }
            ++i;
        }
        return members.toArray(new IFunction[members.size()]);
    }

    private ISourceReference getFirstSelectedSourceReference(SelectionChangedEvent event) {
        ISelection s = event.getSelection();
        if (!(s instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection ss = (IStructuredSelection)s;
        if (ss.size() != 1) {
            return null;
        }
        Object first = ss.getFirstElement();
        if (!(first instanceof ISourceReference)) {
            return null;
        }
        return (ISourceReference)first;
    }

    public IWizardPage getNextPage() {
        this.initializeRefactoring();
        return super.getNextPage();
    }

    private PullUpRefactoring getPullUpRefactoring() {
        return (PullUpRefactoring)this.getRefactoring();
    }

    private String getSupertypeSignature() {
        return JavaElementUtil.createSignature((IMember)this.getPullUpRefactoring().getPullUpProcessor().getDestinationType());
    }

    private ITypeHierarchy getTreeInput() {
        return (ITypeHierarchy)this.fTreeViewer.getInput();
    }

    private void initializeRefactoring() {
        this.getPullUpRefactoring().getPullUpProcessor().setDeletedMethods(this.getCheckedMethods());
    }

    private void initializeTreeViewer() {
        try {
            this.getContainer().run(false, false, new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) {
                    try {
                        PullUpMethodPage.this.initializeTreeViewer(pm);
                    }
                    finally {
                        pm.done();
                    }
                }
            });
        }
        catch (InvocationTargetException e) {
            ExceptionHandler.handle(e, this.getShell(), RefactoringMessages.PullUpInputPage_pull_Up, RefactoringMessages.PullUpInputPage_exception);
        }
        catch (InterruptedException e) {
            Assert.isTrue((boolean)false);
        }
    }

    private void initializeTreeViewer(IProgressMonitor pm) {
        try {
            try {
                pm.beginTask(RefactoringCoreMessages.PullUpRefactoring_checking, 2);
                PullUpRefactoringProcessor processor = this.getPullUpRefactoring().getPullUpProcessor();
                IMember[] matchingMethods = processor.getMatchingElements((IProgressMonitor)new SubProgressMonitor(pm, 1), false);
                ITypeHierarchy hierarchy = processor.getDestinationTypeHierarchy((IProgressMonitor)new SubProgressMonitor(pm, 1));
                this.removeAllTreeViewFilters();
                this.fTreeViewer.addFilter((ViewerFilter)new PullUpFilter(hierarchy, matchingMethods));
                this.fTreeViewer.setContentProvider((IContentProvider)new PullUpHierarchyContentProvider(processor.getDeclaringType(), matchingMethods));
                this.fTreeViewer.setInput((Object)hierarchy);
                this.precheckElements(this.fTreeViewer);
                this.fTreeViewer.expandAll();
                this.updateSelectionLabel();
            }
            catch (JavaScriptModelException e) {
                ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.PullUpInputPage_pull_up1, RefactoringMessages.PullUpInputPage_exception);
                this.fTreeViewer.setInput(null);
                pm.done();
            }
        }
        finally {
            pm.done();
        }
    }

    protected boolean performFinish() {
        this.initializeRefactoring();
        return super.performFinish();
    }

    private void precheckElements(ContainerCheckedTreeViewer treeViewer) {
        IMember[] members = this.getPullUpRefactoring().getPullUpProcessor().getMembersToMove();
        int i = 0;
        while (i < members.length) {
            treeViewer.setChecked((Object)members[i], true);
            ++i;
        }
    }

    private void removeAllTreeViewFilters() {
        ViewerFilter[] filters = this.fTreeViewer.getFilters();
        int i = 0;
        while (i < filters.length) {
            this.fTreeViewer.removeFilter(filters[i]);
            ++i;
        }
    }

    private void setHierarchyLabelText() {
        String message = Messages.format(RefactoringMessages.PullUpInputPage_subtypes, this.getSupertypeSignature());
        this.fTypeHierarchyLabel.setText(message);
    }

    private void setSourceViewerContents(String contents) {
        if (contents != null) {
            IJavaScriptProject project = this.getPullUpRefactoring().getPullUpProcessor().getDestinationType().getJavaScriptProject();
            String[] lines = Strings.convertIntoLines(contents);
            if (lines.length > 0) {
                int indent = Strings.computeIndentUnits(lines[lines.length - 1], project);
                contents = Strings.changeIndent(contents, indent, project, "", "\n");
            }
        }
        Document document = contents == null ? new Document() : new Document(contents);
        JavaScriptPlugin.getDefault().getJavaTextTools().setupJavaDocumentPartitioner((IDocument)document);
        this.fSourceViewer.setDocument((IDocument)document);
    }

    public void setVisible(boolean visible) {
        if (visible && this.fChangedSettings) {
            this.fChangedSettings = false;
            this.initializeTreeViewer();
            this.setHierarchyLabelText();
        }
        super.setVisible(visible);
    }

    private void showInSourceViewer(ISourceReference selected) throws JavaScriptModelException {
        if (selected == null) {
            this.setSourceViewerContents(null);
        } else {
            this.setSourceViewerContents(selected.getSource());
        }
    }

    private void treeViewerSelectionChanged(SelectionChangedEvent event) {
        try {
            this.showInSourceViewer(this.getFirstSelectedSourceReference(event));
        }
        catch (JavaScriptModelException e) {
            ExceptionHandler.handle((CoreException)((Object)e), RefactoringMessages.PullUpInputPage_pull_up1, RefactoringMessages.PullUpInputPage_see_log);
        }
    }

    private void uncheckAll() {
        IType root = this.getTreeInput().getType();
        this.fTreeViewer.setChecked((Object)root, false);
    }

    private void updateSelectionLabel() {
        this.fSelectionLabel.setText(Messages.format(RefactoringMessages.PullUpInputPage_hierarchyLabal, String.valueOf(this.getCheckedMethods().length)));
    }

    private static class PullUpFilter
    extends ViewerFilter {
        private final Set fTypesToShow;

        private static boolean anySubtypeCanBeShown(IType type, Map typeToMemberArray, ITypeHierarchy hierarchy) {
            IType[] subTypes = hierarchy.getSubclasses(type);
            int i = 0;
            while (i < subTypes.length) {
                if (PullUpFilter.canBeShown(subTypes[i], typeToMemberArray, hierarchy)) {
                    return true;
                }
                ++i;
            }
            return false;
        }

        private static boolean canBeShown(IType type, Map typeToMemberArray, ITypeHierarchy hierarchy) {
            if (typeToMemberArray.containsKey(type)) {
                return true;
            }
            return PullUpFilter.anySubtypeCanBeShown(type, typeToMemberArray, hierarchy);
        }

        private static Set computeShowableSubtypesOfMainType(ITypeHierarchy hierarchy, Map typeToMemberArray) {
            HashSet<IType> result = new HashSet<IType>();
            IType[] subtypes = hierarchy.getAllSubtypes(hierarchy.getType());
            int i = 0;
            while (i < subtypes.length) {
                IType subtype = subtypes[i];
                if (PullUpFilter.canBeShown(subtype, typeToMemberArray, hierarchy)) {
                    result.add(subtype);
                }
                ++i;
            }
            return result;
        }

        private static Set computeTypesToShow(ITypeHierarchy hierarchy, Map typeToMemberArray) {
            HashSet<IType> typesToShow = new HashSet<IType>();
            typesToShow.add(hierarchy.getType());
            typesToShow.addAll(PullUpFilter.computeShowableSubtypesOfMainType(hierarchy, typeToMemberArray));
            return typesToShow;
        }

        public PullUpFilter(ITypeHierarchy hierarchy, IMember[] members) {
            Map map = PullUpMethodPage.createTypeToMemberArrayMapping(members);
            this.fTypesToShow = PullUpFilter.computeTypesToShow(hierarchy, map);
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            if (element instanceof IFunction) {
                return true;
            }
            return this.fTypesToShow.contains(element);
        }
    }

    private static class PullUpHierarchyContentProvider
    implements ITreeContentProvider {
        private IType fDeclaringType;
        private ITypeHierarchy fHierarchy;
        private Map fTypeToMemberArray;

        public PullUpHierarchyContentProvider(IType declaringType, IMember[] members) {
            this.fDeclaringType = declaringType;
            this.fTypeToMemberArray = PullUpMethodPage.createTypeToMemberArrayMapping(members);
        }

        public void dispose() {
            this.fHierarchy = null;
            this.fTypeToMemberArray.clear();
            this.fTypeToMemberArray = null;
            this.fDeclaringType = null;
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof IType) {
                return this.getSubclassesAndMembers((IType)parentElement);
            }
            return new Object[0];
        }

        public Object[] getElements(Object inputElement) {
            Assert.isTrue((inputElement == null || inputElement instanceof ITypeHierarchy ? 1 : 0) != 0);
            return new IType[]{this.fHierarchy.getType()};
        }

        private IMember[] getMembers(IType type) {
            if (this.fTypeToMemberArray.containsKey(type)) {
                return (IMember[])this.fTypeToMemberArray.get(type);
            }
            return new IMember[0];
        }

        public Object getParent(Object element) {
            if (element instanceof IType) {
                return this.fHierarchy.getSuperclass((IType)element);
            }
            if (element instanceof IMember) {
                return ((IMember)element).getDeclaringType();
            }
            Assert.isTrue((boolean)false, (String)"Should not get here");
            return null;
        }

        private IType[] getSubclasses(IType type) {
            if (type.equals(this.fDeclaringType)) {
                return new IType[0];
            }
            return this.fHierarchy.getSubclasses(type);
        }

        private Object[] getSubclassesAndMembers(IType type) {
            HashSet<Object> set = new HashSet<Object>();
            set.addAll(Arrays.asList(this.getSubclasses(type)));
            set.addAll(Arrays.asList(this.getMembers(type)));
            return set.toArray();
        }

        public boolean hasChildren(Object element) {
            if (!(element instanceof IType)) {
                return false;
            }
            IType type = (IType)element;
            return this.fHierarchy.getAllSubtypes(type).length > 0 || this.fTypeToMemberArray.containsKey(type);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            Assert.isTrue((newInput == null || newInput instanceof ITypeHierarchy ? 1 : 0) != 0);
            this.fHierarchy = (ITypeHierarchy)newInput;
        }
    }
}

