/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.wst.jsdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.wst.jsdt.ui.JavaScriptElementComparator;
import org.eclipse.wst.jsdt.ui.JavaScriptElementLabelProvider;
import org.eclipse.wst.jsdt.ui.StandardJavaScriptElementContentProvider;

public class SourceContainerDialog
extends ElementTreeSelectionDialog {
    private SourceContainerDialog(Shell shell) {
        super(shell, (ILabelProvider)new JavaScriptElementLabelProvider(18), (ITreeContentProvider)new StandardJavaScriptElementContentProvider());
        this.setValidator(new PackageAndProjectSelectionValidator());
        this.setComparator(new JavaScriptElementComparator());
        this.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        this.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        this.addFilter(new JavaTypedViewerFilter());
    }

    public static IPackageFragmentRoot getSourceContainer(Shell shell, IWorkspaceRoot workspaceRoot, IJavaScriptElement initElement) {
        SourceContainerDialog dialog = new SourceContainerDialog(shell);
        dialog.setInput(JavaScriptCore.create((IWorkspaceRoot)workspaceRoot));
        dialog.setInitialSelection(initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaScriptProject) {
                IJavaScriptProject jproject = (IJavaScriptProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private class JavaTypedViewerFilter
    extends TypedViewerFilter {
        public JavaTypedViewerFilter() {
            super(new Class[]{IPackageFragmentRoot.class, IJavaScriptProject.class});
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)element;
                try {
                    return fragmentRoot.getKind() == 1;
                }
                catch (JavaScriptModelException e) {
                    return false;
                }
            }
            return super.select(viewer, parent, element);
        }
    }

    private class PackageAndProjectSelectionValidator
    extends TypedElementSelectionValidator {
        public PackageAndProjectSelectionValidator() {
            super(new Class[]{IPackageFragmentRoot.class}, false);
        }

        public boolean isSelectedValid(Object element) {
            try {
                if (element instanceof IJavaScriptProject) {
                    IJavaScriptProject jproject = (IJavaScriptProject)element;
                    IPath path = jproject.getProject().getFullPath();
                    return jproject.findPackageFragmentRoot(path) != null;
                }
                if (element instanceof IPackageFragmentRoot) {
                    return ((IPackageFragmentRoot)element).getKind() == 1;
                }
                return true;
            }
            catch (JavaScriptModelException javaScriptModelException) {
                return false;
            }
        }
    }
}

