/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.filebuffers.LocationKind;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Position;
import org.eclipse.search.ui.text.Match;
import org.eclipse.wst.jsdt.core.IField;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.ISourceReference;
import org.eclipse.wst.jsdt.core.ToolFactory;
import org.eclipse.wst.jsdt.core.compiler.IScanner;
import org.eclipse.wst.jsdt.core.compiler.InvalidInputException;
import org.eclipse.wst.jsdt.core.search.SearchMatch;
import org.eclipse.wst.jsdt.core.search.SearchRequestor;
import org.eclipse.wst.jsdt.internal.corext.refactoring.nls.PropertyFileDocumentModel;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.FileEntry;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.LineReader;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchMessages;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.NLSSearchResult;
import org.eclipse.wst.jsdt.internal.ui.refactoring.nls.search.Properties;
import org.eclipse.wst.jsdt.internal.ui.util.StringMatcher;

class NLSSearchResultRequestor
extends SearchRequestor {
    private static final StringMatcher fgGetClassNameMatcher = new StringMatcher("*.class.getName()*", false, false);
    private NLSSearchResult fResult;
    private IFile fPropertiesFile;
    private Properties fProperties;
    private HashSet fUsedPropertyNames;

    public NLSSearchResultRequestor(IFile propertiesFile, NLSSearchResult result) {
        this.fPropertiesFile = propertiesFile;
        this.fResult = result;
    }

    public void beginReporting() {
        this.loadProperties();
        this.fUsedPropertyNames = new HashSet(this.fProperties.size());
    }

    public void acceptSearchMatch(SearchMatch match) throws CoreException {
        String source;
        IField field;
        String source2;
        if (match.getAccuracy() == 1) {
            return;
        }
        int offset = match.getOffset();
        int length = match.getLength();
        if (offset == -1 || length == -1) {
            return;
        }
        if (!(match.getElement() instanceof IJavaScriptElement)) {
            return;
        }
        IJavaScriptElement javaElement = (IJavaScriptElement)match.getElement();
        if (javaElement.getElementType() == 13) {
            return;
        }
        if (javaElement.getElementType() == 6) {
            return;
        }
        if (javaElement.getElementType() == 7) {
            return;
        }
        if (javaElement.getElementType() == 8 && (source2 = (field = (IField)javaElement).getSource()) != null && fgGetClassNameMatcher.match(source2)) {
            return;
        }
        if (javaElement instanceof ISourceReference && (source = ((ISourceReference)javaElement).getSource()) != null && source.indexOf("NLS.initializeMessages") != -1) {
            return;
        }
        Position mutableKeyPosition = new Position(offset, length);
        String key = this.findKey(mutableKeyPosition, javaElement);
        if (key != null && this.isKeyDefined(key)) {
            return;
        }
        IJavaScriptUnit[] allCompilationUnits = JavaModelUtil.getAllCompilationUnits(new IJavaScriptElement[]{javaElement});
        IJavaScriptElement element = javaElement;
        if (allCompilationUnits != null && allCompilationUnits.length == 1) {
            element = allCompilationUnits[0];
        }
        this.fResult.addMatch(new Match((Object)element, mutableKeyPosition.getOffset(), mutableKeyPosition.getLength()));
    }

    public void reportUnusedPropertyNames(IProgressMonitor pm) {
        pm.beginTask("", this.fProperties.size());
        boolean hasUnused = false;
        pm.setTaskName(NLSSearchMessages.NLSSearchResultRequestor_searching);
        String message = Messages.format(NLSSearchMessages.NLSSearchResultCollector_unusedKeys, this.getPropertiesName(this.fPropertiesFile));
        FileEntry groupElement = new FileEntry(this.fPropertiesFile, message);
        Enumeration<?> enumeration = this.fProperties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String propertyName = (String)enumeration.nextElement();
            if (!this.fUsedPropertyNames.contains(propertyName)) {
                this.addMatch(groupElement, propertyName);
                hasUnused = true;
            }
            pm.worked(1);
        }
        if (hasUnused) {
            this.fResult.addFileEntryGroup(groupElement);
        }
        pm.done();
    }

    private String getPropertiesName(IFile propertiesFile) {
        String path = propertiesFile.getFullPath().removeLastSegments(1).toOSString();
        return String.valueOf(propertiesFile.getName()) + " - " + path;
    }

    private void addMatch(FileEntry groupElement, String propertyName) {
        int length;
        String escapedPropertyName = PropertyFileDocumentModel.unwindEscapeChars(propertyName);
        int start = this.findPropertyNameStartPosition(escapedPropertyName);
        if (start == -1) {
            start = 0;
            length = 0;
        } else {
            length = escapedPropertyName.length();
        }
        this.fResult.addMatch(new Match((Object)groupElement, start, length));
    }

    private boolean isKeyDefined(String key) {
        if (key == null) {
            return true;
        }
        this.fUsedPropertyNames.add(key);
        return this.fProperties.getProperty(key) != null;
    }

    public boolean hasPropertyKey(String key) {
        return this.fProperties.containsKey(key);
    }

    public boolean isUsedPropertyKey(String key) {
        return this.fUsedPropertyNames.contains(key);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String findKey(Position keyPositionResult, IJavaScriptElement enclosingElement) throws CoreException {
        IJavaScriptUnit unit = (IJavaScriptUnit)enclosingElement.getAncestor(5);
        if (unit == null) {
            return null;
        }
        String source = unit.getSource();
        if (source == null) {
            return null;
        }
        IScanner scanner = ToolFactory.createScanner((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(source.toCharArray());
        scanner.resetTo(keyPositionResult.getOffset() + keyPositionResult.getLength(), source.length());
        try {
            if (scanner.getNextToken() != 6) {
                return null;
            }
            if (scanner.getNextToken() != 5) {
                return null;
            }
            String src = new String(scanner.getCurrentTokenSource());
            int keyStart = scanner.getCurrentTokenStartPosition();
            int keyEnd = scanner.getCurrentTokenEndPosition();
            if (scanner.getNextToken() != 7) {
                keyPositionResult.setOffset(keyStart);
                keyPositionResult.setLength(keyEnd - keyStart + 1);
                return src;
            }
            if (scanner.getNextToken() != 45) {
                return null;
            }
            keyStart = scanner.getCurrentTokenStartPosition() + 1;
            keyEnd = scanner.getCurrentTokenEndPosition();
            keyPositionResult.setOffset(keyStart);
            keyPositionResult.setLength(keyEnd - keyStart);
            return source.substring(keyStart, keyEnd);
        }
        catch (InvalidInputException e) {
            return null;
        }
    }

    private int findPropertyNameStartPosition(String propertyName) {
        String encoding;
        InputStream stream = null;
        LineReader lineReader = null;
        try {
            encoding = this.fPropertiesFile.getCharset();
        }
        catch (CoreException e1) {
            encoding = "ISO-8859-1";
        }
        try {
            stream = this.createInputStream(this.fPropertiesFile);
            lineReader = new LineReader(stream, encoding);
        }
        catch (CoreException cex) {
            JavaScriptPlugin.log(cex);
            return -1;
        }
        catch (IOException e) {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException ce) {
                    JavaScriptPlugin.log(ce);
                }
            }
            return -1;
        }
        int start = 0;
        try {
            try {
                StringBuffer buf = new StringBuffer(80);
                int eols = lineReader.readLine(buf);
                int keyLength = propertyName.length();
                while (eols > 0) {
                    boolean hasNoValue;
                    String line = buf.toString();
                    int i = line.indexOf(propertyName);
                    int charPos = i + keyLength;
                    char terminatorChar = '\u0000';
                    boolean bl = hasNoValue = charPos >= line.length();
                    if (i > -1 && !hasNoValue) {
                        terminatorChar = line.charAt(charPos);
                    }
                    if (line.trim().startsWith(propertyName) && (hasNoValue || Character.isWhitespace(terminatorChar) || terminatorChar == '=')) {
                        start += line.indexOf(propertyName);
                        eols = -17;
                        continue;
                    }
                    start += line.length() + eols;
                    buf.setLength(0);
                    eols = lineReader.readLine(buf);
                }
                if (eols != -17) {
                    start = -1;
                }
            }
            catch (IOException ex) {
                JavaScriptPlugin.log(ex);
                try {
                    lineReader.close();
                }
                catch (IOException ex2) {
                    JavaScriptPlugin.log(ex2);
                }
                return -1;
            }
        }
        finally {
            try {
                lineReader.close();
            }
            catch (IOException ex) {
                JavaScriptPlugin.log(ex);
            }
        }
        return start;
    }

    private void loadProperties() {
        BufferedInputStream stream;
        HashSet duplicateKeys = new HashSet();
        this.fProperties = new Properties(duplicateKeys);
        try {
            stream = new BufferedInputStream(this.createInputStream(this.fPropertiesFile));
        }
        catch (CoreException ex) {
            this.fProperties = new Properties();
            return;
        }
        try {
            try {
                this.fProperties.load(stream);
            }
            catch (IOException ex) {
                this.fProperties = new Properties();
                try {
                    ((InputStream)stream).close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.reportDuplicateKeys(duplicateKeys);
                return;
            }
        }
        finally {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
            this.reportDuplicateKeys(duplicateKeys);
        }
    }

    private InputStream createInputStream(IFile propertiesFile) throws CoreException {
        ITextFileBuffer buffer;
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        if (manager != null && (buffer = manager.getTextFileBuffer(propertiesFile.getFullPath(), LocationKind.IFILE)) != null) {
            return new ByteArrayInputStream(buffer.getDocument().get().getBytes());
        }
        return propertiesFile.getContents();
    }

    private void reportDuplicateKeys(Set duplicateKeys) {
        if (duplicateKeys.size() == 0) {
            return;
        }
        String message = Messages.format(NLSSearchMessages.NLSSearchResultCollector_duplicateKeys, this.getPropertiesName(this.fPropertiesFile));
        FileEntry groupElement = new FileEntry(this.fPropertiesFile, message);
        for (String propertyName : duplicateKeys) {
            this.addMatch(groupElement, propertyName);
        }
        this.fResult.addFileEntryGroup(groupElement);
    }
}

