/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.refactoring.reorg;

import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IEditingSupport;
import org.eclipse.jface.text.IEditingSupportRegistry;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedModeUI;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;
import org.eclipse.wst.jsdt.core.IFunction;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.JavaScriptConventions;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.refactoring.descriptors.RenameJavaScriptElementDescriptor;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.EditorUtility;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.RenameInformationPopup;
import org.eclipse.wst.jsdt.internal.ui.refactoring.reorg.ReorgMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.LinkedNamesAssistProposal;
import org.eclipse.wst.jsdt.ui.refactoring.RenameSupport;

public class RenameLinkedMode {
    private static RenameLinkedMode fgActiveLinkedMode;
    private final CompilationUnitEditor fEditor;
    private final IJavaScriptElement fJavaElement;
    private RenameInformationPopup fInfoPopup;
    private boolean fOriginalSaved;
    private Point fOriginalSelection;
    private String fOriginalName;
    private LinkedPosition fNamePosition;
    private LinkedModeModel fLinkedModeModel;
    private LinkedPositionGroup fLinkedPositionGroup;
    private final FocusEditingSupport fFocusEditingSupport;
    private boolean fShowPreview;

    public RenameLinkedMode(IJavaScriptElement element, CompilationUnitEditor editor) {
        Assert.isNotNull((Object)element);
        Assert.isNotNull((Object)editor);
        this.fEditor = editor;
        this.fJavaElement = element;
        this.fFocusEditingSupport = new FocusEditingSupport();
    }

    public static RenameLinkedMode getActiveLinkedMode() {
        if (fgActiveLinkedMode != null) {
            StyledText textWidget;
            ISourceViewer viewer = RenameLinkedMode.fgActiveLinkedMode.fEditor.getViewer();
            if (viewer != null && (textWidget = viewer.getTextWidget()) != null && !textWidget.isDisposed()) {
                return fgActiveLinkedMode;
            }
            fgActiveLinkedMode = null;
        }
        return null;
    }

    public void start() {
        if (RenameLinkedMode.getActiveLinkedMode() != null) {
            fgActiveLinkedMode.startFullDialog();
            return;
        }
        this.fOriginalSaved = !this.fEditor.isDirty();
        ISourceViewer viewer = this.fEditor.getViewer();
        IDocument document = viewer.getDocument();
        this.fOriginalSelection = viewer.getSelectedRange();
        int offset = this.fOriginalSelection.x;
        try {
            JavaScriptUnit root = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)this.getCompilationUnit(), ASTProvider.WAIT_YES, null);
            this.fLinkedPositionGroup = new LinkedPositionGroup();
            ASTNode selectedNode = NodeFinder.perform((ASTNode)root, this.fOriginalSelection.x, this.fOriginalSelection.y);
            if (!(selectedNode instanceof SimpleName)) {
                return;
            }
            SimpleName nameNode = (SimpleName)selectedNode;
            this.fOriginalName = nameNode.getIdentifier();
            final int pos = nameNode.getStartPosition();
            SimpleName[] sameNodes = LinkedNodeFinder.findByNode((ASTNode)root, nameNode);
            Arrays.sort(sameNodes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return this.rank((ASTNode)o1) - this.rank((ASTNode)o2);
                }

                private int rank(ASTNode node) {
                    int relativeRank = node.getStartPosition() + node.getLength() - pos;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            int i = 0;
            while (i < sameNodes.length) {
                SimpleName elem = sameNodes[i];
                LinkedPosition linkedPosition = new LinkedPosition(document, elem.getStartPosition(), elem.getLength(), i);
                if (i == 0) {
                    this.fNamePosition = linkedPosition;
                }
                this.fLinkedPositionGroup.addPosition(linkedPosition);
                ++i;
            }
            this.fLinkedModeModel = new LinkedModeModel();
            this.fLinkedModeModel.addGroup(this.fLinkedPositionGroup);
            this.fLinkedModeModel.forceInstall();
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(this.fEditor));
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorSynchronizer());
            EditorLinkedModeUI ui = new EditorLinkedModeUI(this.fLinkedModeModel, (ITextViewer)viewer);
            ui.setExitPosition((ITextViewer)viewer, offset, 0, Integer.MAX_VALUE);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(document));
            ui.enter();
            viewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
            if (viewer instanceof IEditingSupportRegistry) {
                IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
                registry.register((IEditingSupport)this.fFocusEditingSupport);
            }
            this.openSecondaryPopup();
            fgActiveLinkedMode = this;
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
    }

    public void start(int offset, int length) {
        ISourceViewer viewer = this.fEditor.getViewer();
        IDocument document = viewer.getDocument();
        int cursorPosition = viewer.getSelectedRange().x;
        viewer.setSelectedRange(offset, length);
        try {
            JavaScriptUnit root = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)this.getCompilationUnit(), ASTProvider.WAIT_YES, null);
            this.fLinkedPositionGroup = new LinkedPositionGroup();
            ASTNode selectedNode = NodeFinder.perform((ASTNode)root, offset, length);
            if (!(selectedNode instanceof SimpleName)) {
                return;
            }
            SimpleName nameNode = (SimpleName)selectedNode;
            LinkedPosition linkedPosition = new LinkedPosition(document, nameNode.getStartPosition(), nameNode.getLength());
            this.fLinkedPositionGroup.addPosition(linkedPosition);
            this.fLinkedModeModel = new LinkedModeModel();
            this.fLinkedModeModel.addGroup(this.fLinkedPositionGroup);
            this.fLinkedModeModel.forceInstall();
            this.fLinkedModeModel.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(this.fEditor));
            EditorLinkedModeUI ui = new EditorLinkedModeUI(this.fLinkedModeModel, (ITextViewer)viewer);
            ui.setExitPosition((ITextViewer)viewer, cursorPosition, 0, Integer.MAX_VALUE);
            ui.setExitPolicy((LinkedModeUI.IExitPolicy)new ExitPolicy(document));
            ui.enter();
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
    }

    void doRename(boolean showPreview) {
        this.cancel();
        Image image = null;
        Label label = null;
        this.fShowPreview |= showPreview;
        try {
            String newName;
            SourceViewer sourceViewer;
            Control viewerControl;
            ISourceViewer viewer = this.fEditor.getViewer();
            if (viewer instanceof SourceViewer && (viewerControl = (sourceViewer = (SourceViewer)viewer).getControl()) instanceof Composite) {
                Point size;
                Composite composite = (Composite)viewerControl;
                Display display = composite.getDisplay();
                while (!display.isDisposed() && display.readAndDispatch()) {
                }
                GC gc = new GC((Drawable)composite);
                try {
                    size = composite.getSize();
                    image = new Image(gc.getDevice(), size.x, size.y);
                    gc.copyArea(image, 0, 0);
                }
                finally {
                    gc.dispose();
                    gc = null;
                }
                label = new Label(composite, 0);
                label.setImage(image);
                label.setBounds(0, 0, size.x, size.y);
                label.moveAbove(null);
            }
            if (this.fOriginalName.equals(newName = this.fNamePosition.getContent())) {
                return;
            }
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
            if (renameSupport == null) {
                return;
            }
            try {
                boolean executed;
                Shell shell = this.fEditor.getSite().getShell();
                if (this.fShowPreview) {
                    executed = renameSupport.openDialog(shell, true);
                } else {
                    renameSupport.perform(shell, (IRunnableContext)this.fEditor.getSite().getWorkbenchWindow());
                    executed = true;
                }
                if (executed) {
                    this.restoreFullSelection();
                }
                JavaModelUtil.reconcile(this.getCompilationUnit());
            }
            catch (CoreException ex) {
                JavaScriptPlugin.log(ex);
            }
            catch (InterruptedException ex) {
            }
            catch (InvocationTargetException ex) {
                JavaScriptPlugin.log(ex);
            }
            catch (BadLocationException e) {
                JavaScriptPlugin.log(e);
            }
        }
        finally {
            if (label != null) {
                label.dispose();
            }
            if (image != null) {
                image.dispose();
            }
        }
    }

    public void cancel() {
        if (this.fLinkedModeModel != null) {
            this.fLinkedModeModel.exit(0);
        }
        this.linkedModeLeft();
    }

    private void restoreFullSelection() {
        if (this.fOriginalSelection.y != 0) {
            int originalOffset = this.fOriginalSelection.x;
            LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
            int i = 0;
            while (i < positions.length) {
                LinkedPosition position = positions[i];
                if (!position.isDeleted() && position.includes(originalOffset)) {
                    this.fEditor.getViewer().setSelectedRange(position.offset, position.length);
                    return;
                }
                ++i;
            }
        }
    }

    private RenameSupport undoAndCreateRenameSupport(String newName) throws CoreException {
        ISourceViewer viewer = this.fEditor.getViewer();
        final IDocument document = viewer.getDocument();
        try {
            try {
                if (!this.fOriginalName.equals(newName)) {
                    this.fEditor.getSite().getWorkbenchWindow().run(false, true, new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            LinkedPosition[] positions = RenameLinkedMode.this.fLinkedPositionGroup.getPositions();
                            Arrays.sort(positions, new Comparator(){

                                public int compare(Object o1, Object o2) {
                                    return ((LinkedPosition)o1).offset - ((LinkedPosition)o2).offset;
                                }
                            });
                            int correction = 0;
                            int originalLength = RenameLinkedMode.this.fOriginalName.length();
                            int i = 0;
                            while (i < positions.length) {
                                LinkedPosition position = positions[i];
                                try {
                                    int length = position.getLength();
                                    document.replace(position.getOffset() + correction, length, RenameLinkedMode.this.fOriginalName);
                                    correction = correction - length + originalLength;
                                }
                                catch (BadLocationException e) {
                                    throw new InvocationTargetException(e);
                                }
                                ++i;
                            }
                            if (RenameLinkedMode.this.fOriginalSaved) {
                                RenameLinkedMode.this.fEditor.doSave(monitor);
                            }
                        }
                    });
                }
            }
            catch (InvocationTargetException e) {
                throw new CoreException((IStatus)new Status(4, JavaScriptPlugin.getPluginId(), ReorgMessages.RenameLinkedMode_error_saving_editor, (Throwable)e));
            }
            catch (InterruptedException e) {
                JavaModelUtil.reconcile(this.getCompilationUnit());
                return null;
            }
        }
        finally {
            JavaModelUtil.reconcile(this.getCompilationUnit());
        }
        viewer.setSelectedRange(this.fOriginalSelection.x, this.fOriginalSelection.y);
        RenameJavaScriptElementDescriptor descriptor = this.createRenameDescriptor(this.fJavaElement, newName);
        RenameSupport renameSupport = RenameSupport.create(descriptor);
        return renameSupport;
    }

    private IJavaScriptUnit getCompilationUnit() {
        return (IJavaScriptUnit)EditorUtility.getEditorInputJavaElement((IEditorPart)this.fEditor, false);
    }

    public void startFullDialog() {
        this.cancel();
        try {
            String newName = this.fNamePosition.getContent();
            RenameSupport renameSupport = this.undoAndCreateRenameSupport(newName);
            if (renameSupport != null) {
                renameSupport.openDialog(this.fEditor.getSite().getShell());
            }
        }
        catch (CoreException e) {
            JavaScriptPlugin.log(e);
        }
        catch (BadLocationException e) {
            JavaScriptPlugin.log(e);
        }
    }

    private RenameJavaScriptElementDescriptor createRenameDescriptor(IJavaScriptElement javaElement, String newName) throws JavaScriptModelException {
        IDialogSettings javaSettings;
        IDialogSettings refactoringSettings;
        String contributionId;
        int elementType = javaElement.getElementType();
        switch (elementType) {
            case 2: {
                contributionId = "org.eclipse.wst.jsdt.ui.rename.java.project";
                break;
            }
            case 3: {
                contributionId = "org.eclipse.wst.jsdt.ui.rename.source.folder";
                break;
            }
            case 4: {
                contributionId = "org.eclipse.wst.jsdt.ui.rename.package";
                break;
            }
            case 5: {
                contributionId = "org.eclipse.wst.jsdt.ui.rename.compilationunit";
                break;
            }
            case 7: {
                contributionId = "org.eclipse.wst.jsdt.ui.rename.type";
                break;
            }
            case 9: {
                IFunction method = (IFunction)javaElement;
                if (method.isConstructor()) {
                    return this.createRenameDescriptor((IJavaScriptElement)method.getDeclaringType(), newName);
                }
                contributionId = "org.eclipse.wst.jsdt.ui.rename.method";
                break;
            }
            case 8: {
                contributionId = "org.eclipse.wst.jsdt.ui.rename.field";
                break;
            }
            case 14: {
                contributionId = "org.eclipse.wst.jsdt.ui.rename.local.variable";
                break;
            }
            default: {
                return null;
            }
        }
        RenameJavaScriptElementDescriptor descriptor = (RenameJavaScriptElementDescriptor)RefactoringCore.getRefactoringContribution((String)contributionId).createDescriptor();
        descriptor.setJavaElement(javaElement);
        descriptor.setNewName(newName);
        if (elementType != 3) {
            descriptor.setUpdateReferences(true);
        }
        if ((refactoringSettings = (javaSettings = JavaScriptPlugin.getDefault().getDialogSettings()).getSection("org.eclipse.ltk.ui.refactoring.settings")) == null) {
            refactoringSettings = javaSettings.addNewSection("org.eclipse.ltk.ui.refactoring.settings");
        }
        switch (elementType) {
            case 8: 
            case 9: {
                descriptor.setDeprecateDelegate(refactoringSettings.getBoolean("delegateDeprecation"));
                descriptor.setKeepOriginal(refactoringSettings.getBoolean("delegateUpdating"));
            }
        }
        switch (elementType) {
            case 7: {
                int strategy;
                descriptor.setUpdateSimilarDeclarations(refactoringSettings.getBoolean("updateSimilarElements"));
                try {
                    strategy = refactoringSettings.getInt("updateSimilarElementsMatchStrategy");
                }
                catch (NumberFormatException e) {
                    strategy = 1;
                }
                descriptor.setMatchStrategy(strategy);
            }
        }
        switch (elementType) {
            case 4: {
                descriptor.setUpdateHierarchy(refactoringSettings.getBoolean("renameSubpackages"));
            }
        }
        switch (elementType) {
            case 4: 
            case 7: {
                String fileNamePatterns = refactoringSettings.get("patterns");
                if (fileNamePatterns == null || fileNamePatterns.length() == 0) break;
                descriptor.setFileNamePatterns(fileNamePatterns);
                boolean updateQualifiedNames = refactoringSettings.getBoolean("updateQualifiedNames");
                descriptor.setUpdateQualifiedNames(updateQualifiedNames);
                this.fShowPreview |= updateQualifiedNames;
            }
        }
        switch (elementType) {
            case 4: 
            case 7: 
            case 8: {
                boolean updateTextualOccurrences = refactoringSettings.getBoolean("updateTextualMatches");
                descriptor.setUpdateTextualOccurrences(updateTextualOccurrences);
                this.fShowPreview |= updateTextualOccurrences;
            }
        }
        switch (elementType) {
            case 8: {
                descriptor.setRenameGetters(refactoringSettings.getBoolean("renameGetter"));
                descriptor.setRenameSetters(refactoringSettings.getBoolean("renameSetter"));
            }
        }
        return descriptor;
    }

    private void linkedModeLeft() {
        ISourceViewer viewer;
        fgActiveLinkedMode = null;
        if (this.fInfoPopup != null) {
            this.fInfoPopup.close();
        }
        if ((viewer = this.fEditor.getViewer()) instanceof IEditingSupportRegistry) {
            IEditingSupportRegistry registry = (IEditingSupportRegistry)viewer;
            registry.unregister((IEditingSupport)this.fFocusEditingSupport);
        }
    }

    private void openSecondaryPopup() {
        this.fInfoPopup = new RenameInformationPopup(this.fEditor, this);
        this.fInfoPopup.open();
    }

    public boolean isCaretInLinkedPosition() {
        return this.getCurrentLinkedPosition() != null;
    }

    public LinkedPosition getCurrentLinkedPosition() {
        Point selection = this.fEditor.getViewer().getSelectedRange();
        int start = selection.x;
        int end = start + selection.y;
        LinkedPosition[] positions = this.fLinkedPositionGroup.getPositions();
        int i = 0;
        while (i < positions.length) {
            LinkedPosition position = positions[i];
            if (position.includes(start) && position.includes(end)) {
                return position;
            }
            ++i;
        }
        return null;
    }

    public boolean isEnabled() {
        String newName;
        block3: {
            try {
                newName = this.fNamePosition.getContent();
                if (!this.fOriginalName.equals(newName)) break block3;
                return false;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        IJavaScriptProject project = this.fJavaElement.getJavaScriptProject();
        String sourceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.source", true);
        String complianceLevel = project.getOption("org.eclipse.wst.jsdt.core.compiler.compliance", true);
        return JavaScriptConventions.validateIdentifier((String)newName, (String)sourceLevel, (String)complianceLevel).isOK();
    }

    public boolean isOriginalName() {
        try {
            String newName = this.fNamePosition.getContent();
            return this.fOriginalName.equals(newName);
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    private class EditorSynchronizer
    implements ILinkedModeListener {
        private EditorSynchronizer() {
        }

        public void left(LinkedModeModel model, int flags) {
            RenameLinkedMode.this.linkedModeLeft();
            if ((flags & 2) != 0) {
                RenameLinkedMode.this.doRename(RenameLinkedMode.this.fShowPreview);
            }
        }

        public void resume(LinkedModeModel model, int flags) {
        }

        public void suspend(LinkedModeModel model) {
        }
    }

    private class ExitPolicy
    extends LinkedNamesAssistProposal.DeleteBlockingExitPolicy {
        public ExitPolicy(IDocument document) {
            super(document);
        }

        public LinkedModeUI.ExitFlags doExit(LinkedModeModel model, VerifyEvent event, int offset, int length) {
            RenameLinkedMode renameLinkedMode = RenameLinkedMode.this;
            renameLinkedMode.fShowPreview = renameLinkedMode.fShowPreview | (event.stateMask & 0x40000) != 0;
            return super.doExit(model, event, offset, length);
        }
    }

    private class FocusEditingSupport
    implements IEditingSupport {
        private FocusEditingSupport() {
        }

        public boolean ownsFocusShell() {
            Shell activeShell;
            if (RenameLinkedMode.this.fInfoPopup == null) {
                return false;
            }
            if (RenameLinkedMode.this.fInfoPopup.ownsFocusShell()) {
                return true;
            }
            Shell editorShell = RenameLinkedMode.this.fEditor.getSite().getShell();
            return editorShell == (activeShell = editorShell.getDisplay().getActiveShell());
        }

        public boolean isOriginator(DocumentEvent event, IRegion subjectRegion) {
            return false;
        }
    }
}

