/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.search;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.IEditorMatchAdapter;
import org.eclipse.search.ui.text.IFileMatchAdapter;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.IClassFileEditorInput;
import org.eclipse.wst.jsdt.internal.ui.search.JavaElementLine;
import org.eclipse.wst.jsdt.internal.ui.search.OccurrencesSearchQuery;

public class OccurrencesSearchResult
extends AbstractTextSearchResult
implements IEditorMatchAdapter,
IFileMatchAdapter {
    protected static final Match[] NO_MATCHES = new Match[0];
    private OccurrencesSearchQuery fQuery;

    public OccurrencesSearchResult(OccurrencesSearchQuery query) {
        this.fQuery = query;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IFile file) {
        Object[] elements = this.getElements();
        if (elements.length == 0) {
            return NO_MATCHES;
        }
        JavaElementLine jel = (JavaElementLine)elements[0];
        try {
            if (file.equals((Object)jel.getJavaElement().getCorrespondingResource())) {
                return this.collectMatches(elements);
            }
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
        return NO_MATCHES;
    }

    public Match[] computeContainedMatches(AbstractTextSearchResult result, IEditorPart editor) {
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            IFileEditorInput fileEditorInput = (IFileEditorInput)editorInput;
            return this.computeContainedMatches(result, fileEditorInput.getFile());
        }
        if (editorInput instanceof IClassFileEditorInput) {
            IClassFileEditorInput classFileEditorInput = (IClassFileEditorInput)editorInput;
            IClassFile classFile = classFileEditorInput.getClassFile();
            Object[] elements = this.getElements();
            if (elements.length == 0) {
                return NO_MATCHES;
            }
            JavaElementLine jel = (JavaElementLine)elements[0];
            if (jel.getJavaElement().equals(classFile)) {
                return this.collectMatches(elements);
            }
        }
        return NO_MATCHES;
    }

    public IFile getFile(Object element) {
        JavaElementLine jel = (JavaElementLine)element;
        IResource resource = null;
        try {
            resource = jel.getJavaElement().getCorrespondingResource();
        }
        catch (JavaScriptModelException javaScriptModelException) {
            // empty catch block
        }
        if (resource instanceof IFile) {
            return (IFile)resource;
        }
        return null;
    }

    public boolean isShownInEditor(Match match, IEditorPart editor) {
        Object element = match.getElement();
        IJavaScriptElement je = ((JavaElementLine)element).getJavaElement();
        IEditorInput editorInput = editor.getEditorInput();
        if (editorInput instanceof IFileEditorInput) {
            try {
                return ((IFileEditorInput)editorInput).getFile().equals((Object)je.getCorrespondingResource());
            }
            catch (JavaScriptModelException e) {
                return false;
            }
        }
        if (editorInput instanceof IClassFileEditorInput) {
            return ((IClassFileEditorInput)editorInput).getClassFile().equals(je);
        }
        return false;
    }

    public String getLabel() {
        return this.fQuery.getResultLabel(this.getMatchCount());
    }

    public String getTooltip() {
        return this.getLabel();
    }

    public ImageDescriptor getImageDescriptor() {
        return JavaPluginImages.DESC_OBJS_SEARCH_REF;
    }

    public ISearchQuery getQuery() {
        return this.fQuery;
    }

    public IFileMatchAdapter getFileMatchAdapter() {
        return this;
    }

    public IEditorMatchAdapter getEditorMatchAdapter() {
        return this;
    }

    private Match[] collectMatches(Object[] elements) {
        Match[] matches = new Match[this.getMatchCount()];
        int writeIndex = 0;
        int i = 0;
        while (i < elements.length) {
            Match[] perElement = this.getMatches(elements[i]);
            int j = 0;
            while (j < perElement.length) {
                matches[writeIndex++] = perElement[j];
                ++j;
            }
            ++i;
        }
        return matches;
    }
}

