/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.reconciler.DirtyRegion;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.CompilationUnitEditor;
import org.eclipse.wst.jsdt.internal.ui.text.JavaCompositeReconcilingStrategy;

public class JavaReconciler
extends MonoReconciler {
    private ITextEditor fTextEditor;
    private IPartListener fPartListener;
    private ShellListener fActivationListener;
    private Object fMutex;
    private IElementChangedListener fJavaElementChangedListener;
    private volatile boolean fHasJavaModelChanged = true;
    private volatile boolean fIsEditorActive = true;
    private IResourceChangeListener fResourceChangeListener;
    private IPropertyChangeListener fPropertyChangeListener;
    private volatile boolean fIsReconciling = false;
    private boolean fIninitalProcessDone = false;

    public JavaReconciler(ITextEditor editor, JavaCompositeReconcilingStrategy strategy, boolean isIncremental) {
        super((IReconcilingStrategy)strategy, isIncremental);
        this.fTextEditor = editor;
        this.fMutex = editor instanceof CompilationUnitEditor ? ((CompilationUnitEditor)editor).getReconcilerLock() : new Object();
    }

    public void install(ITextViewer textViewer) {
        super.install(textViewer);
        this.fPartListener = new PartListener();
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().addPartListener(this.fPartListener);
        this.fActivationListener = new ActivationListener((Control)textViewer.getTextWidget());
        Shell shell = window.getShell();
        shell.addShellListener(this.fActivationListener);
        this.fJavaElementChangedListener = new ElementChangedListener();
        JavaScriptCore.addElementChangedListener((IElementChangedListener)this.fJavaElementChangedListener);
        this.fResourceChangeListener = new ResourceChangeListener();
        IWorkspace workspace = JavaScriptPlugin.getWorkspace();
        workspace.addResourceChangeListener(this.fResourceChangeListener);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("spellingEnabled".equals(event.getProperty()) || "spellingEngine".equals(event.getProperty()) || "semanticValidation".equals(event.getProperty()) || "strictOnKeywordUsage".equals(event.getProperty())) {
                    JavaReconciler.this.forceReconciling();
                }
            }
        };
        JavaScriptPlugin.getDefault().getCombinedPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public void uninstall() {
        IWorkbenchPartSite site = this.fTextEditor.getSite();
        IWorkbenchWindow window = site.getWorkbenchWindow();
        window.getPartService().removePartListener(this.fPartListener);
        this.fPartListener = null;
        Shell shell = window.getShell();
        if (shell != null && !shell.isDisposed()) {
            shell.removeShellListener(this.fActivationListener);
        }
        this.fActivationListener = null;
        JavaScriptCore.removeElementChangedListener((IElementChangedListener)this.fJavaElementChangedListener);
        this.fJavaElementChangedListener = null;
        IWorkspace workspace = JavaScriptPlugin.getWorkspace();
        workspace.removeResourceChangeListener(this.fResourceChangeListener);
        this.fResourceChangeListener = null;
        JavaScriptPlugin.getDefault().getCombinedPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        this.fPropertyChangeListener = null;
        super.uninstall();
    }

    protected void forceReconciling() {
        if (!this.fIninitalProcessDone) {
            return;
        }
        super.forceReconciling();
        JavaCompositeReconcilingStrategy strategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(false);
    }

    protected void aboutToBeReconciled() {
        JavaCompositeReconcilingStrategy strategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.aboutToBeReconciled();
    }

    protected void reconcilerReset() {
        super.reconcilerReset();
        JavaCompositeReconcilingStrategy strategy = (JavaCompositeReconcilingStrategy)this.getReconcilingStrategy("__dftl_partition_content_type");
        strategy.notifyListeners(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialProcess() {
        Object object = this.fMutex;
        synchronized (object) {
            super.initialProcess();
        }
        this.fIninitalProcessDone = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(DirtyRegion dirtyRegion) {
        Object object = this.fMutex;
        synchronized (object) {
            this.fIsReconciling = true;
            super.process(dirtyRegion);
            this.fIsReconciling = false;
        }
    }

    private synchronized boolean hasJavaModelChanged() {
        return this.fHasJavaModelChanged;
    }

    private synchronized void setJavaModelChanged(boolean state) {
        this.fHasJavaModelChanged = state;
    }

    private synchronized boolean isEditorActive() {
        return this.fIsEditorActive;
    }

    private synchronized void setEditorActive(boolean state) {
        this.fIsEditorActive = state;
    }

    private class ActivationListener
    extends ShellAdapter {
        private Control fControl;

        public ActivationListener(Control control) {
            Assert.isNotNull((Object)control);
            this.fControl = control;
        }

        public void shellActivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.isVisible()) {
                if (JavaReconciler.this.hasJavaModelChanged()) {
                    JavaReconciler.this.forceReconciling();
                }
                JavaReconciler.this.setEditorActive(true);
            }
        }

        public void shellDeactivated(ShellEvent e) {
            if (!this.fControl.isDisposed() && this.fControl.getShell() == e.getSource()) {
                JavaReconciler.this.setJavaModelChanged(false);
                JavaReconciler.this.setEditorActive(false);
            }
        }
    }

    private class ElementChangedListener
    implements IElementChangedListener {
        private ElementChangedListener() {
        }

        public void elementChanged(ElementChangedEvent event) {
            if (event.getDelta().getFlags() == 524288) {
                return;
            }
            JavaReconciler.this.setJavaModelChanged(true);
            if (!JavaReconciler.this.fIsReconciling && JavaReconciler.this.isEditorActive()) {
                JavaReconciler.this.forceReconciling();
            }
        }
    }

    private class PartListener
    implements IPartListener {
        private PartListener() {
        }

        public void partActivated(IWorkbenchPart part) {
            if (part == JavaReconciler.this.fTextEditor) {
                if (JavaReconciler.this.hasJavaModelChanged()) {
                    JavaReconciler.this.forceReconciling();
                }
                JavaReconciler.this.setEditorActive(true);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
            if (part == JavaReconciler.this.fTextEditor) {
                JavaReconciler.this.setJavaModelChanged(false);
                JavaReconciler.this.setEditorActive(false);
            }
        }

        public void partOpened(IWorkbenchPart part) {
        }
    }

    class ResourceChangeListener
    implements IResourceChangeListener {
        ResourceChangeListener() {
        }

        private IResource getResource() {
            IEditorInput input = JavaReconciler.this.fTextEditor.getEditorInput();
            if (input instanceof IFileEditorInput) {
                IFileEditorInput fileInput = (IFileEditorInput)input;
                return fileInput.getFile();
            }
            return null;
        }

        public void resourceChanged(IResourceChangeEvent e) {
            IResourceDelta child;
            IResourceDelta delta = e.getDelta();
            IResource resource = this.getResource();
            if (delta != null && resource != null && (child = delta.findMember(resource.getFullPath())) != null) {
                IMarkerDelta[] deltas = child.getMarkerDeltas();
                int i = deltas.length;
                while (--i >= 0) {
                    try {
                        if (!deltas[i].getMarker().isSubtypeOf("org.eclipse.core.resources.problemmarker")) continue;
                        JavaReconciler.this.forceReconciling();
                        return;
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            }
        }
    }
}

