/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.typehierarchy;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.wst.jsdt.core.ElementChangedEvent;
import org.eclipse.wst.jsdt.core.IClassFile;
import org.eclipse.wst.jsdt.core.IElementChangedListener;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptElementDelta;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.IRegion;
import org.eclipse.wst.jsdt.core.IType;
import org.eclipse.wst.jsdt.core.ITypeHierarchy;
import org.eclipse.wst.jsdt.core.ITypeHierarchyChangedListener;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.util.JavaModelUtil;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.typehierarchy.ITypeHierarchyLifeCycleListener;

public class TypeHierarchyLifeCycle
implements ITypeHierarchyChangedListener,
IElementChangedListener {
    private boolean fHierarchyRefreshNeeded;
    private ITypeHierarchy fHierarchy = null;
    private IJavaScriptElement fInputElement = null;
    private boolean fIsSuperTypesOnly;
    private List fChangeListeners;

    public TypeHierarchyLifeCycle() {
        this(false);
    }

    public TypeHierarchyLifeCycle(boolean isSuperTypesOnly) {
        this.fIsSuperTypesOnly = isSuperTypesOnly;
        this.fChangeListeners = new ArrayList(2);
    }

    public ITypeHierarchy getHierarchy() {
        return this.fHierarchy;
    }

    public IJavaScriptElement getInputElement() {
        return this.fInputElement;
    }

    public void freeHierarchy() {
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            JavaScriptCore.removeElementChangedListener((IElementChangedListener)this);
            this.fHierarchy = null;
            this.fInputElement = null;
        }
    }

    public void removeChangedListener(ITypeHierarchyLifeCycleListener listener) {
        this.fChangeListeners.remove(listener);
    }

    public void addChangedListener(ITypeHierarchyLifeCycleListener listener) {
        if (!this.fChangeListeners.contains(listener)) {
            this.fChangeListeners.add(listener);
        }
    }

    private void fireChange(IType[] changedTypes) {
        int i = this.fChangeListeners.size() - 1;
        while (i >= 0) {
            ITypeHierarchyLifeCycleListener curr = (ITypeHierarchyLifeCycleListener)this.fChangeListeners.get(i);
            curr.typeHierarchyChanged(this, changedTypes);
            --i;
        }
    }

    public void ensureRefreshedTypeHierarchy(final IJavaScriptElement element, IRunnableContext context) throws InvocationTargetException, InterruptedException {
        boolean hierachyCreationNeeded;
        if (element == null || !element.exists()) {
            this.freeHierarchy();
            return;
        }
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (hierachyCreationNeeded || this.fHierarchyRefreshNeeded) {
            IRunnableWithProgress op = new IRunnableWithProgress(){

                public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                    try {
                        TypeHierarchyLifeCycle.this.doHierarchyRefresh(element, pm);
                    }
                    catch (JavaScriptModelException e) {
                        throw new InvocationTargetException(e);
                    }
                    catch (OperationCanceledException e) {
                        throw new InterruptedException();
                    }
                }
            };
            this.fHierarchyRefreshNeeded = true;
            context.run(true, true, op);
            this.fHierarchyRefreshNeeded = false;
        }
    }

    private ITypeHierarchy createTypeHierarchy(IJavaScriptElement element, IProgressMonitor pm) throws JavaScriptModelException {
        IPackageFragmentRoot[] roots;
        if (element.getElementType() == 7) {
            IType type = (IType)element;
            if (this.fIsSuperTypesOnly) {
                return type.newSupertypeHierarchy(pm);
            }
            return type.newTypeHierarchy(pm);
        }
        IRegion region = JavaScriptCore.newRegion();
        if (element.getElementType() == 2) {
            roots = ((IJavaScriptProject)element).getPackageFragmentRoots();
            int i = 0;
            while (i < roots.length) {
                if (!roots[i].isExternal()) {
                    region.add((IJavaScriptElement)roots[i]);
                }
                ++i;
            }
        } else if (element.getElementType() == 4) {
            roots = element.getJavaScriptProject().getPackageFragmentRoots();
            String name = element.getElementName();
            int i = 0;
            while (i < roots.length) {
                IPackageFragment pack = roots[i].getPackageFragment(name);
                if (pack.exists()) {
                    region.add((IJavaScriptElement)pack);
                }
                ++i;
            }
        } else {
            region.add(element);
        }
        IJavaScriptProject jproject = element.getJavaScriptProject();
        return jproject.newTypeHierarchy(region, pm);
    }

    public synchronized void doHierarchyRefresh(IJavaScriptElement element, IProgressMonitor pm) throws JavaScriptModelException {
        boolean hierachyCreationNeeded;
        boolean bl = hierachyCreationNeeded = this.fHierarchy == null || !element.equals(this.fInputElement);
        if (this.fHierarchy != null) {
            this.fHierarchy.removeTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
            JavaScriptCore.removeElementChangedListener((IElementChangedListener)this);
        }
        if (hierachyCreationNeeded) {
            this.fHierarchy = this.createTypeHierarchy(element, pm);
            if (pm != null && pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            this.fInputElement = element;
        } else {
            this.fHierarchy.refresh(pm);
        }
        this.fHierarchy.addTypeHierarchyChangedListener((ITypeHierarchyChangedListener)this);
        JavaScriptCore.addElementChangedListener((IElementChangedListener)this);
        this.fHierarchyRefreshNeeded = false;
    }

    public void typeHierarchyChanged(ITypeHierarchy typeHierarchy) {
        this.fHierarchyRefreshNeeded = true;
        this.fireChange(null);
    }

    public void elementChanged(ElementChangedEvent event) {
        if (this.fChangeListeners.isEmpty()) {
            return;
        }
        if (this.fHierarchyRefreshNeeded) {
            return;
        }
        ArrayList changedTypes = new ArrayList();
        this.processDelta(event.getDelta(), changedTypes);
        if (changedTypes.size() > 0) {
            this.fireChange(changedTypes.toArray(new IType[changedTypes.size()]));
        }
    }

    private void processDelta(IJavaScriptElementDelta delta, ArrayList changedTypes) {
        IJavaScriptElement element = delta.getElement();
        switch (element.getElementType()) {
            case 7: {
                this.processTypeDelta((IType)element, changedTypes);
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 5: {
                IJavaScriptUnit cu = (IJavaScriptUnit)element;
                if (!JavaModelUtil.isPrimary(cu)) {
                    return;
                }
                if (delta.getKind() == 4 && this.isPossibleStructuralChange(delta.getFlags())) {
                    try {
                        if (!cu.exists()) break;
                        IType[] types = cu.getAllTypes();
                        int i = 0;
                        while (i < types.length) {
                            this.processTypeDelta(types[i], changedTypes);
                            ++i;
                        }
                    }
                    catch (JavaScriptModelException e) {
                        JavaScriptPlugin.log(e);
                    }
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
                break;
            }
            case 6: {
                if (delta.getKind() == 4) {
                    IType type = ((IClassFile)element).getType();
                    this.processTypeDelta(type, changedTypes);
                    break;
                }
                this.processChildrenDelta(delta, changedTypes);
            }
        }
    }

    private boolean isPossibleStructuralChange(int flags) {
        return (flags & 0x4001) == 1;
    }

    private void processTypeDelta(IType type, ArrayList changedTypes) {
        if (this.getHierarchy().contains(type)) {
            changedTypes.add(type);
        }
    }

    private void processChildrenDelta(IJavaScriptElementDelta delta, ArrayList changedTypes) {
        IJavaScriptElementDelta[] children = delta.getAffectedChildren();
        int i = 0;
        while (i < children.length) {
            this.processDelta(children[i], changedTypes);
            ++i;
        }
    }
}

