/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragment;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptCore;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.BuildPathBasePage;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;

public class AddFolderToBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public AddFolderToBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
    }

    public AddFolderToBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
    }

    private AddFolderToBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 0);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_label);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_ADD_AS_SOURCE_FOLDER);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_AddSelSFToCP_tooltip);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_toBuildpath;
        }
        Object obj = this.getSelectedElements().get(0);
        if (obj instanceof IJavaScriptProject) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ProjectToBuildpath, ((IJavaScriptProject)obj).getElementName());
        }
        if (obj instanceof IPackageFragment) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_PackageToBuildpath, ((IPackageFragment)obj).getElementName());
        }
        if (obj instanceof IResource) {
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_FolderToBuildpath, ((IResource)obj).getName());
        }
        return null;
    }

    public void run() {
        try {
            IJavaScriptProject project;
            Object object = this.getSelectedElements().get(0);
            if (object instanceof IJavaScriptProject) {
                project = (IJavaScriptProject)object;
            } else if (object instanceof IPackageFragment) {
                project = ((IPackageFragment)object).getJavaScriptProject();
            } else {
                IFolder folder = (IFolder)object;
                project = JavaScriptCore.create((IProject)folder.getProject());
                if (project == null) {
                    return;
                }
            }
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        List result = AddFolderToBuildpathAction.this.addToClasspath(AddFolderToBuildpathAction.this.getSelectedElements(), project, monitor);
                        AddFolderToBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.AddSourceFolderToBuildpathAction_ErrorTitle);
            } else {
                JavaScriptPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private List addToClasspath(List elements, IJavaScriptProject project, IProgressMonitor monitor) throws OperationCanceledException, CoreException {
        if (!project.getProject().hasNature("org.eclipse.wst.jsdt.core.jsNature")) {
            StatusInfo rootStatus = new StatusInfo();
            rootStatus.setError(NewWizardMessages.ClasspathModifier_Error_NoNatures);
            throw new CoreException((IStatus)rootStatus);
        }
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_AddToBuildpath, elements.size() + 4);
            BuildpathDelta delta = new BuildpathDelta(this.getToolTipText());
            List existingEntries = ClasspathModifier.getExistingEntries(project);
            ArrayList<CPListElement> newEntries = new ArrayList<CPListElement>();
            int i = 0;
            while (i < elements.size()) {
                Object element = elements.get(i);
                CPListElement entry = element instanceof IResource ? ClasspathModifier.addToClasspath((IResource)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1)) : ClasspathModifier.addToClasspath((IJavaScriptElement)element, existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                newEntries.add(entry);
                ++i;
            }
            HashSet modifiedSourceEntries = new HashSet();
            BuildPathBasePage.fixNestingConflicts(newEntries.toArray(new CPListElement[newEntries.size()]), existingEntries.toArray(new CPListElement[existingEntries.size()]), modifiedSourceEntries);
            ClasspathModifier.setNewEntry(existingEntries, newEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ClasspathModifier.commitClassPath(existingEntries, project, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            delta.setNewEntries(existingEntries.toArray(new CPListElement[existingEntries.size()]));
            this.informListeners(delta);
            ArrayList<IJavaScriptProject> result = new ArrayList<IJavaScriptProject>();
            int i2 = 0;
            while (i2 < newEntries.size()) {
                IIncludePathEntry entry = ((CPListElement)newEntries.get(i2)).getClasspathEntry();
                Object root = entry.getPath().equals((Object)project.getPath()) ? project : project.findPackageFragmentRoot(entry.getPath());
                if (root != null) {
                    result.add((IJavaScriptProject)root);
                }
                ++i2;
            }
            ArrayList<IJavaScriptProject> arrayList = result;
            return arrayList;
        }
        finally {
            monitor.done();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            Iterator iter = elements.iterator();
            while (true) {
                if (!iter.hasNext()) {
                    return true;
                }
                Object element = iter.next();
                if (element instanceof IJavaScriptProject) {
                    if (!ClasspathModifier.isSourceFolder((IJavaScriptProject)element)) continue;
                    return false;
                }
                if (element instanceof IPackageFragment) {
                    IPackageFragment fragment = (IPackageFragment)element;
                    if (ClasspathModifier.isDefaultFragment(fragment)) {
                        return false;
                    }
                    if (!((IPackageFragmentRoot)fragment.getAncestor(3)).isArchive()) continue;
                    return false;
                }
                if (!(element instanceof IFolder)) {
                    return false;
                }
                IProject project = ((IFolder)element).getProject();
                IJavaScriptProject javaProject = JavaScriptCore.create((IProject)project);
                if (javaProject == null || !javaProject.exists()) break;
            }
            return false;
        }
        catch (CoreException coreException) {
            return false;
        }
    }
}

