/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.wst.jsdt.core.IIncludePathEntry;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptProject;
import org.eclipse.wst.jsdt.core.IPackageFragmentRoot;
import org.eclipse.wst.jsdt.core.JavaScriptModelException;
import org.eclipse.wst.jsdt.internal.corext.buildpath.BuildpathDelta;
import org.eclipse.wst.jsdt.internal.corext.buildpath.CPJavaProject;
import org.eclipse.wst.jsdt.internal.corext.buildpath.ClasspathModifier;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaPluginImages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.packageview.JsGlobalScopeContainer;
import org.eclipse.wst.jsdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.BuildpathModifierAction;
import org.eclipse.wst.jsdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveLinkedFolderDialog;

public class RemoveFromBuildpathAction
extends BuildpathModifierAction {
    private final IRunnableContext fContext;

    public RemoveFromBuildpathAction(IWorkbenchSite site) {
        this(site, null, (IRunnableContext)PlatformUI.getWorkbench().getProgressService());
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_REMOVE_FROM_BP);
    }

    public RemoveFromBuildpathAction(IRunnableContext context, ISetSelectionTarget selectionTarget) {
        this(null, selectionTarget, context);
        this.setImageDescriptor(JavaPluginImages.DESC_ELCL_REMOVE_AS_SOURCE_FOLDER);
        this.setDisabledImageDescriptor(JavaPluginImages.DESC_DLCL_REMOVE_AS_SOURCE_FOLDER);
    }

    public RemoveFromBuildpathAction(IWorkbenchSite site, ISetSelectionTarget selectionTarget, IRunnableContext context) {
        super(site, selectionTarget, 1);
        this.fContext = context;
        this.setText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_label);
        this.setToolTipText(NewWizardMessages.NewSourceContainerWorkbookPage_ToolBar_RemoveFromCP_tooltip);
    }

    public String getDetailedDescription() {
        if (!this.isEnabled()) {
            return null;
        }
        if (this.getSelectedElements().size() != 1) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_FromBuildpath;
        }
        Object elem = this.getSelectedElements().get(0);
        if (elem instanceof IJavaScriptProject) {
            String name = ClasspathModifier.escapeSpecialChars(((IJavaScriptElement)elem).getElementName());
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_ProjectFromBuildpath, name);
        }
        if (elem instanceof IPackageFragmentRoot) {
            String name = ClasspathModifier.escapeSpecialChars(((IJavaScriptElement)elem).getElementName());
            return Messages.format(NewWizardMessages.PackageExplorerActionGroup_FormText_fromBuildpath, name);
        }
        if (elem instanceof JsGlobalScopeContainer) {
            return NewWizardMessages.PackageExplorerActionGroup_FormText_Default_FromBuildpath;
        }
        return null;
    }

    public void run() {
        try {
            IJavaScriptProject project;
            Object object = this.getSelectedElements().get(0);
            if (object instanceof IJavaScriptProject) {
                project = (IJavaScriptProject)object;
            } else if (object instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)object;
                project = root.getJavaScriptProject();
            } else {
                JsGlobalScopeContainer container = (JsGlobalScopeContainer)object;
                project = container.getJavaProject();
            }
            final ArrayList elementsToRemove = new ArrayList();
            final ArrayList foldersToDelete = new ArrayList();
            this.queryToRemoveLinkedFolders(elementsToRemove, foldersToDelete);
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    try {
                        try {
                            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, foldersToDelete.size() + 10);
                            CPJavaProject cpProject = CPJavaProject.createFromExisting(project);
                            CPListElement[] toRemove = new CPListElement[elementsToRemove.size()];
                            int i = 0;
                            for (Object element : elementsToRemove) {
                                toRemove[i] = element instanceof IJavaScriptProject ? ClasspathModifier.getListElement(((IJavaScriptProject)element).getPath(), cpProject.getCPListElements()) : (element instanceof IPackageFragmentRoot ? CPListElement.createFromExisting(((IPackageFragmentRoot)element).getRawIncludepathEntry(), project) : CPListElement.createFromExisting(((JsGlobalScopeContainer)element).getClasspathEntry(), project));
                                ++i;
                            }
                            BuildpathDelta delta = ClasspathModifier.removeFromBuildpath(toRemove, cpProject);
                            ClasspathModifier.commitClassPath(cpProject, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                            RemoveFromBuildpathAction.this.deleteFolders(foldersToDelete, (IProgressMonitor)new SubProgressMonitor(monitor, foldersToDelete.size()));
                            RemoveFromBuildpathAction.this.informListeners(delta);
                            if (delta.getDeletedResources().length == foldersToDelete.size()) {
                                RemoveFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection((Object)project));
                            } else {
                                ArrayList<IResource> result = new ArrayList<IResource>(Arrays.asList(delta.getDeletedResources()));
                                result.removeAll(foldersToDelete);
                                RemoveFromBuildpathAction.this.selectAndReveal((ISelection)new StructuredSelection(result));
                            }
                        }
                        catch (CoreException e) {
                            throw new InvocationTargetException(e);
                        }
                    }
                    finally {
                        monitor.done();
                    }
                }
            };
            this.fContext.run(false, false, runnable);
        }
        catch (CoreException e) {
            this.showExceptionDialog(e, NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle);
        }
        catch (InvocationTargetException e) {
            if (e.getCause() instanceof CoreException) {
                this.showExceptionDialog((CoreException)e.getCause(), NewWizardMessages.RemoveFromBuildpathAction_ErrorTitle);
            } else {
                JavaScriptPlugin.log(e);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void deleteFolders(List folders, IProgressMonitor monitor) throws CoreException {
        try {
            monitor.beginTask(NewWizardMessages.ClasspathModifier_Monitor_RemoveFromBuildpath, folders.size());
            for (IFolder folder : folders) {
                folder.delete(true, true, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
        }
        finally {
            monitor.done();
        }
    }

    private void queryToRemoveLinkedFolders(List elementsToRemove, List foldersToDelete) throws JavaScriptModelException {
        Shell shell = this.getShell();
        for (Object element : this.getSelectedElements()) {
            if (element instanceof IPackageFragmentRoot) {
                IFolder folder = this.getLinkedSourceFolder((IPackageFragmentRoot)element);
                if (folder != null) {
                    int result;
                    RemoveLinkedFolderDialog dialog = new RemoveLinkedFolderDialog(shell, folder);
                    int n = result = dialog.open() == 0 ? dialog.getRemoveStatus() : 0;
                    if (result == 0) continue;
                    if (result == 1) {
                        elementsToRemove.add(element);
                        continue;
                    }
                    if (result != 2) continue;
                    elementsToRemove.add(element);
                    foldersToDelete.add(folder);
                    continue;
                }
                elementsToRemove.add(element);
                continue;
            }
            elementsToRemove.add(element);
        }
    }

    private IFolder getLinkedSourceFolder(IPackageFragmentRoot root) throws JavaScriptModelException {
        if (root.getKind() != 1) {
            return null;
        }
        IResource resource = root.getCorrespondingResource();
        if (!(resource instanceof IFolder)) {
            return null;
        }
        IFolder folder = (IFolder)resource;
        if (!folder.isLinked()) {
            return null;
        }
        return folder;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean canHandle(IStructuredSelection elements) {
        if (elements.size() == 0) {
            return false;
        }
        try {
            Object element;
            block6: {
                Iterator iter = elements.iterator();
                while (true) {
                    if (!iter.hasNext()) {
                        return true;
                    }
                    element = iter.next();
                    if (element instanceof IJavaScriptProject) {
                        IJavaScriptProject project = (IJavaScriptProject)element;
                        if (ClasspathModifier.isSourceFolder(project)) continue;
                        return false;
                    }
                    if (!(element instanceof IPackageFragmentRoot)) break block6;
                    IIncludePathEntry entry = ((IPackageFragmentRoot)element).getRawIncludepathEntry();
                    if (entry != null && entry.getEntryKind() == 5) break;
                }
                return false;
            }
            return element instanceof JsGlobalScopeContainer;
        }
        catch (JavaScriptModelException javaScriptModelException) {
            return false;
        }
    }
}

