/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.debug.internal.core.model;

import java.util.HashMap;
import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.wst.jsdt.debug.core.jsdi.VirtualMachine;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.Event;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventQueue;
import org.eclipse.wst.jsdt.debug.core.jsdi.event.EventSet;
import org.eclipse.wst.jsdt.debug.core.jsdi.request.EventRequest;
import org.eclipse.wst.jsdt.debug.internal.core.JavaScriptDebugPlugin;
import org.eclipse.wst.jsdt.debug.internal.core.model.IJavaScriptEventListener;
import org.eclipse.wst.jsdt.debug.internal.core.model.JavaScriptDebugTarget;

public final class EventDispatcher
implements Runnable {
    public static final int EVENT_SCRIPT_LOADED = 1;
    private HashMap listeners = null;
    private boolean shutdown = false;
    private JavaScriptDebugTarget target = null;

    public EventDispatcher(JavaScriptDebugTarget target) {
        this.target = target;
    }

    public synchronized void addEventListener(IJavaScriptEventListener listener, EventRequest request) {
        if (this.listeners == null) {
            this.listeners = new HashMap(4);
        }
        this.listeners.put(request, listener);
    }

    public synchronized boolean removeEventListener(IJavaScriptEventListener listener, EventRequest request) {
        if (this.listeners != null) {
            return this.listeners.remove(request) != null;
        }
        return false;
    }

    public void run() {
        if (this.shutdown) {
            return;
        }
        VirtualMachine vm = this.target.getVM();
        if (vm != null) {
            EventQueue queue = vm.eventQueue();
            EventSet eventset = null;
            while (!this.shutdown) {
                try {
                    eventset = queue.remove();
                    if (eventset == null) continue;
                    this.dispatch(eventset);
                }
                catch (RuntimeException rte) {
                    try {
                        this.target.terminate();
                    }
                    catch (DebugException e) {
                        JavaScriptDebugPlugin.log(e);
                    }
                }
            }
        }
    }

    void dispatch(EventSet eventSet) {
        IJavaScriptEventListener listener;
        Event event = null;
        boolean resume = true;
        Iterator iter = eventSet.iterator();
        while (iter.hasNext()) {
            event = (Event)iter.next();
            if (event == null || (listener = (IJavaScriptEventListener)this.listeners.get(event.request())) == null) continue;
            resume &= listener.handleEvent(event, this.target, false, eventSet);
        }
        iter = eventSet.iterator();
        while (iter.hasNext()) {
            event = (Event)iter.next();
            if (event == null || (listener = (IJavaScriptEventListener)this.listeners.get(event.request())) == null) continue;
            listener.eventSetComplete(event, this.target, !resume, eventSet);
        }
        if (resume) {
            eventSet.resume();
        }
    }

    public void shutdown() {
        this.shutdown = true;
        this.listeners.clear();
    }
}

