/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.dialogs;

import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.core.runtime.content.IContentTypeManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.dialogs.PreferenceLinkArea;
import org.eclipse.ui.internal.WorkbenchMessages;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.dialogs.FileExtensionDialog;
import org.eclipse.ui.internal.dialogs.NewContentTypeDialog;
import org.eclipse.ui.internal.misc.StatusUtil;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;

public class ContentTypesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private ListViewer fileAssociationViewer;
    private Button removeButton;
    private TreeViewer contentTypesViewer;
    private Button addButton;
    private Button editButton;
    private Text charsetField;
    private Button setButton;
    private IWorkbench workbench;
    private Button removeContentTypeButton;
    private Button addChildContentTypeButton;

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(2, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        PreferenceLinkArea contentTypeArea = new PreferenceLinkArea(composite, 0, "org.eclipse.ui.preferencePages.FileEditors", WorkbenchMessages.ContentTypes_FileEditorsRelatedLink, (IWorkbenchPreferenceContainer)this.getContainer(), null);
        GridData data = new GridData(768);
        contentTypeArea.getControl().setLayoutData((Object)data);
        this.createContentTypesTree(composite);
        this.createFileAssociations(composite);
        this.createCharset(composite);
        this.workbench.getHelpSystem().setHelp((Control)parent, "org.eclipse.ui.content_types_preference_page_context");
        this.applyDialogFont(composite);
        return composite;
    }

    private void createCharset(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        GridData compositeData = new GridData(768);
        compositeData.horizontalSpan = 2;
        composite.setLayoutData((Object)compositeData);
        composite.setLayout((Layout)layout);
        Label label = new Label(composite, 0);
        label.setFont(parent.getFont());
        label.setText(WorkbenchMessages.ContentTypes_characterSetLabel);
        this.charsetField = new Text(composite, 2052);
        this.charsetField.setFont(parent.getFont());
        this.charsetField.setEnabled(false);
        GridData data = new GridData(768);
        this.charsetField.setLayoutData((Object)data);
        this.setButton = new Button(composite, 8);
        this.setButton.setFont(parent.getFont());
        this.setButton.setText(WorkbenchMessages.ContentTypes_characterSetUpdateLabel);
        this.setButton.setEnabled(false);
        this.setButtonLayoutData(this.setButton);
        this.setButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            try {
                String text = this.charsetField.getText().trim();
                if (text.length() == 0) {
                    text = null;
                }
                this.getSelectedContentType().setDefaultCharset(text);
                this.setButton.setEnabled(false);
            }
            catch (CoreException e1) {
                StatusUtil.handleStatus(e1.getStatus(), 2, parent.getShell());
            }
        }));
        this.charsetField.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                IContentType contentType = ContentTypesPreferencePage.this.getSelectedContentType();
                String charset = contentType.getDefaultCharset();
                if (charset == null) {
                    charset = "";
                }
                ContentTypesPreferencePage.this.setButton.setEnabled(!charset.equals(ContentTypesPreferencePage.this.charsetField.getText()) && ContentTypesPreferencePage.this.getErrorMessage() == null);
            }
        });
        this.charsetField.addModifyListener(e -> {
            String errorMessage = null;
            String text = this.charsetField.getText();
            try {
                if (text.length() != 0 && !Charset.isSupported(text)) {
                    errorMessage = WorkbenchMessages.ContentTypes_unsupportedEncoding;
                }
            }
            catch (IllegalCharsetNameException ex) {
                errorMessage = WorkbenchMessages.ContentTypes_unsupportedEncoding;
            }
            this.setErrorMessage(errorMessage);
        });
    }

    private void createFileAssociations(Composite composite) {
        Label label = new Label(composite, 0);
        label.setText(WorkbenchMessages.ContentTypes_fileAssociationsLabel);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.fileAssociationViewer = new ListViewer(composite);
        this.fileAssociationViewer.setComparator((ViewerComparator)new FileSpecComparator());
        this.fileAssociationViewer.getControl().setFont(composite.getFont());
        this.fileAssociationViewer.setContentProvider((IContentProvider)new FileSpecContentProvider());
        this.fileAssociationViewer.setLabelProvider((IBaseLabelProvider)new FileSpecLabelProvider());
        GridData data2 = new GridData(1808);
        data2.horizontalSpan = 1;
        this.fileAssociationViewer.getControl().setLayoutData((Object)data2);
        this.fileAssociationViewer.addSelectionChangedListener(event -> {
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                this.editButton.setEnabled(false);
                this.removeButton.setEnabled(false);
                return;
            }
            boolean enabled = true;
            List elements = selection.toList();
            for (Spec spec : elements) {
                if (!spec.isPredefined) continue;
                enabled = false;
            }
            this.editButton.setEnabled(enabled && selection.size() == 1);
            this.removeButton.setEnabled(enabled);
        });
        Composite buttonArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout(1, false);
        buttonArea.setLayout((Layout)layout);
        GridData data3 = new GridData(-1, 128, false, false);
        buttonArea.setLayoutData((Object)data3);
        this.addButton = new Button(buttonArea, 8);
        this.addButton.setFont(composite.getFont());
        this.addButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsAddLabel);
        this.addButton.setEnabled(false);
        this.setButtonLayoutData(this.addButton);
        this.addButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            block7: {
                Shell shell = composite.getShell();
                IContentType selectedContentType = this.getSelectedContentType();
                FileExtensionDialog dialog = new FileExtensionDialog(shell, WorkbenchMessages.ContentTypes_addDialog_title, "org.eclipse.ui.file_extension_dialog_context", WorkbenchMessages.ContentTypes_addDialog_messageHeader, WorkbenchMessages.ContentTypes_addDialog_message, WorkbenchMessages.ContentTypes_addDialog_label);
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    String extension = dialog.getExtension();
                    try {
                        try {
                            if (name.equals("*")) {
                                selectedContentType.addFileSpec(extension, 8);
                                break block7;
                            }
                            selectedContentType.addFileSpec(String.valueOf(name) + (extension.length() > 0 ? String.valueOf('.') + extension : ""), 4);
                        }
                        catch (CoreException ex) {
                            StatusUtil.handleStatus(ex.getStatus(), 2, shell);
                            WorkbenchPlugin.log(ex);
                            this.fileAssociationViewer.refresh(false);
                        }
                    }
                    finally {
                        this.fileAssociationViewer.refresh(false);
                    }
                }
            }
        }));
        this.editButton = new Button(buttonArea, 8);
        this.editButton.setFont(composite.getFont());
        this.editButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsEditLabel);
        this.editButton.setEnabled(false);
        this.setButtonLayoutData(this.editButton);
        this.editButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            block12: {
                Shell shell = composite.getShell();
                IContentType selectedContentType = this.getSelectedContentType();
                Spec spec = this.getSelectedSpecs()[0];
                FileExtensionDialog dialog = new FileExtensionDialog(shell, WorkbenchMessages.ContentTypes_editDialog_title, "org.eclipse.ui.file_extension_dialog_context", WorkbenchMessages.ContentTypes_editDialog_messageHeader, WorkbenchMessages.ContentTypes_editDialog_message, WorkbenchMessages.ContentTypes_editDialog_label);
                if (spec.name == null) {
                    dialog.setInitialValue("*." + spec.ext);
                } else {
                    dialog.setInitialValue(spec.name);
                }
                if (dialog.open() == 0) {
                    String name = dialog.getName();
                    String extension = dialog.getExtension();
                    try {
                        try {
                            if (spec.name != null) {
                                selectedContentType.removeFileSpec(spec.name, 4);
                            } else if (spec.ext != null) {
                                selectedContentType.removeFileSpec(spec.ext, 8);
                            }
                            if (name.equals("*")) {
                                selectedContentType.addFileSpec(extension, 8);
                                break block12;
                            }
                            selectedContentType.addFileSpec(String.valueOf(name) + (extension.length() > 0 ? String.valueOf('.') + extension : ""), 4);
                        }
                        catch (CoreException ex) {
                            StatusUtil.handleStatus(ex.getStatus(), 2, shell);
                            WorkbenchPlugin.log(ex);
                            this.fileAssociationViewer.refresh(false);
                        }
                    }
                    finally {
                        this.fileAssociationViewer.refresh(false);
                    }
                }
            }
        }));
        this.removeButton = new Button(buttonArea, 8);
        this.removeButton.setEnabled(false);
        this.removeButton.setText(WorkbenchMessages.ContentTypes_fileAssociationsRemoveLabel);
        this.setButtonLayoutData(this.removeButton);
        this.removeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> {
            IContentType contentType = this.getSelectedContentType();
            Spec[] specs = this.getSelectedSpecs();
            MultiStatus result = new MultiStatus("org.eclipse.ui", 0, new IStatus[0], WorkbenchMessages.ContentTypes_errorDialogMessage, null);
            Spec[] specArray = specs;
            int n = specs.length;
            int n2 = 0;
            while (n2 < n) {
                Spec spec = specArray[n2];
                try {
                    if (spec.name != null) {
                        contentType.removeFileSpec(spec.name, 4);
                    } else if (spec.ext != null) {
                        contentType.removeFileSpec(spec.ext, 8);
                    }
                }
                catch (CoreException e) {
                    result.add(e.getStatus());
                }
                ++n2;
            }
            if (!result.isOK()) {
                StatusUtil.handleStatus((IStatus)result, 2, composite.getShell());
            }
            this.fileAssociationViewer.refresh(false);
        }));
    }

    protected Spec[] getSelectedSpecs() {
        List list = this.fileAssociationViewer.getStructuredSelection().toList();
        return list.toArray(new Spec[list.size()]);
    }

    protected IContentType getSelectedContentType() {
        return (IContentType)this.contentTypesViewer.getStructuredSelection().getFirstElement();
    }

    private void createContentTypesTree(Composite composite) {
        Label label = new Label(composite, 0);
        label.setFont(composite.getFont());
        label.setText(WorkbenchMessages.ContentTypes_contentTypesLabel);
        GridData data = new GridData();
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        this.contentTypesViewer = new TreeViewer(composite, 2820);
        this.contentTypesViewer.getControl().setFont(composite.getFont());
        this.contentTypesViewer.setContentProvider((IContentProvider)new ContentTypesContentProvider());
        this.contentTypesViewer.setLabelProvider((IBaseLabelProvider)new ContentTypesLabelProvider());
        this.contentTypesViewer.setComparator(new ViewerComparator());
        this.contentTypesViewer.setInput((Object)Platform.getContentTypeManager());
        GridData data2 = new GridData(1808);
        this.contentTypesViewer.getControl().setLayoutData((Object)data2);
        this.contentTypesViewer.addSelectionChangedListener(event -> {
            IContentType contentType = (IContentType)((IStructuredSelection)event.getSelection()).getFirstElement();
            this.fileAssociationViewer.setInput((Object)contentType);
            this.editButton.setEnabled(false);
            this.removeButton.setEnabled(false);
            if (contentType != null) {
                String charset = contentType.getDefaultCharset();
                if (charset == null) {
                    charset = "";
                }
                this.charsetField.setText(charset);
            } else {
                this.charsetField.setText("");
            }
            this.charsetField.setEnabled(contentType != null);
            this.addButton.setEnabled(contentType != null);
            this.setButton.setEnabled(false);
            this.addChildContentTypeButton.setEnabled(contentType != null);
            this.removeContentTypeButton.setEnabled(contentType != null && contentType.isUserDefined());
        });
        Composite buttonsComposite = new Composite(composite, 0);
        buttonsComposite.setLayoutData((Object)new GridData(-1, 128, false, false));
        buttonsComposite.setLayout((Layout)new GridLayout(1, false));
        Button addRootContentTypeButton = new Button(buttonsComposite, 8);
        this.setButtonLayoutData(addRootContentTypeButton);
        addRootContentTypeButton.setText(WorkbenchMessages.ContentTypes_addRootContentTypeButton);
        addRootContentTypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String id = "userCreated" + System.currentTimeMillis();
            IContentTypeManager manager = (IContentTypeManager)this.contentTypesViewer.getInput();
            NewContentTypeDialog dialog = new NewContentTypeDialog(this.getShell(), manager, null);
            if (dialog.open() == 0) {
                try {
                    IContentType newContentType = manager.addContentType(id, dialog.getName(), null);
                    this.contentTypesViewer.refresh();
                    this.contentTypesViewer.setSelection((ISelection)new StructuredSelection((Object)newContentType));
                }
                catch (CoreException e1) {
                    MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.ContentTypes_failedAtEditingContentTypes, (String)e1.getMessage());
                }
            }
        }));
        this.addChildContentTypeButton = new Button(buttonsComposite, 8);
        this.setButtonLayoutData(this.addChildContentTypeButton);
        this.addChildContentTypeButton.setText(WorkbenchMessages.ContentTypes_addChildContentTypeButton);
        this.addChildContentTypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            String id = "userCreated" + System.currentTimeMillis();
            IContentTypeManager manager = (IContentTypeManager)this.contentTypesViewer.getInput();
            NewContentTypeDialog dialog = new NewContentTypeDialog(this.getShell(), manager, this.getSelectedContentType());
            if (dialog.open() == 0) {
                try {
                    IContentType newContentType = manager.addContentType(id, dialog.getName(), this.getSelectedContentType());
                    this.contentTypesViewer.refresh((Object)this.getSelectedContentType());
                    this.contentTypesViewer.setSelection((ISelection)new StructuredSelection((Object)newContentType));
                }
                catch (CoreException e1) {
                    MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.ContentTypes_failedAtEditingContentTypes, (String)e1.getMessage());
                }
            }
        }));
        this.addChildContentTypeButton.setEnabled(this.getSelectedContentType() != null);
        this.removeContentTypeButton = new Button(buttonsComposite, 8);
        this.setButtonLayoutData(this.removeContentTypeButton);
        this.removeContentTypeButton.setText(WorkbenchMessages.ContentTypes_removeContentTypeButton);
        this.removeContentTypeButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> {
            IContentType selectedContentType = this.getSelectedContentType();
            try {
                Platform.getContentTypeManager().removeContentType(selectedContentType.getId());
                this.contentTypesViewer.refresh();
            }
            catch (CoreException e1) {
                MessageDialog.openError((Shell)this.getShell(), (String)WorkbenchMessages.ContentTypes_failedAtEditingContentTypes, (String)e1.getMessage());
            }
        }));
        this.removeContentTypeButton.setEnabled(this.getSelectedContentType() != null && this.getSelectedContentType().isUserDefined());
    }

    @Override
    public void init(IWorkbench workbench) {
        this.workbench = workbench;
        this.noDefaultAndApplyButton();
    }

    private class ContentTypesContentProvider
    implements ITreeContentProvider {
        private IContentTypeManager manager;

        private ContentTypesContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            ArrayList<IContentType> elements = new ArrayList<IContentType>();
            IContentType baseType = (IContentType)parentElement;
            IContentType[] iContentTypeArray = this.manager.getAllContentTypes();
            int n = iContentTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                IContentType contentType = iContentTypeArray[n2];
                if (Util.equals(contentType.getBaseType(), baseType)) {
                    elements.add(contentType);
                }
                ++n2;
            }
            return elements.toArray();
        }

        public Object getParent(Object element) {
            IContentType contentType = (IContentType)element;
            return contentType.getBaseType();
        }

        public boolean hasChildren(Object element) {
            return this.getChildren(element).length > 0;
        }

        public Object[] getElements(Object inputElement) {
            return this.getChildren(null);
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.manager = (IContentTypeManager)newInput;
        }
    }

    private class ContentTypesLabelProvider
    extends LabelProvider {
        private ContentTypesLabelProvider() {
        }

        public String getText(Object element) {
            IContentType contentType = (IContentType)element;
            return contentType.getName();
        }
    }

    private class FileSpecComparator
    extends ViewerComparator {
        private FileSpecComparator() {
        }

        public int category(Object element) {
            return ((Spec)element).sortValue;
        }
    }

    private class FileSpecContentProvider
    implements IStructuredContentProvider {
        private FileSpecContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            IContentType contentType = (IContentType)inputElement;
            String[] userextfileSpecs = contentType.getFileSpecs(9);
            String[] usernamefileSpecs = contentType.getFileSpecs(5);
            String[] preextfileSpecs = contentType.getFileSpecs(10);
            String[] prenamefileSpecs = contentType.getFileSpecs(6);
            return this.createSpecs(userextfileSpecs, usernamefileSpecs, preextfileSpecs, prenamefileSpecs);
        }

        private Object[] createSpecs(String[] userextfileSpecs, String[] usernamefileSpecs, String[] preextfileSpecs, String[] prenamefileSpecs) {
            Spec spec;
            ArrayList<Spec> returnValues = new ArrayList<Spec>();
            String[] stringArray = usernamefileSpecs;
            int n = usernamefileSpecs.length;
            int n2 = 0;
            while (n2 < n) {
                String usernamefileSpec = stringArray[n2];
                spec = new Spec();
                spec.name = usernamefileSpec;
                spec.isPredefined = false;
                spec.sortValue = 0;
                returnValues.add(spec);
                ++n2;
            }
            stringArray = prenamefileSpecs;
            n = prenamefileSpecs.length;
            n2 = 0;
            while (n2 < n) {
                String prenamefileSpec = stringArray[n2];
                spec = new Spec();
                spec.name = prenamefileSpec;
                spec.isPredefined = true;
                spec.sortValue = 1;
                returnValues.add(spec);
                ++n2;
            }
            stringArray = userextfileSpecs;
            n = userextfileSpecs.length;
            n2 = 0;
            while (n2 < n) {
                String userextfileSpec = stringArray[n2];
                spec = new Spec();
                spec.ext = userextfileSpec;
                spec.isPredefined = false;
                spec.sortValue = 2;
                returnValues.add(spec);
                ++n2;
            }
            stringArray = preextfileSpecs;
            n = preextfileSpecs.length;
            n2 = 0;
            while (n2 < n) {
                String preextfileSpec = stringArray[n2];
                spec = new Spec();
                spec.ext = preextfileSpec;
                spec.isPredefined = true;
                spec.sortValue = 3;
                returnValues.add(spec);
                ++n2;
            }
            return returnValues.toArray();
        }
    }

    private class FileSpecLabelProvider
    extends LabelProvider {
        private FileSpecLabelProvider() {
        }

        public String getText(Object element) {
            String label = super.getText(element);
            return TextProcessor.process((String)label, (String)"*.");
        }
    }

    private class Spec {
        String name;
        String ext;
        boolean isPredefined;
        int sortValue;

        private Spec() {
        }

        public String toString() {
            String toString = this.name != null ? this.name : "*." + this.ext;
            if (this.isPredefined) {
                toString = NLS.bind((String)WorkbenchMessages.ContentTypes_lockedFormat, (Object)toString);
            }
            return toString;
        }
    }
}

