/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.wizards;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.TreeSet;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.ProjectSetCapability;
import org.eclipse.team.core.ProjectSetSerializationContext;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.core.RepositoryProviderType;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.UIProjectSetSerializationContext;
import org.eclipse.team.internal.ui.wizards.ExportProjectSetLocationPage;
import org.eclipse.team.internal.ui.wizards.ExportProjectSetMainPage;
import org.eclipse.team.internal.ui.wizards.PsfFilenameStore;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.XMLMemento;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ProjectSetExportWizard
extends Wizard
implements IExportWizard {
    ExportProjectSetMainPage mainPage;
    ExportProjectSetLocationPage locationPage;
    IStructuredSelection selection;

    public ProjectSetExportWizard() {
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(TeamUIMessages.ProjectSetExportWizard_Project_Set_1);
    }

    public void addPages() {
        this.mainPage = new ExportProjectSetMainPage("projectSetMainPage", TeamUIMessages.ProjectSetExportWizard_Export_a_Project_Set_3, TeamUIPlugin.getImageDescriptor("wizban/export_projectset_wizban.png"));
        IProject[] projects = this.selection.toList().toArray(new IProject[0]);
        this.addPage((IWizardPage)this.mainPage);
        this.mainPage.setSelectedProjects(projects);
        this.locationPage = new ExportProjectSetLocationPage("projectSetLocationPage", TeamUIMessages.ProjectSetExportWizard_Export_a_Project_Set_3, TeamUIPlugin.getImageDescriptor("wizban/export_projectset_wizban.png"));
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean performFinish() {
        boolean[] result;
        block5: {
            result = new boolean[1];
            try {
                this.getContainer().run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) throws InvocationTargetException {
                        boolean r;
                        String filename = ProjectSetExportWizard.this.locationPage.getFileName();
                        Path path = new Path(filename);
                        if (path.getFileExtension() == null) {
                            filename = String.valueOf(filename) + ".psf";
                        }
                        PsfFilenameStore.getInstance().remember(filename);
                        File file = new File(filename);
                        File parentFile = file.getParentFile();
                        if (parentFile != null && !parentFile.exists()) {
                            r = MessageDialog.openQuestion((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Question_4, (String)TeamUIMessages.ProjectSetExportWizard_Target_directory_does_not_exist__Would_you_like_to_create_it__5);
                            if (!r) {
                                result[0] = false;
                                return;
                            }
                            r = parentFile.mkdirs();
                            if (!r) {
                                MessageDialog.openError((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Export_Problems_6, (String)TeamUIMessages.ProjectSetExportWizard_An_error_occurred_creating_the_target_directory_7);
                                result[0] = false;
                                return;
                            }
                        }
                        if (file.exists() && file.isFile() && !(r = MessageDialog.openQuestion((Shell)ProjectSetExportWizard.this.getShell(), (String)TeamUIMessages.ProjectSetExportWizard_Question_8, (String)TeamUIMessages.ProjectSetExportWizard_Target_already_exists__Would_you_like_to_overwrite_it__9))) {
                            result[0] = false;
                            return;
                        }
                        IWorkingSet[] workingSets = null;
                        if (ProjectSetExportWizard.this.mainPage.exportWorkingSets.getSelection()) {
                            workingSets = ProjectSetExportWizard.this.mainPage.getSelectedWorkingSets();
                        }
                        IProject[] projects = ProjectSetExportWizard.this.mainPage.getSelectedProjects();
                        HashMap<String, TreeSet<IProject>> map = new HashMap<String, TreeSet<IProject>>();
                        int i = 0;
                        while (i < projects.length) {
                            IProject project = projects[i];
                            RepositoryProvider provider = RepositoryProvider.getProvider((IProject)project);
                            if (provider != null) {
                                String id = provider.getID();
                                TreeSet<IProject> list = (TreeSet<IProject>)map.get(id);
                                if (list == null) {
                                    list = new TreeSet<IProject>(new Comparator(){

                                        public int compare(Object o1, Object o2) {
                                            return ((IProject)o1).getName().toLowerCase().compareTo(((IProject)o2).getName().toLowerCase());
                                        }
                                    });
                                    map.put(id, list);
                                }
                                list.add(project);
                            }
                            ++i;
                        }
                        UIProjectSetSerializationContext context = new UIProjectSetSerializationContext(ProjectSetExportWizard.this.getShell(), filename);
                        BufferedWriter writer = null;
                        try {
                            try {
                                IMemento memento;
                                if (!ProjectSetExportWizard.this.locationPage.isSaveToFileSystem()) {
                                    ProjectSetExportWizard.this.locationPage.validateEditWorkspaceFile(ProjectSetExportWizard.this.getShell());
                                }
                                writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(file), "UTF-8"));
                                XMLMemento xmlMemento = this.getXMLMementoRoot();
                                Iterator it = map.keySet().iterator();
                                monitor.beginTask(null, 1000 * map.keySet().size());
                                while (it.hasNext()) {
                                    String id = (String)it.next();
                                    memento = xmlMemento.createChild("provider");
                                    memento.putString("id", id);
                                    Set list = (Set)map.get(id);
                                    IProject[] projectArray = list.toArray(new IProject[list.size()]);
                                    RepositoryProviderType providerType = RepositoryProviderType.getProviderType((String)id);
                                    ProjectSetCapability serializer = providerType.getProjectSetCapability();
                                    ProjectSetCapability.ensureBackwardsCompatible((RepositoryProviderType)providerType, (ProjectSetCapability)serializer);
                                    if (serializer == null) continue;
                                    String[] references = serializer.asReference(projectArray, (ProjectSetSerializationContext)context, (IProgressMonitor)new SubProgressMonitor(monitor, 990));
                                    int i2 = 0;
                                    while (i2 < references.length) {
                                        IMemento proj = memento.createChild("project");
                                        proj.putString("reference", references[i2]);
                                        ++i2;
                                    }
                                }
                                if (workingSets != null) {
                                    int i3 = 0;
                                    while (i3 < workingSets.length) {
                                        memento = xmlMemento.createChild("workingSets");
                                        workingSets[i3].saveState(memento);
                                        ++i3;
                                    }
                                }
                                xmlMemento.save((Writer)writer);
                                result[0] = true;
                            }
                            catch (IOException e) {
                                throw new InvocationTargetException(e);
                            }
                            catch (TeamException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                        finally {
                            if (writer != null) {
                                try {
                                    writer.close();
                                }
                                catch (IOException e) {
                                    throw new InvocationTargetException(e);
                                }
                            }
                        }
                        if (!ProjectSetExportWizard.this.locationPage.isSaveToFileSystem()) {
                            try {
                                ProjectSetExportWizard.this.locationPage.refreshWorkspaceFile(monitor);
                            }
                            catch (CoreException e) {
                                // empty catch block
                            }
                        }
                        for (String id : map.keySet()) {
                            ProjectSetCapability capability;
                            RepositoryProviderType type = RepositoryProviderType.getProviderType((String)id);
                            if (type == null || (capability = type.getProjectSetCapability()) == null) continue;
                            capability.projectSetCreated(file, (ProjectSetSerializationContext)context, (IProgressMonitor)new SubProgressMonitor(monitor, 10));
                        }
                        monitor.done();
                    }

                    private XMLMemento getXMLMementoRoot() {
                        try {
                            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
                            Element element = document.createElement("psf");
                            element.setAttribute("version", "2.0");
                            document.appendChild(element);
                            return new XMLMemento(document, element);
                        }
                        catch (ParserConfigurationException e) {
                            throw new Error(e.getMessage());
                        }
                    }
                });
            }
            catch (InterruptedException e) {
                return true;
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof TeamException) {
                    ErrorDialog.openError((Shell)this.getShell(), null, null, (IStatus)((TeamException)target).getStatus());
                    return false;
                }
                if (target instanceof RuntimeException) {
                    throw (RuntimeException)target;
                }
                if (!(target instanceof Error)) break block5;
                throw (Error)target;
            }
        }
        return result[0];
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        this.selection = selection;
    }
}

