/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.ui.synchronize;

import java.util.Arrays;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.core.subscribers.Subscriber;
import org.eclipse.team.core.synchronize.SyncInfoFilter;
import org.eclipse.team.core.synchronize.SyncInfoTree;
import org.eclipse.team.internal.core.subscribers.SubscriberSyncInfoCollector;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.IRefreshSubscriberListener;
import org.eclipse.team.internal.ui.synchronize.IRefreshable;
import org.eclipse.team.internal.ui.synchronize.RefreshParticipantJob;
import org.eclipse.team.internal.ui.synchronize.RefreshSubscriberParticipantJob;
import org.eclipse.team.internal.ui.synchronize.RefreshUserNotificationPolicy;
import org.eclipse.team.internal.ui.synchronize.RefreshUserNotificationPolicyInModalDialog;
import org.eclipse.team.internal.ui.synchronize.SubscriberParticipantPage;
import org.eclipse.team.internal.ui.synchronize.SubscriberRefreshSchedule;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeParticipant;
import org.eclipse.team.ui.synchronize.AbstractSynchronizeScope;
import org.eclipse.team.ui.synchronize.ISynchronizePageConfiguration;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipant;
import org.eclipse.team.ui.synchronize.ISynchronizeParticipantReference;
import org.eclipse.team.ui.synchronize.ISynchronizeScope;
import org.eclipse.team.ui.synchronize.ResourceScope;
import org.eclipse.team.ui.synchronize.WorkspaceScope;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.IPageBookViewPage;
import org.eclipse.ui.progress.IProgressConstants2;

public abstract class SubscriberParticipant
extends AbstractSynchronizeParticipant
implements IPropertyChangeListener {
    private SubscriberSyncInfoCollector collector;
    private SubscriberRefreshSchedule refreshSchedule = new SubscriberRefreshSchedule(this.createRefreshable());
    private ISynchronizeScope scope;
    private static final String CTX_SUBSCRIBER_PARTICIPANT_SETTINGS = "org.eclipse.team.ui.TEAMSUBSRCIBERSETTINGS";
    private static final String CTX_SUBSCRIBER_SCHEDULE_SETTINGS = "org.eclipse.team.ui.TEAMSUBSRCIBER_REFRESHSCHEDULE";

    public SubscriberParticipant() {
    }

    private IRefreshable createRefreshable() {
        return new IRefreshable(){

            @Override
            public RefreshParticipantJob createJob(String interval) {
                return new RefreshSubscriberParticipantJob(SubscriberParticipant.this, TeamUIMessages.RefreshSchedule_14, NLS.bind((String)TeamUIMessages.RefreshSchedule_15, (Object[])new String[]{SubscriberParticipant.this.getName(), interval}), SubscriberParticipant.this.getResources(), new RefreshUserNotificationPolicy(SubscriberParticipant.this));
            }

            @Override
            public ISynchronizeParticipant getParticipant() {
                return SubscriberParticipant.this;
            }

            @Override
            public void setRefreshSchedule(SubscriberRefreshSchedule schedule) {
                SubscriberParticipant.this.setRefreshSchedule(schedule);
            }

            @Override
            public SubscriberRefreshSchedule getRefreshSchedule() {
                return SubscriberParticipant.this.getRefreshSchedule();
            }
        };
    }

    public SubscriberParticipant(ISynchronizeScope scope) {
        this();
        this.scope = scope;
        scope.addPropertyChangeListener(this);
    }

    @Override
    public final IPageBookViewPage createPage(ISynchronizePageConfiguration configuration) {
        this.validateConfiguration(configuration);
        return new SubscriberParticipantPage(configuration, this.getSubscriberSyncInfoCollector());
    }

    public IResource[] getResources() {
        return this.collector.getRoots();
    }

    private void setResources(IResource[] roots) {
        this.collector.setRoots(roots);
    }

    public final void refreshInDialog(Shell shell, IResource[] resources, String jobName, String taskName, ISynchronizePageConfiguration configuration, IWorkbenchSite site) {
        RefreshUserNotificationPolicyInModalDialog listener = new RefreshUserNotificationPolicyInModalDialog(shell, taskName, configuration, this);
        this.internalRefresh(resources, jobName, taskName, site, listener);
    }

    public final void refresh(IResource[] resources, String shortTaskName, String longTaskName, IWorkbenchSite site) {
        RefreshUserNotificationPolicy listener = new RefreshUserNotificationPolicy(this);
        this.internalRefresh(resources, shortTaskName, longTaskName, site, listener);
    }

    public final IStatus refreshNow(IResource[] resources, String taskName, IProgressMonitor monitor) {
        Job.getJobManager().cancel((Object)this);
        RefreshSubscriberParticipantJob job = new RefreshSubscriberParticipantJob(this, taskName, taskName, resources, null);
        return job.run(monitor);
    }

    @Override
    public void dispose() {
        Job.getJobManager().cancel((Object)this);
        this.refreshSchedule.dispose();
        TeamUI.removePropertyChangeListener(this);
        this.collector.dispose();
        this.scope.dispose();
    }

    @Override
    public String getName() {
        String name = super.getName();
        return NLS.bind((String)TeamUIMessages.SubscriberParticipant_namePattern, (Object[])new String[]{name, this.scope.getName()});
    }

    protected final String getShortName() {
        return super.getName();
    }

    public SyncInfoTree getSyncInfoSet() {
        return this.getSubscriberSyncInfoCollector().getSyncInfoSet();
    }

    public Subscriber getSubscriber() {
        if (this.collector == null) {
            return null;
        }
        return this.collector.getSubscriber();
    }

    public static SubscriberParticipant getMatchingParticipant(String ID, IResource[] resources) {
        ISynchronizeParticipantReference[] refs = TeamUI.getSynchronizeManager().getSynchronizeParticipants();
        int i = 0;
        while (i < refs.length) {
            block5: {
                ISynchronizeParticipantReference reference = refs[i];
                if (reference.getId().equals(ID)) {
                    SubscriberParticipant p;
                    try {
                        p = (SubscriberParticipant)reference.getParticipant();
                    }
                    catch (TeamException e) {
                        break block5;
                    }
                    Object[] roots = p.getResources();
                    Arrays.sort(resources, Utils.resourceComparator);
                    Arrays.sort(roots, Utils.resourceComparator);
                    if (Arrays.equals(resources, roots)) {
                        return p;
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("org.eclipse.team.uiglobal_ignores_changed")) {
            this.collector.reset();
        }
        if (event.getProperty().equals("prop_roots")) {
            this.setResources(this.scope.getRoots());
        }
        if (event.getProperty().equals("prop_name")) {
            this.firePropertyChange(this, "org.eclipse.jface.text", null, this.getName());
        }
    }

    @Override
    public void init(String secondaryId, IMemento memento) throws PartInitException {
        IMemento settings;
        super.init(secondaryId, memento);
        if (memento != null && (settings = memento.getChild(CTX_SUBSCRIBER_PARTICIPANT_SETTINGS)) != null) {
            SubscriberRefreshSchedule schedule = SubscriberRefreshSchedule.init(settings.getChild(CTX_SUBSCRIBER_SCHEDULE_SETTINGS), this.createRefreshable());
            this.setRefreshSchedule(schedule);
            this.scope = AbstractSynchronizeScope.createScope(settings);
            this.scope.addPropertyChangeListener(this);
        }
    }

    @Override
    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento settings = memento.createChild(CTX_SUBSCRIBER_PARTICIPANT_SETTINGS);
        this.refreshSchedule.saveState(settings.createChild(CTX_SUBSCRIBER_SCHEDULE_SETTINGS));
        AbstractSynchronizeScope.saveScope(this.scope, settings);
    }

    public void reset() {
        this.getSubscriberSyncInfoCollector().reset();
    }

    public SubscriberSyncInfoCollector getSubscriberSyncInfoCollector() {
        return this.collector;
    }

    public void setRefreshSchedule(SubscriberRefreshSchedule schedule) {
        if (this.refreshSchedule != schedule) {
            if (this.refreshSchedule != null) {
                this.refreshSchedule.dispose();
            }
            this.refreshSchedule = schedule;
        }
        this.firePropertyChange(this, "org.eclipse.team.schedule", schedule, schedule);
    }

    public SubscriberRefreshSchedule getRefreshSchedule() {
        return this.refreshSchedule;
    }

    @Override
    protected void initializeConfiguration(ISynchronizePageConfiguration configuration) {
        configuration.setProperty("org.eclipse.team.ui.P_PARTICIPANT_SYNC_INFO_SET", this.collector.getSyncInfoSet());
    }

    @Override
    public void run(IWorkbenchPart part) {
        this.refresh(this.getResources(), null, null, (IWorkbenchSite)(part != null ? part.getSite() : null));
    }

    protected String getShortTaskName() {
        return TeamUIMessages.Participant_synchronizing;
    }

    @Deprecated
    protected String getLongTaskName() {
        return TeamUIMessages.Participant_synchronizing;
    }

    protected String getLongTaskName(IResource[] resources) {
        int resourceCount = 0;
        if (this.getResources().length == resources.length) {
            ISynchronizeScope scope = this.getScope();
            if (scope instanceof ResourceScope) {
                resourceCount = scope.getRoots().length;
            }
        } else {
            resourceCount = resources.length;
        }
        if (resourceCount == 1) {
            return NLS.bind((String)TeamUIMessages.Participant_synchronizingMoreDetails, (Object[])new String[]{this.getShortName(), resources[0].getFullPath().toString()});
        }
        if (resourceCount > 1) {
            return NLS.bind((String)TeamUIMessages.Participant_synchronizingResources, (Object[])new String[]{this.getShortName(), Integer.toString(resourceCount)});
        }
        return NLS.bind((String)TeamUIMessages.Participant_synchronizingDetails, (Object[])new String[]{this.getName()});
    }

    protected void validateConfiguration(ISynchronizePageConfiguration configuration) {
    }

    protected void setSubscriber(Subscriber subscriber) {
        if (this.scope == null) {
            this.scope = new WorkspaceScope();
        }
        this.collector = new SubscriberSyncInfoCollector(subscriber, this.scope.getRoots());
        TeamUI.addPropertyChangeListener(this);
        this.collector.start();
        SubscriberRefreshSchedule schedule = this.getRefreshSchedule();
        if (schedule.isEnabled()) {
            this.getRefreshSchedule().startJob();
        }
    }

    protected void setSyncInfoFilter(SyncInfoFilter filter) {
        this.collector.setFilter(filter);
    }

    private void internalRefresh(IResource[] resources, String jobName, String taskName, IWorkbenchSite site, IRefreshSubscriberListener listener) {
        if (jobName == null) {
            jobName = this.getShortTaskName();
        }
        if (taskName == null) {
            taskName = this.getLongTaskName(resources);
        }
        Job.getJobManager().cancel((Object)this);
        RefreshSubscriberParticipantJob job = new RefreshSubscriberParticipantJob(this, jobName, taskName, resources, listener);
        job.setUser(true);
        job.setProperty(IProgressConstants2.SHOW_IN_TASKBAR_ICON_PROPERTY, Boolean.TRUE);
        Utils.schedule(job, site);
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant", this.getId());
        TeamUIPlugin.getPlugin().getPreferenceStore().setValue("org.eclipse.team.ui.sychronizing_default_participant_sec_id", this.getSecondaryId());
    }

    public ISynchronizeScope getScope() {
        return this.scope;
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IRefreshable.class && this.refreshSchedule != null) {
            return this.refreshSchedule.getRefreshable();
        }
        return super.getAdapter(adapter);
    }
}

