/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.sign.ui.CertificateIntroButtonInformation;
import org.tizen.common.sign.ui.CertificateType;
import org.tizen.common.sign.ui.ICertificateCreationHandler;

public class CertificateTypeExtensions {
    public static final String EXTENSION_POINT_PROFILE_CREATION_BUTTONS = "org.tizen.common.sign.ui.certificateTypes";
    public static final String ELEMENT_TYPE = "type";
    public static final String ELEMENT_CREATION_BUTTON = "button";
    public static final String ATTRIBUTE_NAME = "name";
    public static final String ATTRIBUTE_PROFILE_TYPE = "profileType";
    public static final String ATTRIBUTE_LABEL = "label";
    public static final String ATTRIBUTE_DESC = "description";
    public static final String ATTRIBUTE_NORMAL_IMAGE = "normalImage";
    public static final String ATTRIBUTE_SELECTED_IMAGE = "selectedImage";
    public static final String ATTRIBUTE_HOVER_IMAGE = "hoverImage";
    public static final String ATTRIBUTE_BUTTON_HANDLER = "handler";
    private static final Logger logger = LoggerFactory.getLogger(CertificateTypeExtensions.class);
    private static final List<CertificateType> certificateTypeList = new ArrayList<CertificateType>();

    public static void registerCertificateTypes() {
        IConfigurationElement[] ces;
        IExtensionRegistry reg = RegistryFactory.getRegistry();
        IConfigurationElement[] iConfigurationElementArray = ces = reg.getConfigurationElementsFor(EXTENSION_POINT_PROFILE_CREATION_BUTTONS);
        int n = ces.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            if (ELEMENT_TYPE.equals(ce.getName())) {
                IConfigurationElement[] childs;
                String name = ce.getAttribute(ATTRIBUTE_NAME);
                String profileType = ce.getAttribute(ATTRIBUTE_PROFILE_TYPE);
                IConfigurationElement[] iConfigurationElementArray2 = childs = ce.getChildren();
                int n3 = childs.length;
                int n4 = 0;
                while (n4 < n3) {
                    block10: {
                        IConfigurationElement child = iConfigurationElementArray2[n4];
                        if (ELEMENT_CREATION_BUTTON.equals(child.getName())) {
                            ICertificateCreationHandler handler;
                            String hoverImagePath;
                            String selectedImagePath;
                            String normalImagePath;
                            String description;
                            String label;
                            String contributor;
                            block9: {
                                contributor = child.getContributor().getName();
                                label = child.getAttribute(ATTRIBUTE_LABEL);
                                description = child.getAttribute(ATTRIBUTE_DESC);
                                normalImagePath = child.getAttribute(ATTRIBUTE_NORMAL_IMAGE);
                                selectedImagePath = child.getAttribute(ATTRIBUTE_SELECTED_IMAGE);
                                hoverImagePath = child.getAttribute(ATTRIBUTE_HOVER_IMAGE);
                                String handlerName = child.getAttribute(ATTRIBUTE_BUTTON_HANDLER);
                                handler = null;
                                if (handlerName != null) {
                                    try {
                                        Object obj = child.createExecutableExtension(ATTRIBUTE_BUTTON_HANDLER);
                                        if (!(obj instanceof ICertificateCreationHandler)) break block9;
                                        handler = (ICertificateCreationHandler)obj;
                                    }
                                    catch (CoreException e) {
                                        logger.error("Failed to get handler from extension", (Throwable)e);
                                        break block10;
                                    }
                                }
                            }
                            Image normalImage = CertificateTypeExtensions.getImageFromContributor(contributor, normalImagePath);
                            Image selectedImage = CertificateTypeExtensions.getImageFromContributor(contributor, selectedImagePath);
                            Image hoverImage = CertificateTypeExtensions.getImageFromContributor(contributor, hoverImagePath);
                            if (normalImage == null || selectedImage == null || hoverImage == null) {
                                logger.error("Failed to get button images of extension certificate. Check image path");
                            } else {
                                CertificateIntroButtonInformation buttonInfo = new CertificateIntroButtonInformation(label, description, normalImage, selectedImage, hoverImage, handler);
                                CertificateType certType = new CertificateType(name, profileType, buttonInfo);
                                certificateTypeList.add(certType);
                            }
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    public static List<CertificateType> getCertificateTypes() {
        return certificateTypeList;
    }

    private static Image getImageFromContributor(String contributor, String imagePath) {
        try {
            InputStream openStream = FileLocator.openStream((Bundle)Platform.getBundle((String)contributor), (IPath)new Path(imagePath), (boolean)false);
            Image image = new Image(null, openStream);
            return image;
        }
        catch (IOException iOException) {
            logger.error("Failed to image from contributor: " + contributor + "," + imagePath);
            return null;
        }
    }
}

