/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui.common;

import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.tizen.common.sign.ui.common.CertificateManagementImages;
import org.tizen.common.sign.ui.common.Messages;
import org.tizen.common.sign.ui.model.CertificateInformation;
import org.tizen.common.ui.color.TizenColors;
import org.tizen.common.ui.font.TizenFonts;
import org.tizen.common.util.FilenameUtil;

public class CertificateComposite
extends Composite {
    private CertificateInformation certInfo;
    private final TextStyle certTitleTextStyle = new TextStyle(TizenFonts.getSmallBoldFont(), null, null);
    private final TextStyle certInfoTextStyle = new TextStyle(TizenFonts.getSmallFont(), null, null);
    private final TextStyle certDescTextStyle = new TextStyle(TizenFonts.getSmallItalicFont(), TizenColors.getTizenDarkGrey(), null);
    private final CertificateManagementImages certificateImages = new CertificateManagementImages();
    private static final String NEWLINE = "\n";

    public CertificateComposite(Composite parent, int style, CertificateInformation certInfo) {
        super(parent, style);
        this.certInfo = certInfo;
        this.createControl();
        final TextLayout textLayout = this.getTextLayout();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                switch (event.type) {
                    case 9: {
                        int imgLocationX = CertificateComposite.this.getSize().x / 2 - ((CertificateComposite)CertificateComposite.this).certificateImages.CERTIFICATE.getImageData().width / 2;
                        int imgLocationY = (CertificateComposite.this.getSize().y + 30) / 2 - ((CertificateComposite)CertificateComposite.this).certificateImages.CERTIFICATE.getImageData().height / 2;
                        event.gc.drawImage(((CertificateComposite)CertificateComposite.this).certificateImages.CERTIFICATE, imgLocationX, imgLocationY);
                        textLayout.draw(event.gc, 10, 10);
                        break;
                    }
                    case 11: {
                        if (CertificateComposite.this.getSize().x <= 20) break;
                        textLayout.setWidth(CertificateComposite.this.getSize().x - 20);
                    }
                }
            }
        };
        this.addListener(9, listener);
        this.addListener(11, listener);
    }

    public CertificateComposite(Composite parent, int style) {
        this(parent, style, null);
    }

    public void setCertificate(CertificateInformation certInfo) {
        this.certInfo = certInfo;
    }

    private TextLayout getTextLayout() {
        TextLayout textLayout = new TextLayout((Device)this.getShell().getDisplay());
        String info = this.getInformationString();
        textLayout.setText(info);
        if (!info.isEmpty()) {
            int idx = info.indexOf("\n\n");
            textLayout.setStyle(this.certTitleTextStyle, 0, idx);
            if (this.certInfo != null && this.certInfo.isLock()) {
                textLayout.setStyle(this.certDescTextStyle, idx + 1, info.length());
            } else {
                textLayout.setStyle(this.certInfoTextStyle, idx + 1, info.length());
            }
        }
        return textLayout;
    }

    private String getInformationString() {
        String info = "";
        if (this.certInfo != null) {
            String filename = this.certInfo.isIotService() ? this.certInfo.getFilename() : FilenameUtil.getName((String)this.certInfo.getFilename());
            info = String.valueOf(filename) + NEWLINE + NEWLINE;
            if (this.certInfo.isLock()) {
                info = this.certInfo.isIotService() ? String.valueOf(info) + Messages.CERT_COMPOSITE_HIDDEN : String.valueOf(info) + Messages.CERT_COMPOSITE_LOCK;
            } else {
                info = String.valueOf(info) + Messages.CERT_COMPOSITE_VERIFIED + this.certInfo.getIssuerCommonName() + NEWLINE;
                info = String.valueOf(info) + Messages.CERT_COMPOSITE_EXPIRES + this.certInfo.getExpires();
            }
        }
        return info;
    }

    public void createControl() {
        this.setBackgroundMode(1);
        this.setLayout((Layout)new GridLayout());
        FormData formData = new FormData();
        formData.left = new FormAttachment(0);
        formData.right = new FormAttachment(100);
        formData.top = new FormAttachment(0);
        formData.bottom = new FormAttachment(100, -30);
        this.setLayoutData(formData);
    }
}

