/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.util;

import java.security.Key;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.core.command.Prompter;

public class Certification {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected Prompter prompter;
    protected KeyStore keyStore;
    protected PrivateKey privateKey;
    protected String privateKeyAlias;
    protected List<X509Certificate> certificationChain;
    protected X509Certificate certificate;
    protected String password;

    public Certification(Prompter prompter) {
        this.prompter = prompter;
    }

    protected Prompter getPrompter() {
        return this.prompter;
    }

    protected char[] inputPassword(String message) {
        Prompter prompter = this.getPrompter();
        return (char[])prompter.password(message);
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public Key getPrivateKey() {
        return this.privateKey;
    }

    public X509Certificate[] getCertificationChain() {
        return this.certificationChain.toArray(new X509Certificate[0]);
    }

    public static enum KeyExtension {
        p12("PKCS12"),
        keystore("JKS");

        private String keyType;

        private KeyExtension(String keyType) {
            this.keyType = keyType;
        }

        public String getKeyType() {
            return this.keyType;
        }

        public static boolean hasExtension(String extension) {
            KeyExtension[] keyExtensionArray = KeyExtension.values();
            int n = keyExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                KeyExtension keyExt = keyExtensionArray[n2];
                if (keyExt.name().equalsIgnoreCase(extension)) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
    }
}

