/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sdb.command;

import java.util.ArrayList;
import java.util.List;
import org.tizen.common.sdb.command.AbstractAppCommand;
import org.tizen.common.sdb.command.SdbCommandHelper;
import org.tizen.common.ui.view.console.ITizenConsoleManager;
import org.tizen.sdblib.IDevice;

public class LaunchCommand
extends AbstractAppCommand {
    protected String widgetId = null;
    protected String args = "";
    protected boolean isUseWidgetViewer = false;

    public LaunchCommand(IDevice device, String widgetId, String args, ITizenConsoleManager console) {
        this.device = device;
        this.widgetId = widgetId;
        this.args = args != null ? args : "";
        this.launchConsole = console;
    }

    public LaunchCommand(IDevice device, String widgetId, String args, boolean isUseWidgetViewerSdk, ITizenConsoleManager console) {
        this.device = device;
        this.widgetId = widgetId;
        this.args = args;
        this.isUseWidgetViewer = isUseWidgetViewerSdk;
        this.launchConsole = console;
    }

    protected LaunchCommand() {
    }

    protected List<String> getCommand() {
        ArrayList<String> command = new ArrayList<String>();
        command.add(this.getSdbPath());
        command.add("-s");
        command.add(this.device.getSerialNumber());
        command.add("launch");
        command.add("-a");
        command.addAll(this.splitParams(this.getWidgetId()));
        command.add("-p");
        command.add("-e");
        command.add("-m");
        command.add("run");
        command.addAll(this.splitParams(this.getArgs()));
        return command;
    }

    protected List<String> splitParams(String param) {
        ArrayList<String> results = new ArrayList<String>();
        if (!param.isEmpty()) {
            String[] splitArgs = param.split(" ");
            int i = 0;
            while (i < splitArgs.length) {
                results.add(splitArgs[i]);
                ++i;
            }
        }
        return results;
    }

    @Override
    protected void executeCommand() throws Exception {
        this.helper = new SdbCommandHelper(this.getDevice(), this.getConsole(), null);
        this.helper.runHostCommand(this.getCommand());
    }

    protected String getWidgetId() {
        if (this.isUseWidgetViewer()) {
            this.widgetId = "org.tizen.widget_viewer_sdk widget_id " + this.widgetId;
        }
        return this.widgetId;
    }

    protected String getArgs() {
        return this.args;
    }

    public String getCommandOutput() {
        return this.helper.getCommandOutput();
    }

    protected boolean isUseWidgetViewer() {
        return this.isUseWidgetViewer;
    }
}

