/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.util;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.URIUtil;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.Surrogate;
import org.tizen.common.util.Assert;

public class PluginUtil {
    protected static final Logger logger = LoggerFactory.getLogger(PluginUtil.class);
    protected static Surrogate<IExtensionRegistry> platformSurrogate = new Surrogate<IExtensionRegistry>(){

        @Override
        public IExtensionRegistry getAdapter() {
            return Platform.getExtensionRegistry();
        }
    };

    public static Object[] loadClasses(String extPointId) throws CoreException {
        IExtension[] exts;
        IExtensionRegistry registry = platformSurrogate.getAdapter();
        IExtensionPoint ep = registry.getExtensionPoint(extPointId);
        ArrayList<Object> classList = new ArrayList<Object>();
        if (ep == null) {
            return classList.toArray();
        }
        IExtension[] iExtensionArray = exts = ep.getExtensions();
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] configs;
            IExtension ext = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = configs = ext.getConfigurationElements();
            int n3 = configs.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement config = iConfigurationElementArray[n4];
                Object cls = config.createExecutableExtension("class");
                classList.add(cls);
                ++n4;
            }
            ++n2;
        }
        return classList.toArray();
    }

    public static Object loadClass(String extPointId, String classId) throws CoreException {
        IExtensionRegistry registry = platformSurrogate.getAdapter();
        IExtensionPoint ep = registry.getExtensionPoint(extPointId);
        if (ep != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = ep.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configs;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configs = ext.getConfigurationElements();
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String id = config.getAttribute("id");
                    if (id != null && id.equals(classId)) {
                        return config.createExecutableExtension("class");
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return null;
    }

    public static Object[] getExtensionAttribute(String extPointId, String attribute) throws CoreException {
        IExtensionRegistry registry = platformSurrogate.getAdapter();
        IExtensionPoint ep = registry.getExtensionPoint(extPointId);
        ArrayList<String> values = new ArrayList<String>();
        if (ep != null) {
            IExtension[] exts;
            IExtension[] iExtensionArray = exts = ep.getExtensions();
            int n = exts.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] configs;
                IExtension ext = iExtensionArray[n2];
                IConfigurationElement[] iConfigurationElementArray = configs = ext.getConfigurationElements();
                int n3 = configs.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement config = iConfigurationElementArray[n4];
                    String value = config.getAttribute(attribute);
                    if (value != null && !value.isEmpty()) {
                        values.add(value);
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        return values.toArray();
    }

    public static String getBuiltInPath(String symbolicName, String entryPath) throws Exception {
        URI sourceURI = null;
        URL sourceURL = FileLocator.toFileURL((URL)Platform.getBundle((String)symbolicName).getEntry(entryPath));
        sourceURI = URIUtil.toURI((URL)sourceURL);
        return sourceURI == null ? null : sourceURI.getPath();
    }

    public static URL getBuiltInURL(Plugin plugin, String entryPath) throws IOException {
        Assert.notNull(plugin);
        Assert.notNull(entryPath);
        URL entry = plugin.getBundle().getEntry(entryPath);
        return entry != null ? FileLocator.toFileURL((URL)entry) : null;
    }

    public static IConfigurationElement[] getExtensionConfigurationElements(String extPointId) {
        IExtensionRegistry registry = platformSurrogate.getAdapter();
        return registry.getConfigurationElementsFor(extPointId);
    }

    public static Bundle getBundle(String symbolicName) {
        return Platform.getBundle((String)symbolicName);
    }

    public static URL getFileURLinBundle(String symbolicName, String filePath) {
        Bundle bundle = PluginUtil.getBundle(symbolicName);
        if (bundle == null) {
            return null;
        }
        return PluginUtil.getFileURLinBundle(bundle, filePath);
    }

    public static URL getFileURLinBundle(Bundle bundle, String filePath) {
        if (bundle == null || filePath == null) {
            return null;
        }
        URL url = bundle.getResource(filePath);
        if (url == null) {
            return null;
        }
        URL resolvedURL = null;
        try {
            int separatorIndex = filePath.lastIndexOf("/");
            if (separatorIndex > 0) {
                String rootFilePath = filePath.substring(0, separatorIndex);
                URL rootUrl = bundle.getResource(rootFilePath);
                FileLocator.toFileURL((URL)rootUrl);
            }
            resolvedURL = FileLocator.toFileURL((URL)url);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        return resolvedURL;
    }
}

