/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.regex.Pattern;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.receiver.FolderSizeReceiver;
import org.tizen.sdblib.receiver.LsReceiver;
import org.tizen.sdblib.service.FileEntryType;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.FilenameUtil;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;
import org.tizen.sdblib.util.ObjectUtil;

public class FileEntry
implements Comparable<FileEntry> {
    private static final String FILE_ROOT = "/";
    public static final String FILE_SEPARATOR = "/";
    public static final long REFRESH_RATE = 5000L;
    public static final long REFRESH_TEST = 4000L;
    public static final int USE_CACHE = 0;
    private static final Pattern ESCAPE_PATTERN = Pattern.compile("([\\\\\"$])");
    private static final int RESPONSE_TIMEOUT_GET_FOLDER_SIZE = 2000;
    protected final IDevice device;
    protected final FileEntry parent;
    protected String name;
    protected FileEntryType type;
    protected final String permissions;
    protected final String owner;
    protected final String group;
    protected final String size;
    protected final String date;
    protected final String time;
    protected String linkSource;
    protected final String info;
    protected long fetchTime = 0L;
    protected Collection<FileEntry> children = new ArrayList<FileEntry>();

    public FileEntry(IDevice device, FileEntry parent, String name, FileEntryType type, String permission, String owner, String group, String size, String date, String time, String info, String linkSource) {
        Assert.notNull(name);
        this.device = device == null ? (parent != null ? parent.getDevice() : null) : device;
        this.parent = parent;
        this.name = name;
        this.type = type;
        this.permissions = permission;
        this.owner = owner;
        this.group = group;
        this.size = size;
        this.date = date;
        this.time = time;
        this.info = info;
        this.linkSource = linkSource;
    }

    public FileEntryType getType() {
        return this.type;
    }

    public void setType(FileEntryType type) {
        this.type = type;
    }

    public IDevice getDevice() {
        return this.device;
    }

    public FileEntry getParent() {
        return this.parent;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getSize() {
        return this.size;
    }

    public String getDate() {
        return this.date;
    }

    public String getTime() {
        return this.time;
    }

    public String getPermissions() {
        return this.permissions;
    }

    public String getLinkSource() {
        return this.linkSource;
    }

    public String getInfo() {
        return this.info;
    }

    public String getFullPath() {
        if (this.parent == null) {
            return "/";
        }
        StringBuilder pathBuilder = new StringBuilder();
        this.fillPathBuilder(pathBuilder, false);
        return pathBuilder.toString();
    }

    public String getFullEscapedPath() {
        StringBuilder pathBuilder = new StringBuilder();
        this.fillPathBuilder(pathBuilder, true);
        return pathBuilder.toString();
    }

    public boolean isDirectory() {
        return this.type.isDirectory();
    }

    public static String getStringWithDoubleQuote(String str) {
        return "\"" + str + "\"";
    }

    public FileEntry[] getChildren() {
        LsReceiver receiver;
        block5: {
            receiver = new LsReceiver(this);
            try {
                try {
                    String path = FilenameUtil.addTailingPath("/", this.getType().isLink() ? this.getLinkSource() : this.getFullEscapedPath());
                    String command = String.format("ls -lF %s --time-style=long-iso --show-control-chars 2> /dev/null", FileEntry.getStringWithDoubleQuote(path));
                    String cmd = "";
                    cmd = this.device.isSecureProtocol() && (this.device.getPlatformCapability().getRootOnOffSupport().equals("unknown") || this.device.getPlatformCapability().getRootOnOffSupport().equals("disabled")) ? (this.device.getPlatformCapability().getProductVersion().equals("1.0") ? "0 list " + FileEntry.getStringWithDoubleQuote(path) : "0 list_showcontrol " + FileEntry.getStringWithDoubleQuote(path)) : command;
                    this.device.executeShellCommand(cmd, receiver);
                }
                catch (IOException e) {
                    Log.e("sdb", "excute doLS failed:" + e);
                    IOUtil.tryClose(receiver);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(receiver);
                throw throwable;
            }
            IOUtil.tryClose(receiver);
        }
        this.fetchTime = System.currentTimeMillis();
        this.children = receiver.getEntries();
        return this.children.toArray(new FileEntry[this.children.size()]);
    }

    public FileEntry[] getChildren(int useCache) {
        if (useCache == 0) {
            if (this.needFetch()) {
                return this.getChildren();
            }
            return this.children.toArray(new FileEntry[this.children.size()]);
        }
        return this.getChildren();
    }

    public long getFolderTotalSize() {
        FolderSizeReceiver receiver;
        block5: {
            receiver = new FolderSizeReceiver();
            String fileEntryPath = "";
            fileEntryPath = this.getType().isLink() ? this.getLinkSource() : (this.getType().isRoot() ? "" : this.getFullEscapedPath());
            String path = FilenameUtil.addTailingPath("/", fileEntryPath);
            String command = String.format("du -bs %s 2> /dev/null", FileEntry.getStringWithDoubleQuote(path));
            String cmd = "";
            cmd = this.device.isSecureProtocol() ? "0 getsize " + FileEntry.getStringWithDoubleQuote(path) : command;
            try {
                try {
                    this.device.executeShellCommand(cmd, receiver, 2000);
                }
                catch (IOException e) {
                    Log.e("sdb", "running du command failed:" + e);
                    IOUtil.tryClose(receiver);
                    break block5;
                }
            }
            catch (Throwable throwable) {
                IOUtil.tryClose(receiver);
                throw throwable;
            }
            IOUtil.tryClose(receiver);
        }
        return receiver.getSize();
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    boolean needFetch() {
        if (this.fetchTime == 0L) {
            return true;
        }
        long current = System.currentTimeMillis();
        return current - this.fetchTime > 4000L;
    }

    protected void fillPathBuilder(StringBuilder pathBuilder, boolean escapePath) {
        if (this.parent == null) {
            return;
        }
        this.parent.fillPathBuilder(pathBuilder, escapePath);
        pathBuilder.append("/");
        pathBuilder.append(escapePath ? FileEntry.escape(this.name) : this.name);
    }

    protected void fillPathSegments(ArrayList<String> list) {
        if (this.parent == null) {
            return;
        }
        this.parent.fillPathSegments(list);
        list.add(this.name);
    }

    protected static String escape(String name) {
        return ESCAPE_PATTERN.matcher(name).replaceAll("\\\\$1");
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FileEntry)) {
            return false;
        }
        FileEntry other = (FileEntry)obj;
        return ObjectUtil.equals(this.getDevice(), other.getDevice()) && ObjectUtil.equals(this.name, other.name) && ObjectUtil.equals(this.parent, other.parent);
    }

    public int hashCode() {
        return 100;
    }

    @Override
    public int compareTo(FileEntry o) {
        if (o == null) {
            return -1;
        }
        if (this.parent == null ? !ObjectUtil.equals(this.device, o.device) : !ObjectUtil.equals(this.parent, o.parent)) {
            return -1;
        }
        return this.name.compareTo(o.name);
    }

    public String toString() {
        return this.name;
    }
}

