/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.sdblib.service;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.channels.SocketChannel;
import org.tizen.sdblib.SdbHelper;
import org.tizen.sdblib.SdbResponse;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.SmartDevelopmentBridgeConstants;
import org.tizen.sdblib.exception.SyncException;
import org.tizen.sdblib.exception.TimeoutException;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.service.SyncServiceReturnCode;
import org.tizen.sdblib.util.Assert;
import org.tizen.sdblib.util.ByteUtil;
import org.tizen.sdblib.util.IOUtil;
import org.tizen.sdblib.util.Log;

public class FileEntryInputStream
extends InputStream {
    protected final FileEntry entry;
    protected final int timeOut;
    protected byte[] header = new byte[8];
    protected final byte[] data = new byte[65544];
    protected int index = 0;
    protected int length = 0;
    protected final SocketChannel channel;

    protected static byte[] createFileReq(byte[] command, byte[] path) {
        byte[] array = new byte[8 + path.length];
        System.arraycopy(command, 0, array, 0, 4);
        ByteUtil.toBytes(path.length, array, 4);
        System.arraycopy(path, 0, array, 8, path.length);
        return array;
    }

    public FileEntryInputStream(FileEntry entry, int timeOut) throws IOException {
        Assert.notNull(entry);
        this.entry = entry;
        this.timeOut = timeOut;
        this.channel = SmartDevelopmentBridge.getBridge().openChannel();
        this.channel.configureBlocking(true);
        SdbHelper.initializeDevice(this.channel, this.entry.getDevice().getSerialNumber());
        SdbHelper.write(this.channel, SdbHelper.formSdbRequest("sync:"));
        SdbResponse res = SdbHelper.readSdbResponse(this.channel);
        if (!res.okay) {
            Log.w("sdb", "Got unhappy response from sdb sync req: " + res.message);
            this.channel.close();
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_ERROR);
        }
        byte[] remotePath = SdbHelper.string2bytes(this.entry.getFullPath());
        try {
            if (1024 < remotePath.length) {
                throw new SyncException(SyncServiceReturnCode.RESULT_REMOTE_PATH_LENGTH);
            }
            SdbHelper.write(this.channel, FileEntryInputStream.createFileReq(SmartDevelopmentBridgeConstants.ID_RECV, remotePath), -1, timeOut);
            SdbHelper.read(this.channel, this.header, -1, timeOut);
        }
        catch (UnsupportedEncodingException e) {
            throw new SyncException(SyncServiceReturnCode.RESULT_REMOTE_PATH_ENCODING, (Throwable)e);
        }
        catch (TimeoutException e) {
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_TIMEOUT, (Throwable)e);
        }
        catch (IOException e) {
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Throwable)e);
        }
    }

    @Override
    public int read() throws IOException {
        if (!SdbHelper.check(this.header, 0, SmartDevelopmentBridgeConstants.ID_DATA, 0, 4) && !SdbHelper.check(this.header, 0, SmartDevelopmentBridgeConstants.ID_DONE, 0, 4)) {
            throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_ERROR);
        }
        if (this.length <= this.index) {
            if (SdbHelper.check(this.header, 0, SmartDevelopmentBridgeConstants.ID_DONE, 0, 4)) {
                return -1;
            }
            this.length = ByteUtil.fromBytes(this.header, 4);
            if (this.length > 65536) {
                throw new SyncException(SyncServiceReturnCode.RESULT_BUFFER_OVERRUN);
            }
            try {
                SdbHelper.read(this.channel, this.data, this.length, this.timeOut);
                this.index = 0;
                SdbHelper.read(this.channel, this.header, -1, this.timeOut);
            }
            catch (TimeoutException e) {
                throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_TIMEOUT, (Throwable)e);
            }
            catch (IOException e) {
                throw new SyncException(SyncServiceReturnCode.RESULT_CONNECTION_ERROR, (Throwable)e);
            }
        }
        return 0xFF & this.data[this.index++];
    }

    private static byte[] createReq(byte[] command, int value) {
        byte[] array = new byte[8];
        System.arraycopy(command, 0, array, 0, 4);
        ByteUtil.toBytes(value, array, 4);
        return array;
    }

    @Override
    public void close() throws IOException {
        SdbHelper.write(this.channel, FileEntryInputStream.createReq(SmartDevelopmentBridgeConstants.ID_QUIT, 0));
        IOUtil.tryClose(this.channel);
        super.close();
    }
}

