/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.sign.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.StatusDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.tizen.common.util.Assert;
import org.tizen.common.util.StringUtil;
import org.tizen.common.util.ValidationUtil;

public class CertGenerationDialog
extends StatusDialog {
    protected static final String REGEX_ALPHABETS_WITH_SPACE = "[a-zA-Z ]*";
    protected static final int minimumWidth = 400;
    protected Map<CertDataKey, String> data = new HashMap<CertDataKey, String>();

    public CertGenerationDialog(Shell parent) {
        super(parent);
        this.setTitle("Certificate Generator");
        this.setHelpAvailable(false);
    }

    public String getValue(CertDataKey key) {
        Assert.notNull((Object)((Object)key));
        return this.data.get((Object)key);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridData gridData = (GridData)composite.getLayoutData();
        gridData.minimumWidth = 400;
        gridData.widthHint = 400;
        CertDataKey[] certDataKeyArray = CertDataKey.values();
        int n = certDataKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            CertDataKey key = certDataKeyArray[n2];
            boolean bPassword = key == CertDataKey.Password || key == CertDataKey.ConfirmPW;
            this.createText(composite, key, bPassword);
            ++n2;
        }
        this.validateDialog();
        return composite;
    }

    protected Composite createText(Composite parent, final CertDataKey key, boolean bPassword) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, true));
        composite.setLayoutData((Object)new GridData(768));
        Label label = new Label(composite, 0);
        label.setText(key.getTitle());
        label.setLayoutData((Object)new GridData(768));
        int style = 2052;
        if (bPassword) {
            style |= 0x400000;
        }
        final Text text = new Text(composite, style);
        GridData textLayoutData = new GridData(768);
        text.setLayoutData((Object)textLayoutData);
        text.setText("");
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent modifyevent) {
                CertGenerationDialog.this.data.put(key, text.getText());
                CertGenerationDialog.this.validateDialog();
            }
        });
        return composite;
    }

    protected void validateDialog() {
        CertDataKey[] alphabetSrcs;
        String confirm;
        CertDataKey[] certDataKeyArray = CertDataKey.values();
        int n = certDataKeyArray.length;
        int n2 = 0;
        while (n2 < n) {
            String value;
            CertDataKey key = certDataKeyArray[n2];
            if (key.getRequired() && StringUtil.isEmpty((CharSequence)(value = this.data.get((Object)key)))) {
                this.updateErrorStatus(String.valueOf(key.getTitle()) + " is empty.");
                return;
            }
            ++n2;
        }
        String password = this.data.get((Object)CertDataKey.Password);
        if (!password.equals(confirm = this.data.get((Object)CertDataKey.ConfirmPW))) {
            this.updateErrorStatus("The password and confirmation don't match.");
            return;
        }
        CertDataKey[] certDataKeyArray2 = alphabetSrcs = new CertDataKey[]{CertDataKey.Country, CertDataKey.State, CertDataKey.City};
        int n3 = alphabetSrcs.length;
        int value = 0;
        while (value < n3) {
            CertDataKey alphabetKey = certDataKeyArray2[value];
            String keyValue = this.data.get((Object)alphabetKey);
            if (!StringUtil.isEmpty((CharSequence)keyValue) && !keyValue.matches(REGEX_ALPHABETS_WITH_SPACE)) {
                this.updateErrorStatus(String.valueOf(alphabetKey.name()) + " name should be alphabetical characters.");
                return;
            }
            ++value;
        }
        String email = this.data.get((Object)CertDataKey.Email);
        if (!StringUtil.isEmpty((CharSequence)email) && !ValidationUtil.checkForEmail((String)email)) {
            this.updateErrorStatus("E-mail address is malformed.");
            return;
        }
        String country = this.data.get((Object)CertDataKey.Country);
        if (!StringUtil.isEmpty((CharSequence)country) && country.length() > 2) {
            this.updateWarningStatus("Country name is more than 2 alphabetical characters.");
            return;
        }
        this.updateOKStatus();
    }

    private void updateErrorStatus(String msg) {
        this.updateStatus((IStatus)new Status(4, "org.tizen.common.sign", msg));
    }

    private void updateWarningStatus(String msg) {
        this.updateStatus((IStatus)new Status(2, "org.tizen.common.sign", msg));
    }

    private void updateOKStatus() {
        this.updateStatus((IStatus)new Status(0, "org.tizen.common.sign", ""));
    }

    public static enum CertDataKey {
        KeyName("Key filename", true),
        Alias("Alias", true),
        Password("Password", true),
        ConfirmPW("Password confirmation", true),
        Country("Country (two letters)", false),
        State("State", false),
        City("City", false),
        Organization("Organization", false),
        Department("Department", false),
        Name("Name", false),
        Email("E-mail", false);

        private String title;
        private boolean required;

        private CertDataKey(String title, boolean required) {
            this.title = title;
            this.required = required;
        }

        public String getTitle() {
            return this.getRequired() ? String.valueOf(this.title) + " (*)" : this.title;
        }

        public boolean getRequired() {
            return this.required;
        }
    }
}

