/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.part.ViewPart;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.explorer.ConnectionExplorerPanel;
import org.tizen.common.connection.explorer.ConnectionUIMessages;
import org.tizen.common.connection.explorer.action.ActionDeviceFilePull;
import org.tizen.common.connection.explorer.action.ActionDeviceFilePush;
import org.tizen.common.connection.explorer.action.ActionDeviceRemote;
import org.tizen.common.connection.explorer.action.ActionEmulatorManager;
import org.tizen.common.connection.explorer.action.ActionViewModeChange;
import org.tizen.common.connection.ui.IConnectionMenu;
import org.tizen.common.util.PluginUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.SmartDevelopmentBridge;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.service.FileEntry;
import org.tizen.sdblib.util.IOUtil;

public class ConnectionExplorer
extends ViewPart
implements IPartListener2 {
    private final Logger logger = LoggerFactory.getLogger(ConnectionExplorer.class);
    private static final String MENU_EXTENSION_ID = "org.tizen.common.connection.ui.menus";
    private ConnectionExplorerPanel panel;
    private Composite parent;
    private static Composite middle;
    private MenuManager menuMgr;
    private MenuManager subNewMenu;
    private MenuManager subLogMenu;
    private Action actionEmulatorManager;
    private Action actionDevicePush;
    private Action actionDevicePull;
    private Action actionDeviceRemote;
    private Action actionViewModeChange;
    private Action actionAddFolder;
    private Action actionAddFile;
    private Action actionRename;
    private Action actionDelete;
    private Action actionPush;
    private Action actionPull;
    private Action actionRefresh;
    private Action actionCollapseAll;
    private Action actionProperty;
    private Action actionPlatformLogOn;
    private Action actionPlatformLogOff;
    private Action actionDisconnect;
    private Action actionOpenShell;
    public static String PLATFORMLOG_OFF;
    public static String PLATFORMLOG_ON;
    public static int PLATFORMLOG_UNABLE;
    public static String VIEW_MODE_AUTO;
    public static String VIEW_MODE_HORIZONTAL;
    public static String VIEW_MODE_VERTICAL;
    public static String VIEW_MODE_SINGLE;
    public static Text pathText;
    public static IStatusLineManager statusLineManager;
    private static ConnectionExplorer connectionExplorer;

    static {
        PLATFORMLOG_OFF = "0";
        PLATFORMLOG_ON = "1";
        PLATFORMLOG_UNABLE = 2;
        VIEW_MODE_AUTO = "Auto";
        VIEW_MODE_HORIZONTAL = "Horizontal";
        VIEW_MODE_VERTICAL = "Vertical";
        VIEW_MODE_SINGLE = "Single";
    }

    public static void setConnectionExplorer(ConnectionExplorer connectionExplorer) {
        ConnectionExplorer.connectionExplorer = connectionExplorer;
    }

    public static void setStatusLineManager(IStatusLineManager statusLineManager) {
        ConnectionExplorer.statusLineManager = statusLineManager;
    }

    public static void setPath(Text pathText) {
        ConnectionExplorer.pathText = pathText;
    }

    public static void setMiddle(Composite middle) {
        ConnectionExplorer.middle = middle;
    }

    public static ConnectionExplorer getConnectionExplorer() {
        return connectionExplorer;
    }

    public void dispose() {
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        workbenchWindow.getPartService().removePartListener((IPartListener2)this);
        super.dispose();
    }

    public void createPartControl(Composite p) {
        IWorkbenchWindow workbenchWindow = this.getSite().getWorkbenchWindow();
        workbenchWindow.getPartService().addPartListener((IPartListener2)this);
        this.parent = p;
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.parent, "org.tizen.ide.common.connection_explorer_context");
        this.parent.setLayoutData((Object)new GridData(1040));
        this.parent.setLayout((Layout)new GridLayout(1, false));
        Composite top = new Composite(this.parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 1;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        GridData gridData = new GridData(768);
        top.setLayoutData((Object)gridData);
        top.setLayout((Layout)gridLayout);
        ConnectionExplorer.setMiddle(new Composite(this.parent, 0));
        middle.setLayoutData((Object)gridData);
        middle.setLayout((Layout)new FillLayout());
        ConnectionExplorer.setPath(new Text(middle, 2052));
        pathText.addListener(14, new Listener(){

            public void handleEvent(Event e) {
                ConnectionExplorer.this.panel.expandTreeAtPath(pathText.getText());
            }
        });
        Composite bottom = new Composite(this.parent, 0);
        bottom.setLayoutData((Object)new GridData(1808));
        bottom.setLayout((Layout)new FillLayout());
        this.createFileExplorerView(bottom);
        this.createToolBar();
        this.makeActions();
        this.activateContext();
        this.initContextMenu();
        this.panel.setToolItems(this.actionDevicePush, this.actionDevicePull);
        this.panel.setActions(this.subNewMenu, this.actionPush, this.actionPull, this.actionRefresh, this.actionCollapseAll, this.actionRename, this.actionProperty, this.actionDelete, this.actionDisconnect, this.actionOpenShell, this.subLogMenu);
        IActionBars actionBars = this.getViewSite().getActionBars();
        ConnectionExplorer.setStatusLineManager(actionBars.getStatusLineManager());
        ConnectionExplorer.setConnectionExplorer(this);
    }

    private void createFileExplorerView(Composite parent) {
        this.panel = new ConnectionExplorerPanel();
        this.panel.createControl(parent);
        this.panel.postCreation();
        this.panel.getTreeViewer().getTree().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ConnectionExplorer.this.handleKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
        this.panel.getTableViewer().getTable().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                ConnectionExplorer.this.handleKeyPressed(e);
            }

            public void keyReleased(KeyEvent e) {
            }
        });
    }

    private void handleKeyPressed(KeyEvent event) {
        int length;
        if (event.widget instanceof Tree) {
            Tree tree = (Tree)event.widget;
            length = tree.getSelectionCount();
        } else {
            Table table = (Table)event.widget;
            length = table.getSelectionCount();
        }
        if (event.keyCode == 0x100000E) {
            if (length == 1) {
                this.actionRefresh();
            }
        } else if (event.keyCode == 0x100000B) {
            if (length == 1) {
                this.actionRename();
            }
        } else if (event.keyCode == 127) {
            this.actionDelete();
        }
        if (event.stateMask == 65536 && event.keyCode == 13) {
            this.actionShowProperty();
        }
    }

    private void actionAddFile() {
        this.panel.addNewFileSelection();
    }

    private void actionAddFolder() {
        this.panel.addNewFolderSelection();
    }

    private void actionRename() {
        this.panel.renameSelection();
    }

    private void actionDelete() {
        this.panel.deleteSelection();
    }

    private void actionPush() {
        this.panel.pushIntoSelection();
    }

    private void actionPull() {
        this.panel.pullSelection();
    }

    private void actionRefresh() {
        this.panel.refreshSelection();
    }

    private void actionCollapseAll() {
        this.panel.getTreeViewer().collapseAll();
    }

    private void actionSetPlatformLog(boolean setON) {
        this.panel.setPlatformLogOnOff(setON);
    }

    private void actionDisconnect() {
        this.panel.disconnectSelection();
    }

    public void actionShowProperty() {
        this.panel.showPropertySelection(this.getSite());
    }

    public void actionOpenShell() {
        this.panel.openShell();
    }

    private void makeActions() {
        this.subNewMenu = new MenuManager(ConnectionUIMessages.Explorer_ConetextMenu_New, null);
        this.actionAddFile = new Action(){

            public void run() {
                ConnectionExplorer.this.actionAddFile();
            }
        };
        this.actionAddFile.setText(ConnectionUIMessages.Explorer_ConetextMenu_File);
        this.actionAddFolder = new Action(){

            public void run() {
                ConnectionExplorer.this.actionAddFolder();
            }
        };
        this.actionAddFolder.setText(ConnectionUIMessages.Explorer_ConetextMenu_Folder);
        this.actionRename = new Action(){

            public void run() {
                ConnectionExplorer.this.actionRename();
            }
        };
        this.actionRename.setText(ConnectionUIMessages.Explorer_ConetextMenu_Rename);
        this.actionRename.setActionDefinitionId("org.tizen.common.connection.rename");
        this.actionDelete = new Action(){

            public void run() {
                ConnectionExplorer.this.actionDelete();
            }
        };
        this.actionDelete.setText(ConnectionUIMessages.Explorer_ConetextMenu_Delete);
        this.actionDelete.setActionDefinitionId("org.tizen.common.connection.delete");
        this.actionPush = new Action(){

            public void run() {
                ConnectionExplorer.this.actionPush();
            }
        };
        this.actionPush.setText(ConnectionUIMessages.Explorer_ConetextMenu_Push);
        this.actionPull = new Action(){

            public void run() {
                ConnectionExplorer.this.actionPull();
            }
        };
        this.actionPull.setText(ConnectionUIMessages.Explorer_ConetextMenu_Pull);
        this.actionRefresh = new Action(){

            public void run() {
                ConnectionExplorer.this.actionRefresh();
            }
        };
        this.actionRefresh.setText(ConnectionUIMessages.Explorer_ConetextMenu_Refresh);
        this.actionRefresh.setActionDefinitionId("org.tizen.common.connection.refresh");
        this.actionCollapseAll = new Action(){

            public void run() {
                ConnectionExplorer.this.actionCollapseAll();
            }
        };
        this.actionCollapseAll.setText(ConnectionUIMessages.Explorer_ConetextMenu_CollapseAll);
        this.actionProperty = new Action(){

            public void run() {
                ConnectionExplorer.this.panel.showPropertySelection(ConnectionExplorer.this.getSite());
            }
        };
        this.actionProperty.setText(ConnectionUIMessages.Explorer_ConetextMenu_Property);
        this.actionProperty.setActionDefinitionId("org.tizen.common.connection.property");
        this.subLogMenu = new MenuManager(ConnectionUIMessages.Explorer_ConetextMenu_Log, null);
        this.actionPlatformLogOn = new Action(){

            public void run() {
                ConnectionExplorer.this.actionSetPlatformLog(true);
            }
        };
        this.actionPlatformLogOn.setText(ConnectionUIMessages.Explorer_ConetextMenu_Log_On);
        this.actionPlatformLogOff = new Action(){

            public void run() {
                ConnectionExplorer.this.actionSetPlatformLog(false);
            }
        };
        this.actionPlatformLogOff.setText(ConnectionUIMessages.Explorer_ConetextMenu_Log_Off);
        this.actionDisconnect = new Action(){

            public void run() {
                ConnectionExplorer.this.actionDisconnect();
            }
        };
        this.actionDisconnect.setText(ConnectionUIMessages.Explorer_ContextMenu_Disconnect);
        this.actionOpenShell = new Action(){

            public void run() {
                ConnectionExplorer.this.actionOpenShell();
            }
        };
        this.actionOpenShell.setText(ConnectionUIMessages.Explorer_ConetextMenu_Open_shell);
    }

    private void initContextMenu() {
        this.menuMgr = new MenuManager("Connection Explorer MenuMgr");
        this.menuMgr.setRemoveAllWhenShown(true);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ConnectionExplorer.this.fillContextMenu(manager);
            }
        });
        Menu menu = this.menuMgr.createContextMenu((Control)this.panel.getTreeViewer().getTree());
        this.panel.getTreeViewer().getTree().setMenu(menu);
        this.panel.getTableViewer().getTable().setMenu(menu);
        this.menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                IContributionItem[] items = manager.getItems();
                if (items != null) {
                    IContributionItem[] iContributionItemArray = items;
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IContributionItem item = iContributionItemArray[n2];
                        if ("team.main".equals(item.getId())) {
                            manager.remove(item);
                            break;
                        }
                        ++n2;
                    }
                }
            }
        });
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        contextService.activateContext("org.tizen.common.connection.delete.context");
        contextService.activateContext("org.tizen.common.connection.rename.context");
        contextService.activateContext("org.tizen.common.connection.refresh.context");
        contextService.activateContext("org.tizen.common.connection.property.context");
    }

    public void getExtensionMenu(IMenuManager manager) {
        IConfigurationElement[] ces = PluginUtil.getExtensionConfigurationElements((String)MENU_EXTENSION_ID);
        try {
            IConfigurationElement[] iConfigurationElementArray = ces;
            int n = ces.length;
            int n2 = 0;
            while (n2 < n) {
                Object obj;
                IConfigurationElement ce = iConfigurationElementArray[n2];
                String elementName = ce.getName();
                this.logger.trace("elementName: " + elementName);
                String label = ce.getAttribute("label");
                this.logger.trace("label: " + label);
                if ("contextMenu".equals(elementName) && (obj = ce.createExecutableExtension("handler")) instanceof IConnectionMenu && label != null) {
                    manager.add((IContributionItem)new Separator());
                    manager.add((IAction)new Action(label){

                        public void run() {
                            ((IConnectionMenu)obj).run();
                        }
                    });
                }
                ++n2;
            }
        }
        catch (CoreException ex) {
            this.logger.error(ex.getMessage());
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        if (this.subNewMenu.isEmpty()) {
            this.subNewMenu.add((IAction)this.actionAddFile);
            this.subNewMenu.add((IAction)this.actionAddFolder);
        }
        manager.add((IContributionItem)this.subNewMenu);
        manager.add((IAction)this.actionRename);
        manager.add((IAction)this.actionDelete);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionPush);
        manager.add((IAction)this.actionPull);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
        manager.add((IAction)this.actionCollapseAll);
        manager.add((IContributionItem)new Separator());
        if (this.subLogMenu.isEmpty()) {
            this.subLogMenu.add((IAction)this.actionPlatformLogOn);
            this.subLogMenu.add((IAction)this.actionPlatformLogOff);
        }
        manager.add((IContributionItem)this.subLogMenu);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionDisconnect);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionProperty);
        manager.add((IAction)this.actionOpenShell);
        int resPlatform = this.isPlatformLogOn();
        if (resPlatform == Integer.parseInt(PLATFORMLOG_ON)) {
            this.actionPlatformLogOn.setChecked(true);
            this.actionPlatformLogOff.setChecked(false);
        } else if (resPlatform == Integer.parseInt(PLATFORMLOG_OFF)) {
            this.actionPlatformLogOn.setChecked(false);
            this.actionPlatformLogOff.setChecked(true);
        } else {
            this.actionPlatformLogOn.setChecked(false);
            this.actionPlatformLogOff.setChecked(false);
        }
        this.getExtensionMenu(manager);
    }

    private int isPlatformLogOn() {
        IDevice[] devices;
        final AtomicInteger result = new AtomicInteger(PLATFORMLOG_UNABLE);
        Tree tree = this.panel.getTreeViewer().getTree();
        if (tree.getSelectionCount() == 0) {
            return result.get();
        }
        TreeItem[] items = tree.getSelection();
        FileEntry file = (FileEntry)items[0].getData();
        IDevice[] iDeviceArray = devices = SmartDevelopmentBridge.getBridge().getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            block9: {
                IDevice device = iDeviceArray[n2];
                if (file.getName().equals(device.getDeviceName())) {
                    MultiLineReceiver receiver = new MultiLineReceiver(){

                        public void processNewLines(String[] lines) {
                            String[] stringArray = lines;
                            int n = lines.length;
                            int n2 = 0;
                            while (n2 < n) {
                                String line = stringArray[n2];
                                if (PLATFORMLOG_ON.equals(line) || PLATFORMLOG_OFF.equals(line)) {
                                    result.set(Integer.parseInt(line));
                                    if (ConnectionExplorer.this.subLogMenu.isVisible()) break;
                                    ConnectionExplorer.this.subLogMenu.setVisible(true);
                                    break;
                                }
                                ++n2;
                            }
                            if (result.get() == PLATFORMLOG_UNABLE) {
                                ConnectionExplorer.this.logger.error("Failed to get platform log: " + lines[0]);
                            }
                        }
                    };
                    try {
                        try {
                            String command = "dlogctrl get platformlog";
                            if (device.getApplicationCmdService() != null) {
                                command = "dlogctrl -k plog -g";
                            }
                            device.executeShellCommand(command, (IShellOutputReceiver)receiver);
                        }
                        catch (IOException e) {
                            this.logger.error("Fail to get platform log", (Object)e.getMessage());
                            IOUtil.tryClose((Closeable)receiver);
                            break block9;
                        }
                    }
                    catch (Throwable throwable) {
                        IOUtil.tryClose((Closeable)receiver);
                        throw throwable;
                    }
                    IOUtil.tryClose((Closeable)receiver);
                }
            }
            ++n2;
        }
        return result.get();
    }

    private void createToolBar() {
        IToolBarManager toolbarManager = this.getViewSite().getActionBars().getToolBarManager();
        this.actionEmulatorManager = new ActionEmulatorManager(this.parent.getShell());
        toolbarManager.add((IAction)this.actionEmulatorManager);
        this.actionDeviceRemote = new ActionDeviceRemote(this.parent.getShell());
        toolbarManager.add((IAction)this.actionDeviceRemote);
        this.actionDevicePush = new ActionDeviceFilePush(this.panel);
        toolbarManager.add((IAction)this.actionDevicePush);
        this.actionDevicePull = new ActionDeviceFilePull(this.panel);
        toolbarManager.add((IAction)this.actionDevicePull);
        this.actionViewModeChange = new ActionViewModeChange(this.parent.getShell(), this.panel);
        toolbarManager.add((IAction)this.actionViewModeChange);
    }

    public void setFocus() {
        if (this.parent != null) {
            this.parent.setFocus();
        }
    }

    public void partActivated(IWorkbenchPartReference partRef) {
    }

    public void partBroughtToTop(IWorkbenchPartReference partRef) {
    }

    public void partClosed(IWorkbenchPartReference partRef) {
        if ("org.tizen.common.connection.explorer.ConnectionExplorer".equals(partRef.getId())) {
            ConnectionPlugin.getDefault().setCurrentDevice(null);
        }
    }

    public void partDeactivated(IWorkbenchPartReference partRef) {
    }

    public void partOpened(IWorkbenchPartReference partRef) {
    }

    public void partHidden(IWorkbenchPartReference partRef) {
    }

    public void partVisible(IWorkbenchPartReference partRef) {
    }

    public void partInputChanged(IWorkbenchPartReference partRef) {
    }

    public static void setPathText(String path) {
        if (pathText.isDisposed()) {
            return;
        }
        pathText.setText(path);
        middle.layout();
    }

    public static String getPathText() {
        return pathText.getText();
    }

    public ConnectionExplorerPanel getConnectionExplorerPanel() {
        return this.panel;
    }

    class DropdownSelectionListener
    extends SelectionAdapter {
        private Menu menu;
        private MenuItem checkedMenuItem;

        public DropdownSelectionListener(ToolItem dropdown) {
            this.menu = new Menu((Control)dropdown.getParent().getShell());
        }

        public void add(String item, boolean defaultCheck) {
            MenuItem menuItem = new MenuItem(this.menu, 32);
            menuItem.setText(item);
            if (defaultCheck) {
                this.checkedMenuItem = menuItem;
                menuItem.setSelection(true);
            }
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    MenuItem selected = (MenuItem)event.widget;
                    DropdownSelectionListener.this.checkedMenuItem.setSelection(false);
                    selected.setSelection(true);
                    DropdownSelectionListener.this.checkedMenuItem = selected;
                    String viewMode = selected.getText();
                    if (viewMode.equals(VIEW_MODE_AUTO)) {
                        ConnectionExplorer.this.panel.showAutoViewMode();
                    } else if (viewMode.equals(VIEW_MODE_HORIZONTAL)) {
                        ConnectionExplorer.this.panel.showHorizontalViewMode();
                    } else if (viewMode.equals(VIEW_MODE_VERTICAL)) {
                        ConnectionExplorer.this.panel.showVerticalViewMode();
                    } else if (viewMode.equals(VIEW_MODE_SINGLE)) {
                        ConnectionExplorer.this.panel.showSingleViewMode();
                    }
                }
            });
        }

        public void widgetSelected(SelectionEvent event) {
            if (event.detail == 4) {
                ToolItem item = (ToolItem)event.widget;
                Rectangle rect = item.getBounds();
                Point pt = item.getParent().toDisplay(new Point(rect.x, rect.y));
                this.menu.setLocation(pt.x, pt.y + rect.height);
                this.menu.setVisible(true);
            }
        }
    }
}

