/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.explorer.action;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.explorer.ConnectionExplorerPanel;
import org.tizen.common.connection.explorer.ConnectionUIMessages;

public class ActionViewModeChange
extends Action
implements IMenuCreator {
    private Shell shell;
    private ConnectionExplorerPanel panel;
    private Menu menu;
    private Action actionViewModeAuto;
    private Action actionViewModeHorizontal;
    private Action actionViewModeVertical;
    private Action actionViewModeSingle;
    public static String VIEW_MODE_AUTO = "Auto";
    public static String VIEW_MODE_HORIZONTAL = "Horizontal";
    public static String VIEW_MODE_VERTICAL = "Vertical";
    public static String VIEW_MODE_SINGLE = "Single";

    public ActionViewModeChange(Shell shell, ConnectionExplorerPanel panel) {
        this.shell = shell;
        this.panel = panel;
        this.setToolTipText(ConnectionUIMessages.Explorer_Tooltip_ViewMode);
        this.setImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/elcl18/view_mode.png"));
        this.setDisabledImageDescriptor(ConnectionPlugin.getImageDescriptorFromPlugin("icons/connection/dlcl18/view_mode.png"));
        this.setMenuCreator(this);
        this.actionViewModeAuto = new ActionViewModeAuto(VIEW_MODE_AUTO);
        this.actionViewModeHorizontal = new ActionViewModeHorizontal(VIEW_MODE_HORIZONTAL);
        this.actionViewModeVertical = new ActionViewModeVertical(VIEW_MODE_VERTICAL);
        this.actionViewModeSingle = new ActionViewModeSingle(VIEW_MODE_SINGLE);
        this.actionViewModeAuto.setChecked(true);
    }

    public void run() {
        if (this.actionViewModeAuto.isChecked()) {
            this.actionViewModeAuto.run();
        } else if (this.actionViewModeHorizontal.isChecked()) {
            this.actionViewModeHorizontal.run();
        } else if (this.actionViewModeVertical.isChecked()) {
            this.actionViewModeVertical.run();
        } else {
            this.actionViewModeSingle.run();
        }
    }

    public void dispose() {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
    }

    public Menu getMenu(Control paramControl) {
        if (this.menu != null) {
            this.menu.dispose();
            this.menu = null;
        }
        this.menu = new Menu((Decorations)this.shell, 12);
        this.addActionToMenu(this.menu, this.actionViewModeAuto);
        this.addActionToMenu(this.menu, this.actionViewModeHorizontal);
        this.addActionToMenu(this.menu, this.actionViewModeVertical);
        this.addActionToMenu(this.menu, this.actionViewModeSingle);
        return this.menu;
    }

    private void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public Menu getMenu(Menu paramMenu) {
        return null;
    }

    class ActionViewModeAuto
    extends Action {
        public ActionViewModeAuto(String menuName) {
            this.setText(menuName);
        }

        public void run() {
            ActionViewModeChange.this.panel.showAutoViewMode();
            this.setChecked(true);
            ActionViewModeChange.this.actionViewModeHorizontal.setChecked(false);
            ActionViewModeChange.this.actionViewModeVertical.setChecked(false);
            ActionViewModeChange.this.actionViewModeSingle.setChecked(false);
        }
    }

    class ActionViewModeHorizontal
    extends Action {
        public ActionViewModeHorizontal(String menuName) {
            this.setText(menuName);
        }

        public void run() {
            ActionViewModeChange.this.panel.showHorizontalViewMode();
            this.setChecked(true);
            ActionViewModeChange.this.actionViewModeAuto.setChecked(false);
            ActionViewModeChange.this.actionViewModeVertical.setChecked(false);
            ActionViewModeChange.this.actionViewModeSingle.setChecked(false);
        }
    }

    class ActionViewModeSingle
    extends Action {
        public ActionViewModeSingle(String menuName) {
            this.setText(menuName);
        }

        public void run() {
            ActionViewModeChange.this.panel.showSingleViewMode();
            this.setChecked(true);
            ActionViewModeChange.this.actionViewModeAuto.setChecked(false);
            ActionViewModeChange.this.actionViewModeHorizontal.setChecked(false);
            ActionViewModeChange.this.actionViewModeVertical.setChecked(false);
        }
    }

    class ActionViewModeVertical
    extends Action {
        public ActionViewModeVertical(String menuName) {
            this.setText(menuName);
        }

        public void run() {
            ActionViewModeChange.this.panel.showVerticalViewMode();
            this.setChecked(true);
            ActionViewModeChange.this.actionViewModeAuto.setChecked(false);
            ActionViewModeChange.this.actionViewModeHorizontal.setChecked(false);
            ActionViewModeChange.this.actionViewModeSingle.setChecked(false);
        }
    }
}

