/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.log;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.mozilla.universalchardet.UniversalDetector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.TizenPlatformConstants;
import org.tizen.common.connection.ConnectionPlugin;
import org.tizen.common.connection.log.EncodingChar;
import org.tizen.common.connection.log.LogColors;
import org.tizen.common.connection.log.LogFilter;
import org.tizen.common.connection.log.LogPanel;
import org.tizen.common.connection.log.model.LogMessage;
import org.tizen.common.connection.log.model.LogMessageInfo;
import org.tizen.common.connection.log.parser.IDlogParser;
import org.tizen.common.ui.view.console.AnsicodeAdapter;
import org.tizen.common.util.SWTUtil;
import org.tizen.sdblib.IDevice;
import org.tizen.sdblib.IShellOutputReceiver;
import org.tizen.sdblib.receiver.MultiLineReceiver;
import org.tizen.sdblib.util.DeviceUtil;
import org.tizen.sdblib.util.LogLevel;

public class LogTab {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final int DEFAULT_STRING_BUFFER_LENGTH = 20000;
    private final int STRING_BUFFER_LENGTH = ConnectionPlugin.getDefault().getPreferenceStore().getInt("string_buffer_length");
    private LogLevel defaultLevel;
    private String logTabName = null;
    private IDevice device = null;
    private LogTabOutputReceiver logReceiver = null;
    private LogColors colors;
    private GC gc;
    private Table table;
    private CTabItem cTabItem;
    private int maxWidth;
    private boolean isScrollLocked;
    private final LogMessage[] allMessages = new LogMessage[this.STRING_BUFFER_LENGTH];
    private final List<LogMessage> filteredMessages = new ArrayList<LogMessage>();
    private final List<LogMessage> tableMessages = new ArrayList<LogMessage>();
    private LogMessageInfo logMessageInfo = null;
    private boolean isDefault = false;
    private int messageIndex = -1;
    private LogFilter logFilter = new LogFilter();
    private UniversalDetector detector = new UniversalDetector(null);
    private boolean isOldPlatform = false;
    private boolean isTVProfile = false;
    public boolean isSupportProfile = true;
    public boolean isVisible = true;
    private IDlogParser dlogParser = null;
    private EncodingChar selectedEncoding = EncodingChar.AUTO;

    public LogFilter getLogFilter() {
        return this.logFilter;
    }

    public void setLogFilter(LogFilter logFilter) {
        this.logFilter = logFilter;
    }

    public LogTab(String pName, IDevice pDevice, LogColors pColors) {
        this.logTabName = pName;
        this.device = pDevice;
        this.colors = pColors;
        this.defaultLevel = LogPanel.DEFAULT_LOG_LEVEL;
        this.isSupportProfile = this.isSupportDeviceProfile();
    }

    public LogTab() {
    }

    public void setLogTabName(String name) {
        this.logTabName = name;
    }

    public void setVisible(boolean visible) {
        this.isVisible = visible;
    }

    private boolean isSupportDeviceProfile() {
        return true;
    }

    public String getLogTabName() {
        return this.logTabName;
    }

    public String getDeviceSerialNumber() {
        if (this.device != null) {
            return this.device.getSerialNumber();
        }
        return null;
    }

    public LogLevel getLogLevel() {
        return this.defaultLevel;
    }

    public void setCTabItem(CTabItem cTabItem) {
        this.cTabItem = cTabItem;
    }

    public CTabItem getCTabItem() {
        return this.cTabItem;
    }

    public void setTable(Table table) {
        this.table = table;
    }

    public void setGc(GC gc) {
        this.gc = gc;
    }

    public Table getTable() {
        return this.table;
    }

    public void setEncoding(EncodingChar encodingChar) {
        this.selectedEncoding = encodingChar;
    }

    public EncodingChar getEncoding() {
        return this.selectedEncoding;
    }

    public void start() {
        LogLevel level = LogLevel.VERBOSE;
        this.start(level);
    }

    public void start(final LogLevel level) {
        if (this.device != null) {
            this.logReceiver = new LogTabOutputReceiver();
            new Thread(String.valueOf(this.device.getSerialNumber()) + " Logger"){

                @Override
                public void run() {
                    while (!DeviceUtil.isOnline((IDevice)LogTab.this.device) && LogTab.this.logReceiver != null && !((LogTab)LogTab.this).logReceiver.isCancelled) {
                        try {
                            1.sleep(2000L);
                        }
                        catch (InterruptedException e) {
                            LogTab.this.logger.error("LogTab : Device is not online or logger is null/cancelled", (Object)e.getMessage(), (Object)e);
                            return;
                        }
                    }
                    if (LogTab.this.logReceiver == null || ((LogTab)LogTab.this).logReceiver.isCancelled) {
                        return;
                    }
                    try {
                        String command = null;
                        command = LogTab.this.isTVProfile && LogTab.this.isOldPlatform ? String.format(TizenPlatformConstants.DLOGUTIL_CMD, "-v threadtime *:*") : String.format(TizenPlatformConstants.DLOGUTIL_CMD, "-v long *:" + level.getLetter());
                        LogTab.this.device.executeShellCommand(command, (IShellOutputReceiver)LogTab.this.logReceiver, 0, "ISO-8859-1");
                    }
                    catch (Exception e) {
                        LogTab.this.logger.error("LogTab", (Throwable)e);
                    }
                }
            }.start();
        }
    }

    public void stop() {
        if (this.logReceiver != null) {
            this.logReceiver.isCancelled = true;
            this.logReceiver = null;
            this.device = null;
            this.clear();
        }
    }

    public void restart() {
        IDevice old = this.device;
        this.stop();
        this.setDevice(old);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void filterMessages() {
        this.initialize();
        List<LogMessage> list = this.filteredMessages;
        synchronized (list) {
            for (LogMessage logMsg : this.filteredMessages) {
                if (!this.logFilter.filteredByLogLevelAndKeyword(logMsg)) continue;
                this.tableMessages.add(logMsg);
            }
            this.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        TableColumn col;
        int tableWidth;
        int count;
        block16: {
            ArrayList<LogMessage> logList = null;
            List<LogMessage> list = this.tableMessages;
            synchronized (list) {
                if (this.tableMessages.isEmpty()) {
                    return;
                }
                logList = new ArrayList<LogMessage>(this.tableMessages);
                this.tableMessages.clear();
            }
            int newCount = logList.size();
            try {
                try {
                    this.table.setRedraw(false);
                    int totalCount = this.table.getItemCount() + newCount;
                    if (totalCount > this.STRING_BUFFER_LENGTH) {
                        int removeCount = totalCount - this.STRING_BUFFER_LENGTH;
                        if (this.table.getItemCount() <= removeCount) {
                            this.table.removeAll();
                        } else {
                            this.table.remove(0, removeCount - 1);
                        }
                    }
                    String longestLog = "";
                    int i = 0;
                    while (i < newCount) {
                        LogMessage msg = (LogMessage)logList.get(i);
                        this.addTableItem(msg);
                        if (msg.msg.length() > longestLog.length()) {
                            longestLog = msg.msg;
                        }
                        ++i;
                    }
                    int width = this.gc.textExtent((String)longestLog).x;
                    this.maxWidth = this.maxWidth < width ? width : this.maxWidth;
                }
                catch (SWTException e) {
                    this.logger.error("LogFilter", (Throwable)e);
                    this.table.setRedraw(true);
                    break block16;
                }
            }
            catch (Throwable throwable) {
                this.table.setRedraw(true);
                throw throwable;
            }
            this.table.setRedraw(true);
        }
        if (!this.getScrollLock() && (count = this.table.getItemCount()) > 1) {
            this.table.showItem(this.table.getItem(this.table.getItemCount() - 1));
        }
        if ((tableWidth = (col = this.table.getColumn(5)).getWidth()) < this.maxWidth) {
            col.setWidth(this.maxWidth);
        }
    }

    void setColors(LogColors pColors) {
        this.colors = pColors;
    }

    private void addTableItem(LogMessage msg) {
        TableItem item = new TableItem(this.table, 0);
        item.setText(0, msg.data.getTime());
        item.setText(2, msg.data.getPidString());
        item.setText(3, msg.data.getTidString());
        item.setText(4, msg.data.getTag());
        item.setText(5, msg.msg);
        item.setData((Object)msg);
        LogLevel logLevel = msg.data.getLogLevel();
        if (logLevel == LogLevel.FATAL) {
            item.setForeground(this.colors.fatalColor);
            item.setText(1, "Fatal");
        } else if (logLevel == LogLevel.ERROR) {
            item.setForeground(this.colors.errorColor);
            item.setText(1, "Error");
        } else if (logLevel == LogLevel.WARN) {
            item.setForeground(this.colors.warningColor);
            item.setText(1, "Warning");
        } else if (logLevel == LogLevel.INFO) {
            item.setForeground(this.colors.infoColor);
            item.setText(1, "Info");
        } else if (logLevel == LogLevel.DEBUG) {
            item.setForeground(this.colors.debugColor);
            item.setText(1, "Debug");
        } else if (logLevel == LogLevel.VERBOSE) {
            item.setForeground(this.colors.verboseColor);
            item.setText(1, "Verbose");
        }
    }

    protected String getDecodedLine(String line) {
        byte[] lineBytes = null;
        String encodedString = line;
        try {
            lineBytes = line.getBytes("ISO-8859-1");
            this.detector.handleData(lineBytes, 0, lineBytes.length);
            this.detector.dataEnd();
            String encoding = this.detector.getDetectedCharset();
            this.detector.reset();
            if (encoding != null) {
                encodedString = new String(lineBytes, encoding);
            }
        }
        catch (UnsupportedEncodingException e1) {
            this.logger.error("encoding or decoding format is not supported", (Object)e1.getMessage());
        }
        return encodedString;
    }

    protected String getDecodedLineManual(String line, EncodingChar encodingChar) {
        byte[] lineBytes = null;
        String encodedString = line;
        try {
            lineBytes = line.getBytes("ISO-8859-1");
            encodedString = new String(lineBytes, encodingChar.getName());
        }
        catch (UnsupportedEncodingException e) {
            this.logger.error("encoding format is not supported", (Object)e.getMessage());
        }
        return encodedString;
    }

    protected void newProcessLogLine(String line) {
        LogMessageInfo msgInfo = null;
        if (this.dlogParser != null) {
            msgInfo = this.dlogParser.parse(line);
        }
        if (msgInfo != null) {
            this.logMessageInfo = msgInfo;
        } else {
            if (this.logMessageInfo == null) {
                return;
            }
            LogMessage logMessage = new LogMessage();
            logMessage.data = this.logMessageInfo;
            logMessage.msg = line.replaceAll("\t", "    ");
            this.processNewMessage(logMessage);
        }
    }

    protected void oldProcessLogLine(String line) {
        LogMessageInfo msgInfo = null;
        if (this.dlogParser != null) {
            msgInfo = this.dlogParser.parse(line);
        }
        if (msgInfo != null) {
            this.logMessageInfo = msgInfo;
            if (this.isTVProfile) {
                LogMessage logMessage = new LogMessage();
                logMessage.data = this.logMessageInfo;
                logMessage.msg = this.logMessageInfo.getMsg();
                this.processNewMessage(logMessage);
            }
        } else if (!this.isTVProfile) {
            if (this.logMessageInfo == null) {
                return;
            }
            LogMessage logMessage = new LogMessage();
            logMessage.data = this.logMessageInfo;
            logMessage.msg = line.replaceAll("\t", "    ");
            this.processNewMessage(logMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processLogLines(String[] lines) {
        if (lines.length > this.STRING_BUFFER_LENGTH) {
            this.logger.error("LogTab : Receiving more lines than " + this.STRING_BUFFER_LENGTH, (Object)"");
            return;
        }
        LogMessage[] logMessageArray = this.allMessages;
        synchronized (this.allMessages) {
            String[] stringArray = lines;
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                line = this.selectedEncoding == EncodingChar.AUTO ? this.getDecodedLine(line) : this.getDecodedLineManual(line, this.selectedEncoding);
                if ((line = AnsicodeAdapter.getStripAnsiString((String)line)).length() > 0) {
                    if (this.isOldPlatform) {
                        this.oldProcessLogLine(line);
                    } else {
                        this.newProcessLogLine(line);
                    }
                }
                ++n2;
            }
            try {
                Display display = this.table.getDisplay();
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (LogTab.this.isVisible) {
                            LogTab.this.asyncRefresh();
                        }
                    }
                });
            }
            catch (SWTException sWTException) {
                this.stop();
            }
            return;
        }
    }

    private void processNewMessage(LogMessage newMessage) {
        LogMessage oldMessage = this.addAllMessages(newMessage);
        if (this.addFilteredMessage(newMessage, oldMessage)) {
            this.addTableMessage(newMessage);
        }
    }

    private LogMessage addAllMessages(LogMessage newMessage) {
        this.messageIndex = this.messageIndex == this.STRING_BUFFER_LENGTH - 1 ? 0 : ++this.messageIndex;
        if (this.allMessages[this.messageIndex] == null) {
            this.allMessages[this.messageIndex] = newMessage;
            return null;
        }
        LogMessage oldMessage = this.allMessages[this.messageIndex];
        this.allMessages[this.messageIndex] = newMessage;
        return oldMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addFilteredMessage(LogMessage newMessage, LogMessage oldMessage) {
        List<LogMessage> list = this.filteredMessages;
        synchronized (list) {
            block5: {
                boolean isValid;
                int index;
                if (oldMessage != null && this.filteredMessages.size() >= this.STRING_BUFFER_LENGTH && (index = this.filteredMessages.indexOf(oldMessage)) != -1) {
                    this.filteredMessages.remove(index);
                }
                if (!(isValid = this.logFilter.filteredByDefaultKeyword(newMessage))) break block5;
                this.filteredMessages.add(newMessage);
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTableMessage(LogMessage newMessage) {
        List<LogMessage> list = this.tableMessages;
        synchronized (list) {
            boolean isValid = this.logFilter.filteredByLogLevelAndKeyword(newMessage);
            if (isValid) {
                this.tableMessages.add(newMessage);
                if (this.tableMessages.size() > this.STRING_BUFFER_LENGTH) {
                    this.tableMessages.remove(0);
                }
            }
        }
    }

    private void asyncRefresh() {
        if (!this.table.isDisposed()) {
            this.flush();
        } else {
            this.stop();
        }
    }

    public void resetUI(boolean inUiThread) {
        if (!this.table.isDisposed()) {
            if (inUiThread) {
                this.table.removeAll();
            } else {
                SWTUtil.syncExec((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (!LogTab.this.table.isDisposed()) {
                            LogTab.this.table.removeAll();
                        }
                    }
                });
            }
        }
    }

    public void setFilterCombo(int index) {
        this.logFilter.setComboFilter(index);
    }

    public void setFilterText(String text) {
        this.logFilter.setKeywordFilter(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() {
        this.tableMessages.clear();
        LogMessage[] logMessageArray = this.allMessages;
        synchronized (this.allMessages) {
            this.logMessageInfo = null;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            this.resetUI(false);
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.allMessages;
        synchronized (this.allMessages) {
            int i = 0;
            while (i < this.STRING_BUFFER_LENGTH) {
                this.allMessages[i] = null;
                ++i;
            }
            // ** MonitorExit[var1_1 /* !! */ ] (shouldn't be in output)
            object = this.filteredMessages;
            synchronized (object) {
                this.filteredMessages.clear();
            }
            this.initialize();
            return;
        }
    }

    public void setDevice(IDevice device) {
        this.device = device;
    }

    public void setDefault() {
        this.isDefault = true;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public void setScrollLock(boolean islock) {
        this.isScrollLocked = islock;
    }

    public boolean getScrollLock() {
        return this.isScrollLocked;
    }

    private final class LogTabOutputReceiver
    extends MultiLineReceiver {
        public boolean isCancelled = false;

        public LogTabOutputReceiver() {
            this.setTrimLines(false);
        }

        public void processNewLines(String[] lines) {
            if (!this.isCancelled) {
                LogTab.this.processLogLines(lines);
            }
        }

        public boolean isCancelled() {
            return this.isCancelled;
        }
    }
}

