/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.log.parser;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.tizen.common.connection.log.model.LogMessageInfo;
import org.tizen.common.connection.log.parser.IDlogParser;
import org.tizen.sdblib.util.LogLevel;

public class DlogOldParser
implements IDlogParser {
    public static final String TV_DLOG_FORMAT_REGEX = "^\\[DLOG\\]\\s*(\\d*\\.?\\d*)\\s+[P]\\(\\s*(\\d+)\\)\\s+[T]\\(\\s*(\\d+)\\)\\s+(V|D|I|W|E|F)\\s([*s[^:]]*):(.*)$";
    public static final String DLOG_FORMAT_REGEX = "^\\[\\s(\\d\\d-\\d\\d\\s\\d\\d:\\d\\d:\\d\\d\\.\\d+)\\s+(\\d*):\\s*(\\d+)\\s([VDIWEF])\\/(.+)\\s+\\]$";
    private boolean isTV = false;
    private Pattern pattern = null;

    public DlogOldParser(boolean isTV) {
        if (isTV) {
            this.isTV = true;
            this.pattern = Pattern.compile(TV_DLOG_FORMAT_REGEX);
        } else {
            this.pattern = Pattern.compile(DLOG_FORMAT_REGEX);
        }
    }

    @Override
    public LogMessageInfo parse(String line) {
        Matcher matcher = this.pattern.matcher(line);
        if (matcher.matches()) {
            LogMessageInfo info = new LogMessageInfo();
            info.setTime(matcher.group(1));
            info.setPidString(matcher.group(2));
            info.setTidString(matcher.group(3));
            info.setLogLevel(LogLevel.getByLetter((String)matcher.group(4)));
            info.setTag(matcher.group(5).trim());
            if (this.isTV) {
                info.setMsg(matcher.group(6).replaceAll("\t", "    "));
            }
            return info;
        }
        return null;
    }
}

