/*
 * Decompiled with CFR 0.152.
 */
package org.tizen.common.connection.toolbar;

import java.io.IOException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tizen.common.connection.explorer.action.ActionEmulatorManager;
import org.tizen.common.connection.toolbar.Messages;
import org.tizen.common.ui.font.TizenFonts;

public class NoTargetDialog
extends MessageDialog {
    private static final Logger logger = LoggerFactory.getLogger(NoTargetDialog.class);
    private static String[] dialogButtonLabels = new String[]{IDialogConstants.CLOSE_LABEL, Messages.CreateNewEmulator, Messages.CreateRemoteDevice};
    public static final int BTN_CREATE_EMULATOR_ID = 1;
    public static final int BTN_CREATE_REMOTE_DEVICE_ID = 2;
    private Shell shell;

    public NoTargetDialog(Shell parentShell) {
        super(parentShell, Messages.DialogTitle, null, Messages.DialogNoTarget, 1, dialogButtonLabels, 0);
        this.shell = parentShell;
    }

    protected Control createMessageArea(Composite parent) {
        Image image = this.getImage();
        if (image != null) {
            this.imageLabel = new Label(parent, 0);
            image.setBackground(this.imageLabel.getBackground());
            this.imageLabel.setImage(image);
            GridDataFactory.fillDefaults().align(0x1000000, 1).applyTo((Control)this.imageLabel);
        }
        if (this.message != null) {
            Composite composite = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            composite.setLayout((Layout)gridLayout);
            this.messageLabel = new Label(composite, this.getMessageLabelStyle());
            this.messageLabel.setFont(TizenFonts.getBoldFont());
            this.messageLabel.setText(Messages.DialogNoTarget);
            Label detailMessageLabel = new Label(composite, this.getMessageLabelStyle());
            detailMessageLabel.setText(Messages.DialogNoTargetComment);
        }
        return parent;
    }

    protected void buttonPressed(int buttonId) {
        switch (buttonId) {
            case 1: {
                try {
                    ActionEmulatorManager.startEmulatorManager();
                }
                catch (IOException iOException) {
                    logger.error("Cannot launch emulator manager");
                }
                this.close();
                break;
            }
            case 2: {
                this.close();
                break;
            }
            default: {
                this.setReturnCode(buttonId);
                this.close();
            }
        }
    }

    public int open() {
        return super.open();
    }
}

